/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.ui.app.editor.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.vtp.desktop.core.localdata.ILocalDomain;
import org.eclipse.vtp.desktop.core.localdata.ILocalModule;
import org.eclipse.vtp.desktop.core.localdata.ILocalModuleGroup;
import org.eclipse.vtp.desktop.core.localdata.ILocalModuleGroupVersion;
import org.eclipse.vtp.desktop.core.localdata.ILocalVendor;
import org.eclipse.vtp.desktop.core.project.FieldType;
import org.eclipse.vtp.desktop.ui.app.editor.MediaProvider;
import org.eclipse.vtp.desktop.ui.app.editor.MediaScript;
import org.eclipse.vtp.desktop.ui.app.editor.MediaScriptReader;
import org.eclipse.vtp.desktop.ui.app.editor.model.Connector;
import org.eclipse.vtp.desktop.ui.app.editor.model.ConnectorDestination;
import org.eclipse.vtp.desktop.ui.app.editor.model.ConnectorOrigin;
import org.eclipse.vtp.desktop.ui.app.editor.model.ConnectorRecord;
import org.eclipse.vtp.desktop.ui.app.editor.model.Element;
import org.eclipse.vtp.desktop.ui.app.editor.model.ModuleGeneralPropertiesPanel;
import org.eclipse.vtp.desktop.ui.app.editor.model.ModuleSettingsPropertiesPanel;
import org.eclipse.vtp.desktop.ui.app.editor.model.Variable;
import org.eclipse.vtp.desktop.ui.app.editor.model.event.ConnectorOriginPathListener;
import org.eclipse.vtp.framework.media.library.MediaLibrary;
import org.eclipse.vtp.framework.util.XMLUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class ModuleElement
extends Element
implements ConnectorOrigin,
ConnectorDestination,
MediaProvider {
    private List hookPoints;
    private List exitPoints;
    private List incomingConnectors;
    private List localVariables;
    protected Properties properties;
    private boolean hasMediaContent = false;
    private MediaScript script = null;
    private List listeners = new ArrayList();
    ILocalModule localModule;
    ILocalModuleGroupVersion localModuleGroupVersion;
    ILocalModuleGroup localModuleGroup;
    ILocalVendor localVendor;
    ILocalDomain localDomain;

    public ModuleElement(ILocalModule localModule) {
        this(localModule.getName(), localModule);
    }

    public ModuleElement(String name, ILocalModule localModule) {
        super(name);
        this.localModule = localModule;
        this.init();
    }

    public ModuleElement(String id, String name, ILocalModule localModule) {
        super(id, name);
        this.localModule = localModule;
        this.init();
    }

    public void init() {
        this.localModuleGroupVersion = this.localModule.getModuleGroupVersion();
        this.localModuleGroup = this.localModuleGroupVersion.getModuleGroup();
        this.localVendor = this.localModuleGroup.getVendor();
        this.localDomain = this.localVendor.getDomain();
        this.exitPoints = new ArrayList();
        this.hookPoints = new ArrayList();
        this.incomingConnectors = new ArrayList();
        this.localVariables = new ArrayList();
        this.properties = new Properties();
        HashMap<String, ConnectorRecord> exitPointMap = new HashMap<String, ConnectorRecord>();
        Document definition = null;
        try {
            definition = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(this.localModule.openDescriptor());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (definition != null) {
            org.w3c.dom.Element modElement = definition.getDocumentElement();
            try {
                this.hasMediaContent = modElement.getAttribute("hasMediaContent").equalsIgnoreCase("true");
                org.w3c.dom.Element[] points = XMLUtilities.getElementsOfNodeList((NodeList)XMLUtilities.getNamedNodeList((org.w3c.dom.Element)modElement, (String)"exit-points"));
                int i = 0;
                while (i < points.length) {
                    String type = points[i].getAttribute("type");
                    String name = points[i].getAttribute("name");
                    if (type.equals("hook")) {
                        this.hookPoints.add(new ConnectorRecord(this, name, ConnectorRecord.HOOK_POINT));
                    } else {
                        ConnectorRecord cr;
                        int idex = name.indexOf(46);
                        while (idex != -1) {
                            if (exitPointMap.get(name.substring(0, idex)) == null) {
                                cr = new ConnectorRecord(this, name.substring(0, idex), type.equals("exit") ? ConnectorRecord.EXIT_POINT : ConnectorRecord.ERROR_POINT);
                                exitPointMap.put(cr.getName(), cr);
                                this.exitPoints.add(cr);
                            }
                            idex = name.indexOf(46, idex + 1);
                        }
                        cr = new ConnectorRecord(this, name, type.equals("exit") ? ConnectorRecord.EXIT_POINT : ConnectorRecord.ERROR_POINT);
                        exitPointMap.put(cr.getName(), cr);
                        this.exitPoints.add(cr);
                    }
                    ++i;
                }
                org.w3c.dom.Element[] variableElements = XMLUtilities.getElementsOfNodeList((NodeList)XMLUtilities.getNamedNodeList((org.w3c.dom.Element)modElement, (String)"variables"));
                int i2 = 0;
                while (i2 < variableElements.length) {
                    String varName = variableElements[i2].getAttribute("name");
                    String varValue = variableElements[i2].getAttribute("type");
                    FieldType ft = null;
                    int type = Integer.parseInt(varValue);
                    switch (type) {
                        case 0: {
                            ft = FieldType.BOOLEAN;
                            break;
                        }
                        case 1: {
                            ft = FieldType.DATETIME;
                            break;
                        }
                        case 2: {
                            ft = FieldType.DECIMAL;
                            break;
                        }
                        case 3: {
                            ft = FieldType.NUMBER;
                            break;
                        }
                        default: {
                            ft = FieldType.STRING;
                        }
                    }
                    this.localVariables.add(new Variable(varName, ft));
                    ++i2;
                }
                org.w3c.dom.Element[] propertyElements = XMLUtilities.getElementsOfNodeList((NodeList)XMLUtilities.getNamedNodeList((org.w3c.dom.Element)modElement, (String)"properties"));
                int i3 = 0;
                while (i3 < propertyElements.length) {
                    String propName = propertyElements[i3].getAttribute("name");
                    String propValue = propertyElements[i3].getAttribute("value");
                    this.properties.put(propName, propValue);
                    ++i3;
                }
                if (this.hasMediaContent) {
                    org.w3c.dom.Element[] scriptElements = XMLUtilities.getElementsOfNodeList((NodeList)modElement.getElementsByTagName("media-script"));
                    this.script = MediaScriptReader.load(this.getProviderType(), this.getId(), scriptElements[0]);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void addIncomingConnector(Connector connector) {
        this.incomingConnectors.remove(connector);
        this.incomingConnectors.add(connector);
        this.validateStatus();
    }

    public void removeIncomingConnector(Connector connector) {
        this.incomingConnectors.remove(connector);
        this.validateStatus();
    }

    public void validateStatus() {
        super.validateStatus();
        boolean isExitedFrom = false;
        boolean isErrorFrom = false;
        boolean hasErrorFrom = false;
        int i = 0;
        while (i < this.exitPoints.size()) {
            ConnectorRecord cr = (ConnectorRecord)this.exitPoints.get(i);
            if (cr.getType() == ConnectorRecord.ERROR_POINT) {
                hasErrorFrom = true;
            }
            if (cr.getConnector() != null) {
                if (cr.getType() == ConnectorRecord.EXIT_POINT) {
                    isExitedFrom = true;
                } else {
                    isErrorFrom = true;
                }
            }
            ++i;
        }
        if (this.incomingConnectors.size() < 1 || !this.hasPathToStart(null)) {
            this.setError(true);
        }
        if (!isErrorFrom && hasErrorFrom) {
            this.setTodo(true);
        }
        if (!isExitedFrom) {
            this.setWarning(true);
        }
    }

    public boolean hasPathToStart(List originPath) {
        if (originPath == null) {
            originPath = new ArrayList<ModuleElement>();
        }
        originPath.add(this);
        boolean ret = false;
        int i = 0;
        while (i < this.incomingConnectors.size()) {
            boolean has;
            Connector connector = (Connector)this.incomingConnectors.get(i);
            if (!originPath.contains(connector.getOrigin()) && (ret |= (has = connector.getOrigin().hasPathToStart(originPath)))) {
                return ret;
            }
            ++i;
        }
        return ret;
    }

    public void setProperty(String name, String value) {
        this.properties.put(name, value);
    }

    public String getTagName() {
        return "module";
    }

    public void writeAttributes(org.w3c.dom.Element element) {
        super.writeAttributes(element);
        element.setAttribute("module", this.localModule.getName());
        element.setAttribute("version-number", this.localModuleGroupVersion.getVersionNumber());
        element.setAttribute("module-group", this.localModuleGroup.getName());
        element.setAttribute("vendor", this.localVendor.getName());
        org.w3c.dom.Element settingsElement = element.getOwnerDocument().createElement("settings");
        element.appendChild(settingsElement);
        Enumeration<Object> enumeration = this.properties.keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            String value = this.properties.getProperty(key);
            org.w3c.dom.Element settingElement = element.getOwnerDocument().createElement("setting");
            settingsElement.appendChild(settingElement);
            settingElement.setAttribute("name", key);
            settingElement.setAttribute("value", value);
        }
    }

    public List getPropertyPanels() {
        List ret = super.getPropertyPanels();
        ret.add(new ModuleGeneralPropertiesPanel(this));
        ret.add(new ModuleSettingsPropertiesPanel(this));
        return ret;
    }

    public List getHooks() {
        ArrayList<ConnectorRecord> hooks = new ArrayList<ConnectorRecord>();
        Iterator iterator = this.hookPoints.iterator();
        while (iterator.hasNext()) {
            ConnectorRecord cr = (ConnectorRecord)iterator.next();
            hooks.add(cr);
        }
        return Collections.unmodifiableList(hooks);
    }

    public List getFreeHooks() {
        ArrayList<ConnectorRecord> freeHooks = new ArrayList<ConnectorRecord>();
        Iterator iterator = this.hookPoints.iterator();
        while (iterator.hasNext()) {
            ConnectorRecord cr = (ConnectorRecord)iterator.next();
            if (cr.getConnector() != null) continue;
            freeHooks.add(cr);
        }
        return Collections.unmodifiableList(freeHooks);
    }

    public List getExits() {
        ArrayList<ConnectorRecord> exits = new ArrayList<ConnectorRecord>();
        Iterator iterator = this.exitPoints.iterator();
        while (iterator.hasNext()) {
            ConnectorRecord cr = (ConnectorRecord)iterator.next();
            exits.add(cr);
        }
        return Collections.unmodifiableList(exits);
    }

    public List getFreeExits() {
        ArrayList<ConnectorRecord> freeExits = new ArrayList<ConnectorRecord>();
        Iterator iterator = this.exitPoints.iterator();
        while (iterator.hasNext()) {
            ConnectorRecord cr = (ConnectorRecord)iterator.next();
            if (cr.getConnector() != null) continue;
            freeExits.add(cr);
        }
        return Collections.unmodifiableList(freeExits);
    }

    public ConnectorRecord getRecord(String name) {
        int i = 0;
        while (i < this.hookPoints.size()) {
            if (((ConnectorRecord)this.hookPoints.get(i)).getName().equals(name)) {
                return (ConnectorRecord)this.hookPoints.get(i);
            }
            ++i;
        }
        i = 0;
        while (i < this.exitPoints.size()) {
            if (((ConnectorRecord)this.exitPoints.get(i)).getName().equals(name)) {
                return (ConnectorRecord)this.exitPoints.get(i);
            }
            ++i;
        }
        return null;
    }

    public MediaProvider getMediaProvider() {
        return this;
    }

    public String getProviderName() {
        return this.localModule.getName();
    }

    public String getProviderType() {
        return String.valueOf(this.localVendor.getName()) + "." + this.localModuleGroup.getName() + "." + this.localModule.getName() + "." + this.localModuleGroupVersion.getVersionNumber();
    }

    public boolean hasMediaContent() {
        return this.hasMediaContent;
    }

    public boolean hasSharedContent() {
        return true;
    }

    public boolean hasDefaultLibrary() {
        return false;
    }

    public MediaScript getScript() {
        return this.script;
    }

    public MediaLibrary getDefaultMediaLibrary() {
        return null;
    }

    public void getVariables(String endPointName, List variables, List visited) {
        if (!visited.contains(this.getRecord(endPointName))) {
            visited.add(this.getRecord(endPointName));
            int i = 0;
            while (i < this.incomingConnectors.size()) {
                Connector con = (Connector)this.incomingConnectors.get(i);
                int c = 0;
                while (c < con.getExitCodes().size()) {
                    ConnectorRecord cr = (ConnectorRecord)con.getExitCodes().get(c);
                    con.getOrigin().getVariables(cr.getName(), variables, visited);
                    ++c;
                }
                ++i;
            }
        }
        HashMap map = new HashMap();
        int i = 0;
        while (i < variables.size()) {
            map.put(((Variable)variables.get(i)).getName(), variables.get(i));
            ++i;
        }
        i = 0;
        while (i < this.localVariables.size()) {
            Variable v = (Variable)this.localVariables.get(i);
            if (map.get(v.name) == null) {
                variables.add(v);
            }
            ++i;
        }
    }

    public List getVariables() {
        ArrayList<Variable> ret = new ArrayList<Variable>();
        ArrayList listed = new ArrayList();
        int i = 0;
        while (i < this.incomingConnectors.size()) {
            Connector con = (Connector)this.incomingConnectors.get(i);
            int c = 0;
            while (c < con.getExitCodes().size()) {
                ConnectorRecord cr = (ConnectorRecord)con.getExitCodes().get(c);
                con.getOrigin().getVariables(cr.getName(), ret, listed);
                ++c;
            }
            ++i;
        }
        HashMap map = new HashMap();
        int i2 = 0;
        while (i2 < ret.size()) {
            map.put(((Variable)ret.get(i2)).getName(), ret.get(i2));
            ++i2;
        }
        i2 = 0;
        while (i2 < this.localVariables.size()) {
            Variable v = (Variable)this.localVariables.get(i2);
            if (map.get(v.name) == null) {
                ret.add(v);
            }
            ++i2;
        }
        return ret;
    }

    public void addPathListener(ConnectorOriginPathListener l) {
        this.listeners.remove(l);
        this.listeners.add(l);
    }

    public void removePathListener(ConnectorOriginPathListener l) {
        this.listeners.remove(l);
    }
}

