/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.ui.app.editor.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.vtp.desktop.ui.app.editor.MediaProvider;
import org.eclipse.vtp.desktop.ui.app.editor.MediaScript;
import org.eclipse.vtp.desktop.ui.app.editor.MediaScriptMessageObject;
import org.eclipse.vtp.desktop.ui.app.editor.model.Connector;
import org.eclipse.vtp.desktop.ui.app.editor.model.ConnectorDestination;
import org.eclipse.vtp.desktop.ui.app.editor.model.ConnectorOrigin;
import org.eclipse.vtp.desktop.ui.app.editor.model.ConnectorRecord;
import org.eclipse.vtp.desktop.ui.app.editor.model.Element;
import org.eclipse.vtp.desktop.ui.app.editor.model.PlayPromptPropertiesPanel;
import org.eclipse.vtp.desktop.ui.app.editor.model.event.ConnectorOriginPathListener;
import org.eclipse.vtp.framework.media.library.MediaLibrary;

public class PlayPromptElement
extends Element
implements ConnectorDestination,
ConnectorOrigin {
    List incomingConnectors;
    ConnectorRecord next = new ConnectorRecord(this, "Next", ConnectorRecord.EXIT_POINT);
    boolean force = true;
    private List listeners = new ArrayList();
    MediaProvider provider = new PlayPromptMediaProvider();

    public PlayPromptElement(String name) {
        super(name);
        this.incomingConnectors = new ArrayList();
    }

    public PlayPromptElement(String id, String name) {
        super(id, name);
        this.incomingConnectors = new ArrayList();
    }

    public boolean isForced() {
        return this.force;
    }

    public void setForced(boolean bargeIn) {
        this.force = bargeIn;
    }

    public void addIncomingConnector(Connector connector) {
        this.incomingConnectors.remove(connector);
        this.incomingConnectors.add(connector);
        this.validateStatus();
    }

    public void removeIncomingConnector(Connector connector) {
        this.incomingConnectors.remove(connector);
        this.validateStatus();
    }

    public ConnectorRecord getRecord(String name) {
        if (name.equals("Next")) {
            return this.next;
        }
        return null;
    }

    public List getHooks() {
        return this.getFreeHooks();
    }

    public List getFreeHooks() {
        return Collections.unmodifiableList(new ArrayList());
    }

    public List getExits() {
        return Collections.unmodifiableList(Arrays.asList(this.next));
    }

    public List getFreeExits() {
        ArrayList<ConnectorRecord> freeExits = new ArrayList<ConnectorRecord>();
        if (this.next.getConnector() == null) {
            freeExits.add(this.next);
        }
        return Collections.unmodifiableList(freeExits);
    }

    public void validateStatus() {
        super.validateStatus();
        boolean isExitedFrom = false;
        boolean isErrorFrom = false;
        boolean hasErrorFrom = false;
        if (this.next.getConnector() != null) {
            isExitedFrom = true;
        }
        if (this.incomingConnectors.size() < 1 || !this.hasPathToStart(null)) {
            this.setError(true);
        }
        if (!isErrorFrom && hasErrorFrom) {
            this.setTodo(true);
        }
        if (!isExitedFrom) {
            this.setWarning(true);
        }
    }

    public boolean hasPathToStart(List originPath) {
        if (originPath == null) {
            originPath = new ArrayList<PlayPromptElement>();
        }
        originPath.add(this);
        boolean ret = false;
        int i = 0;
        while (i < this.incomingConnectors.size()) {
            boolean has;
            Connector connector = (Connector)this.incomingConnectors.get(i);
            if (!originPath.contains(connector.getOrigin()) && (ret |= (has = connector.getOrigin().hasPathToStart(originPath)))) {
                return ret;
            }
            ++i;
        }
        return ret;
    }

    public void writeAttributes(org.w3c.dom.Element element) {
        super.writeAttributes(element);
        element.setAttribute("force", Boolean.toString(this.force));
    }

    public void readSettings(org.w3c.dom.Element element) {
        if (!element.getAttribute("force").equals("")) {
            this.force = Boolean.valueOf(element.getAttribute("force"));
        }
    }

    public MediaProvider getMediaProvider() {
        return this.provider;
    }

    public String getTagName() {
        return "prompt";
    }

    public List getPropertyPanels() {
        List ret = super.getPropertyPanels();
        ret.add(new PlayPromptPropertiesPanel(this));
        return ret;
    }

    public void getVariables(String endPointName, List variables, List visited) {
        if (!visited.contains(this.getRecord(endPointName))) {
            visited.add(this.getRecord(endPointName));
            int i = 0;
            while (i < this.incomingConnectors.size()) {
                Connector con = (Connector)this.incomingConnectors.get(i);
                int c = 0;
                while (c < con.getExitCodes().size()) {
                    ConnectorRecord cr = (ConnectorRecord)con.getExitCodes().get(c);
                    con.getOrigin().getVariables(cr.getName(), variables, visited);
                    ++c;
                }
                ++i;
            }
        }
    }

    public List getVariables() {
        ArrayList ret = new ArrayList();
        ArrayList listed = new ArrayList();
        int i = 0;
        while (i < this.incomingConnectors.size()) {
            Connector con = (Connector)this.incomingConnectors.get(i);
            int c = 0;
            while (c < con.getExitCodes().size()) {
                ConnectorRecord cr = (ConnectorRecord)con.getExitCodes().get(c);
                con.getOrigin().getVariables(cr.getName(), ret, listed);
                ++c;
            }
            ++i;
        }
        return ret;
    }

    public void addPathListener(ConnectorOriginPathListener l) {
        this.listeners.remove(l);
        this.listeners.add(l);
    }

    public void removePathListener(ConnectorOriginPathListener l) {
        this.listeners.remove(l);
    }

    public class PlayPromptMediaProvider
    implements MediaProvider {
        private MediaScript script = new MediaScript(this){
            final /* synthetic */ PlayPromptMediaProvider this$1;
            {
                this.this$1 = playPromptMediaProvider;
            }

            public List getDialogs() {
                ArrayList<MediaScriptMessageObject> ret = new ArrayList<MediaScriptMessageObject>();
                ret.add(new MediaScriptMessageObject("Message", this.this$1.getProviderType(), this.this$1.getId()));
                return ret;
            }
        };

        public String getId() {
            return PlayPromptElement.this.getId();
        }

        public String getProviderType() {
            return "PlayPrompt";
        }

        public String getProviderName() {
            return "PlayPrompt";
        }

        public boolean hasMediaContent() {
            return true;
        }

        public boolean hasSharedContent() {
            return false;
        }

        public boolean hasDefaultLibrary() {
            return false;
        }

        public MediaScript getScript() {
            return this.script;
        }

        public MediaLibrary getDefaultMediaLibrary() {
            return null;
        }
    }
}

