/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.ui.app.editor.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.vtp.desktop.ui.app.editor.MediaProvider;
import org.eclipse.vtp.desktop.ui.app.editor.model.BlankMediaProvider;
import org.eclipse.vtp.desktop.ui.app.editor.model.Connector;
import org.eclipse.vtp.desktop.ui.app.editor.model.ConnectorDestination;
import org.eclipse.vtp.desktop.ui.app.editor.model.Element;
import org.eclipse.vtp.desktop.ui.app.editor.model.TransferPropertiesPanel;

public class TransferElement
extends Element
implements ConnectorDestination {
    private String dn;
    private List incomingConnectors;
    private MediaProvider mediaProvider;

    public TransferElement(String dn) {
        super("Transfer: " + dn);
        this.dn = dn;
        this.incomingConnectors = new ArrayList();
        this.mediaProvider = new BlankMediaProvider(this.getId(), "Transfer", "buildin.genesys.transfer.1_0_0_0");
    }

    public TransferElement(String id, String name, String dn) {
        super(id, name);
        this.dn = dn;
        this.incomingConnectors = new ArrayList();
        this.mediaProvider = new BlankMediaProvider(this.getId(), "Transfer", "buildin.genesys.transfer.1_0_0_0");
    }

    public void validateStatus() {
        super.validateStatus();
        if (this.incomingConnectors.size() < 1 || !this.hasPathToStart()) {
            this.setError(true);
        }
    }

    public boolean hasPathToStart() {
        ArrayList<TransferElement> originPath = new ArrayList<TransferElement>();
        originPath.add(this);
        boolean ret = false;
        int i = 0;
        while (i < this.incomingConnectors.size()) {
            boolean has;
            Connector connector = (Connector)this.incomingConnectors.get(i);
            if (!originPath.contains(connector.getOrigin()) && (ret |= (has = connector.getOrigin().hasPathToStart(originPath)))) {
                return ret;
            }
            ++i;
        }
        return ret;
    }

    public String getDn() {
        return this.dn;
    }

    public void setDn(String dn) {
        this.dn = dn;
    }

    public String getTagName() {
        return "transfer";
    }

    public void writeAttributes(org.w3c.dom.Element element) {
        super.writeAttributes(element);
        element.setAttribute("dn", this.dn);
    }

    public void addIncomingConnector(Connector connector) {
        this.incomingConnectors.remove(connector);
        this.incomingConnectors.add(connector);
        this.validateStatus();
    }

    public void removeIncomingConnector(Connector connector) {
        this.incomingConnectors.remove(connector);
        this.validateStatus();
    }

    public MediaProvider getMediaProvider() {
        return this.mediaProvider;
    }

    public List getPropertyPanels() {
        List ret = super.getPropertyPanels();
        ret.add(new TransferPropertiesPanel(this));
        return ret;
    }
}

