/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.ui.app.editor.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.vtp.desktop.ui.app.editor.model.ComponentPropertiesPanel;
import org.eclipse.vtp.desktop.ui.app.editor.model.Connector;
import org.eclipse.vtp.desktop.ui.app.editor.model.ConnectorOrigin;
import org.eclipse.vtp.desktop.ui.app.editor.model.ConnectorRecord;
import org.eclipse.vtp.desktop.ui.app.editor.model.DataPoint;
import org.eclipse.vtp.desktop.ui.app.editor.model.GraphPoint;
import org.eclipse.vtp.desktop.ui.app.editor.model.IncursionHost;
import org.eclipse.vtp.desktop.ui.app.editor.model.Locatable;
import org.eclipse.vtp.desktop.ui.app.editor.model.ObjectDefinition;
import org.eclipse.vtp.desktop.ui.app.editor.model.ObjectField;
import org.eclipse.vtp.desktop.ui.app.editor.model.Selectable;
import org.eclipse.vtp.desktop.ui.app.editor.model.UIComponent;
import org.eclipse.vtp.desktop.ui.app.editor.model.UIElement;
import org.eclipse.vtp.desktop.ui.app.editor.model.Variable;
import org.eclipse.vtp.desktop.ui.app.editor.model.event.ConnectorOriginPathListener;
import org.eclipse.vtp.desktop.ui.shared.dialogs.FramedDialog;
import org.eclipse.vtp.framework.util.Geom;
import org.w3c.dom.Element;

public class UIConnector
extends UIComponent
implements Selectable,
ConnectorOriginPathListener {
    private UIElement origin;
    private UIElement destination;
    private boolean selected;
    private Connector connector;
    private ConnectorLine line;

    public UIConnector(UIElement origin, UIElement destination, Connector connector) {
        this(origin, destination, connector, false);
    }

    public UIConnector(UIElement origin, UIElement destination, Connector connector, boolean createLoopbackPoints) {
        this.origin = origin;
        this.destination = destination;
        this.connector = connector;
        connector.getOrigin().addPathListener(this);
        this.line = new ConnectorLine(createLoopbackPoints);
    }

    public Rectangle calculateBounds(GC font) {
        return this.line.calculateBounds(font);
    }

    public Rectangle getBounds() {
        return this.line.getBounds();
    }

    public void writeToDocument(Element parent) {
        Element connectorElement = parent.getOwnerDocument().createElement("connector");
        parent.appendChild(connectorElement);
        connectorElement.setAttribute("instance-id", this.connector.getId());
        Element midPointsElement = parent.getOwnerDocument().createElement("mid-points");
        connectorElement.appendChild(midPointsElement);
        this.line.writeToDocument(midPointsElement);
    }

    public void toggleLinePoint(int x, int y) {
        this.line.toggleLinePoint(x, y);
    }

    public boolean contains(int x, int y) {
        return this.line.contains(x, y);
    }

    public void paint(Map resourceMap, GC g, int style) {
        this.line.paint(resourceMap, g, style);
    }

    public Locatable getLocatable(int x, int y) {
        return this.line.getLocatable(x, y);
    }

    public void addMidPoint(int x, int y) {
        this.line.addMidPoint(x, y);
    }

    public void setLabelLocation(int segment, int lox, int loy) {
        this.line.label.setLabelLocation(segment, lox, loy);
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public Connector getConnector() {
        return this.connector;
    }

    public List getPropertyPanels() {
        List panels = super.getPropertyPanels();
        ConnectorPropertiesPanel cpp = new ConnectorPropertiesPanel(this);
        AttachedDataPropertiesPanel adpp = new AttachedDataPropertiesPanel(this);
        cpp.addEndPointListener(adpp);
        adpp.setEndPointProvider(cpp);
        panels.add(cpp);
        panels.add(adpp);
        return panels;
    }

    public void delete() {
        this.connector.getOrigin().removePathListener(this);
        super.delete();
    }

    public List getVariables() {
        ArrayList ret = new ArrayList();
        ArrayList listed = new ArrayList();
        List exits = this.connector.getExitCodes();
        int i = 0;
        while (i < exits.size()) {
            ConnectorRecord cr = (ConnectorRecord)exits.get(i);
            this.connector.getOrigin().getVariables(cr.getName(), ret, listed);
            ++i;
        }
        return ret;
    }

    public void pathRemoved(ConnectorOrigin origin, ConnectorRecord record) {
        List l = this.connector.getExitCodes();
        int i = 0;
        while (i < l.size()) {
            ConnectorRecord cr = (ConnectorRecord)l.get(i);
            if (cr.getName().equals(record.getName())) {
                this.connector.removeExitPoint(record);
            }
            ++i;
        }
        if (this.connector.getExitCodes().size() == 0) {
            this.getModelPage().deleteConnector(this);
            this.getModelPage().fireGraphicUpdate(null);
        }
    }

    public String getToolTip() {
        String ret = "";
        Map dataPoints = this.getConnector().getDataPoints();
        Iterator it = dataPoints.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String pathName = (String)entry.getKey();
            List dataList = (List)entry.getValue();
            if (dataList == null) continue;
            ret = String.valueOf(ret) + pathName + "\r\n";
            int i = 0;
            while (i < dataList.size()) {
                DataPoint dp = (DataPoint)dataList.get(i);
                ret = String.valueOf(ret) + "\t" + dp.getName() + " -> ";
                ret = dp.getType() == 0 ? String.valueOf(ret) + dp.getValue() : String.valueOf(ret) + "[" + dp.getValue() + "]";
                ret = String.valueOf(ret) + "\r\n";
                ++i;
            }
        }
        if (ret.equals("")) {
            return null;
        }
        return ret;
    }

    public static interface ConnectorEndPointProvider {
        public List getEndPoints();
    }

    public static interface ConnectorEndPointConsumer {
        public void endPointsChanged();
    }

    public class ConnectorPropertiesPanel
    extends ComponentPropertiesPanel
    implements ConnectorEndPointProvider {
        private UIConnector connector;
        Label instructionLabel;
        Button hookButton;
        Button resultButton;
        Combo hookSelection;
        org.eclipse.swt.widgets.List resultSelection;
        List hookItems;
        List exits;
        List epListeners;

        public ConnectorPropertiesPanel(UIConnector connector) {
            super("General");
            this.hookItems = new ArrayList();
            this.exits = new ArrayList();
            this.epListeners = new ArrayList();
            this.connector = connector;
        }

        public void createControls(Composite parent) {
            parent.setLayout((Layout)new FillLayout());
            Composite comp = new Composite(parent, 0);
            comp.setBackground(parent.getBackground());
            comp.setLayout((Layout)new FormLayout());
            this.instructionLabel = new Label(comp, 0);
            this.instructionLabel.setBackground(comp.getBackground());
            this.instructionLabel.setText("Please select the event(s) that will initiate this call flow.");
            FormData instructionLabelData = new FormData();
            instructionLabelData.left = new FormAttachment(0, 10);
            instructionLabelData.right = new FormAttachment(100, -10);
            instructionLabelData.top = new FormAttachment(0, 10);
            this.instructionLabel.setLayoutData((Object)instructionLabelData);
            this.hookButton = new Button(comp, 16);
            this.hookButton.setBackground(comp.getBackground());
            this.hookButton.setText("Hook");
            this.hookButton.addSelectionListener(new SelectionListener(this){
                final /* synthetic */ ConnectorPropertiesPanel this$1;
                {
                    this.this$1 = connectorPropertiesPanel;
                }

                public void widgetSelected(SelectionEvent e) {
                    ConnectorPropertiesPanel.access$1(this.this$1);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            FormData hookButtonData = new FormData();
            hookButtonData.left = new FormAttachment(0, 10);
            hookButtonData.top = new FormAttachment((Control)this.instructionLabel, 10);
            hookButtonData.right = new FormAttachment(0, 70);
            this.hookButton.setLayoutData((Object)hookButtonData);
            this.hookSelection = new Combo(comp, 12);
            this.hookSelection.addSelectionListener(new SelectionListener(this){
                final /* synthetic */ ConnectorPropertiesPanel this$1;
                {
                    this.this$1 = connectorPropertiesPanel;
                }

                public void widgetSelected(SelectionEvent e) {
                    ConnectorPropertiesPanel.access$1(this.this$1);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            FormData hookSelectionData = new FormData();
            hookSelectionData.left = new FormAttachment((Control)this.hookButton, 10, 131072);
            hookSelectionData.top = new FormAttachment((Control)this.instructionLabel, 10);
            hookSelectionData.right = new FormAttachment(100, -10);
            this.hookSelection.setLayoutData((Object)hookSelectionData);
            this.resultButton = new Button(comp, 16);
            this.resultButton.setBackground(comp.getBackground());
            this.resultButton.setText("Result");
            this.resultButton.addSelectionListener(new SelectionListener(this){
                final /* synthetic */ ConnectorPropertiesPanel this$1;
                {
                    this.this$1 = connectorPropertiesPanel;
                }

                public void widgetSelected(SelectionEvent e) {
                    ConnectorPropertiesPanel.access$1(this.this$1);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            FormData resultButtonData = new FormData();
            resultButtonData.left = new FormAttachment(0, 10);
            resultButtonData.top = new FormAttachment((Control)this.hookSelection, 10);
            resultButtonData.right = new FormAttachment(0, 70);
            this.resultButton.setLayoutData((Object)resultButtonData);
            this.resultSelection = new org.eclipse.swt.widgets.List(comp, 2562);
            this.resultSelection.addSelectionListener(new SelectionListener(this){
                final /* synthetic */ ConnectorPropertiesPanel this$1;
                {
                    this.this$1 = connectorPropertiesPanel;
                }

                public void widgetSelected(SelectionEvent e) {
                    ConnectorPropertiesPanel.access$1(this.this$1);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            FormData resultSelectionData = new FormData();
            resultSelectionData.left = new FormAttachment((Control)this.resultButton, 10);
            resultSelectionData.top = new FormAttachment((Control)this.hookSelection, 10);
            resultSelectionData.right = new FormAttachment(100, -10);
            resultSelectionData.bottom = new FormAttachment((Control)this.hookSelection, 120);
            this.resultSelection.setLayoutData((Object)resultSelectionData);
            List freeHooks = this.connector.getConnector().getOrigin().getFreeHooks();
            List freeExits = this.connector.getConnector().getOrigin().getFreeExits();
            List currentPoints = this.connector.getConnector().getExitCodes();
            int anchor = -1;
            int lead = -1;
            if (currentPoints.size() > 0) {
                if (((ConnectorRecord)currentPoints.get(0)).getType() == ConnectorRecord.HOOK_POINT) {
                    this.hookButton.setSelection(true);
                    Wrapper wrapper = new Wrapper((ConnectorRecord)currentPoints.get(0));
                    this.hookItems.add(wrapper);
                    this.hookSelection.add(wrapper.toString());
                } else {
                    anchor = 0;
                    lead = currentPoints.size() - 1;
                    this.resultButton.setSelection(true);
                    int i = 0;
                    while (i < currentPoints.size()) {
                        Wrapper wrapper = new Wrapper((ConnectorRecord)currentPoints.get(i));
                        this.exits.add(wrapper);
                        ++i;
                    }
                }
            } else if (freeHooks.size() > 0) {
                this.hookButton.setSelection(true);
            } else {
                this.resultButton.setSelection(true);
            }
            Iterator iterator = freeHooks.iterator();
            while (iterator.hasNext()) {
                ConnectorRecord record = (ConnectorRecord)iterator.next();
                Wrapper wrapper = new Wrapper(record);
                this.hookItems.add(wrapper);
                this.hookSelection.add(wrapper.toString());
            }
            if (this.hookItems.size() > 0) {
                this.hookSelection.select(0);
            } else {
                this.hookButton.setEnabled(false);
                this.hookSelection.setEnabled(false);
            }
            iterator = freeExits.iterator();
            while (iterator.hasNext()) {
                this.exits.add(new Wrapper((ConnectorRecord)iterator.next()));
            }
            Object[] objs = this.exits.toArray();
            int i = 0;
            while (i < objs.length) {
                this.resultSelection.add(objs[i].toString());
                ++i;
            }
            this.resultSelection.select(anchor, lead);
        }

        public void save() {
            Iterator iterator = this.connector.getConnector().exitCodes.iterator();
            while (iterator.hasNext()) {
                ((ConnectorRecord)iterator.next()).setConnector(null);
            }
            this.connector.getConnector().exitCodes.clear();
            UIConnector.this.fireUpdateStatusRequest();
            if (this.hookButton.getSelection()) {
                ConnectorRecord record = ((Wrapper)this.hookItems.get(this.hookSelection.getSelectionIndex())).getRecord();
                this.connector.getConnector().addExitPoint(record);
            } else {
                int[] sidex = this.resultSelection.getSelectionIndices();
                int i = 0;
                while (i < sidex.length) {
                    ConnectorRecord record = ((Wrapper)this.exits.get(sidex[i])).getRecord();
                    this.connector.getConnector().addExitPoint(record);
                    ++i;
                }
            }
            UIConnector.this.fireUpdateStatusRequest();
            UIConnector.this.fireModifiedRequest();
            UIConnector.this.getModelPage().getModel().fireInternalModified();
        }

        public void addEndPointListener(ConnectorEndPointConsumer cepc) {
            this.epListeners.remove(cepc);
            this.epListeners.add(cepc);
        }

        public void removeEndPointListener(ConnectorEndPointConsumer cepc) {
            this.epListeners.remove(cepc);
        }

        private void fireEndPointUpdate() {
            int i = 0;
            while (i < this.epListeners.size()) {
                ((ConnectorEndPointConsumer)this.epListeners.get(i)).endPointsChanged();
                ++i;
            }
        }

        public List getEndPoints() {
            ArrayList<ConnectorRecord> ret = new ArrayList<ConnectorRecord>();
            if (this.hookButton.getSelection()) {
                if (this.hookSelection.getSelectionIndex() != -1) {
                    ConnectorRecord record = ((Wrapper)this.hookItems.get(this.hookSelection.getSelectionIndex())).getRecord();
                    ret.add(record);
                }
            } else {
                int[] sidex = this.resultSelection.getSelectionIndices();
                int i = 0;
                while (i < sidex.length) {
                    ConnectorRecord record = ((Wrapper)this.exits.get(sidex[i])).getRecord();
                    ret.add(record);
                    ++i;
                }
            }
            return ret;
        }

        static /* synthetic */ void access$1(ConnectorPropertiesPanel connectorPropertiesPanel) {
            connectorPropertiesPanel.fireEndPointUpdate();
        }

        public class Wrapper {
            private ConnectorRecord record;

            public Wrapper(ConnectorRecord record) {
                this.record = record;
            }

            public ConnectorRecord getRecord() {
                return this.record;
            }

            public String toString() {
                String ret = this.record.getName();
                if (this.record.getConnector() != null && this.record.getConnector() == ConnectorPropertiesPanel.this.connector.getConnector()) {
                    ret = String.valueOf(ret) + " (Current)";
                }
                return ret;
            }
        }
    }

    public class AttachedDataPropertiesPanel
    extends ComponentPropertiesPanel
    implements ConnectorEndPointConsumer {
        UIConnector pade;
        Map dataPoints;
        TreeViewer treeViewer;
        ConnectorEndPointProvider cepp;
        Label noPathsSelectedLabel;
        Menu menu;

        public AttachedDataPropertiesPanel(UIConnector pade) {
            super("Attached Data");
            this.pade = null;
            this.noPathsSelectedLabel = null;
            this.menu = null;
            this.pade = pade;
            this.dataPoints = new HashMap(pade.getConnector().getDataPoints());
        }

        public void setEndPointProvider(ConnectorEndPointProvider cepp) {
            this.cepp = cepp;
        }

        public void createControls(Composite parent) {
            Composite comp = new Composite(parent, 0);
            comp.setBackground(parent.getBackground());
            comp.setLayout((Layout)new FormLayout());
            this.noPathsSelectedLabel = new Label(comp, 0);
            this.noPathsSelectedLabel.setText("No Exits or Results have been selected.");
            this.noPathsSelectedLabel.setForeground(Display.getCurrent().getSystemColor(3));
            this.noPathsSelectedLabel.setBackground(comp.getBackground());
            Point p = this.noPathsSelectedLabel.computeSize(-1, -1);
            FormData fd = new FormData();
            fd.left = new FormAttachment(50, p.x / 2 * -1);
            fd.top = new FormAttachment(50, p.y / 2 * -1);
            fd.right = new FormAttachment(50, p.x / 2);
            fd.bottom = new FormAttachment(50, p.y / 2);
            this.noPathsSelectedLabel.setLayoutData((Object)fd);
            this.noPathsSelectedLabel.setVisible(this.cepp.getEndPoints().size() < 1);
            Tree tree = new Tree(comp, 67588);
            tree.setHeaderVisible(true);
            TreeColumn targetColumn = new TreeColumn(tree, 0);
            targetColumn.setText("Attached Data Name");
            targetColumn.setResizable(true);
            targetColumn.setWidth(100);
            TreeColumn dataColumn = new TreeColumn(tree, 0);
            dataColumn.setText("Value");
            dataColumn.setResizable(true);
            dataColumn.setWidth(100);
            this.treeViewer = new TreeViewer(tree);
            this.treeViewer.setContentProvider((IContentProvider)new DataPointContentProvider());
            this.treeViewer.setLabelProvider((IBaseLabelProvider)new DataPointLabelProvider());
            this.treeViewer.setInput((Object)this);
            fd = new FormData();
            fd.left = new FormAttachment(0, 5);
            fd.top = new FormAttachment(0, 5);
            fd.right = new FormAttachment(100, -5);
            fd.bottom = new FormAttachment(100, -5);
            tree.setLayoutData((Object)fd);
            this.hookContextMenu();
            if (this.cepp.getEndPoints().size() < 1) {
                this.treeViewer.getControl().setMenu(null);
            }
            this.hookDoubleClick();
        }

        private void hookContextMenu() {
            MenuManager menuMgr = new MenuManager("#PopupMenu");
            menuMgr.setRemoveAllWhenShown(true);
            menuMgr.addMenuListener(new IMenuListener(this){
                final /* synthetic */ AttachedDataPropertiesPanel this$1;
                {
                    this.this$1 = attachedDataPropertiesPanel;
                }

                public void menuAboutToShow(IMenuManager manager) {
                    AttachedDataPropertiesPanel.access$0(this.this$1, manager);
                }
            });
            this.menu = menuMgr.createContextMenu(this.treeViewer.getControl());
            this.treeViewer.getControl().setMenu(this.menu);
        }

        private void fillContextMenu(IMenuManager manager) {
            manager.add((IAction)new AddDataPointAction());
            manager.add((IAction)new RemoveDataPointAction());
        }

        private void hookDoubleClick() {
            this.treeViewer.addDoubleClickListener(new IDoubleClickListener(this){
                final /* synthetic */ AttachedDataPropertiesPanel this$1;
                {
                    this.this$1 = attachedDataPropertiesPanel;
                }

                public void doubleClick(DoubleClickEvent event) {
                    IStructuredSelection iss;
                    if (!this.this$1.treeViewer.getSelection().isEmpty() && (iss = (IStructuredSelection)this.this$1.treeViewer.getSelection()).getFirstElement() instanceof DataPoint) {
                        DataPoint dp = (DataPoint)iss.getFirstElement();
                        DataPointDialog dpd = this.this$1.new DataPointDialog(Display.getCurrent().getActiveShell());
                        dpd.setDataPoint(dp);
                        if (dpd.open() == 0) {
                            dp.setName(dpd.name);
                            dp.setType(dpd.type);
                            dp.setValue(dpd.value);
                            this.this$1.treeViewer.refresh();
                        }
                    }
                }
            });
        }

        public void save() {
            UIConnector.this.connector.setDataPoints(this.dataPoints);
        }

        public void endPointsChanged() {
            if (this.cepp.getEndPoints().size() < 1) {
                this.treeViewer.getControl().setMenu(null);
                this.noPathsSelectedLabel.setVisible(true);
            } else {
                this.noPathsSelectedLabel.setVisible(false);
                this.hookContextMenu();
            }
            this.noPathsSelectedLabel.getParent().layout(true, true);
            this.treeViewer.refresh();
        }

        static /* synthetic */ void access$0(AttachedDataPropertiesPanel attachedDataPropertiesPanel, IMenuManager iMenuManager) {
            attachedDataPropertiesPanel.fillContextMenu(iMenuManager);
        }

        public class DataPointContentProvider
        implements ITreeContentProvider {
            public Object[] getElements(Object inputElement) {
                ArrayList<String> ret = new ArrayList<String>();
                List recs = AttachedDataPropertiesPanel.this.cepp.getEndPoints();
                int i = 0;
                while (i < recs.size()) {
                    ret.add(((ConnectorRecord)recs.get(i)).getName());
                    ++i;
                }
                return ret.toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getChildren(Object parentElement) {
                return AttachedDataPropertiesPanel.this.dataPoints.get((String)parentElement) == null ? null : ((List)AttachedDataPropertiesPanel.this.dataPoints.get((String)parentElement)).toArray();
            }

            public Object getParent(Object element) {
                if (element instanceof String) {
                    return null;
                }
                return ((DataPoint)element).getParent();
            }

            public boolean hasChildren(Object element) {
                return element instanceof String;
            }
        }

        public class DataPointLabelProvider
        implements ITableLabelProvider {
            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                if (columnIndex == 0) {
                    if (element instanceof String) {
                        return (String)element;
                    }
                    return ((DataPoint)element).getName();
                }
                if (element instanceof String) {
                    return null;
                }
                return ((DataPoint)element).getValue();
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return true;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        }

        public class AddDataPointAction
        extends Action {
            public AddDataPointAction() {
                this.setText("Add Attached Data");
            }

            public void run() {
                DataPointDialog dpd = new DataPointDialog(Display.getCurrent().getActiveShell());
                if (dpd.open() == 0) {
                    Object obj = ((IStructuredSelection)AttachedDataPropertiesPanel.this.treeViewer.getSelection()).getFirstElement();
                    DataPoint dp = new DataPoint(obj instanceof String ? (String)obj : ((DataPoint)obj).getParent(), dpd.name, dpd.type, dpd.value);
                    ArrayList<DataPoint> l = (ArrayList<DataPoint>)AttachedDataPropertiesPanel.this.dataPoints.get(dp.getParent());
                    if (l == null) {
                        l = new ArrayList<DataPoint>();
                        AttachedDataPropertiesPanel.this.dataPoints.put(dp.getParent(), l);
                    }
                    l.add(dp);
                    AttachedDataPropertiesPanel.this.treeViewer.refresh();
                }
            }
        }

        public class RemoveDataPointAction
        extends Action {
            public RemoveDataPointAction() {
                this.setText("Remove Attached Data");
            }

            public void run() {
                Object obj = ((IStructuredSelection)AttachedDataPropertiesPanel.this.treeViewer.getSelection()).getFirstElement();
                if (obj instanceof DataPoint) {
                    ((List)AttachedDataPropertiesPanel.this.dataPoints.get(((DataPoint)obj).getParent())).remove(obj);
                    AttachedDataPropertiesPanel.this.treeViewer.refresh();
                }
            }
        }

        public class DataPointDialog
        extends FramedDialog {
            Color darkBlue;
            Color lightBlue;
            Text nameField;
            Button staticButton;
            Text staticField;
            Button variableButton;
            TreeViewer variableViewer;
            String name;
            int type;
            String value;
            DataPoint dp;
            Button okButton;

            public DataPointDialog(Shell shell) {
                super(shell);
                this.okButton = null;
                this.setSideBarSize(20);
                this.setTitle("Add Attached Data");
            }

            public void setDataPoint(DataPoint dp) {
                this.dp = dp;
            }

            protected void createButtonBar(Composite parent) {
                parent.setLayout((Layout)new GridLayout(1, true));
                Composite buttons = new Composite(parent, 0);
                buttons.setBackground(parent.getBackground());
                GridData buttonsData = new GridData(1808);
                buttonsData.horizontalAlignment = 131072;
                buttons.setLayoutData((Object)buttonsData);
                RowLayout rl = new RowLayout();
                rl.pack = false;
                rl.spacing = 5;
                buttons.setLayout((Layout)rl);
                this.okButton = new Button(buttons, 0x800000);
                this.okButton.setText("Ok");
                this.okButton.addSelectionListener(new SelectionListener(this){
                    final /* synthetic */ DataPointDialog this$2;
                    {
                        this.this$2 = dataPointDialog;
                    }

                    public void widgetSelected(SelectionEvent e) {
                        this.this$2.okPressed();
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                Button cancelButton = new Button(buttons, 0x800000);
                cancelButton.setText("Cancel");
                cancelButton.addSelectionListener(new SelectionListener(this){
                    final /* synthetic */ DataPointDialog this$2;
                    {
                        this.this$2 = dataPointDialog;
                    }

                    public void widgetSelected(SelectionEvent e) {
                        this.this$2.cancelPressed();
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
            }

            public void okPressed() {
                IStructuredSelection iss;
                this.name = this.nameField.getText();
                int n = this.type = this.staticButton.getSelection() ? 0 : 1;
                this.value = this.type == 0 ? this.staticField.getText() : (!(iss = (IStructuredSelection)this.variableViewer.getSelection()).isEmpty() ? ((ObjectDefinition)iss.getFirstElement()).getPath() : "");
                this.setReturnCode(0);
                this.close();
            }

            public void cancelPressed() {
                this.setReturnCode(256);
                this.close();
            }

            protected void createDialogContents(Composite parent) {
                this.darkBlue = new Color((Device)parent.getDisplay(), 77, 113, 179);
                this.lightBlue = new Color((Device)parent.getDisplay(), 240, 243, 249);
                parent.addDisposeListener(new DisposeListener(this){
                    final /* synthetic */ DataPointDialog this$2;
                    {
                        this.this$2 = dataPointDialog;
                    }

                    public void widgetDisposed(DisposeEvent e) {
                        this.this$2.darkBlue.dispose();
                        this.this$2.lightBlue.dispose();
                    }
                });
                this.setFrameColor(this.darkBlue);
                this.setSideBarColor(this.lightBlue);
                parent.setLayout((Layout)new GridLayout(1, false));
                Label nameLabel = new Label(parent, 0);
                nameLabel.setText("Name");
                nameLabel.setBackground(parent.getBackground());
                GridData gd = new GridData(768);
                nameLabel.setLayoutData((Object)gd);
                this.nameField = new Text(parent, 2052);
                if (this.dp != null) {
                    this.nameField.setText(this.dp.getName());
                }
                this.nameField.addKeyListener(new KeyListener(this){
                    final /* synthetic */ DataPointDialog this$2;
                    {
                        this.this$2 = dataPointDialog;
                    }

                    public void keyPressed(KeyEvent e) {
                    }

                    public void keyReleased(KeyEvent e) {
                        this.this$2.checkComplete();
                    }
                });
                gd = new GridData(768);
                this.nameField.setLayoutData((Object)gd);
                this.staticButton = new Button(parent, 16);
                this.staticButton.setText("Static Value");
                this.staticButton.setBackground(parent.getBackground());
                this.staticButton.addSelectionListener(new SelectionListener(this){
                    final /* synthetic */ DataPointDialog this$2;
                    {
                        this.this$2 = dataPointDialog;
                    }

                    public void widgetSelected(SelectionEvent e) {
                        this.this$2.checkComplete();
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                gd = new GridData(768);
                this.staticButton.setLayoutData((Object)gd);
                this.staticField = new Text(parent, 2052);
                if (this.dp != null && this.dp.getType() == 0) {
                    this.staticField.setText(this.dp.getValue());
                }
                this.staticField.addKeyListener(new KeyListener(this){
                    final /* synthetic */ DataPointDialog this$2;
                    {
                        this.this$2 = dataPointDialog;
                    }

                    public void keyPressed(KeyEvent e) {
                    }

                    public void keyReleased(KeyEvent e) {
                        this.this$2.checkComplete();
                    }
                });
                gd = new GridData(768);
                gd.horizontalIndent = 15;
                this.staticField.setLayoutData((Object)gd);
                this.variableButton = new Button(parent, 16);
                this.variableButton.setText("Existing Variable");
                this.variableButton.setBackground(parent.getBackground());
                gd = new GridData(768);
                this.variableButton.setLayoutData((Object)gd);
                this.variableButton.addSelectionListener(new SelectionListener(this){
                    final /* synthetic */ DataPointDialog this$2;
                    {
                        this.this$2 = dataPointDialog;
                    }

                    public void widgetSelected(SelectionEvent e) {
                        this.this$2.checkComplete();
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                Tree varTree = new Tree(parent, 2052);
                TreeColumn nameColumn = new TreeColumn(varTree, 0);
                nameColumn.setText("Attached Data Name");
                nameColumn.setResizable(true);
                nameColumn.setWidth(150);
                TreeColumn valueColumn = new TreeColumn(varTree, 0);
                valueColumn.setText("Value");
                valueColumn.setResizable(true);
                valueColumn.setWidth(150);
                varTree.setHeaderVisible(true);
                this.variableViewer = new TreeViewer(varTree);
                this.variableViewer.setContentProvider((IContentProvider)new VariableContentProvider());
                this.variableViewer.setLabelProvider((IBaseLabelProvider)new VariableLabelProvider());
                this.variableViewer.setInput((Object)this);
                gd = new GridData(1808);
                gd.horizontalIndent = 15;
                gd.widthHint = 350;
                gd.heightHint = 130;
                this.variableViewer.getControl().setLayoutData((Object)gd);
                if (this.dp != null) {
                    if (this.dp.getType() == 0) {
                        this.staticButton.setSelection(true);
                    } else {
                        this.variableButton.setSelection(true);
                    }
                } else {
                    this.staticButton.setSelection(true);
                }
                this.variableViewer.addSelectionChangedListener(new ISelectionChangedListener(this){
                    final /* synthetic */ DataPointDialog this$2;
                    {
                        this.this$2 = dataPointDialog;
                    }

                    public void selectionChanged(SelectionChangedEvent event) {
                        this.this$2.checkComplete();
                    }
                });
                this.checkComplete();
                this.nameField.setFocus();
            }

            public void checkComplete() {
                boolean complete = true;
                if (this.nameField.getText().length() < 1) {
                    complete = false;
                } else if (this.staticButton.getSelection()) {
                    if (this.staticField.getText().length() < 1) {
                        complete = false;
                    }
                } else if (this.variableButton.getSelection() && this.variableViewer.getSelection().isEmpty()) {
                    complete = false;
                }
                this.okButton.setEnabled(complete);
            }

            public class VariableContentProvider
            implements ITreeContentProvider {
                public Object[] getChildren(Object parentElement) {
                    if (parentElement instanceof ObjectDefinition) {
                        ObjectDefinition v = (ObjectDefinition)parentElement;
                        return v.getFields().toArray();
                    }
                    return null;
                }

                public Object getParent(Object element) {
                    if (element instanceof Variable) {
                        return null;
                    }
                    return ((ObjectField)element).getParent();
                }

                public boolean hasChildren(Object element) {
                    return ((ObjectDefinition)element).getFields().size() > 0;
                }

                public Object[] getElements(Object inputElement) {
                    return UIConnector.this.getVariables().toArray();
                }

                public void dispose() {
                }

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }
            }

            public class VariableLabelProvider
            implements ITableLabelProvider {
                public Image getColumnImage(Object element, int columnIndex) {
                    return null;
                }

                public String getColumnText(Object element, int columnIndex) {
                    if (columnIndex == 0) {
                        return ((ObjectDefinition)element).getName();
                    }
                    if (element instanceof Variable) {
                        return "";
                    }
                    return ((ObjectField)element).getType().getTypeName();
                }

                public void addListener(ILabelProviderListener listener) {
                }

                public void dispose() {
                }

                public boolean isLabelProperty(Object element, String property) {
                    return true;
                }

                public void removeListener(ILabelProviderListener listener) {
                }
            }
        }
    }

    public class ConnectorLine {
        private List points;
        private LineLabel label;
        private java.awt.Point upperLeft = new java.awt.Point(0, 0);
        private java.awt.Point lowerRight = new java.awt.Point(0, 0);

        public ConnectorLine() {
            this(true);
        }

        public ConnectorLine(boolean createLoopBackPoints) {
            this.points = new ArrayList();
            this.points.add(new ConnectorEndGraphPoint(UIConnector.this.origin));
            if (createLoopBackPoints && UIConnector.this.origin == UIConnector.this.destination) {
                this.points.add(new MidPoint(UIConnector.this.origin.getX() + 50, UIConnector.this.origin.getY() - 30));
                this.points.add(new MidPoint(UIConnector.this.origin.getX() + 50, UIConnector.this.origin.getY() + 30));
            }
            this.points.add(new ConnectorEndGraphPoint(UIConnector.this.destination));
            this.label = new LineLabel();
        }

        public Rectangle calculateBounds(GC font) {
            java.awt.Point[] ps = this.getPoints();
            int rx = Integer.MAX_VALUE;
            int ry = Integer.MAX_VALUE;
            int rw = 0;
            int rh = 0;
            int i = 0;
            while (i < ps.length) {
                rx = Math.min(rx, ps[i].x - 10);
                ry = Math.min(ry, ps[i].y - 10);
                rw = Math.max(rw, ps[i].x + 10);
                rh = Math.max(rh, ps[i].y + 10);
                ++i;
            }
            Rectangle ret = new Rectangle(Math.max(rx, 0), Math.max(ry, 0), rw - rx, rh - ry);
            return ret.union(this.label.calculateBounds(font));
        }

        public Rectangle getBounds() {
            java.awt.Point[] ps = this.getPoints();
            int rx = Integer.MAX_VALUE;
            int ry = Integer.MAX_VALUE;
            int rw = 0;
            int rh = 0;
            int i = 0;
            while (i < ps.length) {
                rx = Math.min(rx, ps[i].x);
                ry = Math.min(ry, ps[i].y);
                rw = Math.max(rw, ps[i].x);
                rh = Math.max(rh, ps[i].y);
                ++i;
            }
            this.upperLeft.x = rx;
            this.upperLeft.y = ry;
            this.lowerRight.x = rw;
            this.lowerRight.y = rh;
            return new Rectangle(this.upperLeft.x, this.upperLeft.y, this.lowerRight.x - this.upperLeft.x, this.lowerRight.y - this.upperLeft.y).union(this.label.getBounds());
        }

        public void writeToDocument(Element parent) {
            parent.setAttribute("number", Integer.toString(this.points.size() - 2));
            int i = 1;
            while (i < this.points.size() - 1) {
                MidPoint mp = (MidPoint)this.points.get(i);
                Element midPointElement = parent.getOwnerDocument().createElement("mid-point");
                parent.appendChild(midPointElement);
                midPointElement.setAttribute("x", Integer.toString(mp.getX()));
                midPointElement.setAttribute("y", Integer.toString(mp.getY()));
                midPointElement.setAttribute("index", Integer.toString(i - 1));
                ++i;
            }
            Element root = (Element)parent.getParentNode();
            Element labelElement = root.getOwnerDocument().createElement("label-position");
            root.appendChild(labelElement);
            labelElement.setAttribute("segment", Integer.toString(this.label.linePointIndex));
            labelElement.setAttribute("lox", Integer.toString(this.label.lox));
            labelElement.setAttribute("loy", Integer.toString(this.label.loy));
        }

        public void addMidPoint(int x, int y) {
            this.points.add(this.points.size() - 1, new MidPoint(x, y));
        }

        public void toggleLinePoint(int x, int y) {
            int i = 1;
            while (i < this.points.size() - 1) {
                MidPoint gp = (MidPoint)this.points.get(i);
                if (gp.contains(x, y)) {
                    if (UIConnector.this.origin != UIConnector.this.destination || UIConnector.this.origin == UIConnector.this.destination && this.points.size() > 4) {
                        this.points.remove(i);
                        this.label.resetLocation();
                        UIConnector.this.fireUpdateRequest();
                        return;
                    }
                    return;
                }
                ++i;
            }
            java.awt.Point[] ps = this.getPoints();
            int i2 = 0;
            while (i2 < ps.length - 1) {
                if (x >= Math.min(ps[i2].x, ps[i2 + 1].x) - 5 && x <= Math.max(ps[i2].x, ps[i2 + 1].x) + 5 && y >= Math.min(ps[i2].y, ps[i2 + 1].y) - 5 && y <= Math.max(ps[i2].y, ps[i2 + 1].y) + 5) {
                    if (ps[i2].x == ps[i2 + 1].x) {
                        if (Math.abs(x - ps[i2].x) < 5) {
                            MidPoint mp = new MidPoint(x, y);
                            this.points.add(i2 + 1, mp);
                            UIConnector.this.fireUpdateRequest();
                            return;
                        }
                    } else if (ps[i2].y == ps[i2 + 1].y) {
                        if (Math.abs(y - ps[i2].y) < 5) {
                            MidPoint mp = new MidPoint(x, y);
                            this.points.add(i2 + 1, mp);
                            UIConnector.this.fireUpdateRequest();
                            return;
                        }
                    } else if (Geom.DistancePointLine((Geom.Point3D)Geom.newPoint3D((float)x, (float)y, (float)0.0f), (Geom.Point3D)Geom.newPoint3D((float)ps[i2].x, (float)ps[i2].y, (float)0.0f), (Geom.Point3D)Geom.newPoint3D((float)ps[i2 + 1].x, (float)ps[i2 + 1].y, (float)0.0f)) < 5.0f) {
                        MidPoint mp = new MidPoint(x, y);
                        this.points.add(i2 + 1, mp);
                        UIConnector.this.fireUpdateRequest();
                        return;
                    }
                }
                ++i2;
            }
        }

        public Locatable getLocatable(int x, int y) {
            int i = 1;
            while (i < this.points.size() - 1) {
                MidPoint mp = (MidPoint)this.points.get(i);
                if (mp.contains(x, y)) {
                    return mp;
                }
                ++i;
            }
            if (this.label.contains(x, y)) {
                return this.label;
            }
            return null;
        }

        public boolean contains(int x, int y) {
            boolean ret = false;
            ret = this.label.contains(x, y);
            if (!ret) {
                java.awt.Point[] ps = this.getPoints();
                int i = 0;
                while (i < ps.length - 1) {
                    if (x >= Math.min(ps[i].x, ps[i + 1].x) - 5 && x <= Math.max(ps[i].x, ps[i + 1].x) + 5 && y >= Math.min(ps[i].y, ps[i + 1].y) - 5 && y <= Math.max(ps[i].y, ps[i + 1].y) + 5) {
                        ret = ps[i].x == ps[i + 1].x ? (ret |= Math.abs(x - ps[i].x) < 5) : (ps[i].y == ps[i + 1].y ? (ret |= Math.abs(y - ps[i].y) < 5) : (ret |= Geom.DistancePointLine((Geom.Point3D)Geom.newPoint3D((float)x, (float)y, (float)0.0f), (Geom.Point3D)Geom.newPoint3D((float)ps[i].x, (float)ps[i].y, (float)0.0f), (Geom.Point3D)Geom.newPoint3D((float)ps[i + 1].x, (float)ps[i + 1].y, (float)0.0f)) < 5.0f));
                        if (ret) break;
                    }
                    ++i;
                }
            }
            return ret;
        }

        public java.awt.Point[] getPoints() {
            java.awt.Point[] ps = new java.awt.Point[this.points.size()];
            int i = 0;
            while (i < this.points.size()) {
                ps[i] = i == this.points.size() - 1 ? ((GraphPoint)this.points.get(i)).getPoint(((GraphPoint)this.points.get(i - 1)).getRegistryPoint()) : ((GraphPoint)this.points.get(i)).getPoint(((GraphPoint)this.points.get(i + 1)).getRegistryPoint());
                if (ps[i] == null) {
                    ps[i] = ((GraphPoint)this.points.get(i)).getRegistryPoint();
                }
                ++i;
            }
            return ps;
        }

        public void paint(Map resourceMap, GC g, int style) {
            Color black = this.getColor(resourceMap, "COLOR_BLACK", 0, 0, 0);
            Color blue = this.getColor(resourceMap, "COLOR_BLUE", 0, 0, 0);
            if ((style & 4) == 0 && UIConnector.this.selected) {
                g.setForeground(blue);
            } else {
                g.setForeground(black);
            }
            java.awt.Point[] ps = this.getPoints();
            if (ps[0] != null) {
                int i = 0;
                while (i < ps.length - 1) {
                    if (ps[i] != null && ps[i + 1] != null) {
                        g.drawLine(ps[i].x, ps[i].y, ps[i + 1].x, ps[i + 1].y);
                    }
                    ++i;
                }
                if (ps[ps.length - 1] != null) {
                    java.awt.Point incursion = ps[ps.length - 1];
                    java.awt.Point oi = ps[ps.length - 2];
                    double rise1 = incursion.getY() - oi.getY();
                    double run1 = incursion.getX() - oi.getX();
                    double dist = Math.sqrt(Math.pow(rise1, 2.0) + Math.pow(run1, 2.0));
                    double line1Xnorm = run1 / dist;
                    double line1Ynorm = rise1 / dist;
                    double perpX = incursion.getX() + -12.0 * line1Xnorm;
                    double perpY = incursion.getY() + -12.0 * line1Ynorm;
                    double a1x = perpX + -6.0 * line1Ynorm;
                    double a1y = perpY + 6.0 * line1Xnorm;
                    double a2x = perpX + 6.0 * line1Ynorm;
                    double a2y = perpY + -6.0 * line1Xnorm;
                    g.drawLine(incursion.x, incursion.y, (int)a1x, (int)a1y);
                    g.drawLine(incursion.x, incursion.y, (int)a2x, (int)a2y);
                }
                if ((style & 4) == 0) {
                    i = 0;
                    while (i < ps.length - 1) {
                        if (ps[i] != null && ps[i + 1] != null && UIConnector.this.selected && i != 0) {
                            MidPoint mp = (MidPoint)this.points.get(i);
                            g.setBackground(black);
                            g.fillRectangle(mp.getUpperLeft().x, mp.getUpperLeft().y, mp.getLowerRight().x - mp.getUpperLeft().x, mp.getLowerRight().y - mp.getUpperLeft().y);
                        }
                        ++i;
                    }
                }
                if ((style & 1) == 0) {
                    this.label.paint(resourceMap, g);
                }
            }
        }

        public Color getColor(Map resourceMap, String name, int r, int g, int b) {
            Object obj = resourceMap.get(name);
            if (obj != null) {
                return (Color)obj;
            }
            Color c = new Color((Device)Display.getCurrent(), r, g, b);
            resourceMap.put(name, c);
            return c;
        }

        public class MidPoint
        implements Locatable,
        GraphPoint {
            private int mx;
            private int my;

            public MidPoint(int x, int y) {
                this.mx = x;
                this.my = y;
            }

            public void setLocation(int x, int y) {
                this.mx = x;
                this.my = y;
            }

            public int getX() {
                return this.mx;
            }

            public int getY() {
                return this.my;
            }

            public java.awt.Point getUpperLeft() {
                return new java.awt.Point(this.mx - 3, this.my - 3);
            }

            public java.awt.Point getLowerRight() {
                return new java.awt.Point(this.mx + 3, this.my + 3);
            }

            public boolean contains(int x, int y) {
                java.awt.Point ul = this.getUpperLeft();
                java.awt.Point lr = this.getLowerRight();
                return new Rectangle(ul.x, ul.y, lr.x - ul.x, lr.y - ul.y).contains(x, y);
            }

            public java.awt.Point getPoint(java.awt.Point p) {
                return new java.awt.Point(this.mx, this.my);
            }

            public java.awt.Point getRegistryPoint() {
                return new java.awt.Point(this.mx, this.my);
            }
        }

        public class LineLabel
        implements Locatable {
            private int lox = 0;
            private int loy = 0;
            private int linePointIndex = 0;
            private java.awt.Point upperLeft = new java.awt.Point(this.getX() - 10, this.getY() - 10);
            private java.awt.Point lowerRight = new java.awt.Point(this.getX() + 10, this.getY() + 10);

            public void setLabelLocation(int segment, int lox, int loy) {
                java.awt.Point[] points = ConnectorLine.this.getPoints();
                if (segment < 0 || segment >= points.length - 1) {
                    segment = 0;
                    lox = 0;
                    loy = 0;
                }
                this.linePointIndex = segment;
                this.lox = lox;
                this.loy = loy;
                this.upperLeft = new java.awt.Point(this.getX() - 10, this.getY() - 10);
                this.lowerRight = new java.awt.Point(this.getX() + 10, this.getY() + 10);
            }

            public Rectangle calculateBounds(GC g) {
                int nw = 0;
                int nh = 0;
                Iterator iterator = ((ConnectorLine)ConnectorLine.this).UIConnector.this.getConnector().exitCodes.iterator();
                while (iterator.hasNext()) {
                    ConnectorRecord cr = (ConnectorRecord)iterator.next();
                    Point np = g.stringExtent(cr.getName());
                    nw = Math.max(nw, np.x);
                    nh = nh + 2 + np.y;
                }
                this.upperLeft = new java.awt.Point(this.getX() - (nw / 2 + 2), this.getY() - ((nh -= 2) / 2 + 2));
                this.lowerRight = new java.awt.Point(this.getX() + (nw / 2 + 2), this.getY() + (nh / 2 + 2));
                return new Rectangle(Math.max(0, this.upperLeft.x), Math.max(0, this.upperLeft.y), this.lowerRight.x + 10 - this.upperLeft.x, this.lowerRight.y + 10 - this.upperLeft.y);
            }

            public void resetLocation() {
                this.linePointIndex = 0;
                this.lox = 0;
                this.loy = 0;
            }

            public boolean contains(int x, int y) {
                java.awt.Point ul = this.getUpperLeft();
                java.awt.Point lr = this.getLowerRight();
                return new Rectangle(ul.x, ul.y, lr.x - ul.x, lr.y - ul.y).contains(x, y);
            }

            public void setLocation(int x, int y) {
                java.awt.Point[] linePoints = ConnectorLine.this.getPoints();
                double dis = 3.4028234663852886E38;
                int idex = 0;
                int i = 0;
                while (i < linePoints.length - 1) {
                    double end1Length = this.calcSegmentLength(linePoints[i].x, linePoints[i].y, x, y);
                    double end2Length = this.calcSegmentLength(linePoints[i + 1].x, linePoints[i + 1].y, x, y);
                    java.awt.Point center = this.getLineSegmentCenterPoint(i);
                    double centerLength = this.calcSegmentLength(center.x, center.y, x, y);
                    double newDis = (centerLength + Math.max(end1Length, end2Length)) / 2.0;
                    if (dis > newDis) {
                        dis = newDis;
                        idex = i;
                    }
                    ++i;
                }
                this.linePointIndex = idex;
                java.awt.Point lineCenter = this.getLineSegmentCenterPoint();
                this.lox = x - lineCenter.x;
                this.loy = y - lineCenter.y;
            }

            public double calcSegmentLength(int x1, int y1, int x2, int y2) {
                return Math.sqrt(Math.pow(x1 - x2, 2.0) + Math.pow(y1 - y2, 2.0));
            }

            public Rectangle getBounds() {
                return new Rectangle(this.upperLeft.x, this.upperLeft.y, this.lowerRight.x - this.upperLeft.x, this.lowerRight.y - this.upperLeft.y);
            }

            public java.awt.Point getLineSegmentCenterPoint() {
                return this.getLineSegmentCenterPoint(this.linePointIndex);
            }

            public java.awt.Point getLineSegmentCenterPoint(int idex) {
                java.awt.Point[] points = ConnectorLine.this.getPoints();
                java.awt.Point p1 = points[idex];
                java.awt.Point p2 = points[idex + 1];
                return new java.awt.Point((p1.x + p2.x) / 2, (p1.y + p2.y) / 2);
            }

            public int getX() {
                java.awt.Point lineCenter = this.getLineSegmentCenterPoint();
                return lineCenter.x + this.lox;
            }

            public int getY() {
                java.awt.Point lineCenter = this.getLineSegmentCenterPoint();
                return lineCenter.y + this.loy;
            }

            public java.awt.Point getUpperLeft() {
                return this.upperLeft;
            }

            public java.awt.Point getLowerRight() {
                return this.lowerRight;
            }

            public void paint(Map resourceMap, GC g) {
                int nw = 0;
                int nh = 0;
                Iterator iterator = ((ConnectorLine)ConnectorLine.this).UIConnector.this.getConnector().exitCodes.iterator();
                while (iterator.hasNext()) {
                    ConnectorRecord cr = (ConnectorRecord)iterator.next();
                    Point np = g.stringExtent(cr.getName());
                    nw = Math.max(nw, np.x);
                    nh = nh + 2 + np.y;
                }
                this.upperLeft = new java.awt.Point(this.getX() - (nw / 2 + 2), this.getY() - ((nh -= 2) / 2 + 2));
                this.lowerRight = new java.awt.Point(this.getX() + (nw / 2 + 2), this.getY() + (nh / 2 + 2));
                iterator = ((ConnectorLine)ConnectorLine.this).UIConnector.this.getConnector().exitCodes.iterator();
                int ry = this.upperLeft.y + 1;
                while (iterator.hasNext()) {
                    ConnectorRecord cr = (ConnectorRecord)iterator.next();
                    if (cr.getType() == ConnectorRecord.ERROR_POINT) {
                        g.setForeground(ConnectorLine.this.getColor(resourceMap, "COLOR_RED", 255, 0, 0));
                    } else {
                        g.setForeground(ConnectorLine.this.getColor(resourceMap, "COLOR_BLACK", 0, 0, 0));
                    }
                    Point np = g.stringExtent(cr.getName());
                    g.drawString(cr.getName(), this.upperLeft.x + 2, ry, true);
                    ry += np.y;
                    ry += 2;
                }
            }
        }

        public class ConnectorEndGraphPoint
        implements GraphPoint {
            private IncursionHost terminus;

            public ConnectorEndGraphPoint(IncursionHost terminus) {
                this.terminus = terminus;
            }

            public java.awt.Point getPoint(java.awt.Point p) {
                return this.terminus.getIncursionPoint(p.x, p.y);
            }

            public java.awt.Point getRegistryPoint() {
                return this.terminus.getRegistryPoint();
            }
        }
    }
}

