/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.ui.app.editor.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.vtp.desktop.core.project.FieldType;
import org.eclipse.vtp.desktop.core.project.IApplicationProject;
import org.eclipse.vtp.desktop.core.project.IBusinessObject;
import org.eclipse.vtp.desktop.core.project.IBusinessObjectField;
import org.eclipse.vtp.desktop.ui.app.editor.MediaProvider;
import org.eclipse.vtp.desktop.ui.app.editor.model.AssignmentVariablesPropertyPanel;
import org.eclipse.vtp.desktop.ui.app.editor.model.BlankMediaProvider;
import org.eclipse.vtp.desktop.ui.app.editor.model.Connector;
import org.eclipse.vtp.desktop.ui.app.editor.model.ConnectorDestination;
import org.eclipse.vtp.desktop.ui.app.editor.model.ConnectorOrigin;
import org.eclipse.vtp.desktop.ui.app.editor.model.ConnectorRecord;
import org.eclipse.vtp.desktop.ui.app.editor.model.Element;
import org.eclipse.vtp.desktop.ui.app.editor.model.ObjectDefinition;
import org.eclipse.vtp.desktop.ui.app.editor.model.ObjectField;
import org.eclipse.vtp.desktop.ui.app.editor.model.Variable;
import org.eclipse.vtp.desktop.ui.app.editor.model.VariableDeclaration;
import org.eclipse.vtp.desktop.ui.app.editor.model.event.ConnectorOriginPathListener;
import org.w3c.dom.NodeList;

public class VariableAssignmentElement
extends Element
implements ConnectorOrigin,
ConnectorDestination {
    private List exitPoints;
    private MediaProvider mediaProvider;
    private List variableDeclarations;
    private List listeners = new ArrayList();
    private List incomingConnectors;

    public VariableAssignmentElement() {
        super("Start");
        this.mediaProvider = new BlankMediaProvider(this.getId(), "Variable Assignment", "builtin.variableassignment.1_0_0_0");
        this.exitPoints = new ArrayList();
        this.exitPoints.add(new ConnectorRecord(this, "Continue", ConnectorRecord.EXIT_POINT));
        this.variableDeclarations = new ArrayList();
        this.incomingConnectors = new ArrayList();
    }

    public VariableAssignmentElement(String id) {
        super(id, "Assign");
        this.mediaProvider = new BlankMediaProvider(this.getId(), "Variable Assignment", "builtin.variableassignment.1_0_0_0");
        this.exitPoints = new ArrayList();
        this.exitPoints.add(new ConnectorRecord(this, "Continue", ConnectorRecord.EXIT_POINT));
        this.variableDeclarations = new ArrayList();
        this.incomingConnectors = new ArrayList();
    }

    public String getTagName() {
        return "assign";
    }

    public void writeAttributes(org.w3c.dom.Element element) {
        super.writeAttributes(element);
        org.w3c.dom.Element declarationsElement = element.getOwnerDocument().createElement("declarations");
        element.appendChild(declarationsElement);
        int i = 0;
        while (i < this.variableDeclarations.size()) {
            VariableDeclaration vd = (VariableDeclaration)this.variableDeclarations.get(i);
            org.w3c.dom.Element declarationElement = declarationsElement.getOwnerDocument().createElement("variable");
            declarationsElement.appendChild(declarationElement);
            declarationElement.setAttribute("name", vd.name == null ? "" : vd.name);
            declarationElement.setAttribute("type", vd.type == null ? "" : vd.type);
            declarationElement.setAttribute("multiplicity", Integer.toString(vd.multiplicity));
            declarationElement.setAttribute("value-type", Integer.toString(vd.valueType));
            declarationElement.setAttribute("value", vd.value == null ? "" : vd.value);
            ++i;
        }
    }

    public List getHooks() {
        return this.getFreeHooks();
    }

    public List getFreeHooks() {
        return new ArrayList();
    }

    public List getExits() {
        return Collections.unmodifiableList(this.exitPoints);
    }

    public List getFreeExits() {
        ArrayList<ConnectorRecord> freeExits = new ArrayList<ConnectorRecord>();
        Iterator iterator = this.exitPoints.iterator();
        while (iterator.hasNext()) {
            ConnectorRecord cr = (ConnectorRecord)iterator.next();
            if (cr.getConnector() != null) continue;
            freeExits.add(cr);
        }
        return Collections.unmodifiableList(freeExits);
    }

    public ConnectorRecord getRecord(String name) {
        if (name.equals("Continue")) {
            return (ConnectorRecord)this.exitPoints.get(0);
        }
        return null;
    }

    public boolean hasPathToStart(List originPath) {
        return true;
    }

    public MediaProvider getMediaProvider() {
        return this.mediaProvider;
    }

    public List getPropertyPanels() {
        ArrayList<VariableDeclaration> declarationsCopy = new ArrayList<VariableDeclaration>();
        int i = 0;
        while (i < this.variableDeclarations.size()) {
            declarationsCopy.add((VariableDeclaration)((VariableDeclaration)this.variableDeclarations.get(i)).clone());
            ++i;
        }
        List ret = super.getPropertyPanels();
        ret.add(new AssignmentVariablesPropertyPanel(this, declarationsCopy));
        return ret;
    }

    public void setVariableDeclarations(List declarations) {
        this.variableDeclarations = declarations;
        if (this.getModel() != null) {
            this.getModel().fireInternalModified();
        }
    }

    public void getVariables(String endPointName, List variables, List visited) {
        if (!visited.contains(this.getRecord(endPointName))) {
            visited.add(this.getRecord(endPointName));
            int i = 0;
            while (i < this.incomingConnectors.size()) {
                Connector con = (Connector)this.incomingConnectors.get(i);
                int c = 0;
                while (c < con.getExitCodes().size()) {
                    ConnectorRecord cr = (ConnectorRecord)con.getExitCodes().get(c);
                    con.getOrigin().getVariables(cr.getName(), variables, visited);
                    ++c;
                }
                ++i;
            }
            HashMap map = new HashMap();
            int i2 = 0;
            while (i2 < variables.size()) {
                map.put(((Variable)variables.get(i2)).getName(), variables.get(i2));
                ++i2;
            }
            i2 = 0;
            while (i2 < this.variableDeclarations.size()) {
                VariableDeclaration vd = (VariableDeclaration)this.variableDeclarations.get(i2);
                if (map.get(vd.name) == null) {
                    FieldType ft = FieldType.custom((String)vd.type, (this.isObject(vd.type) && vd.multiplicity != 1 ? 1 : 0) != 0, (vd.multiplicity == 1 ? 1 : 0) != 0, (int)0);
                    Variable v = new Variable(vd.name, ft);
                    this.buildObjectFields(v);
                    variables.add(v);
                }
                ++i2;
            }
            visited.add(this.getRecord(endPointName));
        }
    }

    public void buildObjectFields(ObjectDefinition def) {
        if (def.getType().isObject()) {
            List bos = ((IApplicationProject)this.getModel().getApplication().getProject()).getBusinessObjectSet().getBusinessObjects();
            int i = 0;
            while (i < bos.size()) {
                IBusinessObject ibo = (IBusinessObject)bos.get(i);
                if (ibo.getName().equals(def.getType().getTypeName())) {
                    List fields = ibo.getFields();
                    int f = 0;
                    while (f < fields.size()) {
                        IBusinessObjectField ibof = (IBusinessObjectField)fields.get(f);
                        this.buildObjectFields(def.addField(new ObjectField(ibof.getName(), ibof.getDataType(), false)));
                        ++f;
                    }
                }
                ++i;
            }
        } else if (def.getType().isArray()) {
            def.addField(new ObjectField("numberOfItems", FieldType.NUMBER, true));
        } else if (def.getType().equals("String")) {
            def.addField(new ObjectField("length", FieldType.NUMBER, true));
        }
    }

    public boolean isObject(String typeName) {
        return !typeName.equals("String") && !typeName.equals("Number") && !typeName.equals("Decimal") && !typeName.equals("Boolean") && !typeName.equals("DateTime");
    }

    public void addPathListener(ConnectorOriginPathListener l) {
        this.listeners.remove(l);
        this.listeners.add(l);
    }

    public void removePathListener(ConnectorOriginPathListener l) {
        this.listeners.remove(l);
    }

    public void addIncomingConnector(Connector connector) {
        this.incomingConnectors.remove(connector);
        this.incomingConnectors.add(connector);
        this.validateStatus();
    }

    public void removeIncomingConnector(Connector connector) {
        this.incomingConnectors.remove(connector);
        this.validateStatus();
    }

    public void readSettings(org.w3c.dom.Element configurationElement) {
        ArrayList<VariableDeclaration> vars = new ArrayList<VariableDeclaration>();
        NodeList varList = configurationElement.getElementsByTagName("variable");
        int v = 0;
        while (v < varList.getLength()) {
            org.w3c.dom.Element varElement = (org.w3c.dom.Element)varList.item(v);
            String vname = varElement.getAttribute("name");
            String vtype = varElement.getAttribute("type");
            int vmulti = varElement.getAttribute("multiplicity").equals("") ? 0 : Integer.parseInt(varElement.getAttribute("multiplicity"));
            int vvaluetype = varElement.getAttribute("value-type").equals("") ? 0 : Integer.parseInt(varElement.getAttribute("value-type"));
            String vvalue = varElement.getAttribute("value");
            VariableDeclaration vd = new VariableDeclaration(vname, vmulti, vtype, vvaluetype, vvalue);
            vars.add(vd);
            ++v;
        }
        this.setVariableDeclarations(vars);
    }
}

