/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.ui.app.editor.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.vtp.desktop.core.project.FieldType;
import org.eclipse.vtp.desktop.core.project.IApplicationProject;
import org.eclipse.vtp.desktop.core.project.IBusinessObject;
import org.eclipse.vtp.desktop.core.project.IBusinessObjectField;
import org.eclipse.vtp.desktop.ui.app.editor.MediaProvider;
import org.eclipse.vtp.desktop.ui.app.editor.model.Connector;
import org.eclipse.vtp.desktop.ui.app.editor.model.ConnectorDestination;
import org.eclipse.vtp.desktop.ui.app.editor.model.ConnectorOrigin;
import org.eclipse.vtp.desktop.ui.app.editor.model.ConnectorRecord;
import org.eclipse.vtp.desktop.ui.app.editor.model.Element;
import org.eclipse.vtp.desktop.ui.app.editor.model.ObjectDefinition;
import org.eclipse.vtp.desktop.ui.app.editor.model.ObjectField;
import org.eclipse.vtp.desktop.ui.app.editor.model.Variable;
import org.eclipse.vtp.desktop.ui.app.editor.model.WebServiceCallInputPropertiesPanel;
import org.eclipse.vtp.desktop.ui.app.editor.model.WebServiceCallOutputPropertiesPanel;
import org.eclipse.vtp.desktop.ui.app.editor.model.WebServiceCallServicePropertiesPanel;
import org.eclipse.vtp.desktop.ui.app.editor.model.WebServiceCallSettingsStructure;
import org.eclipse.vtp.desktop.ui.app.editor.model.WebServiceCallTargetVariablePropertiesPanel;
import org.eclipse.vtp.desktop.ui.app.editor.model.event.ConnectorOriginPathListener;
import org.w3c.dom.NodeList;

public class WebServiceCallElement
extends Element
implements ConnectorDestination,
ConnectorOrigin {
    private List incomingConnectors = new ArrayList();
    private ConnectorRecord next = new ConnectorRecord(this, "Next", ConnectorRecord.EXIT_POINT);
    private ConnectorRecord fault = new ConnectorRecord(this, "error.webservice.fault", ConnectorRecord.ERROR_POINT);
    private ConnectorRecord failure = new ConnectorRecord(this, "error.webservice.unavailable", ConnectorRecord.ERROR_POINT);
    private WebServiceCallSettingsStructure settings = new WebServiceCallSettingsStructure();
    private List listeners = new ArrayList();

    public WebServiceCallElement(String name) {
        super(name);
    }

    public WebServiceCallElement(String id, String name) {
        super(id, name);
    }

    public void readSettings(org.w3c.dom.Element element) {
        NodeList nl = element.getElementsByTagName("settings");
        if (nl.getLength() > 0) {
            this.settings.read((org.w3c.dom.Element)nl.item(0));
        }
    }

    public void configure(WebServiceCallSettingsStructure settings) {
        this.settings = (WebServiceCallSettingsStructure)settings.clone();
        this.getModel().fireInternalModified();
    }

    public void buildObjectFields(ObjectDefinition def) {
        if (def.getType().isArray()) {
            def.addField(new ObjectField("numberOfItems", FieldType.NUMBER, true));
        } else if (def.getType().isObject()) {
            List bos = ((IApplicationProject)this.getModel().getApplication().getProject()).getBusinessObjectSet().getBusinessObjects();
            int i = 0;
            while (i < bos.size()) {
                IBusinessObject ibo = (IBusinessObject)bos.get(i);
                if (ibo.getName().equals(def.getType().getTypeName())) {
                    List fields = ibo.getFields();
                    int f = 0;
                    while (f < fields.size()) {
                        IBusinessObjectField ibof = (IBusinessObjectField)fields.get(f);
                        this.buildObjectFields(def.addField(new ObjectField(ibof.getName(), ibof.getDataType(), false)));
                        ++f;
                    }
                }
                ++i;
            }
        } else if (def.getType().equals("String")) {
            def.addField(new ObjectField("length", FieldType.NUMBER, true));
        }
    }

    public boolean isObject(String typeName) {
        return !typeName.equals("String") && !typeName.equals("Number") && !typeName.equals("Decimal") && !typeName.equals("Boolean") && !typeName.equals("DateTime");
    }

    public void addIncomingConnector(Connector connector) {
        this.incomingConnectors.remove(connector);
        this.incomingConnectors.add(connector);
        this.validateStatus();
    }

    public void removeIncomingConnector(Connector connector) {
        this.incomingConnectors.remove(connector);
        this.validateStatus();
    }

    public ConnectorRecord getRecord(String name) {
        if (name.equals("Next")) {
            return this.next;
        }
        if (name.equals("error.webservice.fault")) {
            return this.fault;
        }
        if (name.equals("error.webservice.unavailable")) {
            return this.failure;
        }
        return null;
    }

    public List getFreeHooks() {
        return Collections.EMPTY_LIST;
    }

    public List getFreeExits() {
        ArrayList<ConnectorRecord> freeExits = new ArrayList<ConnectorRecord>(3);
        if (this.next.getConnector() == null) {
            freeExits.add(this.next);
        }
        if (this.fault.getConnector() == null) {
            freeExits.add(this.fault);
        }
        if (this.failure.getConnector() == null) {
            freeExits.add(this.failure);
        }
        return Collections.unmodifiableList(freeExits);
    }

    public boolean hasPathToStart(List originPath) {
        if (originPath == null) {
            originPath = new ArrayList<WebServiceCallElement>();
        }
        originPath.add(this);
        boolean ret = false;
        int i = 0;
        while (i < this.incomingConnectors.size()) {
            boolean has;
            Connector connector = (Connector)this.incomingConnectors.get(i);
            if (!originPath.contains(connector.getOrigin()) && (ret |= (has = connector.getOrigin().hasPathToStart(originPath)))) {
                return ret;
            }
            ++i;
        }
        return ret;
    }

    public void addPathListener(ConnectorOriginPathListener l) {
        this.listeners.remove(l);
        this.listeners.add(l);
    }

    public void removePathListener(ConnectorOriginPathListener l) {
        this.listeners.remove(l);
    }

    public void getVariables(String endPointName, List variables, List visited) {
        if (!visited.contains(this.getRecord(endPointName))) {
            visited.add(this.getRecord(endPointName));
            int i = 0;
            while (i < this.incomingConnectors.size()) {
                Connector con = (Connector)this.incomingConnectors.get(i);
                int c = 0;
                while (c < con.getExitCodes().size()) {
                    ConnectorRecord cr = (ConnectorRecord)con.getExitCodes().get(c);
                    con.getOrigin().getVariables(cr.getName(), variables, visited);
                    ++c;
                }
                ++i;
            }
            if (endPointName.equals("Next") && !this.settings.targetVariableExists) {
                FieldType ft = FieldType.custom((String)this.settings.targetVariableType, (boolean)this.isObject(this.settings.targetVariableType), (this.settings.targetMultiplicity == 1 ? 1 : 0) != 0, (int)0);
                Variable v = new Variable(this.settings.targetVariableName, ft);
                this.buildObjectFields(v);
                variables.add(v);
            }
        }
    }

    public void writeAttributes(org.w3c.dom.Element element) {
        super.writeAttributes(element);
        org.w3c.dom.Element settingsElement = element.getOwnerDocument().createElement("settings");
        element.appendChild(settingsElement);
        this.settings.write(settingsElement);
    }

    public void validateStatus() {
        super.validateStatus();
        boolean isExitedFrom = false;
        boolean isErrorFrom = false;
        boolean hasErrorFrom = false;
        if (this.next.getConnector() != null) {
            isExitedFrom = true;
        }
        if (this.incomingConnectors.size() < 1 || !this.hasPathToStart(null) || !this.settings.isComplete()) {
            this.setError(true);
        }
        if (!isErrorFrom && hasErrorFrom) {
            this.setTodo(true);
        }
        if (!isExitedFrom) {
            this.setWarning(true);
        }
    }

    public MediaProvider getMediaProvider() {
        return null;
    }

    public String getTagName() {
        return "web-service-call";
    }

    public List getPropertyPanels() {
        WebServiceCallSettingsStructure settings = (WebServiceCallSettingsStructure)this.settings.clone();
        List ret = super.getPropertyPanels();
        ret.add(new WebServiceCallTargetVariablePropertiesPanel(this, settings));
        ret.add(new WebServiceCallServicePropertiesPanel(this, settings));
        ret.add(new WebServiceCallInputPropertiesPanel(this, settings));
        ret.add(new WebServiceCallOutputPropertiesPanel(this, settings));
        return ret;
    }

    public List getVariables() {
        ArrayList ret = new ArrayList();
        ArrayList listed = new ArrayList();
        int i = 0;
        while (i < this.incomingConnectors.size()) {
            Connector con = (Connector)this.incomingConnectors.get(i);
            int c = 0;
            while (c < con.getExitCodes().size()) {
                ConnectorRecord cr = (ConnectorRecord)con.getExitCodes().get(c);
                con.getOrigin().getVariables(cr.getName(), ret, listed);
                ++c;
            }
            ++i;
        }
        return ret;
    }
}

