/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.ui.app.editor.model.builtins.attacheddata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.vtp.desktop.ui.app.editor.MediaProvider;
import org.eclipse.vtp.desktop.ui.app.editor.model.BlankMediaProvider;
import org.eclipse.vtp.desktop.ui.app.editor.model.Connector;
import org.eclipse.vtp.desktop.ui.app.editor.model.ConnectorDestination;
import org.eclipse.vtp.desktop.ui.app.editor.model.ConnectorOrigin;
import org.eclipse.vtp.desktop.ui.app.editor.model.ConnectorRecord;
import org.eclipse.vtp.desktop.ui.app.editor.model.Element;
import org.eclipse.vtp.desktop.ui.app.editor.model.builtins.attacheddata.DataPoint;
import org.eclipse.vtp.desktop.ui.app.editor.model.event.ConnectorOriginPathListener;
import org.w3c.dom.NodeList;

public class PutAttachedDataElement
extends Element
implements ConnectorDestination,
ConnectorOrigin {
    List incomingConnectors;
    ConnectorRecord next = new ConnectorRecord(this, "Next", ConnectorRecord.EXIT_POINT);
    private List listeners = new ArrayList();
    MediaProvider mediaProvider;
    List dataPoints = new ArrayList();

    public PutAttachedDataElement(String name) {
        super(name);
        this.incomingConnectors = new ArrayList();
        this.mediaProvider = new BlankMediaProvider(this.getId(), "Put Attached Data", "builtin.putattacheddata.1_0_0_0");
    }

    public PutAttachedDataElement(String id, String name) {
        super(id, name);
        this.incomingConnectors = new ArrayList();
        this.mediaProvider = new BlankMediaProvider(this.getId(), "Put Attached Data", "builtin.putattacheddata.1_0_0_0");
    }

    public MediaProvider getMediaProvider() {
        return this.mediaProvider;
    }

    public void addIncomingConnector(Connector connector) {
        this.incomingConnectors.remove(connector);
        this.incomingConnectors.add(connector);
        this.validateStatus();
    }

    public void removeIncomingConnector(Connector connector) {
        this.incomingConnectors.remove(connector);
        this.validateStatus();
    }

    public ConnectorRecord getRecord(String name) {
        if (name.equals("Next")) {
            return this.next;
        }
        return null;
    }

    public List getFreeHooks() {
        return Collections.unmodifiableList(new ArrayList());
    }

    public List getFreeExits() {
        ArrayList<ConnectorRecord> freeExits = new ArrayList<ConnectorRecord>();
        if (this.next.getConnector() == null) {
            freeExits.add(this.next);
        }
        return Collections.unmodifiableList(freeExits);
    }

    public void validateStatus() {
        super.validateStatus();
        boolean isExitedFrom = false;
        boolean isErrorFrom = false;
        boolean hasErrorFrom = false;
        if (this.next.getConnector() != null) {
            isExitedFrom = true;
        }
        if (this.incomingConnectors.size() < 1 || !this.hasPathToStart(null)) {
            this.setError(true);
        }
        if (!isErrorFrom && hasErrorFrom) {
            this.setTodo(true);
        }
        if (!isExitedFrom) {
            this.setWarning(true);
        }
    }

    public boolean hasPathToStart(List originPath) {
        if (originPath == null) {
            originPath = new ArrayList<PutAttachedDataElement>();
        }
        originPath.add(this);
        boolean ret = false;
        int i = 0;
        while (i < this.incomingConnectors.size()) {
            boolean has;
            Connector connector = (Connector)this.incomingConnectors.get(i);
            if (!originPath.contains(connector.getOrigin()) && (ret |= (has = connector.getOrigin().hasPathToStart(originPath)))) {
                return ret;
            }
            ++i;
        }
        return ret;
    }

    public void writeAttributes(org.w3c.dom.Element element) {
        super.writeAttributes(element);
        int i = 0;
        while (i < this.dataPoints.size()) {
            DataPoint dp = (DataPoint)this.dataPoints.get(i);
            org.w3c.dom.Element dpElement = element.getOwnerDocument().createElement("data-point");
            element.appendChild(dpElement);
            dpElement.setAttribute("name", dp.getName());
            dpElement.setAttribute("type", (String)DataPoint.TYPE_NAMES.get(dp.getType()));
            dpElement.setAttribute("value", dp.getValue());
            ++i;
        }
    }

    public void readSettings(org.w3c.dom.Element element) {
        NodeList nl = element.getElementsByTagName("data-point");
        int i = 0;
        while (i < nl.getLength()) {
            org.w3c.dom.Element dataPointElement = (org.w3c.dom.Element)nl.item(i);
            String name = dataPointElement.getAttribute("name");
            String type = dataPointElement.getAttribute("type");
            String value = dataPointElement.getAttribute("value");
            this.dataPoints.add(new DataPoint("", name, DataPoint.getTypeByName(type), value));
            ++i;
        }
    }

    public String getTagName() {
        return "put-attached-data";
    }

    public void getVariables(String endPointName, List variables, List visited) {
        if (!visited.contains(this.getRecord(endPointName))) {
            visited.add(this.getRecord(endPointName));
            int i = 0;
            while (i < this.incomingConnectors.size()) {
                Connector con = (Connector)this.incomingConnectors.get(i);
                int c = 0;
                while (c < con.getExitCodes().size()) {
                    ConnectorRecord cr = (ConnectorRecord)con.getExitCodes().get(c);
                    con.getOrigin().getVariables(cr.getName(), variables, visited);
                    ++c;
                }
                ++i;
            }
        }
    }

    public List getVariables() {
        ArrayList ret = new ArrayList();
        ArrayList listed = new ArrayList();
        int i = 0;
        while (i < this.incomingConnectors.size()) {
            Connector con = (Connector)this.incomingConnectors.get(i);
            int c = 0;
            while (c < con.getExitCodes().size()) {
                ConnectorRecord cr = (ConnectorRecord)con.getExitCodes().get(c);
                con.getOrigin().getVariables(cr.getName(), ret, listed);
                ++c;
            }
            ++i;
        }
        return ret;
    }

    public List getDataPoints() {
        return this.dataPoints;
    }

    public void addPathListener(ConnectorOriginPathListener l) {
        this.listeners.remove(l);
        this.listeners.add(l);
    }

    public void removePathListener(ConnectorOriginPathListener l) {
        this.listeners.remove(l);
    }
}

