/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.ui.app.editors;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.vtp.desktop.core.project.IApplicationProject;
import org.eclipse.vtp.desktop.core.project.IBrand;
import org.eclipse.vtp.desktop.ui.app.editors.UICustomBrandLibraryIndex;
import org.eclipse.vtp.desktop.ui.app.editors.UIDefaultBrandLibraryIndex;
import org.eclipse.vtp.framework.media.library.MediaLibrary;
import org.eclipse.vtp.framework.media.util.BrandLibraryIndex;
import org.eclipse.vtp.framework.media.xml.MediaXML;

public class BrandEditorInput
implements IEditorInput {
    private final IBrand brand;

    public BrandEditorInput(IBrand brand) {
        this.brand = brand;
    }

    public IBrand getBrand() {
        return this.brand;
    }

    public IApplicationProject getProject() {
        return (IApplicationProject)this.brand.getBrandSet().getProject();
    }

    public BrandLibraryIndex load() throws IOException {
        try {
            return "Default".equals(this.brand.getName()) ? new UIDefaultBrandLibraryIndex(this.brand) : new UICustomBrandLibraryIndex(this.brand);
        }
        catch (CoreException e) {
            IOException ex = new IOException(e.getMessage());
            ex.initCause(e);
            throw ex;
        }
    }

    public void save(BrandLibraryIndex index, IProgressMonitor monitor) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            MediaXML.saveLibrary((MediaLibrary)index.getLibrary(), (Result)new StreamResult(output));
            this.brand.getPromptSet().write((InputStream)new ByteArrayInputStream(output.toByteArray()), monitor);
        }
        catch (CoreException e) {
            IOException ex = new IOException(e.getMessage());
            ex.initCause(e);
            throw ex;
        }
    }

    public boolean exists() {
        return true;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        return this.brand.getName();
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return this.getName();
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof BrandEditorInput && this.brand.equals(((BrandEditorInput)obj).brand);
    }
}

