/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.ui.app.editors;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.vtp.desktop.core.project.FieldType;
import org.eclipse.vtp.desktop.core.project.IBusinessObject;
import org.eclipse.vtp.desktop.core.project.internals.BusinessObject;
import org.eclipse.vtp.desktop.core.project.internals.BusinessObjectField;
import org.eclipse.vtp.desktop.ui.app.ApplicationUIPlugin;
import org.eclipse.vtp.desktop.ui.app.editors.BusinessObjectEditorInput;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BusinessObjectEditor
extends EditorPart {
    BusinessObject bo;
    boolean dirty = false;
    TableViewer viewer;
    List fieldRecords = new ArrayList();
    TextCellEditor nameEditor;
    ComboBoxCellEditor typeEditor;
    ComboBoxCellEditor precisionEditor;
    CheckboxCellEditor arrayEditor;
    TextCellEditor initialValueEditor;
    List currentTypes = new ArrayList();
    int tumbler = 0;

    public void doSave(IProgressMonitor monitor) {
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element rootElement = doc.createElement("business-object");
            doc.appendChild(rootElement);
            rootElement.setAttribute("id", this.bo.getId());
            rootElement.setAttribute("name", this.bo.getName());
            Element fields = rootElement.getOwnerDocument().createElement("fields");
            rootElement.appendChild(fields);
            int i = 0;
            while (i < this.fieldRecords.size()) {
                FieldRecord fr = (FieldRecord)this.fieldRecords.get(i);
                Element fieldElement = fields.getOwnerDocument().createElement("field");
                fields.appendChild(fieldElement);
                fieldElement.setAttribute("name", fr.name);
                fieldElement.setAttribute("initialValue", fr.initialValue);
                FieldType dt = FieldType.custom((String)fr.type, (boolean)fr.object, (boolean)fr.array, (int)fr.precision);
                dt.write(fieldElement);
                ++i;
            }
            DOMSource source = new DOMSource(doc);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(baos);
            Transformer trans = TransformerFactory.newInstance().newTransformer();
            trans.transform(source, result);
            this.bo.write((InputStream)new ByteArrayInputStream(baos.toByteArray()));
            this.dirty = false;
            this.firePropertyChange(257);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        catch (FactoryConfigurationError e) {
            e.printStackTrace();
        }
        catch (TransformerFactoryConfigurationError e) {
            e.printStackTrace();
        }
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (!(input instanceof BusinessObjectEditorInput)) {
            throw new PartInitException("Cannot edit: " + input);
        }
        this.setInput(input);
        this.setSite((IWorkbenchPartSite)site);
        this.setPartName(input.getName());
        this.bo = (BusinessObject)((BusinessObjectEditorInput)input).businessObject;
        List fields = this.bo.getFields();
        Iterator iterator = fields.iterator();
        while (iterator.hasNext()) {
            BusinessObjectField bof = (BusinessObjectField)iterator.next();
            FieldRecord fr = new FieldRecord();
            fr.name = bof.getName();
            fr.type = bof.getDataType().getTypeName();
            fr.object = bof.getDataType().isObject();
            fr.array = bof.getDataType().isArray();
            fr.precision = bof.getDataType().getPrecision();
            fr.initialValue = bof.getInitialValue();
            this.fieldRecords.add(fr);
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void doSaveAs() {
    }

    public void createPartControl(Composite parent) {
        Table table = new Table(parent, 65540);
        table.setHeaderVisible(true);
        TableColumn fieldName = new TableColumn(table, 0);
        fieldName.setText("Name");
        fieldName.setWidth(150);
        TableColumn dataType = new TableColumn(table, 0);
        dataType.setText("Type");
        dataType.setWidth(200);
        TableColumn precision = new TableColumn(table, 0);
        precision.setText("Precision");
        precision.setWidth(60);
        TableColumn array = new TableColumn(table, 0);
        array.setText("Array");
        array.setWidth(40);
        TableColumn initialValue = new TableColumn(table, 0);
        initialValue.setText("Initial Value");
        initialValue.setWidth(200);
        this.nameEditor = new TextCellEditor((Composite)table);
        this.nameEditor.setValidator(new ICellEditorValidator(){

            public String isValid(Object value) {
                String text = (String)value;
                if (text == null) {
                    text = "";
                }
                FieldRecord fr = (FieldRecord)((IStructuredSelection)BusinessObjectEditor.this.viewer.getSelection()).getFirstElement();
                int i = 0;
                while (i < BusinessObjectEditor.this.fieldRecords.size()) {
                    if (fr != BusinessObjectEditor.this.fieldRecords.get(i) && ((FieldRecord)BusinessObjectEditor.this.fieldRecords.get((int)i)).name.equalsIgnoreCase(text)) {
                        return "A field with that name already exists.";
                    }
                    ++i;
                }
                return null;
            }
        });
        this.nameEditor.addListener(new ICellEditorListener(){

            public void applyEditorValue() {
            }

            public void cancelEditor() {
            }

            public void editorValueChanged(boolean oldValidState, boolean newValidState) {
                if (!newValidState) {
                    BusinessObjectEditor.this.nameEditor.getControl().setForeground(BusinessObjectEditor.this.nameEditor.getControl().getDisplay().getSystemColor(3));
                } else {
                    BusinessObjectEditor.this.nameEditor.getControl().setForeground(BusinessObjectEditor.this.nameEditor.getControl().getDisplay().getSystemColor(2));
                }
            }
        });
        this.typeEditor = new ComboBoxCellEditor((Composite)table, new String[]{"String", "Number", "Decimal", "Boolean"}, 12);
        this.precisionEditor = new ComboBoxCellEditor((Composite)table, new String[]{"Single", "Double", "Absolute"}, 12);
        this.arrayEditor = new CheckboxCellEditor((Composite)table);
        this.initialValueEditor = new TextCellEditor((Composite)table);
        this.viewer = new TableViewer(table);
        this.viewer.setColumnProperties(new String[]{"Name", "Type", "Precision", "Array", "Initial"});
        this.viewer.setContentProvider((IContentProvider)new FieldContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new FieldLabelProvider());
        this.viewer.setCellModifier((ICellModifier)new FieldCellModifier());
        this.viewer.setCellEditors(new CellEditor[]{this.nameEditor, this.typeEditor, this.precisionEditor, this.arrayEditor, this.initialValueEditor});
        this.viewer.setInput((Object)this);
        this.hookContextMenu();
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                BusinessObjectEditor.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)new Action("Add Field"){

            public void run() {
                FieldRecord newField = new FieldRecord();
                newField.name = "";
                newField.type = "String";
                newField.precision = 0;
                newField.initialValue = "";
                BusinessObjectEditor.this.fieldRecords.add(newField);
                BusinessObjectEditor.this.viewer.refresh();
                BusinessObjectEditor.this.viewer.editElement((Object)newField, 0);
                BusinessObjectEditor.this.fireModified();
            }
        });
        if (!this.viewer.getSelection().isEmpty()) {
            final FieldRecord fr = (FieldRecord)((IStructuredSelection)this.viewer.getSelection()).getFirstElement();
            manager.add((IAction)new Action("Remove Field"){

                public void run() {
                    MessageBox mb = new MessageBox(BusinessObjectEditor.this.viewer.getControl().getShell(), 200);
                    mb.setMessage("Are you sure you want to delete this?");
                    int result = mb.open();
                    if (result == 64) {
                        BusinessObjectEditor.this.fieldRecords.remove(fr);
                        BusinessObjectEditor.this.viewer.refresh();
                        BusinessObjectEditor.this.fireModified();
                    }
                }
            });
        }
    }

    public void setFocus() {
    }

    private void fireModified() {
        this.dirty = true;
        this.firePropertyChange(257);
    }

    public class FieldContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object inputElement) {
            BusinessObjectEditor.this.tumbler = 0;
            return BusinessObjectEditor.this.fieldRecords.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public class FieldLabelProvider
    implements ITableLabelProvider,
    IColorProvider {
        Color alternateBackground;
        Color background;
        Color foreground;

        public FieldLabelProvider() {
            this.alternateBackground = new Color((Device)BusinessObjectEditor.this.viewer.getControl().getDisplay(), 216, 238, 255);
            this.background = BusinessObjectEditor.this.viewer.getControl().getDisplay().getSystemColor(1);
            this.foreground = BusinessObjectEditor.this.viewer.getControl().getDisplay().getSystemColor(2);
        }

        public Image getColumnImage(Object element, int columnIndex) {
            FieldRecord fr = (FieldRecord)element;
            if (columnIndex == 0) {
                return ApplicationUIPlugin.getDefault().getImageRegistry().get("ICON_TINY_SQUARE");
            }
            if (columnIndex == 3) {
                if (fr.array) {
                    return ApplicationUIPlugin.getDefault().getImageRegistry().get("ICON_CHECKBOX_TRUE");
                }
                return ApplicationUIPlugin.getDefault().getImageRegistry().get("ICON_CHECKBOX_FALSE");
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            FieldRecord fr = (FieldRecord)element;
            if (columnIndex == 0) {
                return fr.name;
            }
            if (columnIndex == 1) {
                return fr.type;
            }
            if (columnIndex == 2) {
                if (fr.type.equals("Number") || fr.type.equals("Decimal")) {
                    if (fr.precision == 0) {
                        return "Single";
                    }
                    if (fr.precision == 1) {
                        return "Double";
                    }
                    if (fr.precision == 2) {
                        return "Absolute";
                    }
                }
                return "";
            }
            if (columnIndex == 3) {
                return null;
            }
            if (columnIndex == 4) {
                return fr.initialValue == null ? "" : fr.initialValue;
            }
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
            this.alternateBackground.dispose();
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Color getForeground(Object element) {
            return this.foreground;
        }

        public Color getBackground(Object element) {
            Color bg = null;
            bg = BusinessObjectEditor.this.tumbler % 2 == 0 ? this.background : this.alternateBackground;
            ++BusinessObjectEditor.this.tumbler;
            return bg;
        }
    }

    public class FieldCellModifier
    implements ICellModifier {
        public boolean canModify(Object element, String property) {
            FieldRecord fr = (FieldRecord)element;
            if (property.equals("Array") || property.equals("Type") || property.equals("Name") || property.equals("Initial")) {
                return true;
            }
            if (property.equals("Precision")) {
                return fr.type.equals("Number") || fr.type.equals("Decimal");
            }
            return false;
        }

        public Object getValue(Object element, String property) {
            FieldRecord fr = (FieldRecord)element;
            if (property.equals("Array")) {
                return new Boolean(fr.array);
            }
            if (property.equals("Precision")) {
                return new Integer(fr.precision);
            }
            if (property.equals("Name")) {
                return fr.name == null ? "" : fr.name;
            }
            if (property.equals("Initial")) {
                return fr.initialValue == null ? "" : fr.initialValue;
            }
            if (property.equals("Type")) {
                BusinessObjectEditor.this.currentTypes.clear();
                BusinessObjectEditor.this.currentTypes.add("String");
                BusinessObjectEditor.this.currentTypes.add("Number");
                BusinessObjectEditor.this.currentTypes.add("Decimal");
                BusinessObjectEditor.this.currentTypes.add("Boolean");
                BusinessObjectEditor.this.currentTypes.add("DateTime");
                int sel = -1;
                List bos = BusinessObjectEditor.this.bo.getBusinessObjectSet().getBusinessObjects();
                int i = 0;
                while (i < bos.size()) {
                    IBusinessObject b = (IBusinessObject)bos.get(i);
                    if (!b.getName().equals(BusinessObjectEditor.this.bo.getName())) {
                        BusinessObjectEditor.this.currentTypes.add(b.getName());
                        if (b.getName().equals(fr.type)) {
                            sel = i + 5;
                        }
                    }
                    ++i;
                }
                BusinessObjectEditor.this.typeEditor.setItems(BusinessObjectEditor.this.currentTypes.toArray(new String[BusinessObjectEditor.this.currentTypes.size()]));
                if (sel == -1) {
                    if (fr.type.equals("String")) {
                        return new Integer(0);
                    }
                    if (fr.type.equals("Number")) {
                        return new Integer(1);
                    }
                    if (fr.type.equals("Decimal")) {
                        return new Integer(2);
                    }
                    if (fr.type.equals("Boolean")) {
                        return new Integer(3);
                    }
                    if (fr.type.equals("DateTime")) {
                        return new Integer(4);
                    }
                } else {
                    return new Integer(sel);
                }
            }
            return null;
        }

        public void modify(Object element, String property, Object value) {
            TableItem ti = (TableItem)element;
            FieldRecord fr = (FieldRecord)ti.getData();
            if (property.equals("Array")) {
                fr.array = (Boolean)value;
                BusinessObjectEditor.this.fireModified();
            } else if (property.equals("Name")) {
                if (value != null) {
                    String oldName = fr.name;
                    fr.name = (String)value;
                    if (!fr.name.equals(oldName)) {
                        BusinessObjectEditor.this.fireModified();
                    }
                }
            } else if (property.equals("Initial")) {
                fr.initialValue = value == null ? "" : (String)value;
                BusinessObjectEditor.this.fireModified();
            } else if (property.equals("Precision")) {
                fr.precision = (Integer)value;
                BusinessObjectEditor.this.fireModified();
            } else if (property.equals("Type")) {
                int sel = (Integer)value;
                if (!fr.type.equals(BusinessObjectEditor.this.currentTypes.get(sel))) {
                    fr.initialValue = "";
                }
                fr.object = sel > 5;
                fr.type = (String)BusinessObjectEditor.this.currentTypes.get(sel);
                BusinessObjectEditor.this.fireModified();
            }
            BusinessObjectEditor.this.viewer.refresh(true);
        }
    }

    public class FieldRecord {
        String name;
        String type;
        boolean array;
        boolean object;
        int precision;
        String initialValue;
    }
}

