/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.ui.app.editors;

import java.util.LinkedList;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordPatternRule;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.vtp.desktop.ui.app.ApplicationUIPlugin;

public class GRXMLEditor
extends MultiPageEditorPart
implements IResourceChangeListener {
    private static final String[] NAMES = new String[]{"xml", "version", "encoding", "standalone", "DOCTYPE", "PUBLIC", "SYSTEM", "grammar", "xmlns", "xml:lang", "xml:base", "xmlns:xsi", "xsi:schemaLocation", "mode", "root", "lexicon", "meta", "metadata", "tag", "rule", "tag-format", "version", "root", "special", "repeat-prob", "repeat", "type", "weight", "id", "scope", "uri", "name", "content", "http-equiv", "token", "ruleref", "item", "one-of", "example"};
    private static final String[] ELEMENTS = new String[]{"grammar", "token", "ruleref", "item", "one-of", "tag", "example", "lexicon", "meta", "metadata", "rule"};
    private TextEditor editor;
    private Color defaultColor = null;
    private Color commentColor = null;
    private Color elementColor = null;
    private Color attributeColor = null;

    public GRXMLEditor() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        if (!(editorInput instanceof IFileEditorInput)) {
            throw new PartInitException("Invalid Input: Must be IFileEditorInput");
        }
        super.init(site, editorInput);
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    protected void createPages() {
        try {
            this.defaultColor = new Color((Device)Display.getCurrent(), new RGB(0, 0, 0));
            this.commentColor = new Color((Device)Display.getCurrent(), PreferenceConverter.getColor((IPreferenceStore)ApplicationUIPlugin.getDefault().getPreferenceStore(), (String)"grxmleditor.colors.comment"));
            this.elementColor = new Color((Device)Display.getCurrent(), PreferenceConverter.getColor((IPreferenceStore)ApplicationUIPlugin.getDefault().getPreferenceStore(), (String)"grxmleditor.colors.elements"));
            this.attributeColor = new Color((Device)Display.getCurrent(), PreferenceConverter.getColor((IPreferenceStore)ApplicationUIPlugin.getDefault().getPreferenceStore(), (String)"grxmleditor.colors.attributes"));
            this.editor = new TextEditor(){};
            int index = this.addPage((IEditorPart)this.editor, this.getEditorInput());
            this.setPageText(index, this.editor.getTitle());
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Error creating nested text editor", null, (IStatus)e.getStatus());
        }
    }

    public void resourceChanged(final IResourceChangeEvent event) {
        if (event.getType() == 2) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    IWorkbenchPage[] pages = GRXMLEditor.this.getSite().getWorkbenchWindow().getPages();
                    int i = 0;
                    while (i < pages.length) {
                        if (((FileEditorInput)GRXMLEditor.this.editor.getEditorInput()).getFile().getProject().equals((Object)event.getResource())) {
                            IEditorPart editorPart = pages[i].findEditor(GRXMLEditor.this.editor.getEditorInput());
                            pages[i].closeEditor(editorPart, true);
                        }
                        ++i;
                    }
                }
            });
        }
    }

    public void doSave(IProgressMonitor monitor) {
        this.getEditor(0).doSave(monitor);
    }

    public void doSaveAs() {
        IEditorPart editor = this.getEditor(0);
        editor.doSaveAs();
        this.setPageText(0, editor.getTitle());
        this.setInput(editor.getEditorInput());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void dispose() {
        try {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            super.dispose();
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        super.dispose();
    }

    private final class SourceViewerConfig
    extends SourceViewerConfiguration {
        SourceScanner scanner = null;

        SourceViewerConfig() {
        }

        public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
            if (this.scanner == null) {
                this.scanner = new SourceScanner();
                this.scanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(GRXMLEditor.this.defaultColor)));
            }
            PresentationReconciler reconciler = new PresentationReconciler();
            DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)this.scanner);
            reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
            reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
            return reconciler;
        }

        public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
            ContentAssistant assistant = new ContentAssistant();
            assistant.setContentAssistProcessor((IContentAssistProcessor)new CompletionProcessor(), "__dftl_partition_content_type");
            assistant.enableAutoActivation(true);
            assistant.setAutoActivationDelay(500);
            assistant.setProposalPopupOrientation(10);
            return assistant;
        }
    }

    private final class SourceScanner
    extends RuleBasedScanner
    implements IWordDetector {
        SourceScanner() {
            Token commentToken = new Token((Object)new TextAttribute(GRXMLEditor.this.commentColor));
            Token elementToken = new Token((Object)new TextAttribute(GRXMLEditor.this.elementColor));
            Token attributeToken = new Token((Object)new TextAttribute(GRXMLEditor.this.attributeColor));
            LinkedList<Object> rules = new LinkedList<Object>();
            rules.add(new MultiLineRule("<!--", "-->", (IToken)commentToken));
            rules.add(new MultiLineRule("\"", "\"", (IToken)attributeToken));
            int i = 0;
            while (i < NAMES.length) {
                rules.add(new WordPatternRule((IWordDetector)this, NAMES[i], "", (IToken)elementToken));
                ++i;
            }
            this.setRules(rules.toArray(new IRule[rules.size()]));
        }

        public boolean isWordStart(char c) {
            return Character.isJavaIdentifierStart(c);
        }

        public boolean isWordPart(char c) {
            return c == ':' || Character.isJavaIdentifierPart(c);
        }
    }

    private final class CompletionProcessor
    implements IContentAssistProcessor {
        private CompletionProcessor() {
        }

        public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
            ICompletionProposal[] result = new ICompletionProposal[ELEMENTS.length];
            int i = 0;
            while (i < ELEMENTS.length) {
                result[i] = new CompletionProposal(ELEMENTS[i], offset, 0, ELEMENTS[i].length());
                ++i;
            }
            return result;
        }

        public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
            return null;
        }

        public char[] getCompletionProposalAutoActivationCharacters() {
            return new char[]{'<'};
        }

        public char[] getContextInformationAutoActivationCharacters() {
            return null;
        }

        public IContextInformationValidator getContextInformationValidator() {
            return null;
        }

        public String getErrorMessage() {
            return null;
        }
    }
}

