/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.ui.app.editors;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.vtp.desktop.core.project.IPersonaProject;
import org.eclipse.vtp.desktop.ui.app.editors.UIPersonaIndex;
import org.eclipse.vtp.framework.media.persona.MediaPersona;
import org.eclipse.vtp.framework.media.util.PersonaIndex;
import org.eclipse.vtp.framework.media.xml.MediaXML;

public class PersonaEditorInput
implements IEditorInput {
    private final IPersonaProject project;

    public PersonaEditorInput(IPersonaProject project) {
        this.project = project;
    }

    public IPersonaProject getProject() {
        return this.project;
    }

    public PersonaIndex load() throws IOException {
        try {
            return new UIPersonaIndex(this.project);
        }
        catch (CoreException e) {
            IOException ex = new IOException(e.getMessage());
            ex.initCause(e);
            throw ex;
        }
    }

    public void save(PersonaIndex personaIndex, IProgressMonitor monitor) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        MediaXML.savePersona((MediaPersona)personaIndex.getPersona(), (Result)new StreamResult(output));
        try {
            this.project.getPromptSet().write((InputStream)new ByteArrayInputStream(output.toByteArray()), monitor);
        }
        catch (CoreException e) {
            IOException ex = new IOException(e.getMessage());
            ex.initCause(e);
            throw ex;
        }
    }

    public boolean exists() {
        return true;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        try {
            return this.project.getPersonaName();
        }
        catch (CoreException e) {
            e.printStackTrace();
            return "Error getting persona name";
        }
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return this.getName();
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof PersonaEditorInput && this.project.equals(((PersonaEditorInput)obj).project);
    }
}

