/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.ui.app.layouts;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.vtp.desktop.ui.app.layouts.AspectRatioLayoutData;

public class AspectRatioLayout
extends Layout {
    int marginLeft = 0;
    int marginRight = 0;
    int marginTop = 0;
    int marginBottom = 0;

    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        int sHeight;
        if (wHint != -1 && hHint != -1) {
            return new Point(wHint, hHint);
        }
        Control[] children = composite.getChildren();
        if (children.length < 1) {
            return new Point(wHint == -1 ? 100 : wHint, hHint == -1 ? 100 : hHint);
        }
        Object obj = children[0].getLayoutData();
        if (obj == null || !(obj instanceof AspectRatioLayoutData)) {
            return new Point(wHint == -1 ? 100 : wHint, hHint == -1 ? 100 : hHint);
        }
        AspectRatioLayoutData layoutData = (AspectRatioLayoutData)obj;
        int sWidth = layoutData.sourceWidth < 1 ? 1 : layoutData.sourceWidth;
        int n = sHeight = layoutData.sourceHeight < 1 ? 1 : layoutData.sourceHeight;
        if (wHint != -1) {
            double r = (double)wHint / (double)sWidth;
            return new Point(wHint, (int)((double)sHeight * r));
        }
        if (hHint != -1) {
            double r = (double)hHint / (double)sHeight;
            return new Point((int)((double)sWidth * r), hHint);
        }
        return new Point(100, 100);
    }

    protected void layout(Composite composite, boolean flushCache) {
        Point size = composite.getSize();
        Control[] children = composite.getChildren();
        if (children.length > 0) {
            Object obj = children[0].getLayoutData();
            if (obj == null || !(obj instanceof AspectRatioLayoutData)) {
                children[0].setBounds(0, 0, size.x, size.y);
            } else {
                int sHeight;
                double r2;
                AspectRatioLayoutData layoutData = (AspectRatioLayoutData)obj;
                int sWidth = layoutData.sourceWidth < 1 ? 1 : layoutData.sourceWidth;
                double r1 = (double)size.x / (double)sWidth;
                if (r1 > (r2 = (double)size.y / (double)(sHeight = layoutData.sourceHeight < 1 ? 1 : layoutData.sourceHeight))) {
                    double tw = (double)sWidth * r2;
                    double dw = (double)size.x - tw;
                    children[0].setBounds((int)(dw / 2.0), 0, (int)tw, size.y);
                } else {
                    double th = (double)sHeight * r1;
                    double dh = (double)size.y - th;
                    children[0].setBounds(0, (int)(dh / 2.0), size.x, (int)th);
                }
            }
        }
    }

    public int getMarginBottom() {
        return this.marginBottom;
    }

    public void setMarginBottom(int marginBottom) {
        this.marginBottom = marginBottom;
    }

    public int getMarginLeft() {
        return this.marginLeft;
    }

    public void setMarginLeft(int marginLeft) {
        this.marginLeft = marginLeft;
    }

    public int getMarginRight() {
        return this.marginRight;
    }

    public void setMarginRight(int marginRight) {
        this.marginRight = marginRight;
    }

    public int getMarginTop() {
        return this.marginTop;
    }

    public void setMarginTop(int marginTop) {
        this.marginTop = marginTop;
    }

    public int getMarginWidth() {
        return this.marginLeft + this.marginRight;
    }

    public void setMarginWidth(int marginWidth) {
        this.marginRight = this.marginLeft = marginWidth / 2;
        this.marginLeft += marginWidth % 2;
    }

    public int getMarginHeight() {
        return this.marginTop + this.marginBottom;
    }

    public void setMarginHeight(int marginHeight) {
        this.marginTop = marginHeight / 2;
        this.marginBottom = this.marginTop + marginHeight % 2;
    }
}

