/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.ui.app.viewers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.vtp.desktop.ui.app.viewers.MediaActionListener;
import org.eclipse.vtp.desktop.ui.app.viewers.MediaContentProvider;
import org.eclipse.vtp.desktop.ui.app.viewers.MediaViewerRow;

public class MediaViewer {
    private FormToolkit toolkit;
    private Composite parent;
    private Composite composite;
    private boolean showDelete;
    private MediaContentProvider content = null;
    private Object input = null;
    private List rows = new ArrayList();
    private List observers = new LinkedList();

    public MediaViewer(FormToolkit toolkit, Composite parent, boolean showDelete) {
        this.toolkit = toolkit;
        this.parent = parent;
        this.composite = toolkit.createComposite(parent);
        this.showDelete = showDelete;
        this.composite.setBackground(toolkit.getColors().getBorderColor());
        GridLayout layout = new GridLayout(showDelete ? 4 : 3, false);
        layout.marginWidth = 1;
        layout.marginHeight = 1;
        layout.horizontalSpacing = 1;
        layout.verticalSpacing = 1;
        this.composite.setLayout((Layout)layout);
    }

    public boolean addMediaActionListener(MediaActionListener o) {
        return this.observers.add(o);
    }

    public boolean removeMediaActionListener(MediaActionListener o) {
        return this.observers.remove(o);
    }

    public Control getControl() {
        return this.composite;
    }

    public void setContentProvider(MediaContentProvider content) {
        this.content = content;
    }

    public void setInput(Object input) {
        Object oldInput = this.input;
        this.input = input;
        if (this.content != null) {
            this.content.inputChanged(oldInput, input);
        }
        this.composite.getDisplay().asyncExec(new Runnable(){

            public void run() {
                MediaViewer.this.refresh();
            }
        });
    }

    public void refresh() {
        MediaViewerRow row;
        Object[] elements = null;
        if (this.content != null && this.input != null) {
            elements = this.content.getElements(this.input);
        }
        if (elements == null) {
            elements = new Object[]{};
        }
        int i = 0;
        while (i < elements.length) {
            row = null;
            if (this.rows.size() <= i) {
                row = new MediaViewerRow(this);
                this.rows.add(row);
            } else {
                row = (MediaViewerRow)((Object)this.rows.get(i));
            }
            row.setForeground(this.content.isElementInherited(elements[i]) ? this.toolkit.getColors().getBorderColor() : this.toolkit.getColors().getForeground());
            row.setBackground(i % 2 == 0 ? this.toolkit.getColors().getBackground() : this.toolkit.getColors().getInactiveBackground());
            row.setElement(elements[i]);
            row.setVisible(true);
            ++i;
        }
        i = elements.length;
        while (i < this.rows.size()) {
            row = (MediaViewerRow)((Object)this.rows.get(i));
            row.setElement(null);
            row.setVisible(false);
            ++i;
        }
        this.parent.layout(true);
        this.composite.layout(true);
    }

    protected FormToolkit getToolkit() {
        return this.toolkit;
    }

    protected Composite getComposite() {
        return this.composite;
    }

    protected boolean showDelete() {
        return this.showDelete;
    }

    protected MediaContentProvider getContentProvider() {
        return this.content;
    }

    protected void itemClicked(Object element, String href) {
        Iterator i = this.observers.iterator();
        while (i.hasNext()) {
            ((MediaActionListener)i.next()).processItemAction(element, href);
        }
    }

    protected void editClicked(Object element) {
        Iterator i = this.observers.iterator();
        while (i.hasNext()) {
            ((MediaActionListener)i.next()).processEditAction(element);
        }
    }

    protected void deleteClicked(Object element) {
        Iterator i = this.observers.iterator();
        while (i.hasNext()) {
            ((MediaActionListener)i.next()).processDeleteAction(element);
        }
    }
}

