/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.ui.app.views;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.window.SameShellProvider;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.vtp.desktop.core.DesktopCorePlugin;
import org.eclipse.vtp.desktop.core.project.IApplicationDesign;
import org.eclipse.vtp.desktop.core.project.IApplicationProject;
import org.eclipse.vtp.desktop.core.project.IBrand;
import org.eclipse.vtp.desktop.core.project.IBrandSet;
import org.eclipse.vtp.desktop.core.project.IBusinessObject;
import org.eclipse.vtp.desktop.core.project.IBusinessObjectSet;
import org.eclipse.vtp.desktop.core.project.IDatabase;
import org.eclipse.vtp.desktop.core.project.IDatabaseSet;
import org.eclipse.vtp.desktop.core.project.IDatabaseTable;
import org.eclipse.vtp.desktop.core.project.IMediaContainer;
import org.eclipse.vtp.desktop.core.project.IMediaFile;
import org.eclipse.vtp.desktop.core.project.IMediaFilesFolder;
import org.eclipse.vtp.desktop.core.project.IMediaFolder;
import org.eclipse.vtp.desktop.core.project.IPersonaProject;
import org.eclipse.vtp.desktop.core.project.IPromptSet;
import org.eclipse.vtp.desktop.core.project.IVoiceProject;
import org.eclipse.vtp.desktop.core.project.IVoiceResource;
import org.eclipse.vtp.desktop.core.project.IWebService;
import org.eclipse.vtp.desktop.core.project.IWebServicePort;
import org.eclipse.vtp.desktop.core.project.IWebServiceSet;
import org.eclipse.vtp.desktop.core.project.event.IRefreshListener;
import org.eclipse.vtp.desktop.ui.app.editor.ApplicationEditorInput;
import org.eclipse.vtp.desktop.ui.app.editors.BrandEditorInput;
import org.eclipse.vtp.desktop.ui.app.editors.BusinessObjectEditorInput;
import org.eclipse.vtp.desktop.ui.app.editors.DatabaseTableEditorInput;
import org.eclipse.vtp.desktop.ui.app.editors.PersonaEditorInput;
import org.eclipse.vtp.desktop.ui.app.views.ProjectsView;
import org.eclipse.vtp.desktop.ui.shared.actions.ProvisioningModelSelection;
import org.eclipse.vtp.desktop.ui.shared.actions.util.IProvisioningModelSelection;
import org.eclipse.vtp.desktop.ui.shared.actions.util.ProvisioningModelActionManager;

public class ProjectsView
extends ViewPart {
    private TreeViewer viewer = null;
    ProvisioningModelActionManager pmam = new ProvisioningModelActionManager();
    private DropTarget dropTarget = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public ProjectsView() {
        this.pmam.loadExtensionPoint("org.eclipse.vtp.desktop.core.provisioningModelActionSets");
        this.pmam.loadExtensionPoint("org.eclipse.vtp.desktop.ui.app.projectViewActionSets");
    }

    public void createPartControl(Composite parent) {
        this.viewer = new TreeViewer(parent, 770);
        this.viewer.setContentProvider((IContentProvider)new ProjectsContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new WorkbenchLabelProvider(), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator()));
        this.viewer.setSorter((ViewerSorter)new ProjectsSorter());
        this.viewer.setInput((Object)ResourcesPlugin.getWorkspace());
        this.viewer.addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
                Display.getCurrent().asyncExec(new Runnable(this, event){
                    final /* synthetic */ 19 this$1;
                    private final /* synthetic */ TreeExpansionEvent val$event;
                    {
                        this.this$1 = var1_1;
                        this.val$event = treeExpansionEvent;
                    }

                    public void run() {
                        ProjectsView.access$2(19.access$0(this.this$1)).update(this.val$event.getElement(), new String[]{"label"});
                    }
                });
            }

            public void treeExpanded(TreeExpansionEvent event) {
                Display.getCurrent().asyncExec(new Runnable(this, event){
                    final /* synthetic */ 19 this$1;
                    private final /* synthetic */ TreeExpansionEvent val$event;
                    {
                        this.this$1 = var1_1;
                        this.val$event = treeExpansionEvent;
                    }

                    public void run() {
                        ProjectsView.access$2(19.access$0(this.this$1)).update(this.val$event.getElement(), new String[]{"label"});
                    }
                });
            }

            static /* synthetic */ ProjectsView access$0(19 var0) {
                return var0.ProjectsView.this;
            }
        });
        this.dropTarget = new DropTarget(this.viewer.getControl(), 19);
        this.dropTarget.addDropListener(new DropTargetListener(){
            int initialOperation;

            public void dragEnter(DropTargetEvent event) {
                this.initialOperation = event.detail;
            }

            public void dragLeave(DropTargetEvent event) {
            }

            public void dragOperationChanged(DropTargetEvent event) {
                this.initialOperation = event.detail;
            }

            public void dragOver(DropTargetEvent event) {
                int idex;
                Point p = ProjectsView.this.viewer.getControl().toControl(new Point(event.x, event.y));
                Tree t = (Tree)ProjectsView.this.viewer.getControl();
                TreeItem ti = ProjectsView.this.findItem(t, idex = p.y / t.getItemHeight());
                if (ti != null) {
                    Object obj = ti.getData();
                    if (obj instanceof IMediaContainer) {
                        event.detail = this.initialOperation;
                    } else if (obj instanceof IWebServiceSet) {
                        Object files = FileTransfer.getInstance().nativeToJava(event.currentDataType);
                        if (files instanceof String[]) {
                            boolean allWSDL = true;
                            String[] fileNames = (String[])files;
                            int i = 0;
                            while (i < fileNames.length) {
                                if (!fileNames[i].endsWith(".wsdl")) {
                                    allWSDL = false;
                                    break;
                                }
                                ++i;
                            }
                            event.detail = allWSDL ? this.initialOperation : 0;
                        } else {
                            event.detail = 0;
                        }
                    } else {
                        event.detail = 0;
                    }
                } else {
                    event.detail = 0;
                }
            }

            public void drop(DropTargetEvent event) {
                Point p = ProjectsView.this.viewer.getControl().toControl(new Point(event.x, event.y));
                System.err.println("Drop Event: " + p);
                Tree t = (Tree)ProjectsView.this.viewer.getControl();
                int idex = p.y / t.getItemHeight();
                TreeItem ti = ProjectsView.this.findItem(t, idex);
                System.out.println(ti);
                if (ti.getData() instanceof IMediaContainer) {
                    IMediaContainer container = (IMediaContainer)ti.getData();
                    Object obj = FileTransfer.getInstance().nativeToJava(event.currentDataType);
                    if (obj != null) {
                        String[] fileNames = (String[])obj;
                        try {
                            int i = 0;
                            while (i < fileNames.length) {
                                File f = new File(fileNames[i]);
                                if (f.exists()) {
                                    if (f.isDirectory()) {
                                        ProjectsView.this.copyDirectory(f, container);
                                    } else {
                                        ProjectsView.this.copyFile(f, container);
                                    }
                                }
                                ++i;
                            }
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                        }
                        ProjectsView.this.viewer.refresh((Object)container);
                    }
                } else if (ti.getData() instanceof IWebServiceSet) {
                    IWebServiceSet container = (IWebServiceSet)ti.getData();
                    Object obj = FileTransfer.getInstance().nativeToJava(event.currentDataType);
                    if (obj != null) {
                        String[] fileNames = (String[])obj;
                        try {
                            int i = 0;
                            while (i < fileNames.length) {
                                File f = new File(fileNames[i]);
                                if (f.exists() && !f.isDirectory()) {
                                    try {
                                        container.createWebService(f.getName().substring(0, f.getName().length() - 4), f.toURL());
                                    }
                                    catch (MalformedURLException e) {
                                        e.printStackTrace();
                                    }
                                }
                                ++i;
                            }
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                        }
                        ProjectsView.this.viewer.refresh((Object)container);
                    }
                }
            }

            public void dropAccept(DropTargetEvent event) {
            }
        });
        this.dropTarget.setTransfer(new Transfer[]{FileTransfer.getInstance()});
        this.viewer.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ProjectsView.this.dropTarget.dispose();
            }
        });
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.hookSelectionListener();
        this.contributeToActionBars();
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    private void makeActions() {
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ProjectsView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IVoiceResource selection = (IVoiceResource)((IStructuredSelection)event.getSelection()).getFirstElement();
                if (selection instanceof IVoiceProject || selection instanceof IBrandSet || selection instanceof IBrand || selection instanceof IMediaContainer || selection instanceof IBusinessObjectSet || selection instanceof IDatabaseSet || selection instanceof IDatabase) {
                    if (ProjectsView.this.viewer.getExpandedState((Object)selection)) {
                        ProjectsView.this.viewer.collapseToLevel((Object)selection, -1);
                    } else {
                        ProjectsView.this.viewer.expandToLevel((Object)selection, 1);
                    }
                } else if (selection instanceof IApplicationDesign) {
                    try {
                        IApplicationDesign design = (IApplicationDesign)selection;
                        ApplicationEditorInput appInput = new ApplicationEditorInput(design, (IApplicationProject)design.getProject());
                        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)appInput, "org.eclipse.vtp.desktop.ui.app.editor", true);
                    }
                    catch (PartInitException e1) {
                        e1.printStackTrace();
                    }
                } else if (selection instanceof IPromptSet) {
                    IPromptSet promptSet = (IPromptSet)selection;
                    if (promptSet.getParent() instanceof IBrand) {
                        BrandEditorInput input = new BrandEditorInput((IBrand)promptSet.getParent());
                        try {
                            IWorkbenchPage iWorkbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                            Class<?> clazz = class$0;
                            if (clazz == null) {
                                try {
                                    clazz = class$0 = Class.forName("org.eclipse.vtp.desktop.ui.app.editors.BrandEditor");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            iWorkbenchPage.openEditor((IEditorInput)input, clazz.getName(), true);
                        }
                        catch (PartInitException e) {
                            ProjectsView.this.showMessage(e.getMessage());
                            e.printStackTrace();
                        }
                    } else if (promptSet.getParent() instanceof IPersonaProject) {
                        PersonaEditorInput input = new PersonaEditorInput((IPersonaProject)promptSet.getParent());
                        try {
                            IWorkbenchPage iWorkbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                            Class<?> clazz = class$1;
                            if (clazz == null) {
                                try {
                                    clazz = class$1 = Class.forName("org.eclipse.vtp.desktop.ui.app.editors.PersonaEditor");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            iWorkbenchPage.openEditor((IEditorInput)input, clazz.getName(), true);
                        }
                        catch (PartInitException e) {
                            ProjectsView.this.showMessage(e.getMessage());
                            e.printStackTrace();
                        }
                    }
                } else if (selection instanceof IBusinessObject) {
                    IBusinessObject businessObject = (IBusinessObject)selection;
                    BusinessObjectEditorInput input = new BusinessObjectEditorInput(businessObject);
                    try {
                        IWorkbenchPage iWorkbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        Class<?> clazz = class$2;
                        if (clazz == null) {
                            try {
                                clazz = class$2 = Class.forName("org.eclipse.vtp.desktop.ui.app.editors.BusinessObjectEditor");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        iWorkbenchPage.openEditor((IEditorInput)input, clazz.getName(), true);
                    }
                    catch (PartInitException e) {
                        ProjectsView.this.showMessage(e.getMessage());
                        e.printStackTrace();
                    }
                } else if (selection instanceof IDatabaseTable) {
                    IDatabaseTable databaseTable = (IDatabaseTable)selection;
                    DatabaseTableEditorInput input = new DatabaseTableEditorInput(databaseTable);
                    try {
                        IWorkbenchPage iWorkbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        Class<?> clazz = class$3;
                        if (clazz == null) {
                            try {
                                clazz = class$3 = Class.forName("org.eclipse.vtp.desktop.ui.app.editors.DatabaseTableEditor");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        iWorkbenchPage.openEditor((IEditorInput)input, clazz.getName(), true);
                    }
                    catch (PartInitException e) {
                        ProjectsView.this.showMessage(e.getMessage());
                        e.printStackTrace();
                    }
                } else if (selection instanceof IMediaFile) {
                    IMediaFile file = (IMediaFile)selection;
                    IVoiceResource parent = file.getParent();
                    while (!(parent instanceof IMediaFilesFolder)) {
                        parent = parent.getParent();
                    }
                    LinkedList<IVoiceResource> parents = new LinkedList<IVoiceResource>();
                    while (!(parent instanceof IVoiceProject)) {
                        parents.addFirst(parent);
                        parent = parent.getParent();
                    }
                    StringBuffer buf = new StringBuffer();
                    Iterator i = parents.iterator();
                    while (i.hasNext()) {
                        buf.append(((IVoiceResource)i.next()).getName()).append('/');
                    }
                    buf.setLength(buf.length() - 1);
                    buf.append(file.getMediaPath());
                    IFile ifile = selection.getProject().getUnderlyingProject().getFile(buf.toString());
                    ProjectsView.this.getSite().getShell().getDisplay().asyncExec(new Runnable(this, ifile){
                        final /* synthetic */ 25 this$1;
                        private final /* synthetic */ IFile val$ifile;
                        {
                            this.this$1 = var1_1;
                            this.val$ifile = iFile;
                        }

                        public void run() {
                            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                            try {
                                IDE.openEditor((IWorkbenchPage)page, (IFile)this.val$ifile, (boolean)true);
                            }
                            catch (PartInitException partInitException) {}
                        }
                    });
                }
            }
        });
    }

    private void hookSelectionListener() {
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (!selection.isEmpty()) {
                    Object obj = selection.getFirstElement();
                    ProjectsView.this.pmam.selectionChanged((IProvisioningModelSelection)new ProvisioningModelSelection(obj));
                } else {
                    ProjectsView.this.pmam.selectionChanged((IProvisioningModelSelection)new ProvisioningModelSelection(null));
                }
            }
        });
        this.pmam.selectionChanged((IProvisioningModelSelection)new ProvisioningModelSelection(null));
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillContextMenu(IMenuManager manager) {
        this.pmam.fillContextMenu(manager);
        manager.add((IContributionItem)new Separator("additions"));
        manager.add((IAction)ActionFactory.EXPORT.create(this.getSite().getWorkbenchWindow()));
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new PropertyDialogAction((IShellProvider)new SameShellProvider(this.viewer.getControl()), (ISelectionProvider)this.viewer));
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IContributionItem)new Separator());
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IContributionItem)new Separator());
    }

    private void showMessage(String message) {
        MessageDialog.openInformation((Shell)this.viewer.getControl().getShell(), (String)"Projects", (String)message);
    }

    private boolean isApplicationProject(IProject project) {
        try {
            return project.getNature("org.eclipse.vtp.desktop.core.VoiceApplicationNature") != null;
        }
        catch (CoreException e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean isPersonaProject(IProject project) {
        try {
            return project.getNature("org.eclipse.vtp.desktop.core.VoicePersonaNature") != null;
        }
        catch (CoreException e) {
            e.printStackTrace();
            return false;
        }
    }

    public TreeItem findItem(Tree tree, int index) {
        ArrayList<TreeItem> items = new ArrayList<TreeItem>();
        TreeItem[] tis = tree.getItems();
        int i = 0;
        while (i < tis.length) {
            items.add(tis[i]);
            if (tis[i].getExpanded()) {
                this.loadItems(items, tis[i]);
            }
            ++i;
        }
        if (index < items.size()) {
            return (TreeItem)items.get(index);
        }
        return null;
    }

    public void loadItems(List list, TreeItem parent) {
        TreeItem[] tis = parent.getItems();
        int i = 0;
        while (i < tis.length) {
            list.add(tis[i]);
            if (tis[i].getExpanded()) {
                this.loadItems(list, tis[i]);
            }
            ++i;
        }
    }

    public void copyDirectory(File f, IMediaContainer container) throws CoreException {
        IMediaFolder folder = container.makeDirectory(f.getName());
        File[] fs = f.listFiles();
        int i = 0;
        while (i < fs.length) {
            if (fs[i].isDirectory()) {
                this.copyDirectory(fs[i], (IMediaContainer)folder);
            } else {
                this.copyFile(fs[i], (IMediaContainer)folder);
            }
            ++i;
        }
    }

    public void copyFile(File f, IMediaContainer container) throws CoreException {
        try {
            FileInputStream fis = new FileInputStream(f);
            container.create(f.getName(), (InputStream)fis, null);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new WorkbenchException("Problems coping file" + e);
        }
    }

    private class ProjectsContentProvider
    implements IStructuredContentProvider,
    ITreeContentProvider,
    IResourceChangeListener {
        private ProjectsContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
            if (oldInput instanceof IWorkspace) {
                ((IWorkspace)oldInput).removeResourceChangeListener((IResourceChangeListener)this);
            }
            if (newInput instanceof IWorkspace) {
                ((IWorkspace)newInput).addResourceChangeListener((IResourceChangeListener)this, 1);
            }
        }

        public Object[] getElements(Object parent) {
            if (!((IWorkspace)parent).getRoot().isSynchronized(1)) {
                try {
                    ((IWorkspace)parent).getRoot().refreshLocal(1, null);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            IProject[] projects = ((IWorkspace)parent).getRoot().getProjects();
            ArrayList<Object> results = new ArrayList<Object>(projects.length);
            int i = 0;
            while (i < projects.length) {
                if (projects[i].isOpen()) {
                    if (!projects[i].isSynchronized(2)) {
                        try {
                            projects[i].refreshLocal(2, null);
                            projects[i].open(null);
                        }
                        catch (CoreException e1) {
                            e1.printStackTrace();
                        }
                    }
                    if (ProjectsView.this.isApplicationProject(projects[i])) {
                        try {
                            results.add(DesktopCorePlugin.convertToApplication((IProject)projects[i]));
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                        }
                    } else if (ProjectsView.this.isPersonaProject(projects[i])) {
                        try {
                            results.add(DesktopCorePlugin.convertToPersona((IProject)projects[i]));
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                        }
                    }
                }
                ++i;
            }
            return results.toArray();
        }

        public Object getParent(Object child) {
            return child instanceof IVoiceResource ? ((IVoiceResource)child).getParent() : null;
        }

        public Object[] getChildren(Object parent) {
            try {
                if (parent instanceof IApplicationProject) {
                    return new Object[]{((IApplicationProject)parent).getApplicationDesign(), ((IApplicationProject)parent).getBrandSet(), ((IApplicationProject)parent).getBusinessObjectSet(), ((IApplicationProject)parent).getDatabaseSet(), ((IApplicationProject)parent).getWebServiceSet()};
                }
                if (parent instanceof IPersonaProject) {
                    IPersonaProject personaProject = (IPersonaProject)parent;
                    return new Object[]{personaProject.getPromptSet(), personaProject.getMediaFilesFolder()};
                }
                if (parent instanceof IBusinessObjectSet) {
                    IBusinessObjectSet businessObjectSet = (IBusinessObjectSet)parent;
                    businessObjectSet.addRefreshListener(new IRefreshListener(this, businessObjectSet){
                        final /* synthetic */ ProjectsContentProvider this$1;
                        private final /* synthetic */ IBusinessObjectSet val$businessObjectSet;
                        {
                            this.this$1 = projectsContentProvider;
                            this.val$businessObjectSet = iBusinessObjectSet;
                        }

                        public void refreshResource(IVoiceResource resource) {
                            ProjectsView.access$2(ProjectsContentProvider.access$1(this.this$1)).getControl().getDisplay().asyncExec(new Runnable(this, this.val$businessObjectSet){
                                final /* synthetic */ 1 this$2;
                                private final /* synthetic */ IBusinessObjectSet val$businessObjectSet;
                                {
                                    this.this$2 = var1_1;
                                    this.val$businessObjectSet = iBusinessObjectSet;
                                }

                                public void run() {
                                    ProjectsView.access$2(ProjectsContentProvider.access$1(1.access$0(this.this$2))).refresh((Object)this.val$businessObjectSet);
                                    ProjectsView.access$2(ProjectsContentProvider.access$1(1.access$0(this.this$2))).expandToLevel((Object)this.val$businessObjectSet, 1);
                                }
                            });
                        }

                        static /* synthetic */ ProjectsContentProvider access$0(1 var0) {
                            return var0.this$1;
                        }
                    });
                    return businessObjectSet.getBusinessObjects().toArray();
                }
                if (parent instanceof IDatabaseSet) {
                    IDatabaseSet databaseSet = (IDatabaseSet)parent;
                    databaseSet.addRefreshListener(new IRefreshListener(this, databaseSet){
                        final /* synthetic */ ProjectsContentProvider this$1;
                        private final /* synthetic */ IDatabaseSet val$databaseSet;
                        {
                            this.this$1 = projectsContentProvider;
                            this.val$databaseSet = iDatabaseSet;
                        }

                        public void refreshResource(IVoiceResource resource) {
                            ProjectsView.access$2(ProjectsContentProvider.access$1(this.this$1)).getControl().getDisplay().asyncExec(new Runnable(this, this.val$databaseSet){
                                final /* synthetic */ 3 this$2;
                                private final /* synthetic */ IDatabaseSet val$databaseSet;
                                {
                                    this.this$2 = var1_1;
                                    this.val$databaseSet = iDatabaseSet;
                                }

                                public void run() {
                                    ProjectsView.access$2(ProjectsContentProvider.access$1(3.access$0(this.this$2))).refresh((Object)this.val$databaseSet);
                                    ProjectsView.access$2(ProjectsContentProvider.access$1(3.access$0(this.this$2))).expandToLevel((Object)this.val$databaseSet, 1);
                                }
                            });
                        }

                        static /* synthetic */ ProjectsContentProvider access$0(3 var0) {
                            return var0.this$1;
                        }
                    });
                    return databaseSet.getDatabases().toArray();
                }
                if (parent instanceof IDatabase) {
                    IDatabase database = (IDatabase)parent;
                    database.addRefreshListener(new IRefreshListener(this, database){
                        final /* synthetic */ ProjectsContentProvider this$1;
                        private final /* synthetic */ IDatabase val$database;
                        {
                            this.this$1 = projectsContentProvider;
                            this.val$database = iDatabase;
                        }

                        public void refreshResource(IVoiceResource resource) {
                            ProjectsView.access$2(ProjectsContentProvider.access$1(this.this$1)).getControl().getDisplay().asyncExec(new Runnable(this, this.val$database){
                                final /* synthetic */ 5 this$2;
                                private final /* synthetic */ IDatabase val$database;
                                {
                                    this.this$2 = var1_1;
                                    this.val$database = iDatabase;
                                }

                                public void run() {
                                    ProjectsView.access$2(ProjectsContentProvider.access$1(5.access$0(this.this$2))).refresh((Object)this.val$database);
                                }
                            });
                        }

                        static /* synthetic */ ProjectsContentProvider access$0(5 var0) {
                            return var0.this$1;
                        }
                    });
                    return database.getTables().toArray();
                }
                if (parent instanceof IWebServiceSet) {
                    IWebServiceSet webServiceSet = (IWebServiceSet)parent;
                    webServiceSet.addRefreshListener(new IRefreshListener(this, webServiceSet){
                        final /* synthetic */ ProjectsContentProvider this$1;
                        private final /* synthetic */ IWebServiceSet val$webServiceSet;
                        {
                            this.this$1 = projectsContentProvider;
                            this.val$webServiceSet = iWebServiceSet;
                        }

                        public void refreshResource(IVoiceResource resource) {
                            ProjectsView.access$2(ProjectsContentProvider.access$1(this.this$1)).getControl().getDisplay().asyncExec(new Runnable(this, this.val$webServiceSet){
                                final /* synthetic */ 7 this$2;
                                private final /* synthetic */ IWebServiceSet val$webServiceSet;
                                {
                                    this.this$2 = var1_1;
                                    this.val$webServiceSet = iWebServiceSet;
                                }

                                public void run() {
                                    ProjectsView.access$2(ProjectsContentProvider.access$1(7.access$0(this.this$2))).refresh((Object)this.val$webServiceSet);
                                    ProjectsView.access$2(ProjectsContentProvider.access$1(7.access$0(this.this$2))).expandToLevel((Object)this.val$webServiceSet, 1);
                                }
                            });
                        }

                        static /* synthetic */ ProjectsContentProvider access$0(7 var0) {
                            return var0.this$1;
                        }
                    });
                    return webServiceSet.getWebServices().toArray();
                }
                if (parent instanceof IWebService) {
                    IWebService webService = (IWebService)parent;
                    webService.addRefreshListener(new IRefreshListener(this, webService){
                        final /* synthetic */ ProjectsContentProvider this$1;
                        private final /* synthetic */ IWebService val$webService;
                        {
                            this.this$1 = projectsContentProvider;
                            this.val$webService = iWebService;
                        }

                        public void refreshResource(IVoiceResource resource) {
                            ProjectsView.access$2(ProjectsContentProvider.access$1(this.this$1)).getControl().getDisplay().asyncExec(new Runnable(this, this.val$webService){
                                final /* synthetic */ 9 this$2;
                                private final /* synthetic */ IWebService val$webService;
                                {
                                    this.this$2 = var1_1;
                                    this.val$webService = iWebService;
                                }

                                public void run() {
                                    ProjectsView.access$2(ProjectsContentProvider.access$1(9.access$0(this.this$2))).refresh((Object)this.val$webService);
                                    ProjectsView.access$2(ProjectsContentProvider.access$1(9.access$0(this.this$2))).expandToLevel((Object)this.val$webService, 1);
                                }
                            });
                        }

                        static /* synthetic */ ProjectsContentProvider access$0(9 var0) {
                            return var0.this$1;
                        }
                    });
                    return webService.getWebServicePorts().toArray();
                }
                if (parent instanceof IWebServicePort) {
                    IWebServicePort webServicePort = (IWebServicePort)parent;
                    webServicePort.addRefreshListener(new IRefreshListener(this, webServicePort){
                        final /* synthetic */ ProjectsContentProvider this$1;
                        private final /* synthetic */ IWebServicePort val$webServicePort;
                        {
                            this.this$1 = projectsContentProvider;
                            this.val$webServicePort = iWebServicePort;
                        }

                        public void refreshResource(IVoiceResource resource) {
                            ProjectsView.access$2(ProjectsContentProvider.access$1(this.this$1)).getControl().getDisplay().asyncExec(new Runnable(this, this.val$webServicePort){
                                final /* synthetic */ 11 this$2;
                                private final /* synthetic */ IWebServicePort val$webServicePort;
                                {
                                    this.this$2 = var1_1;
                                    this.val$webServicePort = iWebServicePort;
                                }

                                public void run() {
                                    ProjectsView.access$2(ProjectsContentProvider.access$1(11.access$0(this.this$2))).refresh((Object)this.val$webServicePort);
                                    ProjectsView.access$2(ProjectsContentProvider.access$1(11.access$0(this.this$2))).expandToLevel((Object)this.val$webServicePort, 1);
                                }
                            });
                        }

                        static /* synthetic */ ProjectsContentProvider access$0(11 var0) {
                            return var0.this$1;
                        }
                    });
                    return webServicePort.getWebServiceOperations().toArray();
                }
                if (parent instanceof IBrandSet) {
                    IBrandSet brandSet = (IBrandSet)parent;
                    brandSet.addRefreshListener(new IRefreshListener(this, brandSet){
                        final /* synthetic */ ProjectsContentProvider this$1;
                        private final /* synthetic */ IBrandSet val$brandSet;
                        {
                            this.this$1 = projectsContentProvider;
                            this.val$brandSet = iBrandSet;
                        }

                        public void refreshResource(IVoiceResource resource) {
                            ProjectsView.access$2(ProjectsContentProvider.access$1(this.this$1)).getControl().getDisplay().asyncExec(new Runnable(this, this.val$brandSet){
                                final /* synthetic */ 13 this$2;
                                private final /* synthetic */ IBrandSet val$brandSet;
                                {
                                    this.this$2 = var1_1;
                                    this.val$brandSet = iBrandSet;
                                }

                                public void run() {
                                    ProjectsView.access$2(ProjectsContentProvider.access$1(13.access$0(this.this$2))).refresh((Object)this.val$brandSet);
                                }
                            });
                        }

                        static /* synthetic */ ProjectsContentProvider access$0(13 var0) {
                            return var0.this$1;
                        }
                    });
                    return brandSet.getBrands().toArray();
                }
                if (parent instanceof IBrand) {
                    IBrand brand = (IBrand)parent;
                    return new Object[]{brand.getPromptSet(), brand.getMediaFilesFolder()};
                }
                if (parent instanceof IMediaContainer) {
                    IMediaContainer container = (IMediaContainer)parent;
                    container.addRefreshListener(new IRefreshListener(this, container){
                        final /* synthetic */ ProjectsContentProvider this$1;
                        private final /* synthetic */ IMediaContainer val$container;
                        {
                            this.this$1 = projectsContentProvider;
                            this.val$container = iMediaContainer;
                        }

                        public void refreshResource(IVoiceResource resource) {
                            ProjectsView.access$2(ProjectsContentProvider.access$1(this.this$1)).getControl().getDisplay().asyncExec(new Runnable(this, this.val$container){
                                final /* synthetic */ 15 this$2;
                                private final /* synthetic */ IMediaContainer val$container;
                                {
                                    this.this$2 = var1_1;
                                    this.val$container = iMediaContainer;
                                }

                                public void run() {
                                    ProjectsView.access$2(ProjectsContentProvider.access$1(15.access$0(this.this$2))).refresh((Object)this.val$container);
                                }
                            });
                        }

                        static /* synthetic */ ProjectsContentProvider access$0(15 var0) {
                            return var0.this$1;
                        }
                    });
                    return container.listMediaResources().toArray();
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            return new Object[0];
        }

        public boolean hasChildren(Object parent) {
            return parent instanceof IApplicationProject || parent instanceof IPersonaProject || parent instanceof IBrandSet || parent instanceof IBrand || parent instanceof IMediaContainer || parent instanceof IBusinessObjectSet || parent instanceof IDatabaseSet || parent instanceof IDatabase || parent instanceof IWebServiceSet || parent instanceof IWebService || parent instanceof IWebServicePort;
        }

        public void dispose() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            boolean[] bs = new boolean[1];
            try {
                event.getDelta().accept(new IResourceDeltaVisitor(this, bs){
                    final /* synthetic */ ProjectsContentProvider this$1;
                    private final /* synthetic */ boolean[] val$bs;
                    {
                        this.this$1 = projectsContentProvider;
                        this.val$bs = blArray;
                    }

                    public boolean visit(IResourceDelta delta) throws CoreException {
                        if (delta.getKind() == 1 && (delta.getResource().getName().equals(".buildPath") || delta.getResource().getName().equals(".config"))) {
                            this.val$bs[0] = true;
                        }
                        return true;
                    }
                });
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            if (bs[0]) {
                ProjectsView.this.viewer.getControl().getDisplay().asyncExec(new Runnable(this){
                    final /* synthetic */ ProjectsContentProvider this$1;
                    {
                        this.this$1 = projectsContentProvider;
                    }

                    public void run() {
                        ProjectsView.access$2(ProjectsContentProvider.access$1(this.this$1)).refresh();
                    }
                });
            }
        }

        static /* synthetic */ ProjectsView access$1(ProjectsContentProvider projectsContentProvider) {
            return projectsContentProvider.ProjectsView.this;
        }
    }

    private final class ProjectsSorter
    extends ViewerSorter {
        private ProjectsSorter() {
        }

        public int category(Object element) {
            if (element instanceof IApplicationDesign || element instanceof IPromptSet) {
                return 1;
            }
            if (element instanceof IMediaContainer) {
                return 2;
            }
            return 3;
        }
    }
}

