/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.ui.app.widgets;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.vtp.desktop.core.project.IMediaFilesFolder;
import org.eclipse.vtp.desktop.core.project.ISupportedLanguage;
import org.eclipse.vtp.desktop.ui.app.ApplicationUIPlugin;
import org.eclipse.vtp.desktop.ui.app.dialogs.GrammarDialog;
import org.eclipse.vtp.desktop.ui.app.dialogs.PromptSequenceDialog;
import org.eclipse.vtp.desktop.ui.app.editor.DynamicMenuOption;
import org.eclipse.vtp.desktop.ui.app.editor.MediaScriptCustomObject;
import org.eclipse.vtp.desktop.ui.app.editor.MediaScriptDynamicMenuObject;
import org.eclipse.vtp.desktop.ui.app.editor.MediaScriptFieldObject;
import org.eclipse.vtp.desktop.ui.app.editor.MediaScriptMenuObject;
import org.eclipse.vtp.desktop.ui.app.editor.MediaScriptMessageObject;
import org.eclipse.vtp.desktop.ui.app.editor.MediaScriptObject;
import org.eclipse.vtp.desktop.ui.app.editor.MenuOption;
import org.eclipse.vtp.desktop.ui.app.editor.model.ApplicationModel;
import org.eclipse.vtp.desktop.ui.app.editor.model.Element;
import org.eclipse.vtp.desktop.ui.app.editor.model.GridCellManager;
import org.eclipse.vtp.desktop.ui.app.wizards.NewMenuChoiceWizard;
import org.eclipse.vtp.framework.media.binding.BindingGrammarEntry;
import org.eclipse.vtp.framework.media.binding.BindingGrammarTranslation;
import org.eclipse.vtp.framework.media.binding.BindingPromptEntry;
import org.eclipse.vtp.framework.media.binding.BindingPromptTranslation;
import org.eclipse.vtp.framework.media.grammars.FileGrammar;
import org.eclipse.vtp.framework.media.grammars.Grammar;
import org.eclipse.vtp.framework.media.prompts.CharactersPrompt;
import org.eclipse.vtp.framework.media.prompts.FilePrompt;
import org.eclipse.vtp.framework.media.prompts.Prompt;
import org.eclipse.vtp.framework.media.prompts.PromptVisitorAdapter;
import org.eclipse.vtp.framework.media.prompts.TextPrompt;
import org.eclipse.vtp.framework.media.prompts.VariablePrompt;
import org.eclipse.vtp.framework.media.util.BindingIndex;
import org.eclipse.vtp.framework.media.util.CustomBindingIndex;
import org.eclipse.vtp.framework.media.util.DialogAggregate;

public class DialogWidget
extends ScrolledComposite {
    PromptRenderer promptRenderer = new PromptRenderer();
    private Composite parent;
    private Composite canvas;
    private Color lightBlue;
    private Color darkBlue;
    private Color lightOrange;
    private Color darkOrange;
    private Color dividerColor;
    private Font boldFont;
    private Font smallFont;
    private HeaderExpansionListener headerListener;
    private List dialogControls;
    private Map dialogDataMap;
    BindingIndex bi;
    private Element element = null;
    private ApplicationModel model;
    private String brandName;

    public DialogWidget(Composite parent, int style, Element element) {
        super(parent, style);
        this.parent = parent;
        this.element = element;
        this.dialogDataMap = new HashMap();
        this.boldFont = new Font((Device)this.getDisplay(), parent.getFont().getFontData()[0].getName(), parent.getFont().getFontData()[0].getHeight(), 1);
        this.smallFont = new Font((Device)this.getDisplay(), "Arial", 8, 0);
        this.headerListener = new HeaderExpansionListener(){

            public void headerExpansionChanged(HeaderComposite header) {
                DialogWidget.this.canvas.layout(true, true);
                DialogWidget.this.setMinSize(300, ((DialogWidget)DialogWidget.this).canvas.computeSize((int)Math.max((int)300, (int)DialogWidget.this.getClientArea().width), (int)-1).y);
            }
        };
        this.canvas = new Canvas((Composite)this, 0x20000000);
        this.canvas.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                DialogWidget.this.canvas.forceFocus();
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        this.canvas.setBackground(this.parent.getBackground());
        GridLayout gl = new GridLayout(2, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.verticalSpacing = 1;
        gl.horizontalSpacing = 30;
        this.canvas.setLayout((Layout)gl);
        this.lightBlue = new Color((Device)Display.getCurrent(), 143, 176, 216);
        this.darkBlue = new Color((Device)Display.getCurrent(), 68, 144, 237);
        this.lightOrange = new Color((Device)Display.getCurrent(), 242, 200, 133);
        this.darkOrange = new Color((Device)Display.getCurrent(), 254, 156, 3);
        this.dividerColor = new Color((Device)Display.getCurrent(), 231, 233, 240);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                DialogWidget.this.lightBlue.dispose();
                DialogWidget.this.darkBlue.dispose();
                DialogWidget.this.lightOrange.dispose();
                DialogWidget.this.darkOrange.dispose();
                DialogWidget.this.dividerColor.dispose();
                DialogWidget.this.boldFont.dispose();
                DialogWidget.this.smallFont.dispose();
            }
        });
        this.setContent((Control)this.canvas);
        this.setExpandHorizontal(true);
        this.setExpandVertical(true);
        this.setMinSize(300, this.canvas.computeSize((int)this.canvas.getClientArea().width, (int)-1).y);
        this.canvas.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                DialogWidget.this.setMinSize(300, ((DialogWidget)DialogWidget.this).canvas.computeSize((int)Math.max((int)300, (int)DialogWidget.this.getClientArea().width), (int)-1).y);
            }
        });
        this.dialogControls = new ArrayList();
    }

    public void setModel(ApplicationModel model) {
        this.model = model;
    }

    public void setDialogData(String brandName, Map dataMap, BindingIndex index) {
        this.dialogDataMap = dataMap;
        this.bi = index;
        this.brandName = brandName;
        int i = 0;
        while (i < this.dialogControls.size()) {
            DialogControlSet dcs = (DialogControlSet)this.dialogControls.get(i);
            dcs.update();
            ++i;
        }
    }

    public void addMessageDialog(MediaScriptMessageObject msmo) {
        this.dialogControls.add(new MessageDialogControlSet(msmo));
        this.setMinSize(300, this.canvas.computeSize((int)this.getClientArea().width, (int)-1).y);
    }

    public void addFieldDialog(MediaScriptFieldObject msfo) {
        this.dialogControls.add(new FieldDialogControlSet(msfo));
        this.setMinSize(300, this.canvas.computeSize((int)this.getClientArea().width, (int)-1).y);
    }

    public void addMenuDialog(MediaScriptMenuObject msmo) {
        this.dialogControls.add(new MenuDialogControlSet(msmo));
        this.setMinSize(300, this.canvas.computeSize((int)this.getClientArea().width, (int)-1).y);
    }

    public void addDynamicMenuDialog(MediaScriptDynamicMenuObject msdmo) {
        this.dialogControls.add(new DynamicMenuDialogControlSet(msdmo));
        this.setMinSize(300, this.canvas.computeSize((int)this.getClientArea().width, (int)-1).y);
    }

    public void addCustomFieldDialog(MediaScriptCustomObject msco) {
        this.dialogControls.add(new CustomFieldDialogControlSet(msco));
        this.setMinSize(300, this.canvas.computeSize((int)this.getClientArea().width, (int)-1).y);
    }

    public void addCustomMenuDialog(MediaScriptCustomObject msco) {
        this.dialogControls.add(new CustomMenuDialogControlSet(msco));
        this.setMinSize(300, this.canvas.computeSize((int)this.getClientArea().width, (int)-1).y);
    }

    public void addCustomMessageDialog(MediaScriptCustomObject msco) {
        this.dialogControls.add(new CustomMessageDialogControlSet(msco));
        this.setMinSize(300, this.canvas.computeSize((int)this.getClientArea().width, (int)-1).y);
    }

    private Label createPropertyLabel(Composite parent, String text) {
        Label ret = new Label(parent, 0);
        ret.setText(text);
        ret.setBackground(parent.getBackground());
        GridData gd = new GridData();
        gd.verticalAlignment = 128;
        gd.verticalIndent = 4;
        gd.horizontalIndent = 50;
        ret.setLayoutData((Object)gd);
        return ret;
    }

    private Label createOptionLabel(Composite parent, String text) {
        Label ret = new Label(parent, 0);
        ret.setText(text);
        ret.setBackground(parent.getBackground());
        GridData gd = new GridData();
        gd.verticalAlignment = 128;
        gd.verticalIndent = 4;
        gd.horizontalIndent = 60;
        ret.setLayoutData((Object)gd);
        return ret;
    }

    private Label createOptionChildLabel(Composite parent, String text) {
        Label ret = new Label(parent, 0);
        ret.setText(text);
        ret.setBackground(parent.getBackground());
        GridData gd = new GridData();
        gd.verticalAlignment = 128;
        gd.verticalIndent = 4;
        gd.horizontalIndent = 70;
        ret.setLayoutData((Object)gd);
        return ret;
    }

    private RowDivider createRowDivider(Composite parent, Color dividerColor) {
        RowDivider rd1 = new RowDivider(parent, 0);
        rd1.setBackground(parent.getBackground());
        rd1.setForeground(dividerColor);
        GridData gd = new GridData(768);
        gd.heightHint = 3;
        gd.horizontalIndent = 50;
        gd.horizontalSpan = 2;
        rd1.setLayoutData(gd);
        return rd1;
    }

    private Spinner createValueSpinner(Composite parent, int min, int max, int digits, int value) {
        Spinner ret = new Spinner(parent, 2048);
        ret.setMinimum(min);
        ret.setMaximum(max);
        ret.setDigits(digits);
        ret.setSelection(value);
        GridData gd = new GridData();
        gd.verticalIndent = 2;
        gd.horizontalAlignment = 131072;
        ret.setLayoutData((Object)gd);
        return ret;
    }

    private Combo createValueDropDown(Composite parent) {
        Combo ret = new Combo(parent, 2060);
        GridData gd = new GridData();
        gd.verticalIndent = 2;
        gd.horizontalAlignment = 131072;
        gd.grabExcessHorizontalSpace = false;
        ret.setLayoutData((Object)gd);
        return ret;
    }

    public BindingPromptEntry editPrompt(String entryName, BindingPromptEntry entry) {
        Map map = new HashMap<Locale, List>();
        Iterator i = this.model.getProject().getSupportedLanguages().iterator();
        while (i.hasNext()) {
            ISupportedLanguage lang = (ISupportedLanguage)i.next();
            if (entry == null || entry.getTranslation(lang.getLocale()) == null) {
                map.put(lang.getLocale(), new ArrayList());
                continue;
            }
            map.put(lang.getLocale(), entry.getTranslation(lang.getLocale()).getAll());
        }
        ArrayList<IMediaFilesFolder> fileDirs = new ArrayList<IMediaFilesFolder>(2);
        if (this.bi instanceof CustomBindingIndex) {
            fileDirs.add(this.model.getProject().getBrandSet().getBrand(this.brandName).getMediaFilesFolder());
        }
        fileDirs.add(this.model.getProject().getBrandSet().getBrand("Default").getMediaFilesFolder());
        PromptSequenceDialog dialog = new PromptSequenceDialog(this.getShell(), entryName, false, map, false, true, fileDirs.toArray(new IMediaFilesFolder[fileDirs.size()]), this.bi.indexAvailablePrompts("", ""), this.element);
        if (dialog.open() != 0) {
            return entry;
        }
        entry = new BindingPromptEntry(entryName);
        map = dialog.getPromptListsByLocale();
        Iterator i2 = map.keySet().iterator();
        while (i2.hasNext()) {
            Locale locale = (Locale)i2.next();
            entry.addTranslation(new BindingPromptTranslation(locale, (List)map.get(locale)));
        }
        return entry;
    }

    private String getPromptText(MediaScriptObject mso, BindingPromptEntry entry) {
        String ret = "Not Configured";
        if (entry != null) {
            BindingPromptTranslation bt = entry.getTranslation(this.bi.getDefaultLocale());
            if (bt == null || bt.getAll().isEmpty()) {
                bt = entry.getTranslation(new Locale(this.bi.getDefaultLocale().getLanguage()));
            }
            if (bt != null) {
                List promptList = bt.getAll();
                StringBuffer buf = new StringBuffer();
                int p = 0;
                while (p < promptList.size()) {
                    List all = this.bi.solvePrompt((Prompt)promptList.get(p), mso.getGroupType(), mso.getInstanceId());
                    Iterator i = all.iterator();
                    while (i.hasNext()) {
                        buf.append(((Prompt)i.next()).accept((Prompt.Visitor)this.promptRenderer));
                        if (!i.hasNext()) continue;
                        buf.append(' ');
                    }
                    ret = buf.toString();
                    ++p;
                }
            }
        }
        return ret;
    }

    public BindingGrammarEntry editGrammar(String entryName, BindingGrammarEntry entry) {
        Map map = new HashMap<Locale, List>();
        Iterator i = this.model.getProject().getSupportedLanguages().iterator();
        while (i.hasNext()) {
            ISupportedLanguage lang = (ISupportedLanguage)i.next();
            if (entry == null || entry.getTranslation(lang.getLocale()) == null) {
                map.put(lang.getLocale(), new ArrayList());
                continue;
            }
            map.put(lang.getLocale(), entry.getTranslation(lang.getLocale()).getAll());
        }
        ArrayList<IMediaFilesFolder> fileDirs = new ArrayList<IMediaFilesFolder>(2);
        if (this.bi instanceof CustomBindingIndex) {
            fileDirs.add(this.model.getProject().getBrandSet().getBrand(this.brandName).getMediaFilesFolder());
        }
        fileDirs.add(this.model.getProject().getBrandSet().getBrand("Default").getMediaFilesFolder());
        GrammarDialog dialog = new GrammarDialog(this.getShell(), entryName, false, map, false, fileDirs.toArray(new IMediaFilesFolder[fileDirs.size()]), this.bi.indexAvailableGrammars("", ""));
        if (dialog.open() != 0) {
            return entry;
        }
        entry = new BindingGrammarEntry(entryName);
        map = dialog.getGrammarListsByLocale();
        Iterator i2 = map.keySet().iterator();
        while (i2.hasNext()) {
            Locale locale = (Locale)i2.next();
            entry.addTranslation(new BindingGrammarTranslation(locale, (List)map.get(locale)));
        }
        return entry;
    }

    private String getGrammarText(MediaScriptObject mso, BindingGrammarEntry entry) {
        String ret = "Not Configured";
        if (entry != null) {
            BindingGrammarTranslation bt = entry.getTranslation(this.bi.getDefaultLocale());
            if (bt == null || bt.getAll().isEmpty()) {
                bt = entry.getTranslation(new Locale(this.bi.getDefaultLocale().getLanguage()));
            }
            if (bt != null) {
                List promptList = bt.getAll();
                StringBuffer buf = new StringBuffer();
                int p = 0;
                while (p < promptList.size()) {
                    List all = this.bi.solveGrammar((Grammar)promptList.get(p), mso.getGroupType(), mso.getInstanceId());
                    Iterator i = all.iterator();
                    while (i.hasNext()) {
                        buf.append(((FileGrammar)i.next()).getPath());
                        if (!i.hasNext()) continue;
                        buf.append(' ');
                    }
                    ret = buf.toString();
                    ++p;
                }
            }
        }
        return ret;
    }

    private static interface HeaderExpansionListener {
        public void headerExpansionChanged(HeaderComposite var1);
    }

    private class HeaderComposite
    extends Composite
    implements PaintListener,
    MouseListener {
        String title;
        Color topGradient;
        Color bottomGradient;
        GridCellManager cellManager;
        String groupName;
        boolean expanded;
        List listeners;

        public HeaderComposite(Composite parent, int style, String title) {
            super(parent, style);
            this.title = "";
            this.topGradient = null;
            this.bottomGradient = null;
            this.cellManager = null;
            this.groupName = "";
            this.expanded = true;
            this.listeners = new ArrayList();
            this.title = title;
            this.addPaintListener(this);
            this.addMouseListener(this);
        }

        public boolean isExpanded() {
            return this.expanded;
        }

        public void setExpanded(boolean expanded) {
            this.expanded = expanded;
            if (this.cellManager != null) {
                if (expanded) {
                    this.cellManager.showGroup(this.groupName);
                } else {
                    this.cellManager.hideGroup(this.groupName);
                }
            }
            this.fireExpansionChanged();
        }

        public void addExpansionListener(HeaderExpansionListener l) {
            this.listeners.remove(l);
            this.listeners.add(l);
        }

        public void removeExpansionListener(HeaderExpansionListener l) {
            this.listeners.remove(l);
        }

        public void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public void setCellManager(GridCellManager manager) {
            this.cellManager = manager;
        }

        public void setTopGradient(Color tg) {
            this.topGradient = tg;
        }

        public void setBottomGradient(Color bg) {
            this.bottomGradient = bg;
        }

        public void paintControl(PaintEvent e) {
            if (this.topGradient == null) {
                this.topGradient = e.gc.getBackground();
            }
            if (this.bottomGradient == null) {
                this.bottomGradient = e.gc.getBackground();
            }
            Color fg = e.gc.getForeground();
            Color bg = e.gc.getBackground();
            e.gc.setForeground(this.topGradient);
            e.gc.setBackground(this.bottomGradient);
            Point size = this.getSize();
            e.gc.fillGradientRectangle(0, 0, size.x, size.y, true);
            e.gc.setForeground(fg);
            e.gc.setBackground(bg);
            Point titleSize = e.gc.stringExtent(this.title);
            e.gc.drawString(this.title, 15, (size.y - titleSize.y) / 2, true);
        }

        void fireExpansionChanged() {
            int i = 0;
            while (i < this.listeners.size()) {
                ((HeaderExpansionListener)this.listeners.get(i)).headerExpansionChanged(this);
                ++i;
            }
        }

        public void mouseDoubleClick(MouseEvent e) {
            if (this.cellManager != null) {
                if (this.expanded) {
                    this.cellManager.hideGroup(this.groupName);
                } else {
                    this.cellManager.showGroup(this.groupName);
                }
                this.expanded = !this.expanded;
            }
            this.fireExpansionChanged();
        }

        public void mouseDown(MouseEvent e) {
        }

        public void mouseUp(MouseEvent e) {
        }
    }

    private class RowDivider
    extends Canvas
    implements PaintListener {
        public RowDivider(Composite parent, int style) {
            super(parent, style);
            this.addPaintListener(this);
        }

        public void paintControl(PaintEvent e) {
            Point size = this.getSize();
            e.gc.drawLine(30, 1, size.x - 30, 1);
        }
    }

    private abstract class DialogControlSet {
        MediaScriptObject mso = null;
        GridCellManager gridCellManager = null;
        boolean listenerUpdate = true;
        HeaderComposite titleHeader;
        Combo modeCombo = null;
        HeaderComposite mediaHeader;
        HeaderComposite settingsHeader;
        Combo bargeinCombo;

        public DialogControlSet(MediaScriptObject mso) {
            this.mso = mso;
            this.gridCellManager = new GridCellManager(DialogWidget.this.canvas);
            this.titleHeader = this.createTitleHeader();
            this.mediaHeader = this.createMediaHeader();
            this.createMediaSection();
            this.settingsHeader = this.createSettingsHeader();
            this.createSettingsSection();
        }

        public void update() {
            this.listenerUpdate = false;
            DialogAggregate da = (DialogAggregate)DialogWidget.this.dialogDataMap.get(this.mso.getName());
            if (da != null) {
                this.bargeinCombo.select(da.getBargeIn() != null && da.getBargeIn() != false ? 0 : 1);
            }
            this.listenerUpdate = true;
        }

        public HeaderComposite createTitleHeader() {
            HeaderComposite tHeader = new HeaderComposite(DialogWidget.this.canvas, 0, this.mso.getName());
            tHeader.setTopGradient(DialogWidget.this.lightBlue);
            tHeader.setBottomGradient(DialogWidget.this.darkBlue);
            tHeader.setCellManager(this.gridCellManager);
            tHeader.setGroupName(this.mso.getName());
            tHeader.addExpansionListener(DialogWidget.this.headerListener);
            tHeader.setFont(DialogWidget.this.boldFont);
            GridData gd = new GridData(768);
            gd.heightHint = 25;
            gd.horizontalSpan = 2;
            tHeader.setLayoutData(gd);
            return tHeader;
        }

        public HeaderComposite createMediaHeader() {
            HeaderComposite mHeader = new HeaderComposite(DialogWidget.this.canvas, 0, "Media Library");
            mHeader.setTopGradient(DialogWidget.this.lightOrange);
            mHeader.setBottomGradient(DialogWidget.this.darkOrange);
            mHeader.setCellManager(this.gridCellManager);
            mHeader.setGroupName("MEDIA");
            mHeader.addExpansionListener(DialogWidget.this.headerListener);
            mHeader.setFont(DialogWidget.this.boldFont);
            GridData gd = new GridData(768);
            gd.heightHint = 20;
            gd.horizontalSpan = 2;
            gd.horizontalIndent = 30;
            mHeader.setLayoutData(gd);
            this.gridCellManager.addCell((Control)mHeader, this.mso.getName());
            return mHeader;
        }

        public abstract void createMediaSection();

        public HeaderComposite createSettingsHeader() {
            HeaderComposite sHeader = new HeaderComposite(DialogWidget.this.canvas, 0, "Settings");
            sHeader.setTopGradient(DialogWidget.this.lightOrange);
            sHeader.setBottomGradient(DialogWidget.this.darkOrange);
            sHeader.setCellManager(this.gridCellManager);
            sHeader.setGroupName("SETTINGS");
            sHeader.addExpansionListener(DialogWidget.this.headerListener);
            sHeader.setFont(DialogWidget.this.boldFont);
            GridData gd = new GridData(768);
            gd.heightHint = 20;
            gd.horizontalSpan = 3;
            gd.horizontalIndent = 30;
            sHeader.setLayoutData(gd);
            this.gridCellManager.addCell((Control)sHeader, new String[]{this.mso.getName()});
            return sHeader;
        }

        public void createSettingsSection() {
            Label bargeinLabel = DialogWidget.this.createPropertyLabel(DialogWidget.this.canvas, "Is Barge-In Enabled");
            this.gridCellManager.addCell((Control)bargeinLabel, new String[]{this.mso.getName(), "SETTINGS"});
            this.bargeinCombo = new Combo(DialogWidget.this.canvas, 2060);
            this.bargeinCombo.add("true");
            this.bargeinCombo.add("false");
            this.bargeinCombo.select(0);
            this.bargeinCombo.addSelectionListener(new SelectionListener(this){
                final /* synthetic */ DialogControlSet this$1;
                {
                    this.this$1 = dialogControlSet;
                }

                public void widgetSelected(SelectionEvent e) {
                    DialogAggregate da = (DialogAggregate)DialogWidget.access$1(DialogControlSet.access$0(this.this$1)).get(this.this$1.mso.getName());
                    if (da != null) {
                        da.setBargeIn(new Boolean(this.this$1.bargeinCombo.getSelectionIndex() == 0));
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            GridData gd = new GridData();
            gd.verticalIndent = 2;
            gd.horizontalAlignment = 131072;
            this.bargeinCombo.setLayoutData((Object)gd);
            this.gridCellManager.addCell((Control)this.bargeinCombo, new String[]{this.mso.getName(), "SETTINGS"});
        }

        static /* synthetic */ DialogWidget access$0(DialogControlSet dialogControlSet) {
            return dialogControlSet.DialogWidget.this;
        }
    }

    private abstract class InputDialogControlSet
    extends DialogControlSet {
        Combo modeCombo;
        HeaderComposite confirmationHeader;
        Combo confirmationCombo;
        Spinner initialTimeoutSpinner;
        Label confirmationLeadInPromptText;
        Label acceptOptionPromptText;
        Label rejectOptionPromptText;

        public InputDialogControlSet(MediaScriptObject mso) {
            super(mso);
            this.gridCellManager.showGroup("DTMF");
            this.gridCellManager.hideGroup("VOICE");
        }

        public void update() {
            super.update();
            this.listenerUpdate = false;
            DialogAggregate da = (DialogAggregate)DialogWidget.this.dialogDataMap.get(this.mso.getName());
            if (da != null) {
                this.modeCombo.select(da.getInputMode());
                DialogWidget.this.canvas.setLayoutDeferred(true);
                if (this.modeCombo.getSelectionIndex() == 0) {
                    this.gridCellManager.hideGroup("VOICE");
                    this.gridCellManager.showGroup("DTMF");
                } else if (this.modeCombo.getSelectionIndex() == 2) {
                    this.gridCellManager.showGroup("DTMF");
                    this.gridCellManager.showGroup("VOICE");
                } else {
                    this.gridCellManager.hideGroup("DTMF");
                    this.gridCellManager.showGroup("VOICE");
                }
                DialogWidget.this.canvas.setLayoutDeferred(false);
                DialogWidget.this.canvas.layout(true, true);
                DialogWidget.this.setMinSize(300, ((DialogWidget)DialogWidget.this).canvas.computeSize((int)Math.max((int)300, (int)DialogWidget.this.getClientArea().width), (int)-1).y);
                this.initialTimeoutSpinner.setSelection((int)da.getInitialInputTimeout());
            }
            this.listenerUpdate = true;
        }

        public HeaderComposite createTitleHeader() {
            HeaderComposite tHeader = super.createTitleHeader();
            GridLayout gl = new GridLayout(1, false);
            gl.marginHeight = 0;
            tHeader.setLayout((Layout)gl);
            this.modeCombo = new Combo((Composite)tHeader, 12);
            this.modeCombo.add("DTMF Only");
            this.modeCombo.add("Voice");
            this.modeCombo.add("Hybrid");
            this.modeCombo.select(0);
            GridData gd = new GridData();
            gd.horizontalAlignment = 131072;
            gd.verticalAlignment = 0x1000000;
            gd.grabExcessHorizontalSpace = true;
            gd.grabExcessVerticalSpace = true;
            this.modeCombo.setLayoutData((Object)gd);
            this.modeCombo.addSelectionListener(new SelectionListener(this){
                final /* synthetic */ InputDialogControlSet this$1;
                {
                    this.this$1 = inputDialogControlSet;
                }

                public void widgetSelected(SelectionEvent e) {
                    if (this.this$1.modeCombo.getSelectionIndex() == 0) {
                        this.this$1.gridCellManager.hideGroup("VOICE");
                        this.this$1.gridCellManager.showGroup("DTMF");
                    } else if (this.this$1.modeCombo.getSelectionIndex() == 2) {
                        this.this$1.gridCellManager.showGroup("DTMF");
                        this.this$1.gridCellManager.showGroup("VOICE");
                    } else {
                        this.this$1.gridCellManager.hideGroup("DTMF");
                        this.this$1.gridCellManager.showGroup("VOICE");
                    }
                    DialogAggregate da = (DialogAggregate)DialogWidget.access$1(InputDialogControlSet.access$0(this.this$1)).get(this.this$1.mso.getName());
                    if (da != null) {
                        da.setInputMode(this.this$1.modeCombo.getSelectionIndex());
                    }
                    DialogWidget.access$0(InputDialogControlSet.access$0(this.this$1)).layout(true, true);
                    InputDialogControlSet.access$0(this.this$1).setMinSize(300, DialogWidget.access$0((DialogWidget)InputDialogControlSet.access$0((InputDialogControlSet)this.this$1)).computeSize((int)Math.max((int)300, (int)InputDialogControlSet.access$0((InputDialogControlSet)this.this$1).getClientArea().width), (int)-1).y);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            return tHeader;
        }

        public void createSettingsSection() {
            super.createSettingsSection();
            RowDivider rd5 = DialogWidget.this.createRowDivider(DialogWidget.this.canvas, DialogWidget.this.dividerColor);
            this.gridCellManager.addCell((Control)rd5, new String[]{this.mso.getName(), "SETTINGS"});
            Label initialTimeoutLabel = DialogWidget.this.createPropertyLabel(DialogWidget.this.canvas, "Initial Input Timeout");
            this.gridCellManager.addCell((Control)initialTimeoutLabel, new String[]{this.mso.getName(), "SETTINGS"});
            this.initialTimeoutSpinner = DialogWidget.this.createValueSpinner(DialogWidget.this.canvas, 0, 10, 0, 3);
            this.initialTimeoutSpinner.addModifyListener(new ModifyListener(this){
                final /* synthetic */ InputDialogControlSet this$1;
                {
                    this.this$1 = inputDialogControlSet;
                }

                public void modifyText(ModifyEvent e) {
                    DialogAggregate da;
                    if (this.this$1.listenerUpdate && (da = (DialogAggregate)DialogWidget.access$1(InputDialogControlSet.access$0(this.this$1)).get(this.this$1.mso.getName())) != null) {
                        da.setInitialInputTimeout((long)this.this$1.initialTimeoutSpinner.getSelection());
                    }
                }
            });
            this.gridCellManager.addCell((Control)this.initialTimeoutSpinner, new String[]{this.mso.getName(), "SETTINGS"});
        }

        public HeaderComposite createConfirmationHeader() {
            HeaderComposite cHeader = new HeaderComposite(DialogWidget.this.canvas, 0, "Confirmation");
            cHeader.setTopGradient(DialogWidget.this.lightOrange);
            cHeader.setBottomGradient(DialogWidget.this.darkOrange);
            cHeader.setCellManager(this.gridCellManager);
            cHeader.setGroupName("CONFIRM");
            cHeader.addExpansionListener(DialogWidget.this.headerListener);
            cHeader.setFont(DialogWidget.this.boldFont);
            GridData gd = new GridData(768);
            gd.heightHint = 22;
            gd.horizontalSpan = 3;
            gd.horizontalIndent = 30;
            cHeader.setLayoutData(gd);
            GridLayout gl = new GridLayout(1, false);
            gl.marginHeight = 0;
            cHeader.setLayout((Layout)gl);
            this.gridCellManager.addCell((Control)cHeader, new String[]{this.mso.getName()});
            this.confirmationCombo = new Combo((Composite)cHeader, 12);
            this.confirmationCombo.add("Disabled");
            this.confirmationCombo.add("Always");
            this.confirmationCombo.add("Conditional");
            this.confirmationCombo.select(0);
            gd = new GridData();
            gd.horizontalAlignment = 131072;
            gd.verticalAlignment = 0x1000000;
            gd.grabExcessHorizontalSpace = true;
            gd.grabExcessVerticalSpace = true;
            this.confirmationCombo.setLayoutData((Object)gd);
            this.gridCellManager.addCell((Control)this.confirmationCombo, new String[]{this.mso.getName()});
            return cHeader;
        }

        public void createConfirmationSection() {
            Label confirmationLeadInPromptLabel = DialogWidget.this.createPropertyLabel(DialogWidget.this.canvas, "Confirmation Lead In Prompt");
            this.gridCellManager.addCell((Control)confirmationLeadInPromptLabel, new String[]{this.mso.getName(), "CONFIRM"});
            this.confirmationLeadInPromptText = new Label(DialogWidget.this.canvas, 64);
            this.confirmationLeadInPromptText.setText("");
            this.confirmationLeadInPromptText.setBackground(DialogWidget.this.canvas.getBackground());
            GridData gd = new GridData(768);
            gd.horizontalAlignment = 131072;
            this.confirmationLeadInPromptText.setLayoutData((Object)gd);
            this.confirmationLeadInPromptText.addMouseListener(new MouseListener(this){
                final /* synthetic */ InputDialogControlSet this$1;
                {
                    this.this$1 = inputDialogControlSet;
                }

                public void mouseDoubleClick(MouseEvent e) {
                    DialogAggregate da = (DialogAggregate)DialogWidget.access$1(InputDialogControlSet.access$0(this.this$1)).get(this.this$1.mso.getName());
                    if (da != null) {
                        Rectangle r = InputDialogControlSet.access$0(this.this$1).getClientArea();
                        da.setConfirmPrompt(InputDialogControlSet.access$0(this.this$1).editPrompt("Accept Option Prompt", da.getConfirmPrompt()));
                        this.this$1.confirmationLeadInPromptText.setText(DialogWidget.access$12(InputDialogControlSet.access$0(this.this$1), this.this$1.mso, da.getConfirmPrompt()));
                        DialogWidget.access$0(InputDialogControlSet.access$0(this.this$1)).layout(true, true);
                        InputDialogControlSet.access$0(this.this$1).setMinSize(300, DialogWidget.access$0((DialogWidget)InputDialogControlSet.access$0((InputDialogControlSet)this.this$1)).computeSize((int)Math.max((int)300, (int)r.width), (int)-1).y);
                    }
                }

                public void mouseDown(MouseEvent e) {
                    DialogWidget.access$0(InputDialogControlSet.access$0(this.this$1)).forceFocus();
                }

                public void mouseUp(MouseEvent e) {
                }
            });
            this.gridCellManager.addCell((Control)this.confirmationLeadInPromptText, new String[]{this.mso.getName(), "CONFIRM"});
            RowDivider rd12 = DialogWidget.this.createRowDivider(DialogWidget.this.canvas, DialogWidget.this.dividerColor);
            this.gridCellManager.addCell((Control)rd12, new String[]{this.mso.getName(), "CONFIRM"});
            Label acceptOptionPromptLabel = DialogWidget.this.createPropertyLabel(DialogWidget.this.canvas, "Accept Option Prompt");
            this.gridCellManager.addCell((Control)acceptOptionPromptLabel, new String[]{this.mso.getName(), "CONFIRM"});
            this.acceptOptionPromptText = new Label(DialogWidget.this.canvas, 64);
            this.acceptOptionPromptText.setText("");
            this.acceptOptionPromptText.setBackground(DialogWidget.this.canvas.getBackground());
            gd = new GridData(768);
            gd.horizontalAlignment = 131072;
            this.acceptOptionPromptText.setLayoutData((Object)gd);
            this.acceptOptionPromptText.addMouseListener(new MouseListener(this){
                final /* synthetic */ InputDialogControlSet this$1;
                {
                    this.this$1 = inputDialogControlSet;
                }

                public void mouseDoubleClick(MouseEvent e) {
                    DialogAggregate da = (DialogAggregate)DialogWidget.access$1(InputDialogControlSet.access$0(this.this$1)).get(this.this$1.mso.getName());
                    if (da != null) {
                        this.this$1.acceptOptionPromptText.setText(DialogWidget.access$12(InputDialogControlSet.access$0(this.this$1), this.this$1.mso, null));
                        DialogWidget.access$0(InputDialogControlSet.access$0(this.this$1)).layout(true, true);
                        InputDialogControlSet.access$0(this.this$1).setMinSize(300, DialogWidget.access$0((DialogWidget)InputDialogControlSet.access$0((InputDialogControlSet)this.this$1)).computeSize((int)Math.max((int)300, (int)InputDialogControlSet.access$0((InputDialogControlSet)this.this$1).getClientArea().width), (int)-1).y);
                    }
                }

                public void mouseDown(MouseEvent e) {
                    DialogWidget.access$0(InputDialogControlSet.access$0(this.this$1)).forceFocus();
                }

                public void mouseUp(MouseEvent e) {
                }
            });
            this.gridCellManager.addCell((Control)this.acceptOptionPromptText, new String[]{this.mso.getName(), "CONFIRM"});
            RowDivider rd13 = DialogWidget.this.createRowDivider(DialogWidget.this.canvas, DialogWidget.this.dividerColor);
            this.gridCellManager.addCell((Control)rd13, new String[]{this.mso.getName(), "CONFIRM"});
            Label rejectOptionPromptLabel = DialogWidget.this.createPropertyLabel(DialogWidget.this.canvas, "Reject Option Prompt");
            this.gridCellManager.addCell((Control)rejectOptionPromptLabel, new String[]{this.mso.getName(), "CONFIRM"});
            this.rejectOptionPromptText = new Label(DialogWidget.this.canvas, 64);
            this.rejectOptionPromptText.setText("");
            this.rejectOptionPromptText.setBackground(DialogWidget.this.canvas.getBackground());
            gd = new GridData(768);
            gd.horizontalAlignment = 131072;
            this.rejectOptionPromptText.setLayoutData((Object)gd);
            this.rejectOptionPromptText.addMouseListener(new MouseListener(this){
                final /* synthetic */ InputDialogControlSet this$1;
                {
                    this.this$1 = inputDialogControlSet;
                }

                public void mouseDoubleClick(MouseEvent e) {
                    DialogAggregate da = (DialogAggregate)DialogWidget.access$1(InputDialogControlSet.access$0(this.this$1)).get(this.this$1.mso.getName());
                    if (da != null) {
                        this.this$1.rejectOptionPromptText.setText(DialogWidget.access$12(InputDialogControlSet.access$0(this.this$1), this.this$1.mso, null));
                        DialogWidget.access$0(InputDialogControlSet.access$0(this.this$1)).layout(true, true);
                        InputDialogControlSet.access$0(this.this$1).setMinSize(300, DialogWidget.access$0((DialogWidget)InputDialogControlSet.access$0((InputDialogControlSet)this.this$1)).computeSize((int)Math.max((int)300, (int)InputDialogControlSet.access$0((InputDialogControlSet)this.this$1).getClientArea().width), (int)-1).y);
                    }
                }

                public void mouseDown(MouseEvent e) {
                    DialogWidget.access$0(InputDialogControlSet.access$0(this.this$1)).forceFocus();
                }

                public void mouseUp(MouseEvent e) {
                }
            });
            this.gridCellManager.addCell((Control)this.rejectOptionPromptText, new String[]{this.mso.getName(), "CONFIRM"});
        }

        static /* synthetic */ DialogWidget access$0(InputDialogControlSet inputDialogControlSet) {
            return inputDialogControlSet.DialogWidget.this;
        }
    }

    private class FieldDialogControlSet
    extends InputDialogControlSet {
        Label fieldPromptText;
        Label fieldGrammarText;
        Label noInputText;
        Label noMatchText;
        Spinner interdigitTimeoutSpinner;
        Spinner terminationTimeoutSpinner;
        Combo terminationCharacterCombo;
        Spinner completeTimeoutSpinner;
        Spinner incompleteTimeoutSpinner;
        Spinner confidenceSpinner;
        Spinner maxSpeechSpinner;
        Spinner maxNBestSpinner;
        Spinner sensitivitySpinner;
        Spinner speedVsAccuracySpinner;

        public FieldDialogControlSet(MediaScriptObject msfo) {
            super(msfo);
        }

        public void update() {
            super.update();
            this.listenerUpdate = false;
            DialogAggregate da = (DialogAggregate)DialogWidget.this.dialogDataMap.get(this.mso.getName());
            if (da != null) {
                this.interdigitTimeoutSpinner.setSelection((int)da.getInterDigitTimeout());
                this.terminationTimeoutSpinner.setSelection((int)da.getTerminationTimeout());
                char c = da.getTerminationCharacter();
                int sel = 0;
                switch (c) {
                    case '0': {
                        sel = 1;
                        break;
                    }
                    case '1': {
                        sel = 2;
                        break;
                    }
                    case '2': {
                        sel = 3;
                        break;
                    }
                    case '3': {
                        sel = 4;
                        break;
                    }
                    case '4': {
                        sel = 5;
                        break;
                    }
                    case '5': {
                        sel = 6;
                        break;
                    }
                    case '6': {
                        sel = 7;
                        break;
                    }
                    case '7': {
                        sel = 8;
                        break;
                    }
                    case '8': {
                        sel = 9;
                        break;
                    }
                    case '9': {
                        sel = 10;
                        break;
                    }
                    case '*': {
                        sel = 11;
                        break;
                    }
                    case '#': {
                        sel = 12;
                    }
                }
                this.terminationCharacterCombo.select(sel);
                this.completeTimeoutSpinner.setSelection((int)da.getSpeechCompletionTimeout());
                this.incompleteTimeoutSpinner.setSelection((int)da.getIncompleteSpeechTimeout());
                this.confidenceSpinner.setSelection(da.getConfidenceLevel() == null ? 50 : da.getConfidenceLevel().movePointRight(2).intValue());
                this.maxSpeechSpinner.setSelection(da.getMaximumSpeechLength());
                this.maxNBestSpinner.setSelection(da.getMaximumNBestResults());
                this.sensitivitySpinner.setSelection(da.getSensitivity() == null ? 50 : da.getSensitivity().movePointRight(2).intValue());
                this.speedVsAccuracySpinner.setSelection(da.getSpeedVsAccuracy() == null ? 50 : da.getSpeedVsAccuracy().movePointRight(2).intValue());
                this.updateMediaSection(da);
            }
            this.listenerUpdate = true;
            DialogWidget.this.canvas.layout(true, true);
            DialogWidget.this.setMinSize(300, ((DialogWidget)DialogWidget.this).canvas.computeSize((int)Math.max((int)300, (int)DialogWidget.this.getClientArea().width), (int)-1).y);
        }

        public void updateMediaSection(DialogAggregate da) {
            this.fieldPromptText.setText(DialogWidget.this.getPromptText(this.mso, da.getFieldPrompt()));
            this.fieldGrammarText.setText(DialogWidget.this.getGrammarText(this.mso, da.getFieldGrammar()));
            this.noInputText.setText(DialogWidget.this.getPromptText(this.mso, da.getNoInputPrompt()));
            this.noMatchText.setText(DialogWidget.this.getPromptText(this.mso, da.getNoMatchPrompt()));
        }

        public void createMediaSection() {
            Label fieldPromptLabel = DialogWidget.this.createPropertyLabel(DialogWidget.this.canvas, "Field Prompt");
            this.gridCellManager.addCell((Control)fieldPromptLabel, new String[]{this.mso.getName(), "MEDIA"});
            this.fieldPromptText = new Label(DialogWidget.this.canvas, 64);
            this.fieldPromptText.setText("This is a cell with a lot of text that wraps within its borders.  Does it look good?  Does it make sense to do the row breaks like this?");
            this.fieldPromptText.setBackground(DialogWidget.this.canvas.getBackground());
            GridData gd = new GridData(768);
            gd.horizontalAlignment = 131072;
            this.fieldPromptText.setLayoutData((Object)gd);
            this.fieldPromptText.addMouseListener(new MouseListener(this){
                final /* synthetic */ FieldDialogControlSet this$1;
                {
                    this.this$1 = fieldDialogControlSet;
                }

                public void mouseDoubleClick(MouseEvent e) {
                    DialogAggregate da = (DialogAggregate)DialogWidget.access$1(FieldDialogControlSet.access$0(this.this$1)).get(this.this$1.mso.getName());
                    if (da != null) {
                        da.setFieldPrompt(FieldDialogControlSet.access$0(this.this$1).editPrompt("Field Prompt", da.getFieldPrompt()));
                        this.this$1.fieldPromptText.setText(DialogWidget.access$12(FieldDialogControlSet.access$0(this.this$1), this.this$1.mso, da.getFieldPrompt()));
                        DialogWidget.access$0(FieldDialogControlSet.access$0(this.this$1)).layout(true, true);
                        FieldDialogControlSet.access$0(this.this$1).setMinSize(300, DialogWidget.access$0((DialogWidget)FieldDialogControlSet.access$0((FieldDialogControlSet)this.this$1)).computeSize((int)Math.max((int)300, (int)FieldDialogControlSet.access$0((FieldDialogControlSet)this.this$1).getClientArea().width), (int)-1).y);
                    }
                }

                public void mouseDown(MouseEvent e) {
                    DialogWidget.access$0(FieldDialogControlSet.access$0(this.this$1)).forceFocus();
                }

                public void mouseUp(MouseEvent e) {
                }
            });
            this.gridCellManager.addCell((Control)this.fieldPromptText, new String[]{this.mso.getName(), "MEDIA"});
            RowDivider rd1 = DialogWidget.this.createRowDivider(DialogWidget.this.canvas, DialogWidget.this.dividerColor);
            this.gridCellManager.addCell((Control)rd1, new String[]{this.mso.getName(), "MEDIA"});
            Label fieldGrammarLabel = DialogWidget.this.createPropertyLabel(DialogWidget.this.canvas, "Input Grammar");
            this.gridCellManager.addCell((Control)fieldGrammarLabel, new String[]{this.mso.getName(), "MEDIA"});
            this.fieldGrammarText = new Label(DialogWidget.this.canvas, 64);
            this.fieldGrammarText.setText("");
            this.fieldGrammarText.setBackground(DialogWidget.this.canvas.getBackground());
            gd = new GridData(768);
            gd.horizontalAlignment = 131072;
            this.fieldGrammarText.setLayoutData((Object)gd);
            this.fieldGrammarText.addMouseListener(new MouseListener(this){
                final /* synthetic */ FieldDialogControlSet this$1;
                {
                    this.this$1 = fieldDialogControlSet;
                }

                public void mouseDoubleClick(MouseEvent e) {
                    DialogAggregate da = (DialogAggregate)DialogWidget.access$1(FieldDialogControlSet.access$0(this.this$1)).get(this.this$1.mso.getName());
                    if (da != null) {
                        da.setFieldGrammar(FieldDialogControlSet.access$0(this.this$1).editGrammar("Input Grammar", da.getFieldGrammar()));
                        this.this$1.fieldGrammarText.setText(DialogWidget.access$13(FieldDialogControlSet.access$0(this.this$1), this.this$1.mso, da.getFieldGrammar()));
                        DialogWidget.access$0(FieldDialogControlSet.access$0(this.this$1)).layout(true, true);
                        FieldDialogControlSet.access$0(this.this$1).setMinSize(300, DialogWidget.access$0((DialogWidget)FieldDialogControlSet.access$0((FieldDialogControlSet)this.this$1)).computeSize((int)Math.max((int)300, (int)FieldDialogControlSet.access$0((FieldDialogControlSet)this.this$1).getClientArea().width), (int)-1).y);
                    }
                }

                public void mouseDown(MouseEvent e) {
                    DialogWidget.access$0(FieldDialogControlSet.access$0(this.this$1)).forceFocus();
                }

                public void mouseUp(MouseEvent e) {
                }
            });
            this.gridCellManager.addCell((Control)this.fieldGrammarText, new String[]{this.mso.getName(), "MEDIA"});
            RowDivider rd2 = DialogWidget.this.createRowDivider(DialogWidget.this.canvas, DialogWidget.this.dividerColor);
            this.gridCellManager.addCell((Control)rd2, new String[]{this.mso.getName(), "MEDIA"});
            Label noInputLabel = DialogWidget.this.createPropertyLabel(DialogWidget.this.canvas, "No Input Prompt");
            this.gridCellManager.addCell((Control)noInputLabel, new String[]{this.mso.getName(), "MEDIA"});
            this.noInputText = new Label(DialogWidget.this.canvas, 64);
            this.noInputText.setText("");
            this.noInputText.setBackground(DialogWidget.this.canvas.getBackground());
            gd = new GridData(768);
            gd.horizontalAlignment = 131072;
            this.noInputText.setLayoutData((Object)gd);
            this.noInputText.addMouseListener(new MouseListener(this){
                final /* synthetic */ FieldDialogControlSet this$1;
                {
                    this.this$1 = fieldDialogControlSet;
                }

                public void mouseDoubleClick(MouseEvent e) {
                    DialogAggregate da = (DialogAggregate)DialogWidget.access$1(FieldDialogControlSet.access$0(this.this$1)).get(this.this$1.mso.getName());
                    if (da != null) {
                        da.setNoInputPrompt(FieldDialogControlSet.access$0(this.this$1).editPrompt("No Input Prompt", da.getNoInputPrompt()));
                        this.this$1.noInputText.setText(DialogWidget.access$12(FieldDialogControlSet.access$0(this.this$1), this.this$1.mso, da.getNoInputPrompt()));
                        DialogWidget.access$0(FieldDialogControlSet.access$0(this.this$1)).layout(true, true);
                        FieldDialogControlSet.access$0(this.this$1).setMinSize(300, DialogWidget.access$0((DialogWidget)FieldDialogControlSet.access$0((FieldDialogControlSet)this.this$1)).computeSize((int)Math.max((int)300, (int)FieldDialogControlSet.access$0((FieldDialogControlSet)this.this$1).getClientArea().width), (int)-1).y);
                    }
                }

                public void mouseDown(MouseEvent e) {
                    DialogWidget.access$0(FieldDialogControlSet.access$0(this.this$1)).forceFocus();
                }

                public void mouseUp(MouseEvent e) {
                }
            });
            this.gridCellManager.addCell((Control)this.noInputText, new String[]{this.mso.getName(), "MEDIA"});
            RowDivider rd3 = DialogWidget.this.createRowDivider(DialogWidget.this.canvas, DialogWidget.this.dividerColor);
            this.gridCellManager.addCell((Control)rd3, new String[]{this.mso.getName(), "MEDIA"});
            Label noMatchLabel = DialogWidget.this.createPropertyLabel(DialogWidget.this.canvas, "No Match Prompt");
            this.gridCellManager.addCell((Control)noMatchLabel, new String[]{this.mso.getName(), "MEDIA"});
            this.noMatchText = new Label(DialogWidget.this.canvas, 64);
            this.noMatchText.setText("");
            this.noMatchText.setBackground(DialogWidget.this.canvas.getBackground());
            gd = new GridData(768);
            gd.horizontalAlignment = 131072;
            this.noMatchText.setLayoutData((Object)gd);
            this.noMatchText.addMouseListener(new MouseListener(this){
                final /* synthetic */ FieldDialogControlSet this$1;
                {
                    this.this$1 = fieldDialogControlSet;
                }

                public void mouseDoubleClick(MouseEvent e) {
                    DialogAggregate da = (DialogAggregate)DialogWidget.access$1(FieldDialogControlSet.access$0(this.this$1)).get(this.this$1.mso.getName());
                    if (da != null) {
                        da.setNoMatchPrompt(FieldDialogControlSet.access$0(this.this$1).editPrompt("No Match Prompt", da.getNoMatchPrompt()));
                        this.this$1.noMatchText.setText(DialogWidget.access$12(FieldDialogControlSet.access$0(this.this$1), this.this$1.mso, da.getNoMatchPrompt()));
                        DialogWidget.access$0(FieldDialogControlSet.access$0(this.this$1)).layout(true, true);
                        FieldDialogControlSet.access$0(this.this$1).setMinSize(300, DialogWidget.access$0((DialogWidget)FieldDialogControlSet.access$0((FieldDialogControlSet)this.this$1)).computeSize((int)Math.max((int)300, (int)FieldDialogControlSet.access$0((FieldDialogControlSet)this.this$1).getClientArea().width), (int)-1).y);
                    }
                }

                public void mouseDown(MouseEvent e) {
                    DialogWidget.access$0(FieldDialogControlSet.access$0(this.this$1)).forceFocus();
                }

                public void mouseUp(MouseEvent e) {
                }
            });
            this.gridCellManager.addCell((Control)this.noMatchText, new String[]{this.mso.getName(), "MEDIA"});
        }

        public void createSettingsSection() {
            super.createSettingsSection();
            RowDivider rd2 = DialogWidget.this.createRowDivider(DialogWidget.this.canvas, DialogWidget.this.dividerColor);
            this.gridCellManager.addCell((Control)rd2, new String[]{this.mso.getName(), "SETTINGS", "DTMF"});
            Label interdigitTimeoutLabel = DialogWidget.this.createPropertyLabel(DialogWidget.this.canvas, "Inter-digit Timeout");
            this.gridCellManager.addCell((Control)interdigitTimeoutLabel, new String[]{this.mso.getName(), "SETTINGS", "DTMF"});
            this.interdigitTimeoutSpinner = DialogWidget.this.createValueSpinner(DialogWidget.this.canvas, 0, 10, 0, 3);
            this.interdigitTimeoutSpinner.addModifyListener(new ModifyListener(this){
                final /* synthetic */ FieldDialogControlSet this$1;
                {
                    this.this$1 = fieldDialogControlSet;
                }

                public void modifyText(ModifyEvent e) {
                    DialogAggregate da;
                    if (this.this$1.listenerUpdate && (da = (DialogAggregate)DialogWidget.access$1(FieldDialogControlSet.access$0(this.this$1)).get(this.this$1.mso.getName())) != null) {
                        da.setInterDigitTimeout((long)this.this$1.interdigitTimeoutSpinner.getSelection());
                    }
                }
            });
            this.gridCellManager.addCell((Control)this.interdigitTimeoutSpinner, new String[]{this.mso.getName(), "SETTINGS", "DTMF"});
            RowDivider rd3 = DialogWidget.this.createRowDivider(DialogWidget.this.canvas, DialogWidget.this.dividerColor);
            this.gridCellManager.addCell((Control)rd3, new String[]{this.mso.getName(), "SETTINGS", "DTMF"});
            Label terminationTimeoutLabel = DialogWidget.this.createPropertyLabel(DialogWidget.this.canvas, "Termination Timeout");
            this.gridCellManager.addCell((Control)terminationTimeoutLabel, new String[]{this.mso.getName(), "SETTINGS", "DTMF"});
            this.terminationTimeoutSpinner = DialogWidget.this.createValueSpinner(DialogWidget.this.canvas, 0, 10, 0, 3);
            this.terminationTimeoutSpinner.addModifyListener(new ModifyListener(this){
                final /* synthetic */ FieldDialogControlSet this$1;
                {
                    this.this$1 = fieldDialogControlSet;
                }

                public void modifyText(ModifyEvent e) {
                    DialogAggregate da;
                    if (this.this$1.listenerUpdate && (da = (DialogAggregate)DialogWidget.access$1(FieldDialogControlSet.access$0(this.this$1)).get(this.this$1.mso.getName())) != null) {
                        da.setTerminationTimeout((long)this.this$1.terminationTimeoutSpinner.getSelection());
                    }
                }
            });
            this.gridCellManager.addCell((Control)this.terminationTimeoutSpinner, new String[]{this.mso.getName(), "SETTINGS", "DTMF"});
            RowDivider rd4 = DialogWidget.this.createRowDivider(DialogWidget.this.canvas, DialogWidget.this.dividerColor);
            this.gridCellManager.addCell((Control)rd4, new String[]{this.mso.getName(), "SETTINGS", "DTMF"});
            Label terminationCharacterLabel = DialogWidget.this.createPropertyLabel(DialogWidget.this.canvas, "Termination Character");
            this.gridCellManager.addCell((Control)terminationCharacterLabel, new String[]{this.mso.getName(), "SETTINGS", "DTMF"});
            this.terminationCharacterCombo = new Combo(DialogWidget.this.canvas, 2060);
            this.terminationCharacterCombo.add("None");
            this.terminationCharacterCombo.add("0");
            this.terminationCharacterCombo.add("1");
            this.terminationCharacterCombo.add("2");
            this.terminationCharacterCombo.add("3");
            this.terminationCharacterCombo.add("4");
            this.terminationCharacterCombo.add("5");
            this.terminationCharacterCombo.add("6");
            this.terminationCharacterCombo.add("7");
            this.terminationCharacterCombo.add("8");
            this.terminationCharacterCombo.add("9");
            this.terminationCharacterCombo.add("*");
            this.terminationCharacterCombo.add("#");
            this.terminationCharacterCombo.select(12);
            this.terminationCharacterCombo.addSelectionListener(new SelectionListener(this){
                final /* synthetic */ FieldDialogControlSet this$1;
                {
                    this.this$1 = fieldDialogControlSet;
                }

                public void widgetSelected(SelectionEvent e) {
                    char[] cs = new char[]{'q', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '*', '#'};
                    DialogAggregate da = (DialogAggregate)DialogWidget.access$1(FieldDialogControlSet.access$0(this.this$1)).get(this.this$1.mso.getName());
                    if (da != null) {
                        da.setTerminationCharacter(cs[this.this$1.terminationCharacterCombo.getSelectionIndex()]);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            GridData gd = new GridData();
            gd.verticalIndent = 2;
            gd.horizontalAlignment = 131072;
            this.terminationCharacterCombo.setLayoutData((Object)gd);
            this.gridCellManager.addCell((Control)this.terminationCharacterCombo, new String[]{this.mso.getName(), "SETTINGS", "DTMF"});
            RowDivider rd5 = DialogWidget.this.createRowDivider(DialogWidget.this.canvas, DialogWidget.this.dividerColor);
            this.gridCellManager.addCell((Control)rd5, new String[]{this.mso.getName(), "SETTINGS", "VOICE"});
            Label completeTimeoutLabel = DialogWidget.this.createPropertyLabel(DialogWidget.this.canvas, "Speech Completion Timeout");
            this.gridCellManager.addCell((Control)completeTimeoutLabel, new String[]{this.mso.getName(), "SETTINGS", "VOICE"});
            this.completeTimeoutSpinner = DialogWidget.this.createValueSpinner(DialogWidget.this.canvas, 0, 10, 0, 3);
            this.completeTimeoutSpinner.addModifyListener(new ModifyListener(this){
                final /* synthetic */ FieldDialogControlSet this$1;
                {
                    this.this$1 = fieldDialogControlSet;
                }

                public void modifyText(ModifyEvent e) {
                    DialogAggregate da;
                    if (this.this$1.listenerUpdate && (da = (DialogAggregate)DialogWidget.access$1(FieldDialogControlSet.access$0(this.this$1)).get(this.this$1.mso.getName())) != null) {
                        da.setSpeechCompletionTimeout((long)this.this$1.completeTimeoutSpinner.getSelection());
                    }
                }
            });
            this.gridCellManager.addCell((Control)this.completeTimeoutSpinner, new String[]{this.mso.getName(), "SETTINGS", "VOICE"});
            RowDivider rd6 = DialogWidget.this.createRowDivider(DialogWidget.this.canvas, DialogWidget.this.dividerColor);
            this.gridCellManager.addCell((Control)rd6, new String[]{this.mso.getName(), "SETTINGS", "VOICE"});
            Label incompleteTimeoutLabel = DialogWidget.this.createPropertyLabel(DialogWidget.this.canvas, "Incomplete Speech Timeout");
            this.gridCellManager.addCell((Control)incompleteTimeoutLabel, new String[]{this.mso.getName(), "SETTINGS", "VOICE"});
            this.incompleteTimeoutSpinner = DialogWidget.this.createValueSpinner(DialogWidget.this.canvas, 0, 10, 0, 3);
            this.incompleteTimeoutSpinner.addModifyListener(new ModifyListener(this){
                final /* synthetic */ FieldDialogControlSet this$1;
                {
                    this.this$1 = fieldDialogControlSet;
                }

                public void modifyText(ModifyEvent e) {
                    DialogAggregate da;
                    if (this.this$1.listenerUpdate && (da = (DialogAggregate)DialogWidget.access$1(FieldDialogControlSet.access$0(this.this$1)).get(this.this$1.mso.getName())) != null) {
                        da.setIncompleteSpeechTimeout((long)this.this$1.incompleteTimeoutSpinner.getSelection());
                    }
                }
            });
            this.gridCellManager.addCell((Control)this.incompleteTimeoutSpinner, new String[]{this.mso.getName(), "SETTINGS", "VOICE"});
            RowDivider rd7 = DialogWidget.this.createRowDivider(DialogWidget.this.canvas, DialogWidget.this.dividerColor);
            this.gridCellManager.addCell((Control)rd7, new String[]{this.mso.getName(), "SETTINGS", "VOICE"});
            Label confidenceLevelLabel = DialogWidget.this.createPropertyLabel(DialogWidget.this.canvas, "Confidence Level");
            this.gridCellManager.addCell((Control)confidenceLevelLabel, new String[]{this.mso.getName(), "SETTINGS", "VOICE"});
            this.confidenceSpinner = DialogWidget.this.createValueSpinner(DialogWidget.this.canvas, 0, 100, 2, 50);
            this.confidenceSpinner.addModifyListener(new ModifyListener(this){
                final /* synthetic */ FieldDialogControlSet this$1;
                {
                    this.this$1 = fieldDialogControlSet;
                }

                public void modifyText(ModifyEvent e) {
                    if (this.this$1.listenerUpdate) {
                        BigDecimal bd = new BigDecimal((double)this.this$1.confidenceSpinner.getSelection()).movePointLeft(2);
                        DialogAggregate da = (DialogAggregate)DialogWidget.access$1(FieldDialogControlSet.access$0(this.this$1)).get(this.this$1.mso.getName());
                        if (da != null) {
                            da.setConfidenceLevel(bd);
                        }
                    }
                }
            });
            this.gridCellManager.addCell((Control)this.confidenceSpinner, new String[]{this.mso.getName(), "SETTINGS", "VOICE"});
            RowDivider rd8 = DialogWidget.this.createRowDivider(DialogWidget.this.canvas, DialogWidget.this.dividerColor);
            this.gridCellManager.addCell((Control)rd8, new String[]{this.mso.getName(), "SETTINGS", "VOICE"});
            Label maxSpeechTimeoutLabel = DialogWidget.this.createPropertyLabel(DialogWidget.this.canvas, "Maximum Speech Length");
            this.gridCellManager.addCell((Control)maxSpeechTimeoutLabel, new String[]{this.mso.getName(), "SETTINGS", "VOICE"});
            this.maxSpeechSpinner = DialogWidget.this.createValueSpinner(DialogWidget.this.canvas, 5, 30, 0, 10);
            this.maxSpeechSpinner.addModifyListener(new ModifyListener(this){
                final /* synthetic */ FieldDialogControlSet this$1;
                {
                    this.this$1 = fieldDialogControlSet;
                }

                public void modifyText(ModifyEvent e) {
                    DialogAggregate da;
                    if (this.this$1.listenerUpdate && (da = (DialogAggregate)DialogWidget.access$1(FieldDialogControlSet.access$0(this.this$1)).get(this.this$1.mso.getName())) != null) {
                        da.setMaximumSpeechLength(this.this$1.maxSpeechSpinner.getSelection());
                    }
                }
            });
            this.gridCellManager.addCell((Control)this.maxSpeechSpinner, new String[]{this.mso.getName(), "SETTINGS", "VOICE"});
            RowDivider rd9 = DialogWidget.this.createRowDivider(DialogWidget.this.canvas, DialogWidget.this.dividerColor);
            this.gridCellManager.addCell((Control)rd9, new String[]{this.mso.getName(), "SETTINGS", "VOICE"});
            Label maxNBestLabel = DialogWidget.this.createPropertyLabel(DialogWidget.this.canvas, "Maximum N-Best Results");
            this.gridCellManager.addCell((Control)maxNBestLabel, new String[]{this.mso.getName(), "SETTINGS", "VOICE"});
            this.maxNBestSpinner = DialogWidget.this.createValueSpinner(DialogWidget.this.canvas, 1, 10, 0, 1);
            this.maxNBestSpinner.addModifyListener(new ModifyListener(this){
                final /* synthetic */ FieldDialogControlSet this$1;
                {
                    this.this$1 = fieldDialogControlSet;
                }

                public void modifyText(ModifyEvent e) {
                    DialogAggregate da;
                    if (this.this$1.listenerUpdate && (da = (DialogAggregate)DialogWidget.access$1(FieldDialogControlSet.access$0(this.this$1)).get(this.this$1.mso.getName())) != null) {
                        da.setMaximumNBestResults(this.this$1.maxNBestSpinner.getSelection());
                    }
                }
            });
            this.gridCellManager.addCell((Control)this.maxNBestSpinner, new String[]{this.mso.getName(), "SETTINGS", "VOICE"});
            RowDivider rd10 = DialogWidget.this.createRowDivider(DialogWidget.this.canvas, DialogWidget.this.dividerColor);
            this.gridCellManager.addCell((Control)rd10, new String[]{this.mso.getName(), "SETTINGS", "VOICE"});
            Label sensitivityLabel = DialogWidget.this.createPropertyLabel(DialogWidget.this.canvas, "Sensitivity");
            this.gridCellManager.addCell((Control)sensitivityLabel, new String[]{this.mso.getName(), "SETTINGS", "VOICE"});
            this.sensitivitySpinner = DialogWidget.this.createValueSpinner(DialogWidget.this.canvas, 0, 100, 2, 50);
            this.sensitivitySpinner.addModifyListener(new ModifyListener(this){
                final /* synthetic */ FieldDialogControlSet this$1;
                {
                    this.this$1 = fieldDialogControlSet;
                }

                public void modifyText(ModifyEvent e) {
                    if (this.this$1.listenerUpdate) {
                        BigDecimal bd = new BigDecimal((double)this.this$1.sensitivitySpinner.getSelection()).movePointLeft(2);
                        DialogAggregate da = (DialogAggregate)DialogWidget.access$1(FieldDialogControlSet.access$0(this.this$1)).get(this.this$1.mso.getName());
                        if (da != null) {
                            da.setSensitivity(bd);
                        }
                    }
                }
            });
            this.gridCellManager.addCell((Control)this.sensitivitySpinner, new String[]{this.mso.getName(), "SETTINGS", "VOICE"});
            RowDivider rd11 = DialogWidget.this.createRowDivider(DialogWidget.this.canvas, DialogWidget.this.dividerColor);
            this.gridCellManager.addCell((Control)rd11, new String[]{this.mso.getName(), "SETTINGS", "VOICE"});
            Label speedVsAccuracyLabel = DialogWidget.this.createPropertyLabel(DialogWidget.this.canvas, "Speed Vs. Accuracy");
            this.gridCellManager.addCell((Control)speedVsAccuracyLabel, new String[]{this.mso.getName(), "SETTINGS", "VOICE"});
            this.speedVsAccuracySpinner = DialogWidget.this.createValueSpinner(DialogWidget.this.canvas, 0, 100, 2, 50);
            this.speedVsAccuracySpinner.addModifyListener(new ModifyListener(this){
                final /* synthetic */ FieldDialogControlSet this$1;
                {
                    this.this$1 = fieldDialogControlSet;
                }

                public void modifyText(ModifyEvent e) {
                    if (this.this$1.listenerUpdate) {
                        BigDecimal bd = new BigDecimal((double)this.this$1.speedVsAccuracySpinner.getSelection()).movePointLeft(2);
                        DialogAggregate da = (DialogAggregate)DialogWidget.access$1(FieldDialogControlSet.access$0(this.this$1)).get(this.this$1.mso.getName());
                        if (da != null) {
                            da.setSpeedVsAccuracy(bd);
                        }
                    }
                }
            });
            this.gridCellManager.addCell((Control)this.speedVsAccuracySpinner, new String[]{this.mso.getName(), "SETTINGS", "VOICE"});
        }

        static /* synthetic */ DialogWidget access$0(FieldDialogControlSet fieldDialogControlSet) {
            return fieldDialogControlSet.DialogWidget.this;
        }
    }

    private class CustomFieldDialogControlSet
    extends FieldDialogControlSet {
        Map customEntityControls;

        public CustomFieldDialogControlSet(MediaScriptCustomObject msfo) {
            super(msfo);
        }

        public void createMediaSection() {
            List entities = ((MediaScriptCustomObject)this.mso).getCustomEntities();
            int i = 0;
            while (i < entities.size()) {
                if (i != 0) {
                    RowDivider rd1 = DialogWidget.this.createRowDivider(DialogWidget.this.canvas, DialogWidget.this.dividerColor);
                    this.gridCellManager.addCell((Control)rd1, new String[]{this.mso.getName(), "MEDIA"});
                }
                String entityName = (String)entities.get(i);
                Label fieldPromptLabel = DialogWidget.this.createPropertyLabel(DialogWidget.this.canvas, (String)entities.get(i));
                this.gridCellManager.addCell((Control)fieldPromptLabel, new String[]{this.mso.getName(), "MEDIA"});
                Label fieldPromptText = new Label(DialogWidget.this.canvas, 64);
                fieldPromptText.setBackground(DialogWidget.this.canvas.getBackground());
                GridData gd = new GridData(768);
                gd.horizontalAlignment = 131072;
                fieldPromptText.setLayoutData((Object)gd);
                fieldPromptText.addMouseListener(new MouseListener(this, entityName, fieldPromptText){
                    final /* synthetic */ CustomFieldDialogControlSet this$1;
                    private final /* synthetic */ String val$entityName;
                    private final /* synthetic */ Label val$fieldPromptText;
                    {
                        this.this$1 = customFieldDialogControlSet;
                        this.val$entityName = string;
                        this.val$fieldPromptText = label;
                    }

                    public void mouseDoubleClick(MouseEvent e) {
                        DialogAggregate da = (DialogAggregate)DialogWidget.access$1(CustomFieldDialogControlSet.access$0(this.this$1)).get(this.this$1.mso.getName());
                        if (da != null) {
                            da.setCustomPrompt(this.val$entityName, CustomFieldDialogControlSet.access$0(this.this$1).editPrompt(this.val$entityName, da.getCustomPrompt(this.val$entityName)));
                            this.val$fieldPromptText.setText(DialogWidget.access$12(CustomFieldDialogControlSet.access$0(this.this$1), this.this$1.mso, da.getCustomPrompt(this.val$entityName)));
                            DialogWidget.access$0(CustomFieldDialogControlSet.access$0(this.this$1)).layout(true, true);
                            CustomFieldDialogControlSet.access$0(this.this$1).setMinSize(300, DialogWidget.access$0((DialogWidget)CustomFieldDialogControlSet.access$0((CustomFieldDialogControlSet)this.this$1)).computeSize((int)Math.max((int)300, (int)CustomFieldDialogControlSet.access$0((CustomFieldDialogControlSet)this.this$1).getClientArea().width), (int)-1).y);
                        }
                    }

                    public void mouseDown(MouseEvent e) {
                        DialogWidget.access$0(CustomFieldDialogControlSet.access$0(this.this$1)).forceFocus();
                    }

                    public void mouseUp(MouseEvent e) {
                    }
                });
                this.gridCellManager.addCell((Control)fieldPromptText, new String[]{this.mso.getName(), "MEDIA"});
                if (this.customEntityControls == null) {
                    this.customEntityControls = new HashMap();
                }
                this.customEntityControls.put(entities.get(i), fieldPromptText);
                ++i;
            }
        }

        public void updateMediaSection(DialogAggregate da) {
            List entities = ((MediaScriptCustomObject)this.mso).getCustomEntities();
            int i = 0;
            while (i < entities.size()) {
                String entityName = (String)entities.get(i);
                ((Label)this.customEntityControls.get(entityName)).setText(DialogWidget.this.getPromptText(this.mso, da.getCustomPrompt(entityName)));
                ++i;
            }
        }

        static /* synthetic */ DialogWidget access$0(CustomFieldDialogControlSet customFieldDialogControlSet) {
            return customFieldDialogControlSet.DialogWidget.this;
        }
    }

    private class MenuDialogControlSet
    extends InputDialogControlSet {
        Label fieldPromptText;
        Label noInputText;
        Label noMatchText;
        Spinner terminationTimeoutSpinner;
        Spinner completeTimeoutSpinner;
        Spinner incompleteTimeoutSpinner;
        Spinner confidenceSpinner;
        Spinner maxSpeechSpinner;
        Spinner maxNBestSpinner;
        Spinner sensitivitySpinner;
        Spinner speedVsAccuracySpinner;
        Map optionPromptMap;
        Map optionGrammarMap;

        public MenuDialogControlSet(MediaScriptObject msmo) {
            super(msmo);
        }

        public void update() {
            super.update();
            this.listenerUpdate = false;
            DialogAggregate da = (DialogAggregate)DialogWidget.this.dialogDataMap.get(this.mso.getName());
            if (da != null) {
                this.terminationTimeoutSpinner.setSelection((int)da.getTerminationTimeout());
                this.completeTimeoutSpinner.setSelection((int)da.getSpeechCompletionTimeout());
                this.incompleteTimeoutSpinner.setSelection((int)da.getIncompleteSpeechTimeout());
                this.confidenceSpinner.setSelection(da.getConfidenceLevel() == null ? 50 : da.getConfidenceLevel().movePointRight(2).intValue());
                this.maxSpeechSpinner.setSelection(da.getMaximumSpeechLength());
                this.maxNBestSpinner.setSelection(da.getMaximumNBestResults());
                this.sensitivitySpinner.setSelection(da.getSensitivity() == null ? 50 : da.getSensitivity().movePointRight(2).intValue());
                this.speedVsAccuracySpinner.setSelection(da.getSpeedVsAccuracy() == null ? 50 : da.getSpeedVsAccuracy().movePointRight(2).intValue());
                this.updateMediaSection(da);
            }
            this.listenerUpdate = true;
            DialogWidget.this.canvas.layout(true, true);
            DialogWidget.this.setMinSize(300, ((DialogWidget)DialogWidget.this).canvas.computeSize((int)Math.max((int)300, (int)DialogWidget.this.getClientArea().width), (int)-1).y);
        }

        public void updateMediaSection(DialogAggregate da) {
            this.fieldPromptText.setText(DialogWidget.this.getPromptText(this.mso, da.getMenuPrompt()));
            this.noInputText.setText(DialogWidget.this.getPromptText(this.mso, da.getNoInputPrompt()));
            this.noMatchText.setText(DialogWidget.this.getPromptText(this.mso, da.getNoMatchPrompt()));
            List currentOptions = ((MediaScriptMenuObject)this.mso).getOptions();
            int i = 0;
            while (i < currentOptions.size()) {
                ((Label)this.optionPromptMap.get(currentOptions.get(i))).setText(DialogWidget.this.getPromptText(this.mso, da.getMenuOptionPrompt(((MenuOption)currentOptions.get(i)).getName())));
                ((Label)this.optionGrammarMap.get(currentOptions.get(i))).setText(DialogWidget.this.getGrammarText(this.mso, da.getMenuOptionGrammar(((MenuOption)currentOptions.get(i)).getName())));
                ++i;
            }
        }

        public void createMediaSection() {
            Label fieldPromptLabel = DialogWidget.this.createPropertyLabel(DialogWidget.this.canvas, "Lead In Prompt");
            this.gridCellManager.addCell((Control)fieldPromptLabel, new String[]{this.mso.getName(), "MEDIA"});
            this.fieldPromptText = new Label(DialogWidget.this.canvas, 64);
            this.fieldPromptText.setText("This is a cell with a lot of text that wraps within its borders.  Does it look good?  Does it make sense to do the row breaks like this?");
            this.fieldPromptText.setBackground(DialogWidget.this.canvas.getBackground());
            GridData gd = new GridData(768);
            gd.horizontalAlignment = 131072;
            this.fieldPromptText.setLayoutData((Object)gd);
            this.fieldPromptText.addMouseListener(new MouseListener(this){
                final /* synthetic */ MenuDialogControlSet this$1;
                {
                    this.this$1 = menuDialogControlSet;
                }

                public void mouseDoubleClick(MouseEvent e) {
                    DialogAggregate da = (DialogAggregate)DialogWidget.access$1(MenuDialogControlSet.access$0(this.this$1)).get(this.this$1.mso.getName());
                    if (da != null) {
                        Rectangle r = MenuDialogControlSet.access$0(this.this$1).getClientArea();
                        da.setMenuPrompt(MenuDialogControlSet.access$0(this.this$1).editPrompt("Menu Prompt", da.getMenuPrompt()));
                        this.this$1.fieldPromptText.setText(DialogWidget.access$12(MenuDialogControlSet.access$0(this.this$1), this.this$1.mso, da.getMenuPrompt()));
                        DialogWidget.access$0(MenuDialogControlSet.access$0(this.this$1)).setSize(r.width, DialogWidget.access$0((DialogWidget)MenuDialogControlSet.access$0((MenuDialogControlSet)this.this$1)).computeSize((int)r.width, (int)-1).y);
                        DialogWidget.access$0(MenuDialogControlSet.access$0(this.this$1)).layout(true, false);
                        MenuDialogControlSet.access$0(this.this$1).setMinSize(300, DialogWidget.access$0((DialogWidget)MenuDialogControlSet.access$0((MenuDialogControlSet)this.this$1)).computeSize((int)Math.max((int)300, (int)MenuDialogControlSet.access$0((MenuDialogControlSet)this.this$1).getClientArea().width), (int)-1).y);
                    }
                }

                public void mouseDown(MouseEvent e) {
                    DialogWidget.access$0(MenuDialogControlSet.access$0(this.this$1)).forceFocus();
                }

                public void mouseUp(MouseEvent e) {
                }
            });
            this.gridCellManager.addCell((Control)this.fieldPromptText, new String[]{this.mso.getName(), "MEDIA"});
            RowDivider rd1 = DialogWidget.this.createRowDivider(DialogWidget.this.canvas, DialogWidget.this.dividerColor);
            this.gridCellManager.addCell((Control)rd1, new String[]{this.mso.getName(), "MEDIA", "VOICE"});
            Label noInputLabel = DialogWidget.this.createPropertyLabel(DialogWidget.this.canvas, "No Input Prompt");
            this.gridCellManager.addCell((Control)noInputLabel, new String[]{this.mso.getName(), "MEDIA"});
            this.noInputText = new Label(DialogWidget.this.canvas, 64);
            this.noInputText.setText("");
            this.noInputText.setBackground(DialogWidget.this.canvas.getBackground());
            gd = new GridData(768);
            gd.horizontalAlignment = 131072;
            this.noInputText.setLayoutData((Object)gd);
            this.noInputText.addMouseListener(new MouseListener(this){
                final /* synthetic */ MenuDialogControlSet this$1;
                {
                    this.this$1 = menuDialogControlSet;
                }

                public void mouseDoubleClick(MouseEvent e) {
                    DialogAggregate da = (DialogAggregate)DialogWidget.access$1(MenuDialogControlSet.access$0(this.this$1)).get(this.this$1.mso.getName());
                    if (da != null) {
                        Rectangle r = MenuDialogControlSet.access$0(this.this$1).getClientArea();
                        da.setNoInputPrompt(MenuDialogControlSet.access$0(this.this$1).editPrompt("No Input Prompt", da.getNoInputPrompt()));
                        this.this$1.noInputText.setText(DialogWidget.access$12(MenuDialogControlSet.access$0(this.this$1), this.this$1.mso, da.getNoInputPrompt()));
                        DialogWidget.access$0(MenuDialogControlSet.access$0(this.this$1)).layout(true, true);
                        MenuDialogControlSet.access$0(this.this$1).setMinSize(300, DialogWidget.access$0((DialogWidget)MenuDialogControlSet.access$0((MenuDialogControlSet)this.this$1)).computeSize((int)Math.max((int)300, (int)r.width), (int)-1).y);
                    }
                }

                public void mouseDown(MouseEvent e) {
                    DialogWidget.access$0(MenuDialogControlSet.access$0(this.this$1)).forceFocus();
                }

                public void mouseUp(MouseEvent e) {
                }
            });
            this.gridCellManager.addCell((Control)this.noInputText, new String[]{this.mso.getName(), "MEDIA"});
            RowDivider rd3 = DialogWidget.this.createRowDivider(DialogWidget.this.canvas, DialogWidget.this.dividerColor);
            this.gridCellManager.addCell((Control)rd3, new String[]{this.mso.getName(), "MEDIA"});
            Label noMatchLabel = DialogWidget.this.createPropertyLabel(DialogWidget.this.canvas, "No Match Prompt");
            this.gridCellManager.addCell((Control)noMatchLabel, new String[]{this.mso.getName(), "MEDIA"});
            this.noMatchText = new Label(DialogWidget.this.canvas, 64);
            this.noMatchText.setText("");
            this.noMatchText.setBackground(DialogWidget.this.canvas.getBackground());
            gd = new GridData(768);
            gd.horizontalAlignment = 131072;
            this.noMatchText.setLayoutData((Object)gd);
            this.noMatchText.addMouseListener(new MouseListener(this){
                final /* synthetic */ MenuDialogControlSet this$1;
                {
                    this.this$1 = menuDialogControlSet;
                }

                public void mouseDoubleClick(MouseEvent e) {
                    DialogAggregate da = (DialogAggregate)DialogWidget.access$1(MenuDialogControlSet.access$0(this.this$1)).get(this.this$1.mso.getName());
                    if (da != null) {
                        Rectangle r = MenuDialogControlSet.access$0(this.this$1).getClientArea();
                        da.setNoMatchPrompt(MenuDialogControlSet.access$0(this.this$1).editPrompt("No Match Prompt", da.getNoMatchPrompt()));
                        this.this$1.noMatchText.setText(DialogWidget.access$12(MenuDialogControlSet.access$0(this.this$1), this.this$1.mso, da.getNoMatchPrompt()));
                        DialogWidget.access$0(MenuDialogControlSet.access$0(this.this$1)).layout(true, true);
                        MenuDialogControlSet.access$0(this.this$1).setMinSize(300, DialogWidget.access$0((DialogWidget)MenuDialogControlSet.access$0((MenuDialogControlSet)this.this$1)).computeSize((int)Math.max((int)300, (int)r.width), (int)-1).y);
                    }
                }

                public void mouseDown(MouseEvent e) {
                }

                public void mouseUp(MouseEvent e) {
                }
            });
            this.gridCellManager.addCell((Control)this.noMatchText, new String[]{this.mso.getName(), "MEDIA"});
            this.createOptionsHeader();
            this.createOptionsSection();
        }

        public HeaderComposite createOptionsHeader() {
            HeaderComposite optionsHeader = new HeaderComposite(DialogWidget.this.canvas, 262144, "Options");
            optionsHeader.setTopGradient(DialogWidget.this.lightOrange);
            optionsHeader.setBottomGradient(DialogWidget.this.darkOrange);
            optionsHeader.setCellManager(this.gridCellManager);
            optionsHeader.setGroupName("OPTIONS");
            optionsHeader.addExpansionListener(DialogWidget.this.headerListener);
            optionsHeader.setFont(DialogWidget.this.boldFont);
            GridData gd = new GridData(768);
            gd.heightHint = 20;
            gd.horizontalSpan = 2;
            gd.horizontalIndent = 50;
            optionsHeader.setLayoutData(gd);
            this.gridCellManager.addCell((Control)optionsHeader, new String[]{this.mso.getName(), "MEDIA"});
            GridLayout gl = new GridLayout(1, false);
            gl.marginHeight = 0;
            optionsHeader.setLayout((Layout)gl);
            return optionsHeader;
        }

        public void createOptionsSection() {
            if (this.optionPromptMap == null) {
                this.optionPromptMap = new HashMap();
                this.optionGrammarMap = new HashMap();
            }
            List optionList = ((MediaScriptMenuObject)this.mso).getOptions();
            int o = 0;
            while (o < optionList.size()) {
                this.createOption((MenuOption)optionList.get(o), o > 0);
                ++o;
            }
        }

        public void createOption(MenuOption option, boolean needsDivider) {
            if (needsDivider) {
                RowDivider ord4 = DialogWidget.this.createRowDivider(DialogWidget.this.canvas, DialogWidget.this.dividerColor);
                this.gridCellManager.addCell((Control)ord4, new String[]{this.mso.getName(), "MEDIA", "OPTIONS"});
            }
            Label option1Label = DialogWidget.this.createOptionLabel(DialogWidget.this.canvas, option.getName());
            this.gridCellManager.addCell((Control)option1Label, new String[]{this.mso.getName(), "MEDIA", "OPTIONS"});
            Label option1Text = new Label(DialogWidget.this.canvas, 0);
            option1Text.setText("");
            option1Text.setBackground(DialogWidget.this.canvas.getBackground());
            option1Text.setFont(DialogWidget.this.boldFont);
            GridData gd = new GridData(768);
            gd.horizontalAlignment = 131072;
            option1Text.setLayoutData((Object)gd);
            this.gridCellManager.addCell((Control)option1Text, new String[]{this.mso.getName(), "MEDIA", "OPTIONS"});
            RowDivider ord1 = DialogWidget.this.createRowDivider(DialogWidget.this.canvas, DialogWidget.this.dividerColor);
            this.gridCellManager.addCell((Control)ord1, new String[]{this.mso.getName(), "MEDIA", "OPTIONS"});
            Label optionPromptLabel = DialogWidget.this.createOptionChildLabel(DialogWidget.this.canvas, "Prompt");
            this.gridCellManager.addCell((Control)optionPromptLabel, new String[]{this.mso.getName(), "MEDIA", "OPTIONS"});
            Label optionPromptText = new Label(DialogWidget.this.canvas, 64);
            optionPromptText.setText("");
            optionPromptText.setBackground(DialogWidget.this.canvas.getBackground());
            gd = new GridData(768);
            gd.horizontalAlignment = 131072;
            optionPromptText.setLayoutData((Object)gd);
            optionPromptText.addMouseListener(new MouseListener(this, option, optionPromptText){
                final /* synthetic */ MenuDialogControlSet this$1;
                private final /* synthetic */ MenuOption val$option;
                private final /* synthetic */ Label val$optionPromptText;
                {
                    this.this$1 = menuDialogControlSet;
                    this.val$option = menuOption;
                    this.val$optionPromptText = label;
                }

                public void mouseDoubleClick(MouseEvent e) {
                    DialogAggregate da = (DialogAggregate)DialogWidget.access$1(MenuDialogControlSet.access$0(this.this$1)).get(this.this$1.mso.getName());
                    if (da != null) {
                        Rectangle r = MenuDialogControlSet.access$0(this.this$1).getClientArea();
                        da.setMenuOptionPrompt(this.val$option.getName(), MenuDialogControlSet.access$0(this.this$1).editPrompt("Prompt", da.getMenuOptionPrompt(this.val$option.getName())));
                        this.val$optionPromptText.setText(DialogWidget.access$12(MenuDialogControlSet.access$0(this.this$1), this.this$1.mso, da.getMenuOptionPrompt(this.val$option.getName())));
                        DialogWidget.access$0(MenuDialogControlSet.access$0(this.this$1)).layout(true, true);
                        MenuDialogControlSet.access$0(this.this$1).setMinSize(300, DialogWidget.access$0((DialogWidget)MenuDialogControlSet.access$0((MenuDialogControlSet)this.this$1)).computeSize((int)Math.max((int)300, (int)r.width), (int)-1).y);
                    }
                }

                public void mouseDown(MouseEvent e) {
                    DialogWidget.access$0(MenuDialogControlSet.access$0(this.this$1)).forceFocus();
                }

                public void mouseUp(MouseEvent e) {
                }
            });
            this.optionPromptMap.put(option, optionPromptText);
            this.gridCellManager.addCell((Control)optionPromptText, new String[]{this.mso.getName(), "MEDIA", "OPTIONS"});
            RowDivider ord2 = DialogWidget.this.createRowDivider(DialogWidget.this.canvas, DialogWidget.this.dividerColor);
            this.gridCellManager.addCell((Control)ord2, new String[]{this.mso.getName(), "MEDIA", "OPTIONS", "VOICE"});
            Label optionGrammarLabel = DialogWidget.this.createOptionChildLabel(DialogWidget.this.canvas, "Grammar");
            this.gridCellManager.addCell((Control)optionGrammarLabel, new String[]{this.mso.getName(), "MEDIA", "OPTIONS"});
            Label optionGrammarText = new Label(DialogWidget.this.canvas, 64);
            optionGrammarText.setText("");
            optionGrammarText.setBackground(DialogWidget.this.canvas.getBackground());
            gd = new GridData(768);
            gd.horizontalAlignment = 131072;
            optionGrammarText.setLayoutData((Object)gd);
            optionGrammarText.addMouseListener(new MouseListener(this, option, optionGrammarText){
                final /* synthetic */ MenuDialogControlSet this$1;
                private final /* synthetic */ MenuOption val$option;
                private final /* synthetic */ Label val$optionGrammarText;
                {
                    this.this$1 = menuDialogControlSet;
                    this.val$option = menuOption;
                    this.val$optionGrammarText = label;
                }

                public void mouseDoubleClick(MouseEvent e) {
                    DialogAggregate da = (DialogAggregate)DialogWidget.access$1(MenuDialogControlSet.access$0(this.this$1)).get(this.this$1.mso.getName());
                    if (da != null) {
                        da.setMenuOptionGrammar(this.val$option.getName(), MenuDialogControlSet.access$0(this.this$1).editGrammar("Grammar", da.getMenuOptionGrammar(this.val$option.getName())));
                        this.val$optionGrammarText.setText(DialogWidget.access$13(MenuDialogControlSet.access$0(this.this$1), this.this$1.mso, da.getMenuOptionGrammar(this.val$option.getName())));
                        DialogWidget.access$0(MenuDialogControlSet.access$0(this.this$1)).layout(true, true);
                        MenuDialogControlSet.access$0(this.this$1).setMinSize(300, DialogWidget.access$0((DialogWidget)MenuDialogControlSet.access$0((MenuDialogControlSet)this.this$1)).computeSize((int)Math.max((int)300, (int)MenuDialogControlSet.access$0((MenuDialogControlSet)this.this$1).getClientArea().width), (int)-1).y);
                    }
                }

                public void mouseDown(MouseEvent e) {
                    DialogWidget.access$0(MenuDialogControlSet.access$0(this.this$1)).forceFocus();
                }

                public void mouseUp(MouseEvent e) {
                }
            });
            this.gridCellManager.addCell((Control)optionGrammarText, new String[]{this.mso.getName(), "MEDIA", "OPTIONS"});
            this.optionGrammarMap.put(option, optionGrammarText);
            RowDivider ord3 = DialogWidget.this.createRowDivider(DialogWidget.this.canvas, DialogWidget.this.dividerColor);
            this.gridCellManager.addCell((Control)ord3, new String[]{this.mso.getName(), "MEDIA", "OPTIONS", "DTMF"});
            Label optionDTMFLabel = DialogWidget.this.createOptionChildLabel(DialogWidget.this.canvas, "DTMF Value");
            this.gridCellManager.addCell((Control)optionDTMFLabel, new String[]{this.mso.getName(), "MEDIA", "OPTIONS", "DTMF"});
            Label optionDTMFText = new Label(DialogWidget.this.canvas, 0);
            optionDTMFText.setText(Integer.toString(option.getDTMF()));
            optionDTMFText.setBackground(DialogWidget.this.canvas.getBackground());
            gd = new GridData(768);
            gd.horizontalAlignment = 131072;
            optionDTMFText.setLayoutData((Object)gd);
            this.gridCellManager.addCell((Control)optionDTMFText, new String[]{this.mso.getName(), "MEDIA", "OPTIONS", "DTMF"});
        }

        public void createSettingsSection() {
            super.createSettingsSection();
            RowDivider rd3 = DialogWidget.this.createRowDivider(DialogWidget.this.canvas, DialogWidget.this.dividerColor);
            this.gridCellManager.addCell((Control)rd3, new String[]{this.mso.getName(), "SETTINGS", "DTMF"});
            Label terminationTimeoutLabel = DialogWidget.this.createPropertyLabel(DialogWidget.this.canvas, "Termination Timeout");
            this.gridCellManager.addCell((Control)terminationTimeoutLabel, new String[]{this.mso.getName(), "SETTINGS", "DTMF"});
            this.terminationTimeoutSpinner = DialogWidget.this.createValueSpinner(DialogWidget.this.canvas, 0, 10, 0, 3);
            this.gridCellManager.addCell((Control)this.terminationTimeoutSpinner, new String[]{this.mso.getName(), "SETTINGS", "DTMF"});
            RowDivider rd5 = DialogWidget.this.createRowDivider(DialogWidget.this.canvas, DialogWidget.this.dividerColor);
            this.gridCellManager.addCell((Control)rd5, new String[]{this.mso.getName(), "SETTINGS", "VOICE"});
            Label completeTimeoutLabel = DialogWidget.this.createPropertyLabel(DialogWidget.this.canvas, "Speech Completion Timeout");
            this.gridCellManager.addCell((Control)completeTimeoutLabel, new String[]{this.mso.getName(), "SETTINGS", "VOICE"});
            this.completeTimeoutSpinner = DialogWidget.this.createValueSpinner(DialogWidget.this.canvas, 0, 10, 0, 3);
            this.completeTimeoutSpinner.addModifyListener(new ModifyListener(this){
                final /* synthetic */ MenuDialogControlSet this$1;
                {
                    this.this$1 = menuDialogControlSet;
                }

                public void modifyText(ModifyEvent e) {
                    DialogAggregate da;
                    if (this.this$1.listenerUpdate && (da = (DialogAggregate)DialogWidget.access$1(MenuDialogControlSet.access$0(this.this$1)).get(this.this$1.mso.getName())) != null) {
                        da.setSpeechCompletionTimeout((long)this.this$1.completeTimeoutSpinner.getSelection());
                    }
                }
            });
            this.gridCellManager.addCell((Control)this.completeTimeoutSpinner, new String[]{this.mso.getName(), "SETTINGS", "VOICE"});
            RowDivider rd6 = DialogWidget.this.createRowDivider(DialogWidget.this.canvas, DialogWidget.this.dividerColor);
            this.gridCellManager.addCell((Control)rd6, new String[]{this.mso.getName(), "SETTINGS", "VOICE"});
            Label incompleteTimeoutLabel = DialogWidget.this.createPropertyLabel(DialogWidget.this.canvas, "Incomplete Speech Timeout");
            this.gridCellManager.addCell((Control)incompleteTimeoutLabel, new String[]{this.mso.getName(), "SETTINGS", "VOICE"});
            this.incompleteTimeoutSpinner = DialogWidget.this.createValueSpinner(DialogWidget.this.canvas, 0, 10, 0, 3);
            this.incompleteTimeoutSpinner.addModifyListener(new ModifyListener(this){
                final /* synthetic */ MenuDialogControlSet this$1;
                {
                    this.this$1 = menuDialogControlSet;
                }

                public void modifyText(ModifyEvent e) {
                    DialogAggregate da;
                    if (this.this$1.listenerUpdate && (da = (DialogAggregate)DialogWidget.access$1(MenuDialogControlSet.access$0(this.this$1)).get(this.this$1.mso.getName())) != null) {
                        da.setIncompleteSpeechTimeout((long)this.this$1.incompleteTimeoutSpinner.getSelection());
                    }
                }
            });
            this.gridCellManager.addCell((Control)this.incompleteTimeoutSpinner, new String[]{this.mso.getName(), "SETTINGS", "VOICE"});
            RowDivider rd7 = DialogWidget.this.createRowDivider(DialogWidget.this.canvas, DialogWidget.this.dividerColor);
            this.gridCellManager.addCell((Control)rd7, new String[]{this.mso.getName(), "SETTINGS", "VOICE"});
            Label confidenceLevelLabel = DialogWidget.this.createPropertyLabel(DialogWidget.this.canvas, "Confidence Level");
            this.gridCellManager.addCell((Control)confidenceLevelLabel, new String[]{this.mso.getName(), "SETTINGS", "VOICE"});
            this.confidenceSpinner = DialogWidget.this.createValueSpinner(DialogWidget.this.canvas, 0, 100, 2, 50);
            this.confidenceSpinner.addModifyListener(new ModifyListener(this){
                final /* synthetic */ MenuDialogControlSet this$1;
                {
                    this.this$1 = menuDialogControlSet;
                }

                public void modifyText(ModifyEvent e) {
                    if (this.this$1.listenerUpdate) {
                        BigDecimal bd = new BigDecimal((double)this.this$1.confidenceSpinner.getSelection()).movePointLeft(2);
                        DialogAggregate da = (DialogAggregate)DialogWidget.access$1(MenuDialogControlSet.access$0(this.this$1)).get(this.this$1.mso.getName());
                        if (da != null) {
                            da.setConfidenceLevel(bd);
                        }
                    }
                }
            });
            this.gridCellManager.addCell((Control)this.confidenceSpinner, new String[]{this.mso.getName(), "SETTINGS", "VOICE"});
            RowDivider rd8 = DialogWidget.this.createRowDivider(DialogWidget.this.canvas, DialogWidget.this.dividerColor);
            this.gridCellManager.addCell((Control)rd8, new String[]{this.mso.getName(), "SETTINGS", "VOICE"});
            Label maxSpeechTimeoutLabel = DialogWidget.this.createPropertyLabel(DialogWidget.this.canvas, "Maximum Speech Length");
            this.gridCellManager.addCell((Control)maxSpeechTimeoutLabel, new String[]{this.mso.getName(), "SETTINGS", "VOICE"});
            this.maxSpeechSpinner = DialogWidget.this.createValueSpinner(DialogWidget.this.canvas, 5, 30, 0, 10);
            this.maxSpeechSpinner.addModifyListener(new ModifyListener(this){
                final /* synthetic */ MenuDialogControlSet this$1;
                {
                    this.this$1 = menuDialogControlSet;
                }

                public void modifyText(ModifyEvent e) {
                    DialogAggregate da;
                    if (this.this$1.listenerUpdate && (da = (DialogAggregate)DialogWidget.access$1(MenuDialogControlSet.access$0(this.this$1)).get(this.this$1.mso.getName())) != null) {
                        da.setMaximumSpeechLength(this.this$1.maxSpeechSpinner.getSelection());
                    }
                }
            });
            this.gridCellManager.addCell((Control)this.maxSpeechSpinner, new String[]{this.mso.getName(), "SETTINGS", "VOICE"});
            RowDivider rd9 = DialogWidget.this.createRowDivider(DialogWidget.this.canvas, DialogWidget.this.dividerColor);
            this.gridCellManager.addCell((Control)rd9, new String[]{this.mso.getName(), "SETTINGS", "VOICE"});
            Label maxNBestLabel = DialogWidget.this.createPropertyLabel(DialogWidget.this.canvas, "Maximum N-Best Results");
            this.gridCellManager.addCell((Control)maxNBestLabel, new String[]{this.mso.getName(), "SETTINGS", "VOICE"});
            this.maxNBestSpinner = DialogWidget.this.createValueSpinner(DialogWidget.this.canvas, 1, 10, 0, 1);
            this.maxNBestSpinner.addModifyListener(new ModifyListener(this){
                final /* synthetic */ MenuDialogControlSet this$1;
                {
                    this.this$1 = menuDialogControlSet;
                }

                public void modifyText(ModifyEvent e) {
                    DialogAggregate da;
                    if (this.this$1.listenerUpdate && (da = (DialogAggregate)DialogWidget.access$1(MenuDialogControlSet.access$0(this.this$1)).get(this.this$1.mso.getName())) != null) {
                        da.setMaximumNBestResults(this.this$1.maxNBestSpinner.getSelection());
                    }
                }
            });
            this.gridCellManager.addCell((Control)this.maxNBestSpinner, new String[]{this.mso.getName(), "SETTINGS", "VOICE"});
            RowDivider rd10 = DialogWidget.this.createRowDivider(DialogWidget.this.canvas, DialogWidget.this.dividerColor);
            this.gridCellManager.addCell((Control)rd10, new String[]{this.mso.getName(), "SETTINGS", "VOICE"});
            Label sensitivityLabel = DialogWidget.this.createPropertyLabel(DialogWidget.this.canvas, "Sensitivity");
            this.gridCellManager.addCell((Control)sensitivityLabel, new String[]{this.mso.getName(), "SETTINGS", "VOICE"});
            this.sensitivitySpinner = DialogWidget.this.createValueSpinner(DialogWidget.this.canvas, 0, 100, 2, 50);
            this.sensitivitySpinner.addModifyListener(new ModifyListener(this){
                final /* synthetic */ MenuDialogControlSet this$1;
                {
                    this.this$1 = menuDialogControlSet;
                }

                public void modifyText(ModifyEvent e) {
                    if (this.this$1.listenerUpdate) {
                        BigDecimal bd = new BigDecimal((double)this.this$1.sensitivitySpinner.getSelection()).movePointLeft(2);
                        DialogAggregate da = (DialogAggregate)DialogWidget.access$1(MenuDialogControlSet.access$0(this.this$1)).get(this.this$1.mso.getName());
                        if (da != null) {
                            da.setSensitivity(bd);
                        }
                    }
                }
            });
            this.gridCellManager.addCell((Control)this.sensitivitySpinner, new String[]{this.mso.getName(), "SETTINGS", "VOICE"});
            RowDivider rd11 = DialogWidget.this.createRowDivider(DialogWidget.this.canvas, DialogWidget.this.dividerColor);
            this.gridCellManager.addCell((Control)rd11, new String[]{this.mso.getName(), "SETTINGS", "VOICE"});
            Label speedVsAccuracyLabel = DialogWidget.this.createPropertyLabel(DialogWidget.this.canvas, "Speed Vs. Accuracy");
            this.gridCellManager.addCell((Control)speedVsAccuracyLabel, new String[]{this.mso.getName(), "SETTINGS", "VOICE"});
            this.speedVsAccuracySpinner = DialogWidget.this.createValueSpinner(DialogWidget.this.canvas, 0, 100, 2, 50);
            this.speedVsAccuracySpinner.addModifyListener(new ModifyListener(this){
                final /* synthetic */ MenuDialogControlSet this$1;
                {
                    this.this$1 = menuDialogControlSet;
                }

                public void modifyText(ModifyEvent e) {
                    if (this.this$1.listenerUpdate) {
                        BigDecimal bd = new BigDecimal((double)this.this$1.speedVsAccuracySpinner.getSelection()).movePointLeft(2);
                        DialogAggregate da = (DialogAggregate)DialogWidget.access$1(MenuDialogControlSet.access$0(this.this$1)).get(this.this$1.mso.getName());
                        if (da != null) {
                            da.setSpeedVsAccuracy(bd);
                        }
                    }
                }
            });
            this.gridCellManager.addCell((Control)this.speedVsAccuracySpinner, new String[]{this.mso.getName(), "SETTINGS", "VOICE"});
        }

        static /* synthetic */ DialogWidget access$0(MenuDialogControlSet menuDialogControlSet) {
            return menuDialogControlSet.DialogWidget.this;
        }
    }

    private class CustomMenuDialogControlSet
    extends MenuDialogControlSet {
        Map customEntityControls;

        public CustomMenuDialogControlSet(MediaScriptCustomObject msfo) {
            super(msfo);
        }

        public void createMediaSection() {
            List entities = ((MediaScriptCustomObject)this.mso).getCustomEntities();
            int i = 0;
            while (i < entities.size()) {
                if (i != 0) {
                    RowDivider rd1 = DialogWidget.this.createRowDivider(DialogWidget.this.canvas, DialogWidget.this.dividerColor);
                    this.gridCellManager.addCell((Control)rd1, new String[]{this.mso.getName(), "MEDIA"});
                }
                String entityName = (String)entities.get(i);
                Label fieldPromptLabel = DialogWidget.this.createPropertyLabel(DialogWidget.this.canvas, (String)entities.get(i));
                this.gridCellManager.addCell((Control)fieldPromptLabel, new String[]{this.mso.getName(), "MEDIA"});
                Label fieldPromptText = new Label(DialogWidget.this.canvas, 64);
                fieldPromptText.setBackground(DialogWidget.this.canvas.getBackground());
                GridData gd = new GridData(768);
                gd.horizontalAlignment = 131072;
                fieldPromptText.setLayoutData((Object)gd);
                fieldPromptText.addMouseListener(new MouseListener(this, entityName, fieldPromptText){
                    final /* synthetic */ CustomMenuDialogControlSet this$1;
                    private final /* synthetic */ String val$entityName;
                    private final /* synthetic */ Label val$fieldPromptText;
                    {
                        this.this$1 = customMenuDialogControlSet;
                        this.val$entityName = string;
                        this.val$fieldPromptText = label;
                    }

                    public void mouseDoubleClick(MouseEvent e) {
                        DialogAggregate da = (DialogAggregate)DialogWidget.access$1(CustomMenuDialogControlSet.access$0(this.this$1)).get(this.this$1.mso.getName());
                        if (da != null) {
                            da.setCustomPrompt(this.val$entityName, CustomMenuDialogControlSet.access$0(this.this$1).editPrompt(this.val$entityName, da.getCustomPrompt(this.val$entityName)));
                            this.val$fieldPromptText.setText(DialogWidget.access$12(CustomMenuDialogControlSet.access$0(this.this$1), this.this$1.mso, da.getCustomPrompt(this.val$entityName)));
                            DialogWidget.access$0(CustomMenuDialogControlSet.access$0(this.this$1)).layout(true, true);
                            CustomMenuDialogControlSet.access$0(this.this$1).setMinSize(300, DialogWidget.access$0((DialogWidget)CustomMenuDialogControlSet.access$0((CustomMenuDialogControlSet)this.this$1)).computeSize((int)Math.max((int)300, (int)CustomMenuDialogControlSet.access$0((CustomMenuDialogControlSet)this.this$1).getClientArea().width), (int)-1).y);
                        }
                    }

                    public void mouseDown(MouseEvent e) {
                        DialogWidget.access$0(CustomMenuDialogControlSet.access$0(this.this$1)).forceFocus();
                    }

                    public void mouseUp(MouseEvent e) {
                    }
                });
                this.gridCellManager.addCell((Control)fieldPromptText, new String[]{this.mso.getName(), "MEDIA"});
                if (this.customEntityControls == null) {
                    this.customEntityControls = new HashMap();
                }
                this.customEntityControls.put(entities.get(i), fieldPromptText);
                ++i;
            }
        }

        public void updateMediaSection(DialogAggregate da) {
            List entities = ((MediaScriptCustomObject)this.mso).getCustomEntities();
            int i = 0;
            while (i < entities.size()) {
                String entityName = (String)entities.get(i);
                ((Label)this.customEntityControls.get(entityName)).setText(DialogWidget.this.getPromptText(this.mso, da.getCustomPrompt(entityName)));
                ++i;
            }
        }

        static /* synthetic */ DialogWidget access$0(CustomMenuDialogControlSet customMenuDialogControlSet) {
            return customMenuDialogControlSet.DialogWidget.this;
        }
    }

    private class DynamicMenuDialogControlSet
    extends MenuDialogControlSet {
        MediaScriptDynamicMenuObject msdmo;
        Button addOptionButton;
        Map optionControlMap;
        Map moveUpButtons;
        Map moveDownButtons;

        public DynamicMenuDialogControlSet(MediaScriptDynamicMenuObject msfo) {
            super(msfo);
            this.msdmo = msfo;
        }

        public void update() {
            super.update();
            this.listenerUpdate = false;
            DialogAggregate da = (DialogAggregate)DialogWidget.this.dialogDataMap.get(this.mso.getName());
            if (da != null) {
                List currentOptions = ((MediaScriptMenuObject)this.mso).getOptions();
                int i = 0;
                while (i < currentOptions.size()) {
                    ((Label)this.optionPromptMap.get(currentOptions.get(i))).setText(DialogWidget.this.getPromptText(this.mso, da.getMenuOptionPrompt(((MenuOption)currentOptions.get(i)).getName())));
                    ++i;
                }
            }
            this.listenerUpdate = true;
            DialogWidget.this.canvas.layout(true, true);
            DialogWidget.this.setMinSize(300, ((DialogWidget)DialogWidget.this).canvas.computeSize((int)Math.max((int)300, (int)DialogWidget.this.getClientArea().width), (int)-1).y);
        }

        public HeaderComposite createOptionsHeader() {
            HeaderComposite ret = super.createOptionsHeader();
            GridLayout gl = new GridLayout(1, false);
            gl.marginHeight = 0;
            ret.setLayout((Layout)gl);
            this.addOptionButton = new Button((Composite)ret, 8);
            this.addOptionButton.setText("Add Option");
            GridData gd = new GridData();
            gd.horizontalAlignment = 131072;
            gd.verticalAlignment = 0x1000000;
            gd.grabExcessHorizontalSpace = true;
            gd.grabExcessVerticalSpace = true;
            this.addOptionButton.setLayoutData((Object)gd);
            this.addOptionButton.addSelectionListener(new SelectionListener(this, ret){
                final /* synthetic */ DynamicMenuDialogControlSet this$1;
                private final /* synthetic */ HeaderComposite val$ret;
                {
                    this.this$1 = dynamicMenuDialogControlSet;
                    this.val$ret = headerComposite;
                }

                public void widgetSelected(SelectionEvent e) {
                    List currentOptions = ((MediaScriptDynamicMenuObject)this.this$1.mso).getOptions();
                    MenuOption lastOption = currentOptions.size() == 0 ? null : (MenuOption)currentOptions.get(currentOptions.size() - 1);
                    NewMenuChoiceWizard nmo = new NewMenuChoiceWizard((MediaScriptDynamicMenuObject)this.this$1.mso);
                    WizardDialog wd = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)nmo);
                    if (wd.open() == 0) {
                        RowDivider ord4 = DialogWidget.access$10(DynamicMenuDialogControlSet.access$0(this.this$1), DialogWidget.access$0(DynamicMenuDialogControlSet.access$0(this.this$1)), DialogWidget.access$9(DynamicMenuDialogControlSet.access$0(this.this$1)));
                        DynamicMenuOption newOption = nmo.getMenuOption();
                        List controls = this.this$1.createOptionControls(newOption);
                        if (this.this$1.optionControlMap == null) {
                            this.this$1.optionControlMap = new HashMap<K, V>();
                        }
                        this.this$1.optionControlMap.put(newOption, controls);
                        List insertPointControlList = (List)this.this$1.optionControlMap.get(lastOption);
                        PaintListener target = insertPointControlList == null ? this.val$ret : (Control)insertPointControlList.get(insertPointControlList.size() - 1);
                        ord4.moveBelow((Control)target);
                        target = ord4;
                        int i = 0;
                        while (i < controls.size()) {
                            ((Control)controls.get(i)).moveBelow((Control)target);
                            target = (Control)controls.get(i);
                            ++i;
                        }
                        controls.add(0, ord4);
                        this.this$1.updateButtons();
                        this.this$1.gridCellManager.refresh();
                        DialogWidget.access$0(DynamicMenuDialogControlSet.access$0(this.this$1)).layout(true, true);
                        DynamicMenuDialogControlSet.access$0(this.this$1).setMinSize(300, DialogWidget.access$0((DialogWidget)DynamicMenuDialogControlSet.access$0((DynamicMenuDialogControlSet)this.this$1)).computeSize((int)Math.max((int)300, (int)DynamicMenuDialogControlSet.access$0((DynamicMenuDialogControlSet)this.this$1).getClientArea().width), (int)-1).y);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            return ret;
        }

        public void createOptionsSection() {
            super.createOptionsSection();
            this.updateButtons();
        }

        public void updateButtons() {
            List currentOptions = ((MediaScriptDynamicMenuObject)this.mso).getOptions();
            int i = 0;
            while (i < currentOptions.size()) {
                MenuOption lastOption = (MenuOption)currentOptions.get(i);
                ((ToolItem)this.moveUpButtons.get(lastOption)).setEnabled(i != 0);
                ((ToolItem)this.moveDownButtons.get(lastOption)).setEnabled(i < currentOptions.size() - 1);
                ++i;
            }
        }

        public void createOption(MenuOption option, boolean needsDivider) {
            RowDivider ord4 = null;
            if (needsDivider) {
                ord4 = DialogWidget.this.createRowDivider(DialogWidget.this.canvas, DialogWidget.this.dividerColor);
                this.gridCellManager.addCell((Control)ord4, new String[]{this.mso.getName(), "MEDIA", "OPTIONS"});
            }
            List controlList = this.createOptionControls(option);
            if (needsDivider) {
                controlList.add(0, ord4);
            }
            if (this.optionControlMap == null) {
                this.optionControlMap = new HashMap();
            }
            this.optionControlMap.put(option, controlList);
        }

        public List createOptionControls(MenuOption option) {
            ArrayList<Object> controlList = new ArrayList<Object>();
            DynamicMenuOption mo = (DynamicMenuOption)option;
            Label option1Label = DialogWidget.this.createOptionLabel(DialogWidget.this.canvas, mo.getName());
            option1Label.setFont(DialogWidget.this.boldFont);
            controlList.add(option1Label);
            this.gridCellManager.addCell((Control)option1Label, new String[]{this.mso.getName(), "MEDIA", "OPTIONS"});
            Composite optHeaderComp = new Composite(DialogWidget.this.canvas, 0);
            FillLayout fl = new FillLayout();
            optHeaderComp.setLayout((Layout)fl);
            optHeaderComp.setBackground(DialogWidget.this.canvas.getBackground());
            if (this.moveUpButtons == null) {
                this.moveUpButtons = new HashMap();
                this.moveDownButtons = new HashMap();
            }
            ToolBar tb = new ToolBar(optHeaderComp, 0x800000);
            tb.setBackground(optHeaderComp.getBackground());
            ToolItem moveUpButton = new ToolItem(tb, 8);
            moveUpButton.setImage(ApplicationUIPlugin.getDefault().getImageRegistry().get("ICON_MOVE_UP"));
            this.moveUpButtons.put(option, moveUpButton);
            moveUpButton.addSelectionListener(new SelectionListener(this, option){
                final /* synthetic */ DynamicMenuDialogControlSet this$1;
                private final /* synthetic */ MenuOption val$option;
                {
                    this.this$1 = dynamicMenuDialogControlSet;
                    this.val$option = menuOption;
                }

                public void widgetSelected(SelectionEvent e) {
                    List currentOptions = ((MediaScriptMenuObject)this.this$1.mso).getOptions();
                    MenuOption targetOption = null;
                    int i = 0;
                    while (i < currentOptions.size()) {
                        if (currentOptions.get(i) == this.val$option && i != 0) {
                            targetOption = (MenuOption)currentOptions.get(i - 1);
                        }
                        ++i;
                    }
                    if (targetOption != null) {
                        List targetControlList = (List)this.this$1.optionControlMap.get(targetOption);
                        List mobileControlList = (List)this.this$1.optionControlMap.get(this.val$option);
                        Control topTargetControl = (Control)targetControlList.get(0);
                        if (!(topTargetControl instanceof RowDivider)) {
                            targetControlList.add(0, mobileControlList.get(0));
                            Control mobileDivider = (Control)mobileControlList.remove(0);
                            mobileDivider.moveAbove((Control)targetControlList.get(1));
                        }
                        int i2 = 0;
                        while (i2 < mobileControlList.size()) {
                            ((Control)mobileControlList.get(i2)).moveAbove((Control)targetControlList.get(0));
                            ++i2;
                        }
                        ((MediaScriptDynamicMenuObject)this.this$1.mso).moveOptionUp((DynamicMenuOption)this.val$option);
                        this.this$1.updateButtons();
                        DialogWidget.access$0(DynamicMenuDialogControlSet.access$0(this.this$1)).layout(true, true);
                        DynamicMenuDialogControlSet.access$0(this.this$1).setMinSize(300, DialogWidget.access$0((DialogWidget)DynamicMenuDialogControlSet.access$0((DynamicMenuDialogControlSet)this.this$1)).computeSize((int)Math.max((int)300, (int)DynamicMenuDialogControlSet.access$0((DynamicMenuDialogControlSet)this.this$1).getClientArea().width), (int)-1).y);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            ToolItem moveDownButton = new ToolItem(tb, 8);
            moveDownButton.setImage(ApplicationUIPlugin.getDefault().getImageRegistry().get("ICON_MOVE_DOWN"));
            this.moveDownButtons.put(option, moveDownButton);
            moveDownButton.addSelectionListener(new SelectionListener(this, option){
                final /* synthetic */ DynamicMenuDialogControlSet this$1;
                private final /* synthetic */ MenuOption val$option;
                {
                    this.this$1 = dynamicMenuDialogControlSet;
                    this.val$option = menuOption;
                }

                public void widgetSelected(SelectionEvent e) {
                    List currentOptions = ((MediaScriptMenuObject)this.this$1.mso).getOptions();
                    MenuOption targetOption = this.val$option;
                    MenuOption mobileOption = null;
                    int i = 0;
                    while (i < currentOptions.size()) {
                        if (currentOptions.get(i) == this.val$option && i < currentOptions.size() - 1) {
                            mobileOption = (MenuOption)currentOptions.get(i + 1);
                        }
                        ++i;
                    }
                    if (mobileOption != null) {
                        List targetControlList = (List)this.this$1.optionControlMap.get(targetOption);
                        List mobileControlList = (List)this.this$1.optionControlMap.get(mobileOption);
                        Control topTargetControl = (Control)targetControlList.get(0);
                        if (!(topTargetControl instanceof RowDivider)) {
                            targetControlList.add(0, mobileControlList.get(0));
                            Control mobileDivider = (Control)mobileControlList.remove(0);
                            mobileDivider.moveAbove((Control)targetControlList.get(1));
                        }
                        int i2 = 0;
                        while (i2 < mobileControlList.size()) {
                            ((Control)mobileControlList.get(i2)).moveAbove((Control)targetControlList.get(0));
                            ++i2;
                        }
                        ((MediaScriptDynamicMenuObject)this.this$1.mso).moveOptionDown((DynamicMenuOption)this.val$option);
                        this.this$1.updateButtons();
                        DialogWidget.access$0(DynamicMenuDialogControlSet.access$0(this.this$1)).layout(true, true);
                        DynamicMenuDialogControlSet.access$0(this.this$1).setMinSize(300, DialogWidget.access$0((DialogWidget)DynamicMenuDialogControlSet.access$0((DynamicMenuDialogControlSet)this.this$1)).computeSize((int)Math.max((int)300, (int)DynamicMenuDialogControlSet.access$0((DynamicMenuDialogControlSet)this.this$1).getClientArea().width), (int)-1).y);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            ToolItem deleteButton = new ToolItem(tb, 8);
            deleteButton.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE"));
            deleteButton.addSelectionListener(new SelectionListener(this, option){
                final /* synthetic */ DynamicMenuDialogControlSet this$1;
                private final /* synthetic */ MenuOption val$option;
                {
                    this.this$1 = dynamicMenuDialogControlSet;
                    this.val$option = menuOption;
                }

                public void widgetSelected(SelectionEvent e) {
                    List controlList = (List)this.this$1.optionControlMap.get(this.val$option);
                    this.this$1.moveUpButtons.remove(this.val$option);
                    this.this$1.moveDownButtons.remove(this.val$option);
                    this.this$1.optionPromptMap.remove(this.val$option);
                    this.this$1.optionGrammarMap.remove(this.val$option);
                    int i = 0;
                    while (i < controlList.size()) {
                        this.this$1.gridCellManager.removeCell((Control)controlList.get(i));
                        ((Control)controlList.get(i)).dispose();
                        ++i;
                    }
                    this.this$1.optionControlMap.remove(this.val$option);
                    ((MediaScriptDynamicMenuObject)this.this$1.mso).removeOption((DynamicMenuOption)this.val$option);
                    this.this$1.updateButtons();
                    DialogWidget.access$0(DynamicMenuDialogControlSet.access$0(this.this$1)).layout(true, true);
                    DynamicMenuDialogControlSet.access$0(this.this$1).setMinSize(300, DialogWidget.access$0((DialogWidget)DynamicMenuDialogControlSet.access$0((DynamicMenuDialogControlSet)this.this$1)).computeSize((int)Math.max((int)300, (int)DynamicMenuDialogControlSet.access$0((DynamicMenuDialogControlSet)this.this$1).getClientArea().width), (int)-1).y);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            GridData gd = new GridData();
            gd.horizontalAlignment = 131072;
            optHeaderComp.setLayoutData((Object)gd);
            controlList.add(optHeaderComp);
            this.gridCellManager.addCell((Control)optHeaderComp, new String[]{this.mso.getName(), "MEDIA", "OPTIONS"});
            RowDivider ord1 = DialogWidget.this.createRowDivider(DialogWidget.this.canvas, DialogWidget.this.dividerColor);
            controlList.add((Object)ord1);
            this.gridCellManager.addCell((Control)ord1, new String[]{this.mso.getName(), "MEDIA", "OPTIONS"});
            Label optionPromptLabel = DialogWidget.this.createOptionChildLabel(DialogWidget.this.canvas, "Prompt");
            controlList.add(optionPromptLabel);
            this.gridCellManager.addCell((Control)optionPromptLabel, new String[]{this.mso.getName(), "MEDIA", "OPTIONS"});
            Label optionPromptText = new Label(DialogWidget.this.canvas, 64);
            optionPromptText.setText("Not Configured");
            optionPromptText.setBackground(DialogWidget.this.canvas.getBackground());
            gd = new GridData(768);
            gd.horizontalAlignment = 131072;
            optionPromptText.setLayoutData((Object)gd);
            optionPromptText.addMouseListener(new MouseListener(this, option, optionPromptText){
                final /* synthetic */ DynamicMenuDialogControlSet this$1;
                private final /* synthetic */ MenuOption val$option;
                private final /* synthetic */ Label val$optionPromptText;
                {
                    this.this$1 = dynamicMenuDialogControlSet;
                    this.val$option = menuOption;
                    this.val$optionPromptText = label;
                }

                public void mouseDoubleClick(MouseEvent e) {
                    DialogAggregate da = (DialogAggregate)DialogWidget.access$1(DynamicMenuDialogControlSet.access$0(this.this$1)).get(this.this$1.mso.getName());
                    if (da != null) {
                        Rectangle r = DynamicMenuDialogControlSet.access$0(this.this$1).getClientArea();
                        da.setMenuOptionPrompt(this.val$option.getName(), DynamicMenuDialogControlSet.access$0(this.this$1).editPrompt("Prompt", da.getMenuOptionPrompt(this.val$option.getName())));
                        this.val$optionPromptText.setText(DialogWidget.access$12(DynamicMenuDialogControlSet.access$0(this.this$1), this.this$1.mso, da.getMenuOptionPrompt(this.val$option.getName())));
                        DialogWidget.access$0(DynamicMenuDialogControlSet.access$0(this.this$1)).setSize(r.width, DialogWidget.access$0((DialogWidget)DynamicMenuDialogControlSet.access$0((DynamicMenuDialogControlSet)this.this$1)).getSize().y);
                        DialogWidget.access$0(DynamicMenuDialogControlSet.access$0(this.this$1)).layout(true, true);
                        DynamicMenuDialogControlSet.access$0(this.this$1).setMinSize(300, DialogWidget.access$0((DialogWidget)DynamicMenuDialogControlSet.access$0((DynamicMenuDialogControlSet)this.this$1)).computeSize((int)Math.max((int)300, (int)r.width), (int)-1).y);
                    }
                }

                public void mouseDown(MouseEvent e) {
                    DialogWidget.access$0(DynamicMenuDialogControlSet.access$0(this.this$1)).forceFocus();
                }

                public void mouseUp(MouseEvent e) {
                }
            });
            this.optionPromptMap.put(option, optionPromptText);
            controlList.add(optionPromptText);
            this.gridCellManager.addCell((Control)optionPromptText, new String[]{this.mso.getName(), "MEDIA", "OPTIONS"});
            RowDivider ord2 = DialogWidget.this.createRowDivider(DialogWidget.this.canvas, DialogWidget.this.dividerColor);
            controlList.add((Object)ord2);
            this.gridCellManager.addCell((Control)ord2, new String[]{this.mso.getName(), "MEDIA", "OPTIONS", "VOICE"});
            Label optionGrammarLabel = DialogWidget.this.createOptionChildLabel(DialogWidget.this.canvas, "Grammar");
            controlList.add(optionGrammarLabel);
            this.gridCellManager.addCell((Control)optionGrammarLabel, new String[]{this.mso.getName(), "MEDIA", "OPTIONS", "VOICE"});
            Label optionGrammarText = new Label(DialogWidget.this.canvas, 64);
            optionGrammarText.setText("");
            optionGrammarText.setBackground(DialogWidget.this.canvas.getBackground());
            gd = new GridData(768);
            gd.horizontalAlignment = 131072;
            optionGrammarText.setLayoutData((Object)gd);
            optionGrammarText.addMouseListener(new MouseListener(this, option, optionGrammarText){
                final /* synthetic */ DynamicMenuDialogControlSet this$1;
                private final /* synthetic */ MenuOption val$option;
                private final /* synthetic */ Label val$optionGrammarText;
                {
                    this.this$1 = dynamicMenuDialogControlSet;
                    this.val$option = menuOption;
                    this.val$optionGrammarText = label;
                }

                public void mouseDoubleClick(MouseEvent e) {
                    DialogAggregate da = (DialogAggregate)DialogWidget.access$1(DynamicMenuDialogControlSet.access$0(this.this$1)).get(this.this$1.mso.getName());
                    if (da != null) {
                        da.setMenuOptionGrammar(this.val$option.getName(), DynamicMenuDialogControlSet.access$0(this.this$1).editGrammar("Grammar", da.getMenuOptionGrammar(this.val$option.getName())));
                        this.val$optionGrammarText.setText(DialogWidget.access$13(DynamicMenuDialogControlSet.access$0(this.this$1), this.this$1.mso, da.getMenuOptionGrammar(this.val$option.getName())));
                        DialogWidget.access$0(DynamicMenuDialogControlSet.access$0(this.this$1)).layout(true, true);
                        DynamicMenuDialogControlSet.access$0(this.this$1).setMinSize(300, DialogWidget.access$0((DialogWidget)DynamicMenuDialogControlSet.access$0((DynamicMenuDialogControlSet)this.this$1)).computeSize((int)Math.max((int)300, (int)DynamicMenuDialogControlSet.access$0((DynamicMenuDialogControlSet)this.this$1).getClientArea().width), (int)-1).y);
                    }
                }

                public void mouseDown(MouseEvent e) {
                    DialogWidget.access$0(DynamicMenuDialogControlSet.access$0(this.this$1)).forceFocus();
                }

                public void mouseUp(MouseEvent e) {
                }
            });
            this.gridCellManager.addCell((Control)optionGrammarText, new String[]{this.mso.getName(), "MEDIA", "OPTIONS", "VOICE"});
            this.optionGrammarMap.put(option, optionGrammarText);
            RowDivider ord3 = DialogWidget.this.createRowDivider(DialogWidget.this.canvas, DialogWidget.this.dividerColor);
            controlList.add((Object)ord3);
            this.gridCellManager.addCell((Control)ord3, new String[]{this.mso.getName(), "MEDIA", "OPTIONS", "DTMF"});
            Label optionDTMFLabel = DialogWidget.this.createOptionChildLabel(DialogWidget.this.canvas, "DTMF Value");
            controlList.add(optionDTMFLabel);
            this.gridCellManager.addCell((Control)optionDTMFLabel, new String[]{this.mso.getName(), "MEDIA", "OPTIONS", "DTMF"});
            Combo dtmfCombo = DialogWidget.this.createValueDropDown(DialogWidget.this.canvas);
            dtmfCombo.add("0");
            dtmfCombo.add("1");
            dtmfCombo.add("2");
            dtmfCombo.add("3");
            dtmfCombo.add("4");
            dtmfCombo.add("5");
            dtmfCombo.add("6");
            dtmfCombo.add("7");
            dtmfCombo.add("8");
            dtmfCombo.add("9");
            dtmfCombo.add("*");
            dtmfCombo.add("#");
            dtmfCombo.select(option.getDTMF());
            dtmfCombo.addSelectionListener(new SelectionListener(this, option, dtmfCombo){
                final /* synthetic */ DynamicMenuDialogControlSet this$1;
                private final /* synthetic */ MenuOption val$option;
                private final /* synthetic */ Combo val$dtmfCombo;
                {
                    this.this$1 = dynamicMenuDialogControlSet;
                    this.val$option = menuOption;
                    this.val$dtmfCombo = combo;
                }

                public void widgetSelected(SelectionEvent e) {
                    ((DynamicMenuOption)this.val$option).setDTMF(this.val$dtmfCombo.getSelectionIndex());
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            controlList.add(dtmfCombo);
            this.gridCellManager.addCell((Control)dtmfCombo, new String[]{this.mso.getName(), "MEDIA", "OPTIONS", "DTMF"});
            RowDivider ord5 = DialogWidget.this.createRowDivider(DialogWidget.this.canvas, DialogWidget.this.dividerColor);
            controlList.add((Object)ord5);
            this.gridCellManager.addCell((Control)ord5, new String[]{this.mso.getName(), "MEDIA", "OPTIONS", "DTMF"});
            Label optionSilentLabel = DialogWidget.this.createOptionChildLabel(DialogWidget.this.canvas, "Option is Silent");
            controlList.add(optionSilentLabel);
            this.gridCellManager.addCell((Control)optionSilentLabel, new String[]{this.mso.getName(), "MEDIA", "OPTIONS", "DTMF"});
            Combo silentCombo = DialogWidget.this.createValueDropDown(DialogWidget.this.canvas);
            silentCombo.add("true");
            silentCombo.add("false");
            silentCombo.select(((DynamicMenuOption)option).isSilent() ? 0 : 1);
            silentCombo.addSelectionListener(new SelectionListener(this, option, silentCombo){
                final /* synthetic */ DynamicMenuDialogControlSet this$1;
                private final /* synthetic */ MenuOption val$option;
                private final /* synthetic */ Combo val$silentCombo;
                {
                    this.this$1 = dynamicMenuDialogControlSet;
                    this.val$option = menuOption;
                    this.val$silentCombo = combo;
                }

                public void widgetSelected(SelectionEvent e) {
                    ((DynamicMenuOption)this.val$option).setSilent(this.val$silentCombo.getSelectionIndex() == 0);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            controlList.add(silentCombo);
            this.gridCellManager.addCell((Control)silentCombo, new String[]{this.mso.getName(), "MEDIA", "OPTIONS", "DTMF"});
            return controlList;
        }

        static /* synthetic */ DialogWidget access$0(DynamicMenuDialogControlSet dynamicMenuDialogControlSet) {
            return dynamicMenuDialogControlSet.DialogWidget.this;
        }
    }

    private class MessageDialogControlSet
    extends DialogControlSet {
        Label messagePromptText;

        public MessageDialogControlSet(MediaScriptObject mso) {
            super(mso);
        }

        public void update() {
            super.update();
            this.listenerUpdate = false;
            DialogAggregate da = (DialogAggregate)DialogWidget.this.dialogDataMap.get(this.mso.getName());
            if (da != null) {
                this.updateMediaSection(da);
            }
            this.listenerUpdate = true;
            DialogWidget.this.canvas.layout(true, true);
            DialogWidget.this.setMinSize(300, ((DialogWidget)DialogWidget.this).canvas.computeSize((int)Math.max((int)300, (int)DialogWidget.this.getClientArea().width), (int)-1).y);
        }

        public void updateMediaSection(DialogAggregate da) {
            this.messagePromptText.setText(DialogWidget.this.getPromptText(this.mso, da.getMessagePrompt()));
        }

        public void createMediaSection() {
            Label fieldPromptLabel = DialogWidget.this.createPropertyLabel(DialogWidget.this.canvas, "Prompt");
            this.gridCellManager.addCell((Control)fieldPromptLabel, new String[]{this.mso.getName(), "MEDIA"});
            this.messagePromptText = new Label(DialogWidget.this.canvas, 64);
            this.messagePromptText.setBackground(DialogWidget.this.canvas.getBackground());
            GridData gd = new GridData(768);
            gd.horizontalAlignment = 131072;
            this.messagePromptText.setLayoutData((Object)gd);
            this.messagePromptText.addMouseListener(new MouseListener(this){
                final /* synthetic */ MessageDialogControlSet this$1;
                {
                    this.this$1 = messageDialogControlSet;
                }

                public void mouseDoubleClick(MouseEvent e) {
                    DialogAggregate da = (DialogAggregate)DialogWidget.access$1(MessageDialogControlSet.access$0(this.this$1)).get(this.this$1.mso.getName());
                    if (da != null) {
                        da.setMessagePrompt(MessageDialogControlSet.access$0(this.this$1).editPrompt("Message Prompt", da.getMessagePrompt()));
                        this.this$1.messagePromptText.setText(DialogWidget.access$12(MessageDialogControlSet.access$0(this.this$1), this.this$1.mso, da.getMessagePrompt()));
                        DialogWidget.access$0(MessageDialogControlSet.access$0(this.this$1)).layout(true, false);
                        MessageDialogControlSet.access$0(this.this$1).setMinSize(300, DialogWidget.access$0((DialogWidget)MessageDialogControlSet.access$0((MessageDialogControlSet)this.this$1)).computeSize((int)Math.max((int)300, (int)MessageDialogControlSet.access$0((MessageDialogControlSet)this.this$1).getClientArea().width), (int)-1).y);
                    }
                }

                public void mouseDown(MouseEvent e) {
                    DialogWidget.access$0(MessageDialogControlSet.access$0(this.this$1)).forceFocus();
                }

                public void mouseUp(MouseEvent e) {
                }
            });
            this.gridCellManager.addCell((Control)this.messagePromptText, new String[]{this.mso.getName(), "MEDIA"});
        }

        static /* synthetic */ DialogWidget access$0(MessageDialogControlSet messageDialogControlSet) {
            return messageDialogControlSet.DialogWidget.this;
        }
    }

    private class CustomMessageDialogControlSet
    extends MessageDialogControlSet {
        Map customEntityControls;

        public CustomMessageDialogControlSet(MediaScriptObject mso) {
            super(mso);
        }

        public void createMediaSection() {
            List entities = ((MediaScriptCustomObject)this.mso).getCustomEntities();
            int i = 0;
            while (i < entities.size()) {
                if (i != 0) {
                    RowDivider rd1 = DialogWidget.this.createRowDivider(DialogWidget.this.canvas, DialogWidget.this.dividerColor);
                    this.gridCellManager.addCell((Control)rd1, new String[]{this.mso.getName(), "MEDIA"});
                }
                String entityName = (String)entities.get(i);
                Label fieldPromptLabel = DialogWidget.this.createPropertyLabel(DialogWidget.this.canvas, (String)entities.get(i));
                this.gridCellManager.addCell((Control)fieldPromptLabel, new String[]{this.mso.getName(), "MEDIA"});
                Label fieldPromptText = new Label(DialogWidget.this.canvas, 64);
                fieldPromptText.setBackground(DialogWidget.this.canvas.getBackground());
                GridData gd = new GridData(768);
                gd.horizontalAlignment = 131072;
                fieldPromptText.setLayoutData((Object)gd);
                fieldPromptText.addMouseListener(new MouseListener(this, entityName, fieldPromptText){
                    final /* synthetic */ CustomMessageDialogControlSet this$1;
                    private final /* synthetic */ String val$entityName;
                    private final /* synthetic */ Label val$fieldPromptText;
                    {
                        this.this$1 = customMessageDialogControlSet;
                        this.val$entityName = string;
                        this.val$fieldPromptText = label;
                    }

                    public void mouseDoubleClick(MouseEvent e) {
                        DialogAggregate da = (DialogAggregate)DialogWidget.access$1(CustomMessageDialogControlSet.access$0(this.this$1)).get(this.this$1.mso.getName());
                        if (da != null) {
                            da.setCustomPrompt(this.val$entityName, CustomMessageDialogControlSet.access$0(this.this$1).editPrompt(this.val$entityName, da.getCustomPrompt(this.val$entityName)));
                            this.val$fieldPromptText.setText(DialogWidget.access$12(CustomMessageDialogControlSet.access$0(this.this$1), this.this$1.mso, da.getCustomPrompt(this.val$entityName)));
                            DialogWidget.access$0(CustomMessageDialogControlSet.access$0(this.this$1)).layout(true, true);
                            CustomMessageDialogControlSet.access$0(this.this$1).setMinSize(300, DialogWidget.access$0((DialogWidget)CustomMessageDialogControlSet.access$0((CustomMessageDialogControlSet)this.this$1)).computeSize((int)Math.max((int)300, (int)CustomMessageDialogControlSet.access$0((CustomMessageDialogControlSet)this.this$1).getClientArea().width), (int)-1).y);
                        }
                    }

                    public void mouseDown(MouseEvent e) {
                        DialogWidget.access$0(CustomMessageDialogControlSet.access$0(this.this$1)).forceFocus();
                    }

                    public void mouseUp(MouseEvent e) {
                    }
                });
                this.gridCellManager.addCell((Control)fieldPromptText, new String[]{this.mso.getName(), "MEDIA"});
                if (this.customEntityControls == null) {
                    this.customEntityControls = new HashMap();
                }
                this.customEntityControls.put(entities.get(i), fieldPromptText);
                ++i;
            }
        }

        public void updateMediaSection(DialogAggregate da) {
            List entities = ((MediaScriptCustomObject)this.mso).getCustomEntities();
            int i = 0;
            while (i < entities.size()) {
                String entityName = (String)entities.get(i);
                ((Label)this.customEntityControls.get(entityName)).setText(DialogWidget.this.getPromptText(this.mso, da.getCustomPrompt(entityName)));
                ++i;
            }
        }

        static /* synthetic */ DialogWidget access$0(CustomMessageDialogControlSet customMessageDialogControlSet) {
            return customMessageDialogControlSet.DialogWidget.this;
        }
    }

    private class PromptRenderer
    extends PromptVisitorAdapter {
        private PromptRenderer() {
        }

        public Object charactersPrompt(CharactersPrompt arg0) {
            return arg0.getCharacters().toUpperCase();
        }

        public Object filePrompt(FilePrompt arg0) {
            String txt = DialogWidget.this.bi.getAlternateText(arg0.getPath());
            if (txt == null || txt.length() == 0) {
                txt = arg0.getPath();
            }
            return txt;
        }

        public Object textPrompt(TextPrompt arg0) {
            return arg0.getContent();
        }

        public Object variablePrompt(VariablePrompt variablePrompt) {
            return "[" + variablePrompt.getVariable() + "]";
        }
    }
}

