/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.ui.app.wizards;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.eclipse.vtp.desktop.core.DesktopCorePlugin;
import org.eclipse.vtp.desktop.core.localdata.ILocalDomain;
import org.eclipse.vtp.desktop.core.localdata.ILocalLanguagePack;
import org.eclipse.vtp.desktop.core.localdata.ILocalVendor;
import org.eclipse.vtp.desktop.core.project.IApplicationProject;
import org.eclipse.vtp.desktop.core.project.IPersonaProject;
import org.eclipse.vtp.desktop.core.project.ISupportedLanguage;
import org.eclipse.vtp.desktop.core.project.internals.SupportedLanguage;
import org.eclipse.vtp.desktop.ui.app.ApplicationUIPlugin;
import org.eclipse.vtp.desktop.ui.app.wizards.CreateApplicationWizard;

public class CreateApplicationWizard
extends Wizard
implements INewWizard,
IExecutableExtension {
    ApplicationPage page = new ApplicationPage();
    PersonaSelectionPage personaSelectionPage = null;
    IConfigurationElement configElement = null;

    public CreateApplicationWizard() {
        this.addPage((IWizardPage)this.page);
        this.personaSelectionPage = new PersonaSelectionPage();
        this.addPage((IWizardPage)this.personaSelectionPage);
    }

    public boolean performFinish() {
        IProject newProject = ResourcesPlugin.getWorkspace().getRoot().getProject(this.page.getApplicationName());
        try {
            newProject.create(null);
            newProject.open(null);
            IProjectDescription desc = newProject.getDescription();
            desc.setNatureIds(new String[]{"org.eclipse.vtp.desktop.core.VoiceApplicationNature"});
            newProject.setDescription(desc, null);
            DesktopCorePlugin.initializeApplicationStructure((IProject)newProject, (String)"", (String)this.page.getApplicationName());
            IApplicationProject ap = DesktopCorePlugin.convertToApplication((IProject)newProject);
            ap.setSupportedLanguages(new ArrayList<ISupportedLanguage>(Arrays.asList(this.personaSelectionPage.ls.toArray())));
            BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.configElement);
        }
        catch (CoreException ce) {
            ce.printStackTrace();
        }
        return true;
    }

    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
        this.configElement = cfig;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public class ApplicationPage
    extends WizardPage {
        Text nameField;

        public ApplicationPage() {
            super("CreateApplicationPage", "Create Application", null);
            this.nameField = null;
            this.setPageComplete(false);
        }

        public void createControl(Composite parent) {
            Composite comp = new Composite(parent, 0);
            this.setControl((Control)comp);
            Label hostLabel = new Label(comp, 0);
            hostLabel.setText("Application Name:");
            hostLabel.setSize(hostLabel.computeSize(-1, -1));
            this.nameField = new Text(comp, 2052);
            this.nameField.addKeyListener(new KeyListener(this){
                final /* synthetic */ ApplicationPage this$1;
                {
                    this.this$1 = applicationPage;
                }

                public void keyPressed(KeyEvent e) {
                }

                public void keyReleased(KeyEvent e) {
                    if (this.this$1.nameField.getText().length() == 0) {
                        this.this$1.setPageComplete(false);
                    } else {
                        IProject[] existingProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                        int i = 0;
                        while (i < existingProjects.length) {
                            if (this.this$1.nameField.getText().equalsIgnoreCase(existingProjects[i].getName())) {
                                this.this$1.setPageComplete(false);
                                this.this$1.setErrorMessage("Another project already exists with that name.");
                                return;
                            }
                            ++i;
                        }
                        this.this$1.setPageComplete(true);
                        this.this$1.setErrorMessage(null);
                    }
                }
            });
            FormLayout formLayout = new FormLayout();
            formLayout.marginHeight = 10;
            formLayout.marginWidth = 10;
            comp.setLayout((Layout)formLayout);
            FormData hostLabelFormData = new FormData();
            hostLabelFormData.left = new FormAttachment(0, 10);
            hostLabelFormData.top = new FormAttachment(0, 10);
            hostLabelFormData.right = new FormAttachment(0, 10 + hostLabel.getSize().x);
            hostLabelFormData.bottom = new FormAttachment(0, 10 + hostLabel.getSize().y);
            hostLabel.setLayoutData((Object)hostLabelFormData);
            FormData hostFieldFormData = new FormData();
            hostFieldFormData.left = new FormAttachment((Control)hostLabel, 6);
            hostFieldFormData.top = new FormAttachment(0, 10);
            hostFieldFormData.right = new FormAttachment(100, -10);
            this.nameField.setLayoutData((Object)hostFieldFormData);
        }

        public String getApplicationName() {
            return this.nameField.getText();
        }
    }

    public class PersonaSelectionPage
    extends WizardPage {
        TreeViewer personaViewer;
        LanguageStructure ls;
        ComboBoxCellEditor personaEditor;
        List personaProjects;
        List currentList;
        ILocalDomain domain;

        public PersonaSelectionPage() {
            super("SelectPersonaPage", "Language Support", null);
            this.ls = new LanguageStructure();
            this.currentList = new ArrayList();
            this.domain = null;
            this.setPageComplete(false);
        }

        public void createControl(Composite parent) {
            Composite personaComp = new Composite(parent, 0);
            personaComp.setLayout((Layout)new GridLayout(2, false));
            Label personaTableLabel = new Label(personaComp, 0);
            personaTableLabel.setText("Currently supported languages");
            Composite blankComp = new Composite(personaComp, 0);
            GridData bgd = new GridData();
            bgd.heightHint = 1;
            bgd.widthHint = 1;
            bgd.grabExcessHorizontalSpace = false;
            bgd.grabExcessVerticalSpace = false;
            blankComp.setLayoutData((Object)bgd);
            Tree personaTree = new Tree(personaComp, 67588);
            personaTree.setHeaderVisible(true);
            personaTree.setLinesVisible(true);
            personaTree.setLayoutData((Object)new GridData(1808));
            TreeColumn languageColumn = new TreeColumn(personaTree, 0);
            languageColumn.setText("Language");
            languageColumn.setWidth(200);
            TreeColumn personaColumn = new TreeColumn(personaTree, 0);
            personaColumn.setText("Persona");
            personaColumn.setWidth(150);
            this.personaEditor = new ComboBoxCellEditor((Composite)personaTree, new String[]{"1", "2", "3"}, 12);
            this.personaViewer = new TreeViewer(personaTree);
            this.personaViewer.setColumnProperties(new String[]{"Language", "Persona"});
            this.personaViewer.setContentProvider((IContentProvider)new PersonaContentProvider());
            this.personaViewer.setLabelProvider((IBaseLabelProvider)new PersonaLabelProvider());
            this.personaViewer.setCellModifier((ICellModifier)new PersonaCellModifier());
            CellEditor[] cellEditorArray = new CellEditor[2];
            cellEditorArray[1] = this.personaEditor;
            this.personaViewer.setCellEditors(cellEditorArray);
            this.personaViewer.setInput((Object)this);
            Composite buttonComp = new Composite(personaComp, 0);
            GridLayout gl = new GridLayout();
            buttonComp.setLayout((Layout)gl);
            GridData gd = new GridData();
            gd.verticalAlignment = 128;
            buttonComp.setLayoutData((Object)gd);
            Button addButton = new Button(buttonComp, 8);
            addButton.setText("Add Variant");
            addButton.setLayoutData((Object)new GridData(768));
            addButton.setEnabled(false);
            addButton.addSelectionListener(new SelectionListener(this, addButton){
                final /* synthetic */ PersonaSelectionPage this$1;
                private final /* synthetic */ Button val$addButton;
                {
                    this.this$1 = personaSelectionPage;
                    this.val$addButton = button;
                }

                public void widgetSelected(SelectionEvent e) {
                    LanguageStructure.Entry entry = (LanguageStructure.Entry)((IStructuredSelection)this.this$1.personaViewer.getSelection()).getFirstElement();
                    if (!entry.getSupportedLanguage().getLocale().getVariant().equals("")) {
                        entry = entry.getParent();
                    }
                    List children = entry.getChildren();
                    InputDialog variantDialog = new InputDialog(this.val$addButton.getShell(), "Add New Variant", "Please enter the name of the new variant", "", new IInputValidator(this, children){
                        final /* synthetic */ 2 this$2;
                        private final /* synthetic */ List val$children;
                        {
                            this.this$2 = var1_1;
                            this.val$children = list;
                        }

                        public String isValid(String newText) {
                            Iterator<E> iterator = this.val$children.iterator();
                            while (iterator.hasNext()) {
                                LanguageStructure.Entry le = (LanguageStructure.Entry)iterator.next();
                                if (!le.getSupportedLanguage().getLocale().getVariant().equalsIgnoreCase(newText)) continue;
                                return "That language variant already exists";
                            }
                            return null;
                        }
                    });
                    int result = variantDialog.open();
                    if (result == 0) {
                        this.this$1.ls.addLanguageSupport(new Locale(entry.getSupportedLanguage().getLocale().getLanguage(), entry.getSupportedLanguage().getLocale().getCountry(), variantDialog.getValue()), null);
                        this.this$1.personaViewer.refresh((Object)entry, true);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            Button removeButton = new Button(buttonComp, 8);
            removeButton.setText("Remove Variant");
            removeButton.setLayoutData((Object)new GridData(768));
            removeButton.setEnabled(false);
            removeButton.addSelectionListener(new SelectionListener(this){
                final /* synthetic */ PersonaSelectionPage this$1;
                {
                    this.this$1 = personaSelectionPage;
                }

                public void widgetSelected(SelectionEvent e) {
                    IStructuredSelection selection = (IStructuredSelection)this.this$1.personaViewer.getSelection();
                    LanguageStructure.Entry entry = (LanguageStructure.Entry)selection.getFirstElement();
                    entry.getParent().removeChild(entry.getSupportedLanguage().getLocale());
                    this.this$1.personaViewer.refresh((Object)entry.getParent());
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.personaViewer.addSelectionChangedListener(new ISelectionChangedListener(this, addButton, removeButton){
                final /* synthetic */ PersonaSelectionPage this$1;
                private final /* synthetic */ Button val$addButton;
                private final /* synthetic */ Button val$removeButton;
                {
                    this.this$1 = personaSelectionPage;
                    this.val$addButton = button;
                    this.val$removeButton = button2;
                }

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    LanguageStructure.Entry entry = (LanguageStructure.Entry)selection.getFirstElement();
                    if (entry != null) {
                        this.val$addButton.setEnabled(entry.getParent() != null);
                        this.val$removeButton.setEnabled(entry.getParent() == null ? false : entry.getParent().getParent() != null);
                    } else {
                        this.val$addButton.setEnabled(false);
                        this.val$removeButton.setEnabled(false);
                    }
                }
            });
            this.setControl((Control)personaComp);
            this.domain = DesktopCorePlugin.getDefault().getLocalDomain();
            this.ls = new LanguageStructure();
            this.personaProjects = new ArrayList();
            IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int i = 0;
            while (i < projects.length) {
                try {
                    if (projects[i].hasNature("org.eclipse.vtp.desktop.core.VoicePersonaNature")) {
                        IPersonaProject pp = DesktopCorePlugin.convertToPersona((IProject)projects[i]);
                        this.personaProjects.add(pp);
                    }
                }
                catch (CoreException e1) {
                    e1.printStackTrace();
                }
                ++i;
            }
            List vendors = this.domain.getVendors();
            Iterator vendorIterator = vendors.iterator();
            while (vendorIterator.hasNext()) {
                ILocalVendor localVendor = (ILocalVendor)vendorIterator.next();
                List languagePacks = localVendor.getLanguagePacks();
                Iterator languagePackIterator = languagePacks.iterator();
                while (languagePackIterator.hasNext()) {
                    ILocalLanguagePack localLanguagePack = (ILocalLanguagePack)languagePackIterator.next();
                    this.ls.addLanguageSupport(localLanguagePack.getLanguageCode(), null);
                }
            }
            this.personaViewer.refresh(true);
        }

        public class PersonaContentProvider
        implements ITreeContentProvider {
            public Object[] getElements(Object inputElement) {
                return PersonaSelectionPage.this.ls.getSupportedLanguages().toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getChildren(Object parentElement) {
                return ((LanguageStructure.Entry)parentElement).getChildren().toArray();
            }

            public Object getParent(Object element) {
                return ((LanguageStructure.Entry)element).getParent();
            }

            public boolean hasChildren(Object element) {
                return ((LanguageStructure.Entry)element).getChildren().size() > 0;
            }
        }

        public class PersonaLabelProvider
        implements ITableLabelProvider {
            public Image getColumnImage(Object element, int columnIndex) {
                LanguageStructure.Entry entry = (LanguageStructure.Entry)element;
                if (columnIndex == 0) {
                    return ApplicationUIPlugin.getDefault().getImageRegistry().get("ICON_FOLDER_OPEN");
                }
                if (columnIndex == 1 && entry.getSupportedLanguage().getSupportingPersona() != null) {
                    return ApplicationUIPlugin.getDefault().getImageRegistry().get("ICON_PERSONA");
                }
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                LanguageStructure.Entry entry = (LanguageStructure.Entry)element;
                Locale locale = entry.getSupportedLanguage().getLocale();
                int level = 0;
                if (!locale.getCountry().equals("")) {
                    ++level;
                }
                if (!locale.getVariant().equals("")) {
                    ++level;
                }
                if (columnIndex == 0) {
                    if (level == 0) {
                        return locale.getDisplayLanguage();
                    }
                    if (level == 1) {
                        return locale.getDisplayCountry();
                    }
                    return locale.getDisplayVariant();
                }
                if (columnIndex == 1) {
                    block14: {
                        block13: {
                            if (entry.getSupportedLanguage().getSupportingPersona() != null) {
                                return entry.getSupportedLanguage().getSupportingPersona().getPersonaName();
                            }
                            if (level != 0) break block13;
                            return "Unsupported";
                        }
                        if (level != 1) break block14;
                        if (entry.getParent().getSupportedLanguage().getSupportingPersona() == null) {
                            return "Unsupported";
                        }
                        return "Inherit from above";
                    }
                    try {
                        if (entry.getParent().getSupportedLanguage().getSupportingPersona() == null && entry.getParent().getParent().getSupportedLanguage().getSupportingPersona() == null) {
                            return "Unsupported";
                        }
                        return "Inherit from above";
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                return "Unknown";
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        }

        public class LanguageStructure {
            Map languageMap = new HashMap();

            public void addLanguageSupport(ISupportedLanguage supportedLanguage) {
                Entry lang;
                Locale locale = supportedLanguage.getLocale();
                Locale languageLocale = new Locale(locale.getLanguage());
                Object obj = this.languageMap.get(languageLocale);
                if (obj == null) {
                    Entry entry = null;
                    entry = locale.equals(languageLocale) ? new Entry(supportedLanguage) : new Entry((ISupportedLanguage)new SupportedLanguage(languageLocale, supportedLanguage.getSupportingPersona()));
                    obj = entry;
                    this.languageMap.put(languageLocale, entry);
                }
                if ((lang = (Entry)obj).getSupportedLanguage().getSupportingPersona() == null) {
                    lang.supportedLanguage = new SupportedLanguage(languageLocale, supportedLanguage.getSupportingPersona());
                }
                if (!languageLocale.equals(locale)) {
                    Entry country;
                    Locale countryLocale = new Locale(locale.getLanguage(), locale.getCountry());
                    obj = lang.getChild(countryLocale);
                    if (obj == null) {
                        Entry entry = null;
                        entry = countryLocale.equals(locale) ? new Entry(supportedLanguage) : new Entry((ISupportedLanguage)new SupportedLanguage(countryLocale, supportedLanguage.getSupportingPersona()));
                        obj = entry;
                        lang.putChild(entry);
                    }
                    if ((country = (Entry)obj).getSupportedLanguage().getSupportingPersona() == null) {
                        country.supportedLanguage = new SupportedLanguage(countryLocale, supportedLanguage.getSupportingPersona());
                    }
                    if (!countryLocale.equals(locale)) {
                        obj = country.getChild(locale);
                        if (obj == null) {
                            obj = new Entry(supportedLanguage);
                            country.putChild((Entry)obj);
                        }
                        Entry variant = (Entry)obj;
                        variant.supportedLanguage = supportedLanguage;
                    } else {
                        country.supportedLanguage = supportedLanguage;
                    }
                } else {
                    lang.supportedLanguage = supportedLanguage;
                }
            }

            public void addLanguageSupport(String localeCode, IPersonaProject persona) {
                String[] parts = localeCode.split("-");
                String languageCode = "";
                String countryCode = "";
                String variantCode = "";
                if (parts.length > 2) {
                    variantCode = parts[2];
                }
                if (parts.length > 1) {
                    countryCode = parts[1];
                }
                languageCode = parts[0];
                this.addLanguageSupport((ISupportedLanguage)new SupportedLanguage(new Locale(languageCode, countryCode, variantCode), persona));
            }

            public void addLanguageSupport(Locale locale, IPersonaProject persona) {
                this.addLanguageSupport((ISupportedLanguage)new SupportedLanguage(locale, persona));
            }

            public List getSupportedLanguages() {
                ArrayList<Entry> ret = new ArrayList<Entry>();
                Collection c = this.languageMap.values();
                Iterator iterator = c.iterator();
                while (iterator.hasNext()) {
                    Entry child = (Entry)iterator.next();
                    ret.add(child);
                }
                return ret;
            }

            public ISupportedLanguage[] toArray() {
                ArrayList<ISupportedLanguage> ret = new ArrayList<ISupportedLanguage>();
                Collection c = this.languageMap.values();
                Iterator iterator = c.iterator();
                while (iterator.hasNext()) {
                    Entry child = (Entry)iterator.next();
                    ret.add(child.getSupportedLanguage());
                    ret.addAll(child.dumpLanguages());
                }
                return ret.toArray(new ISupportedLanguage[ret.size()]);
            }

            public class Entry {
                Entry parentEntry;
                ISupportedLanguage supportedLanguage;
                Map childMap = new HashMap();

                public Entry(ISupportedLanguage supportedLanguage) {
                    this.supportedLanguage = supportedLanguage;
                }

                public ISupportedLanguage getSupportedLanguage() {
                    return this.supportedLanguage;
                }

                public void addChild(ISupportedLanguage child) {
                    Locale childLocale = child.getLocale();
                    Object obj = this.childMap.get(childLocale);
                    if (obj == null) {
                        this.childMap.put(childLocale, new Entry(child));
                    }
                    ((Entry)obj).supportedLanguage = child;
                    ((Entry)obj).parentEntry = this;
                }

                public Entry getParent() {
                    return this.parentEntry;
                }

                public void putChild(Entry child) {
                    this.childMap.put(child.getSupportedLanguage().getLocale(), child);
                    child.parentEntry = this;
                }

                public Entry getChild(Locale childLocale) {
                    return (Entry)this.childMap.get(childLocale);
                }

                public void removeChild(Locale childLocale) {
                    this.childMap.remove(childLocale);
                }

                public List getChildren() {
                    ArrayList<Entry> ret = new ArrayList<Entry>();
                    Collection children = this.childMap.values();
                    Iterator iterator = children.iterator();
                    while (iterator.hasNext()) {
                        Entry child = (Entry)iterator.next();
                        ret.add(child);
                    }
                    return ret;
                }

                public List dumpLanguages() {
                    ArrayList<ISupportedLanguage> ret = new ArrayList<ISupportedLanguage>();
                    Collection children = this.childMap.values();
                    Iterator iterator = children.iterator();
                    while (iterator.hasNext()) {
                        Entry child = (Entry)iterator.next();
                        ret.add(child.getSupportedLanguage());
                        ret.addAll(child.dumpLanguages());
                    }
                    return ret;
                }
            }
        }

        public class PersonaCellModifier
        implements ICellModifier {
            public boolean canModify(Object element, String property) {
                return property.equals("Persona");
            }

            public Object getValue(Object element, String property) {
                LanguageStructure.Entry entry = (LanguageStructure.Entry)element;
                if (property.equals("Persona")) {
                    PersonaSelectionPage.this.currentList.clear();
                    Locale locale = entry.getSupportedLanguage().getLocale();
                    int selected = 0;
                    int pos = 0;
                    Iterator iterator = PersonaSelectionPage.this.personaProjects.iterator();
                    while (iterator.hasNext()) {
                        IPersonaProject pp = (IPersonaProject)iterator.next();
                        String languageCode = "";
                        try {
                            languageCode = pp.getLanguageCode();
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                        }
                        if (!locale.getVariant().equals("")) {
                            if (languageCode.equals(String.valueOf(locale.getLanguage()) + "-" + locale.getCountry())) {
                                PersonaSelectionPage.this.currentList.add(pp);
                                if (pp.equals(entry.getSupportedLanguage().getSupportingPersona())) {
                                    selected = pos;
                                }
                            }
                        } else if (!locale.getCountry().equals("")) {
                            if (languageCode.equals(String.valueOf(locale.getLanguage()) + "-" + locale.getCountry())) {
                                PersonaSelectionPage.this.currentList.add(pp);
                                if (pp.equals(entry.getSupportedLanguage().getSupportingPersona())) {
                                    selected = pos;
                                }
                            }
                        } else if (languageCode.startsWith(locale.getLanguage())) {
                            PersonaSelectionPage.this.currentList.add(pp);
                            if (pp.equals(entry.getSupportedLanguage().getSupportingPersona())) {
                                selected = pos;
                            }
                        }
                        ++pos;
                    }
                    if (!locale.getVariant().equals("")) {
                        PersonaSelectionPage.this.currentList.add(0, null);
                    } else if (!locale.getCountry().equals("")) {
                        PersonaSelectionPage.this.currentList.add(0, null);
                    } else {
                        boolean foundOne = false;
                        List langs = entry.dumpLanguages();
                        int i = 0;
                        while (i < langs.size()) {
                            if (((ISupportedLanguage)langs.get(i)).getSupportingPersona() != null) {
                                foundOne = true;
                                break;
                            }
                            ++i;
                        }
                        if (!foundOne) {
                            PersonaSelectionPage.this.currentList.add(0, null);
                        }
                    }
                    String[] items = new String[PersonaSelectionPage.this.currentList.size()];
                    int i = 0;
                    while (i < items.length) {
                        Object obj = PersonaSelectionPage.this.currentList.get(i);
                        if (obj == null) {
                            items[i] = !locale.getVariant().equals("") ? (entry.getParent().getSupportedLanguage().getSupportingPersona() == null && entry.getParent().getParent().getSupportedLanguage().getSupportingPersona() == null ? "Unsupported" : "Inherit from above") : (!locale.getCountry().equals("") ? (entry.getParent().getSupportedLanguage().getSupportingPersona() == null ? "Unsupported" : "Inherit from above") : "Unsupported");
                        } else {
                            IPersonaProject pp = (IPersonaProject)PersonaSelectionPage.this.currentList.get(i);
                            try {
                                items[i] = pp.getPersonaName();
                            }
                            catch (CoreException e) {
                                e.printStackTrace();
                                items[i] = "Error";
                            }
                        }
                        ++i;
                    }
                    PersonaSelectionPage.this.personaEditor.setItems(items);
                    return new Integer(selected);
                }
                return null;
            }

            public void modify(Object element, String property, Object value) {
                LanguageStructure.Entry entry = (LanguageStructure.Entry)((TreeItem)element).getData();
                if (property.equals("Persona")) {
                    Integer index = (Integer)value;
                    PersonaSelectionPage.this.ls.addLanguageSupport(entry.getSupportedLanguage().getLocale(), (IPersonaProject)PersonaSelectionPage.this.currentList.get(index));
                    PersonaSelectionPage.this.personaViewer.refresh((Object)entry, true);
                    if (entry.getParent() != null) {
                        PersonaSelectionPage.this.personaViewer.refresh((Object)entry.getParent(), true);
                        if (entry.getParent().getParent() != null) {
                            PersonaSelectionPage.this.personaViewer.refresh((Object)entry.getParent().getParent(), true);
                        }
                    }
                    List sl = PersonaSelectionPage.this.ls.getSupportedLanguages();
                    boolean finished = true;
                    int i = 0;
                    while (i < sl.size()) {
                        entry = (LanguageStructure.Entry)sl.get(i);
                        ISupportedLanguage isl = entry.getSupportedLanguage();
                        finished &= isl.getSupportingPersona() != null;
                        ++i;
                    }
                    PersonaSelectionPage.this.setPageComplete(finished);
                }
            }
        }
    }
}

