/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.ui.app.wizards;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.eclipse.vtp.desktop.core.DesktopCorePlugin;
import org.eclipse.vtp.desktop.core.localdata.ILocalDomain;
import org.eclipse.vtp.desktop.core.localdata.ILocalLanguagePack;
import org.eclipse.vtp.desktop.core.localdata.ILocalVendor;

public class CreatePersonaWizard
extends Wizard
implements INewWizard,
IExecutableExtension {
    private PersonaInformationPage personaInformationPage = new PersonaInformationPage();
    private IConfigurationElement configElement = null;

    public CreatePersonaWizard() {
        this.addPage((IWizardPage)this.personaInformationPage);
    }

    public boolean performFinish() {
        IProject newProject = ResourcesPlugin.getWorkspace().getRoot().getProject(this.personaInformationPage.personaName.getText());
        try {
            newProject.create(null);
            newProject.open(null);
            IProjectDescription desc = newProject.getDescription();
            desc.setNatureIds(new String[]{"org.eclipse.vtp.desktop.core.VoicePersonaNature"});
            newProject.setDescription(desc, null);
            ILocalLanguagePack llp = (ILocalLanguagePack)this.personaInformationPage.languagePacks.get(this.personaInformationPage.languagePackSelector.getSelectionIndex());
            DesktopCorePlugin.initializePersonaStructure((IProject)newProject, (String)newProject.getName(), (String)"", (String)llp.getLanguageCode(), (String)llp.getId());
            BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.configElement);
        }
        catch (CoreException ce) {
            ce.printStackTrace();
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
        this.configElement = cfig;
    }

    private class PersonaInformationPage
    extends WizardPage {
        Text personaName;
        Combo languagePackSelector;
        List languagePacks;

        public PersonaInformationPage() {
            super("PersonaInformationPage", "Persona Information", null);
            this.languagePacks = new ArrayList();
        }

        public void createControl(Composite parent) {
            this.setPageComplete(false);
            Composite comp = new Composite(parent, 0);
            GridLayout gl = new GridLayout();
            gl.numColumns = 2;
            gl.makeColumnsEqualWidth = false;
            comp.setLayout((Layout)gl);
            Label nameLabel = new Label(comp, 0);
            nameLabel.setText("Name:");
            this.personaName = new Text(comp, 2052);
            this.personaName.addKeyListener(new KeyListener(this){
                final /* synthetic */ PersonaInformationPage this$1;
                {
                    this.this$1 = personaInformationPage;
                }

                public void keyPressed(KeyEvent e) {
                }

                public void keyReleased(KeyEvent e) {
                    boolean ok = true;
                    IProject[] projs = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                    int i = 0;
                    while (i < projs.length) {
                        if (projs[i].getName().equalsIgnoreCase(this.this$1.personaName.getText())) {
                            this.this$1.setPageComplete(false);
                            this.this$1.setErrorMessage("There is already a project with that name.");
                            ok = false;
                        }
                        ++i;
                    }
                    if (ok) {
                        this.this$1.setPageComplete(true);
                        this.this$1.setErrorMessage(null);
                    }
                }
            });
            Label languageLabel = new Label(comp, 0);
            languageLabel.setText("Language:");
            this.languagePackSelector = new Combo(comp, 2060);
            nameLabel.setLayoutData((Object)new GridData());
            this.personaName.setLayoutData((Object)new GridData(768));
            languageLabel.setLayoutData((Object)new GridData());
            this.languagePackSelector.setLayoutData((Object)new GridData(768));
            this.setControl((Control)comp);
            ILocalDomain domain = DesktopCorePlugin.getDefault().getLocalDomain();
            this.languagePacks.clear();
            this.languagePackSelector.removeAll();
            List vendors = domain.getVendors();
            Iterator iterator = vendors.iterator();
            while (iterator.hasNext()) {
                ILocalVendor vendor = (ILocalVendor)iterator.next();
                List vendorLanguagePacks = vendor.getLanguagePacks();
                int i = 0;
                while (i < vendorLanguagePacks.size()) {
                    ILocalLanguagePack localLanguagePack = (ILocalLanguagePack)vendorLanguagePacks.get(i);
                    this.languagePacks.add(localLanguagePack);
                    String languageCode = localLanguagePack.getLanguageCode();
                    String[] parts = languageCode.split("-");
                    Locale locale = parts.length > 1 ? new Locale(parts[0], parts[1]) : new Locale(parts[0]);
                    this.languagePackSelector.add(String.valueOf(locale.getDisplayName()) + " [" + localLanguagePack.getVendor().getName() + "]");
                    ++i;
                }
            }
            this.languagePackSelector.select(0);
        }
    }
}

