/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.impl.CalendarData;
import com.ibm.icu.impl.UCharacterProperty;
import com.ibm.icu.impl.ZoneMeta;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.DateFormatSymbols;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.ref.SoftReference;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.text.ParsePosition;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;

public class SimpleDateFormat
extends DateFormat {
    private static final long serialVersionUID = 4774881970558875024L;
    static final int currentSerialVersion = 1;
    private int serialVersionOnStream = 1;
    private String pattern;
    private DateFormatSymbols formatData;
    private transient ULocale locale;
    private Date defaultCenturyStart;
    private transient int defaultCenturyStartYear;
    private transient TimeZone parsedTimeZone;
    private static final int millisPerHour = 3600000;
    private static final int millisPerMinute = 60000;
    private static final String GMT_PLUS = "GMT+";
    private static final String GMT_MINUS = "GMT-";
    private static final String GMT = "GMT";
    private static final String SUPPRESS_NEGATIVE_PREFIX = "\uab00";
    private static Hashtable cachedLocaleData = new Hashtable(3);
    private transient boolean useFastFormat;
    private static final boolean CACHE = true;
    private static long cacheAge;
    private static SoftReference highCacheRef;
    private static final int[] PATTERN_INDEX_TO_CALENDAR_FIELD;
    private static final int[] PATTERN_INDEX_TO_DATE_FORMAT_FIELD;
    private static final String NUMERIC_FORMAT_CHARS = "MyudhHmsSDFwWkK";
    static /* synthetic */ Class class$0;

    static {
        int[] nArray = new int[27];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 5;
        nArray[4] = 11;
        nArray[5] = 11;
        nArray[6] = 12;
        nArray[7] = 13;
        nArray[8] = 14;
        nArray[9] = 7;
        nArray[10] = 6;
        nArray[11] = 8;
        nArray[12] = 3;
        nArray[13] = 4;
        nArray[14] = 9;
        nArray[15] = 10;
        nArray[16] = 10;
        nArray[17] = 15;
        nArray[18] = 17;
        nArray[19] = 18;
        nArray[20] = 19;
        nArray[21] = 20;
        nArray[22] = 21;
        nArray[23] = 15;
        nArray[24] = 15;
        nArray[25] = 7;
        nArray[26] = 2;
        PATTERN_INDEX_TO_CALENDAR_FIELD = nArray;
        int[] nArray2 = new int[27];
        nArray2[1] = 1;
        nArray2[2] = 2;
        nArray2[3] = 3;
        nArray2[4] = 4;
        nArray2[5] = 5;
        nArray2[6] = 6;
        nArray2[7] = 7;
        nArray2[8] = 8;
        nArray2[9] = 9;
        nArray2[10] = 10;
        nArray2[11] = 11;
        nArray2[12] = 12;
        nArray2[13] = 13;
        nArray2[14] = 14;
        nArray2[15] = 15;
        nArray2[16] = 16;
        nArray2[17] = 17;
        nArray2[18] = 18;
        nArray2[19] = 19;
        nArray2[20] = 20;
        nArray2[21] = 21;
        nArray2[22] = 22;
        nArray2[23] = 23;
        nArray2[24] = 24;
        nArray2[25] = 25;
        nArray2[26] = 26;
        PATTERN_INDEX_TO_DATE_FORMAT_FIELD = nArray2;
    }

    public SimpleDateFormat() {
        this(3, 3, ULocale.getDefault());
    }

    public SimpleDateFormat(String pattern) {
        this(pattern, ULocale.getDefault());
    }

    public SimpleDateFormat(String pattern, Locale loc) {
        this(pattern, ULocale.forLocale(loc));
    }

    public SimpleDateFormat(String pattern, ULocale loc) {
        this.pattern = pattern;
        this.formatData = new DateFormatSymbols(loc);
        this.initialize(loc);
    }

    public SimpleDateFormat(String pattern, DateFormatSymbols formatData) {
        this(pattern, formatData, ULocale.getDefault());
    }

    public SimpleDateFormat(String pattern, DateFormatSymbols formatData, ULocale loc) {
        this.pattern = pattern;
        this.formatData = (DateFormatSymbols)formatData.clone();
        this.initialize(loc);
    }

    SimpleDateFormat(String pattern, DateFormatSymbols formatData, boolean useFastFormat) {
        this.pattern = pattern;
        this.formatData = (DateFormatSymbols)formatData.clone();
        this.initialize(ULocale.getDefault());
        this.useFastFormat = useFastFormat;
    }

    SimpleDateFormat(int timeStyle, int dateStyle, ULocale loc) {
        SimpleDateFormat target;
        HashMap<String, Object> map = null;
        String key = null;
        long time = System.currentTimeMillis();
        if (time - cacheAge < 86400000L && highCacheRef != null) {
            map = (HashMap<String, Object>)highCacheRef.get();
        }
        if (map == null) {
            map = new HashMap<String, Object>(3);
            highCacheRef = new SoftReference(map);
            cacheAge = time;
        }
        if ((target = (SimpleDateFormat)map.get(key = String.valueOf(loc.toString()) + timeStyle + dateStyle)) != null) {
            this.pattern = target.pattern;
            this.formatData = target.formatData;
            this.defaultCenturyStart = target.defaultCenturyStart;
            this.defaultCenturyStartYear = target.defaultCenturyStartYear;
            this.calendar = (Calendar)target.calendar.clone();
            this.calendar.setTimeZone(TimeZone.getDefault());
            this.numberFormat = (NumberFormat)target.numberFormat.clone();
            return;
        }
        String[] dateTimePatterns = (String[])cachedLocaleData.get(loc);
        if (dateTimePatterns == null) {
            CalendarData calData = new CalendarData(loc, null);
            ULocale uloc = calData.getULocale();
            this.setLocale(uloc, uloc);
            dateTimePatterns = calData.getStringArray("DateTimePatterns");
            cachedLocaleData.put(loc, dateTimePatterns);
        } else {
            this.setLocale(loc, loc);
        }
        this.formatData = new DateFormatSymbols(loc);
        if (timeStyle >= 0 && dateStyle >= 0) {
            Object[] dateTimeArgs = new Object[]{dateTimePatterns[timeStyle], dateTimePatterns[dateStyle + 4]};
            this.pattern = MessageFormat.format(dateTimePatterns[8], dateTimeArgs);
        } else if (timeStyle >= 0) {
            this.pattern = dateTimePatterns[timeStyle];
        } else if (dateStyle >= 0) {
            this.pattern = dateTimePatterns[dateStyle + 4];
        } else {
            throw new IllegalArgumentException("No date or time style specified");
        }
        this.initialize(loc);
        map.put(key, this.clone());
    }

    private void initialize(ULocale loc) {
        this.locale = loc;
        this.calendar = Calendar.getInstance(TimeZone.getDefault(), loc);
        this.numberFormat = NumberFormat.getInstance(loc);
        this.numberFormat.setGroupingUsed(false);
        if (this.numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)this.numberFormat).setDecimalSeparatorAlwaysShown(false);
        }
        this.numberFormat.setParseIntegerOnly(true);
        this.numberFormat.setMinimumFractionDigits(0);
        this.initializeDefaultCentury();
        Class<?> clazz = this.getClass();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("com.ibm.icu.text.SimpleDateFormat");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.useFastFormat = clazz == clazz2;
    }

    private void initializeDefaultCentury() {
        this.calendar.setTime(new Date());
        this.calendar.add(1, -80);
        this.parseAmbiguousDatesAsAfter(this.calendar.getTime());
    }

    private void parseAmbiguousDatesAsAfter(Date startDate) {
        this.defaultCenturyStart = startDate;
        this.calendar.setTime(startDate);
        this.defaultCenturyStartYear = this.calendar.get(1);
    }

    public void set2DigitYearStart(Date startDate) {
        this.parseAmbiguousDatesAsAfter(startDate);
    }

    public Date get2DigitYearStart() {
        return this.defaultCenturyStart;
    }

    public StringBuffer format(Calendar cal, StringBuffer toAppendTo, FieldPosition pos) {
        if (!this.useFastFormat) {
            return this.slowFormat(cal, toAppendTo, pos);
        }
        pos.setBeginIndex(0);
        pos.setEndIndex(0);
        int n = this.pattern.length();
        int i = 0;
        block0: while (i < n) {
            int j;
            char ch = this.pattern.charAt(i);
            if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z') {
                j = i + 1;
                while (j < n && this.pattern.charAt(j) == ch) {
                    ++j;
                }
                this.subFormat(toAppendTo, ch, j - i, toAppendTo.length(), pos, cal);
                i = j;
                continue;
            }
            if (ch == '\'') {
                int start = i + 1;
                while (++i != n) {
                    j = i;
                    while (j < n && this.pattern.charAt(j) != '\'') {
                        ++j;
                    }
                    if (j == start) {
                        toAppendTo.append('\'');
                        ++i;
                        continue block0;
                    }
                    int k = j;
                    int jj = j + 1;
                    if (jj < n && this.pattern.charAt(jj) == '\'') {
                        ++k;
                    }
                    toAppendTo.append(this.pattern.substring(i, k));
                    i = jj;
                    if (k != j) continue;
                    continue block0;
                }
                continue;
            }
            toAppendTo.append(ch);
            ++i;
        }
        return toAppendTo;
    }

    private StringBuffer slowFormat(Calendar cal, StringBuffer toAppendTo, FieldPosition pos) {
        pos.setBeginIndex(0);
        pos.setEndIndex(0);
        boolean inQuote = false;
        char prevCh = '\u0000';
        int count = 0;
        int i = 0;
        while (i < this.pattern.length()) {
            char ch = this.pattern.charAt(i);
            if (ch != prevCh && count > 0) {
                toAppendTo.append(this.subFormat(prevCh, count, toAppendTo.length(), pos, this.formatData, cal));
                count = 0;
            }
            if (ch == '\'') {
                if (i + 1 < this.pattern.length() && this.pattern.charAt(i + 1) == '\'') {
                    toAppendTo.append('\'');
                    ++i;
                } else {
                    inQuote = !inQuote;
                }
            } else if (!inQuote && (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z')) {
                prevCh = ch;
                ++count;
            } else {
                toAppendTo.append(ch);
            }
            ++i;
        }
        if (count > 0) {
            toAppendTo.append(this.subFormat(prevCh, count, toAppendTo.length(), pos, this.formatData, cal));
        }
        return toAppendTo;
    }

    protected String subFormat(char ch, int count, int beginOffset, FieldPosition pos, DateFormatSymbols formatData, Calendar cal) throws IllegalArgumentException {
        StringBuffer buf = new StringBuffer();
        this.subFormat(buf, ch, count, beginOffset, pos, cal);
        return buf.toString();
    }

    protected void subFormat(StringBuffer buf, char ch, int count, int beginOffset, FieldPosition pos, Calendar cal) {
        int bufstart = buf.length();
        int patternCharIndex = "GyMdkHmsSEDFwWahKzYeugAZvcL".indexOf(ch);
        if (patternCharIndex == -1) {
            throw new IllegalArgumentException("Illegal pattern character '" + ch + "' in \"" + new String(this.pattern) + '\"');
        }
        int field = PATTERN_INDEX_TO_CALENDAR_FIELD[patternCharIndex];
        int value = cal.get(field);
        switch (patternCharIndex) {
            case 0: {
                if (count >= 4) {
                    buf.append(this.formatData.eraNames[value]);
                    break;
                }
                buf.append(this.formatData.eras[value]);
                break;
            }
            case 1: {
                if (count == 2) {
                    this.zeroPaddingNumber(buf, value, 2, 2);
                    break;
                }
                this.zeroPaddingNumber(buf, value, count, Integer.MAX_VALUE);
                break;
            }
            case 2: {
                if (count == 5) {
                    buf.append(this.formatData.narrowMonths[value]);
                    break;
                }
                if (count == 4) {
                    buf.append(this.formatData.months[value]);
                    break;
                }
                if (count == 3) {
                    buf.append(this.formatData.shortMonths[value]);
                    break;
                }
                this.zeroPaddingNumber(buf, value + 1, count, Integer.MAX_VALUE);
                break;
            }
            case 4: {
                if (value == 0) {
                    this.zeroPaddingNumber(buf, cal.getMaximum(11) + 1, count, Integer.MAX_VALUE);
                    break;
                }
                this.zeroPaddingNumber(buf, value, count, Integer.MAX_VALUE);
                break;
            }
            case 8: {
                this.numberFormat.setMinimumIntegerDigits(Math.min(3, count));
                this.numberFormat.setMaximumIntegerDigits(Integer.MAX_VALUE);
                if (count == 1) {
                    value = (value + 50) / 100;
                } else if (count == 2) {
                    value = (value + 5) / 10;
                }
                FieldPosition p = new FieldPosition(-1);
                this.numberFormat.format(value, buf, p);
                if (count <= 3) break;
                this.numberFormat.setMinimumIntegerDigits(count - 3);
                this.numberFormat.format(0L, buf, p);
                break;
            }
            case 9: {
                if (count >= 4) {
                    buf.append(this.formatData.weekdays[value]);
                    break;
                }
                buf.append(this.formatData.shortWeekdays[value]);
                break;
            }
            case 14: {
                buf.append(this.formatData.ampms[value]);
                break;
            }
            case 15: {
                if (value == 0) {
                    this.zeroPaddingNumber(buf, cal.getLeastMaximum(10) + 1, count, Integer.MAX_VALUE);
                    break;
                }
                this.zeroPaddingNumber(buf, value, count, Integer.MAX_VALUE);
                break;
            }
            case 17: 
            case 24: {
                boolean isGeneric;
                String res = null;
                String zid = ZoneMeta.getCanonicalID(cal.getTimeZone().getID());
                boolean bl = isGeneric = patternCharIndex == 24;
                if (zid != null) {
                    res = patternCharIndex == 24 ? (count < 4 ? this.formatData.getZoneString(zid, 0) : this.formatData.getZoneString(zid, 3)) : (cal.get(16) != 0 ? (count < 4 ? this.formatData.getZoneString(zid, 2) : this.formatData.getZoneString(zid, 5)) : (count < 4 ? this.formatData.getZoneString(zid, 1) : this.formatData.getZoneString(zid, 4)));
                }
                if (res == null || res.length() == 0) {
                    if (zid == null || !isGeneric || ZoneMeta.getCanonicalCountry(zid) == null) {
                        long offset = cal.get(15) + cal.get(16);
                        res = ZoneMeta.displayGMT(offset, this.locale);
                    } else {
                        String city = this.formatData.getZoneString(zid, 6);
                        res = ZoneMeta.displayFallback(zid, city, this.locale);
                    }
                }
                if (res.length() == 0) {
                    this.appendGMT(buf, cal);
                    break;
                }
                buf.append(res);
                break;
            }
            case 23: {
                if (count < 4) {
                    long val = (cal.get(15) + cal.get(16)) / 60000;
                    char sign = '+';
                    if (val < 0L) {
                        val = -val;
                        sign = '-';
                    }
                    val = val / 3L * 5L + val % 60L;
                    buf.append(sign);
                    buf.append(new DecimalFormat("0000").format(val));
                    break;
                }
                long val = cal.get(15) + cal.get(16);
                buf.append(ZoneMeta.displayGMT(val, this.locale));
                break;
            }
            case 25: {
                if (count == 5) {
                    buf.append(this.formatData.standaloneNarrowWeekdays[value]);
                    break;
                }
                if (count == 4) {
                    buf.append(this.formatData.standaloneWeekdays[value]);
                    break;
                }
                if (count == 3) {
                    buf.append(this.formatData.standaloneShortWeekdays[value]);
                    break;
                }
                this.zeroPaddingNumber(buf, value, 1, Integer.MAX_VALUE);
                break;
            }
            case 26: {
                if (count == 5) {
                    buf.append(this.formatData.standaloneNarrowMonths[value]);
                    break;
                }
                if (count == 4) {
                    buf.append(this.formatData.standaloneMonths[value]);
                    break;
                }
                if (count == 3) {
                    buf.append(this.formatData.standaloneShortMonths[value]);
                    break;
                }
                this.zeroPaddingNumber(buf, value + 1, count, Integer.MAX_VALUE);
                break;
            }
            default: {
                this.zeroPaddingNumber(buf, value, count, Integer.MAX_VALUE);
            }
        }
        if (pos.getBeginIndex() == pos.getEndIndex() && pos.getField() == PATTERN_INDEX_TO_DATE_FORMAT_FIELD[patternCharIndex]) {
            pos.setBeginIndex(beginOffset);
            pos.setEndIndex(beginOffset + buf.length() - bufstart);
        }
    }

    private void appendGMT(StringBuffer buf, Calendar cal) {
        int value = cal.get(15) + cal.get(16);
        if (value < 0) {
            buf.append(GMT_MINUS);
            value = -value;
        } else {
            buf.append(GMT_PLUS);
        }
        this.zeroPaddingNumber(buf, value / 3600000, 2, 2);
        buf.append(':');
        this.zeroPaddingNumber(buf, value % 3600000 / 60000, 2, 2);
    }

    private String getZoneArrayValue(String[] zs, int ix) {
        String result;
        if (ix >= 0 && ix < zs.length && (result = zs[ix]) != null && result.length() != 0) {
            return result;
        }
        return null;
    }

    protected void zeroPaddingNumber(StringBuffer buf, int value, int minDigits, int maxDigits) {
        FieldPosition pos = new FieldPosition(-1);
        this.numberFormat.setMinimumIntegerDigits(minDigits);
        this.numberFormat.setMaximumIntegerDigits(maxDigits);
        this.numberFormat.format(value, buf, pos);
    }

    protected String zeroPaddingNumber(long value, int minDigits, int maxDigits) {
        this.numberFormat.setMinimumIntegerDigits(minDigits);
        this.numberFormat.setMaximumIntegerDigits(maxDigits);
        return this.numberFormat.format(value);
    }

    private static final boolean isNumeric(char formatChar, int count) {
        int i = NUMERIC_FORMAT_CHARS.indexOf(formatChar);
        return i > 0 || i == 0 && count < 3;
    }

    /*
     * Unable to fully structure code
     */
    public void parse(String text, Calendar cal, ParsePosition parsePos) {
        start = pos = parsePos.getIndex();
        ambiguousYear = new boolean[1];
        count = 0;
        this.parsedTimeZone = null;
        abutPat = -1;
        abutStart = 0;
        abutPass = 0;
        inQuote = false;
        i = 0;
        while (i < this.pattern.length()) {
            block24: {
                block27: {
                    block25: {
                        block26: {
                            block23: {
                                ch = this.pattern.charAt(i);
                                if (inQuote || (ch < 'A' || ch > 'Z') && (ch < 'a' || ch > 'z')) break block23;
                                fieldPat = i;
                                count = 1;
                                while (i + 1 < this.pattern.length() && this.pattern.charAt(i + 1) == ch) {
                                    ++count;
                                    ++i;
                                }
                                if (SimpleDateFormat.isNumeric(ch, count)) {
                                    if (abutPat < 0 && i + 1 < this.pattern.length()) {
                                        nextCh = this.pattern.charAt(i + 1);
                                        k = "MyudhHmsSDFwWkK".indexOf(nextCh);
                                        if (k == 0) {
                                            j = i + 2;
                                            while (j < this.pattern.length() && this.pattern.charAt(j) == nextCh) {
                                                ++j;
                                            }
                                            abutting = j - i < 4;
                                        } else {
                                            v0 = abutting = k > 0;
                                        }
                                        if (abutting) {
                                            abutPat = fieldPat;
                                            abutStart = pos;
                                            abutPass = 0;
                                        }
                                    }
                                } else {
                                    abutPat = -1;
                                }
                                if (abutPat >= 0) {
                                    if (fieldPat == abutPat && (count -= abutPass++) == 0) {
                                        parsePos.setIndex(start);
                                        parsePos.setErrorIndex(pos);
                                        return;
                                    }
                                    if ((pos = this.subParse(text, pos, ch, count, true, false, ambiguousYear, cal)) < 0) {
                                        i = abutPat - 1;
                                        pos = abutStart;
                                    }
                                } else {
                                    s = pos;
                                    if ((pos = this.subParse(text, pos, ch, count, false, true, ambiguousYear, cal)) < 0) {
                                        parsePos.setErrorIndex(s);
                                        parsePos.setIndex(start);
                                        return;
                                    }
                                }
                                break block24;
                            }
                            abutPat = -1;
                            if (ch != '\'') break block25;
                            if (i + 1 < this.pattern.length() && this.pattern.charAt(i + 1) == ch) break block26;
                            inQuote = inQuote == false;
                            break block24;
                        }
                        ++i;
                    }
                    if (!UCharacterProperty.isRuleWhiteSpace(ch)) break block27;
                    while (i + 1 < this.pattern.length() && UCharacterProperty.isRuleWhiteSpace(this.pattern.charAt(i + 1))) {
                        ++i;
                    }
                    s = pos;
                    while (pos < text.length() && UCharacter.isUWhiteSpace(text.charAt(pos))) {
                        ++pos;
                    }
                    if (pos <= s) ** GOTO lbl-1000
                    break block24;
                }
                if (pos < text.length() && text.charAt(pos) == ch) {
                    ++pos;
                } else lbl-1000:
                // 2 sources

                {
                    parsePos.setIndex(start);
                    parsePos.setErrorIndex(pos);
                    return;
                }
            }
            ++i;
        }
        parsePos.setIndex(pos);
        try {
            if (ambiguousYear[0] || this.parsedTimeZone != null) {
                copy = (Calendar)cal.clone();
                if (ambiguousYear[0] && (parsedDate = copy.getTime()).before(this.defaultCenturyStart)) {
                    cal.set(1, this.defaultCenturyStartYear + 100);
                }
                if (this.parsedTimeZone != null) {
                    tz = this.parsedTimeZone;
                    offsets = new int[2];
                    tz.getOffset(copy.getTimeInMillis() + (long)tz.getRawOffset(), true, offsets);
                    cal.set(15, offsets[0]);
                    cal.set(16, offsets[1]);
                    cal.setTimeZone(tz);
                }
            }
        }
        catch (IllegalArgumentException v1) {
            parsePos.setErrorIndex(pos);
            parsePos.setIndex(start);
        }
    }

    protected int matchString(String text, int start, int field, String[] data, Calendar cal) {
        int i = 0;
        int count = data.length;
        if (field == 7) {
            i = 1;
        }
        int bestMatchLength = 0;
        int bestMatch = -1;
        while (i < count) {
            int length = data[i].length();
            if (length > bestMatchLength && text.regionMatches(true, start, data[i], 0, length)) {
                bestMatch = i;
                bestMatchLength = length;
            }
            ++i;
        }
        if (bestMatch >= 0) {
            cal.set(field, bestMatch);
            return start + bestMatchLength;
        }
        return -start;
    }

    private int subParseZoneString(String text, int start, Calendar cal) {
        DateFormatSymbols.ZoneItem item;
        TimeZone defaultZone;
        DateFormatSymbols.ZoneItem item2;
        TimeZone tz = null;
        String zid = null;
        String value = null;
        int type = -1;
        zid = this.formatData.getZoneID(this.getTimeZone().getID());
        if (zid != null && (item2 = this.formatData.getZoneItem(zid, text, start)) != null) {
            zid = item2.zid;
            value = item2.value;
            type = item2.type;
            tz = (TimeZone)this.getTimeZone().clone();
        }
        if (tz == null && (zid = this.formatData.getZoneID((defaultZone = TimeZone.getDefault()).getID())) != null && (item = this.formatData.getZoneItem(zid, text, start)) != null) {
            zid = item.zid;
            value = item.value;
            type = item.type;
            tz = defaultZone;
        }
        if (tz == null) {
            item2 = this.formatData.findZoneIDTypeValue(text, start);
            if (item2 != null) {
                zid = item2.zid;
                value = item2.value;
                type = item2.type;
            }
            if (zid != null) {
                tz = TimeZone.getTimeZone(zid);
            }
        }
        if (tz != null) {
            cal.set(15, tz.getRawOffset());
            if (type == 1 || type == 4) {
                cal.set(16, 0);
                tz = null;
            } else if (type == 2 || type == 5) {
                cal.set(16, 3600000);
                tz = null;
            } else {
                this.parsedTimeZone = tz;
            }
            if (value != null) {
                return start + value.length();
            }
        }
        return 0;
    }

    protected int subParse(String text, int start, char ch, int count, boolean obeyCount, boolean allowNegative, boolean[] ambiguousYear, Calendar cal) {
        Number number = null;
        int value = 0;
        ParsePosition pos = new ParsePosition(0);
        int patternCharIndex = "GyMdkHmsSEDFwWahKzYeugAZvcL".indexOf(ch);
        if (patternCharIndex == -1) {
            return -start;
        }
        int field = PATTERN_INDEX_TO_CALENDAR_FIELD[patternCharIndex];
        while (true) {
            if (start >= text.length()) {
                return -start;
            }
            int c = UTF16.charAt(text, start);
            if (!UCharacter.isUWhiteSpace(c)) break;
            start += UTF16.getCharCount(c);
        }
        pos.setIndex(start);
        if (patternCharIndex == 4 || patternCharIndex == 15 || patternCharIndex == 2 && count <= 2 || patternCharIndex == 1 || patternCharIndex == 8) {
            if (obeyCount) {
                if (start + count > text.length()) {
                    return -start;
                }
                number = this.parseInt(text.substring(0, start + count), pos, allowNegative);
            } else {
                number = this.parseInt(text, pos, allowNegative);
            }
            if (number == null) {
                return -start;
            }
            value = number.intValue();
        }
        switch (patternCharIndex) {
            case 0: {
                return this.matchString(text, start, 0, this.formatData.eras, cal);
            }
            case 1: {
                if (count == 2 && pos.getIndex() - start == 2 && Character.isDigit(text.charAt(start)) && Character.isDigit(text.charAt(start + 1))) {
                    int ambiguousTwoDigitYear = this.defaultCenturyStartYear % 100;
                    ambiguousYear[0] = value == ambiguousTwoDigitYear;
                    value += this.defaultCenturyStartYear / 100 * 100 + (value < ambiguousTwoDigitYear ? 100 : 0);
                }
                cal.set(1, value);
                return pos.getIndex();
            }
            case 2: {
                if (count <= 2) {
                    cal.set(2, value - 1);
                    return pos.getIndex();
                }
                int newStart = this.matchString(text, start, 2, this.formatData.months, cal);
                if (newStart > 0) {
                    return newStart;
                }
                return this.matchString(text, start, 2, this.formatData.shortMonths, cal);
            }
            case 4: {
                if (value == cal.getMaximum(11) + 1) {
                    value = 0;
                }
                cal.set(11, value);
                return pos.getIndex();
            }
            case 8: {
                int i = pos.getIndex() - start;
                if (i < 3) {
                    while (i < 3) {
                        value *= 10;
                        ++i;
                    }
                } else {
                    int a = 1;
                    while (i > 3) {
                        a *= 10;
                        --i;
                    }
                    value = (value + (a >> 1)) / a;
                }
                cal.set(14, value);
                return pos.getIndex();
            }
            case 9: {
                int newStart = this.matchString(text, start, 7, this.formatData.weekdays, cal);
                if (newStart > 0) {
                    return newStart;
                }
                return this.matchString(text, start, 7, this.formatData.shortWeekdays, cal);
            }
            case 14: {
                return this.matchString(text, start, 9, this.formatData.ampms, cal);
            }
            case 15: {
                if (value == cal.getLeastMaximum(10) + 1) {
                    value = 0;
                }
                cal.set(10, value);
                return pos.getIndex();
            }
            case 17: 
            case 23: 
            case 24: {
                int offset;
                int sign = 0;
                if (text.length() - start >= GMT.length() && text.regionMatches(true, start, GMT, 0, GMT.length())) {
                    cal.set(16, 0);
                    pos.setIndex(start + GMT.length());
                    try {
                        switch (text.charAt(pos.getIndex())) {
                            case '+': {
                                sign = 1;
                                break;
                            }
                            case '-': {
                                sign = -1;
                            }
                        }
                    }
                    catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
                    if (sign == 0) {
                        cal.set(15, 0);
                        return pos.getIndex();
                    }
                    pos.setIndex(pos.getIndex() + 1);
                    int st = pos.getIndex();
                    Number tzNumber = this.numberFormat.parse(text, pos);
                    if (tzNumber == null) {
                        return -start;
                    }
                    if (pos.getIndex() < text.length() && text.charAt(pos.getIndex()) == ':') {
                        offset = tzNumber.intValue() * 60;
                        pos.setIndex(pos.getIndex() + 1);
                        tzNumber = this.numberFormat.parse(text, pos);
                        if (tzNumber == null) {
                            return -start;
                        }
                        offset += tzNumber.intValue();
                    } else {
                        offset = tzNumber.intValue();
                        offset = offset < 24 && pos.getIndex() - st <= 2 ? (offset *= 60) : offset % 100 + offset / 100 * 60;
                    }
                } else {
                    int i = this.subParseZoneString(text, start, cal);
                    if (i != 0) {
                        return i;
                    }
                    DecimalFormat fmt = new DecimalFormat("+####;-####");
                    fmt.setParseIntegerOnly(true);
                    Number tzNumber = fmt.parse(text, pos);
                    if (tzNumber == null) {
                        return -start;
                    }
                    offset = tzNumber.intValue();
                    sign = 1;
                    if (offset < 0) {
                        sign = -1;
                        offset = -offset;
                    }
                    offset = offset < 24 && pos.getIndex() - start <= 3 ? (offset *= 60) : offset % 100 + offset / 100 * 60;
                }
                offset *= 60000 * sign;
                if (cal.getTimeZone().useDaylightTime()) {
                    cal.set(16, 3600000);
                    offset -= 3600000;
                }
                cal.set(15, offset);
                return pos.getIndex();
            }
        }
        if (obeyCount) {
            if (start + count > text.length()) {
                return -start;
            }
            number = this.parseInt(text.substring(0, start + count), pos, allowNegative);
        } else {
            number = this.parseInt(text, pos, allowNegative);
        }
        if (number != null) {
            cal.set(field, number.intValue());
            return pos.getIndex();
        }
        return -start;
    }

    private Number parseInt(String text, ParsePosition pos, boolean allowNegative) {
        String oldPrefix = null;
        DecimalFormat df = null;
        if (!allowNegative) {
            try {
                df = (DecimalFormat)this.numberFormat;
                oldPrefix = df.getNegativePrefix();
                df.setNegativePrefix(SUPPRESS_NEGATIVE_PREFIX);
            }
            catch (ClassCastException classCastException) {}
        }
        Number number = this.numberFormat.parse(text, pos);
        if (df != null) {
            df.setNegativePrefix(oldPrefix);
        }
        return number;
    }

    private String translatePattern(String pattern, String from, String to) {
        StringBuffer result = new StringBuffer();
        boolean inQuote = false;
        int i = 0;
        while (i < pattern.length()) {
            int ci;
            char c = pattern.charAt(i);
            if (inQuote) {
                if (c == '\'') {
                    inQuote = false;
                }
            } else if (c == '\'') {
                inQuote = true;
            } else if ((c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') && (ci = from.indexOf(c)) != -1) {
                c = to.charAt(ci);
            }
            result.append(c);
            ++i;
        }
        if (inQuote) {
            throw new IllegalArgumentException("Unfinished quote in pattern");
        }
        return result.toString();
    }

    public String toPattern() {
        return this.pattern;
    }

    public String toLocalizedPattern() {
        return this.translatePattern(this.pattern, "GyMdkHmsSEDFwWahKzYeugAZvcL", this.formatData.localPatternChars);
    }

    public void applyPattern(String pattern) {
        this.pattern = pattern;
        this.setLocale(null, null);
    }

    public void applyLocalizedPattern(String pattern) {
        this.pattern = this.translatePattern(pattern, this.formatData.localPatternChars, "GyMdkHmsSEDFwWahKzYeugAZvcL");
        this.setLocale(null, null);
    }

    public DateFormatSymbols getDateFormatSymbols() {
        return (DateFormatSymbols)this.formatData.clone();
    }

    public void setDateFormatSymbols(DateFormatSymbols newFormatSymbols) {
        this.formatData = (DateFormatSymbols)newFormatSymbols.clone();
    }

    protected DateFormatSymbols getSymbols() {
        return this.formatData;
    }

    public Object clone() {
        SimpleDateFormat other = (SimpleDateFormat)super.clone();
        other.formatData = (DateFormatSymbols)this.formatData.clone();
        return other;
    }

    public int hashCode() {
        return this.pattern.hashCode();
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        SimpleDateFormat that = (SimpleDateFormat)obj;
        return this.pattern.equals(that.pattern) && this.formatData.equals(that.formatData);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (this.serialVersionOnStream < 1) {
            this.initializeDefaultCentury();
        } else {
            this.parseAmbiguousDatesAsAfter(this.defaultCenturyStart);
        }
        this.serialVersionOnStream = 1;
        this.locale = this.getLocale(ULocale.VALID_LOCALE);
    }
}

