/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.widgets.vxml;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Vector;
import org.eclipse.vtp.framework.util.XMLUtilities;
import org.eclipse.vtp.framework.widgets.vxml.Action;
import org.eclipse.vtp.framework.widgets.vxml.If;
import org.eclipse.vtp.framework.widgets.vxml.VXMLWidget;

public abstract class EventHandler
extends VXMLWidget {
    protected int count = -1;
    protected String condition = null;
    protected Vector actions = new Vector();

    public EventHandler() {
    }

    public EventHandler(String condition) {
        this.init(condition, -1);
    }

    public EventHandler(int count) {
        this.init(null, count);
    }

    public EventHandler(int count, String condition) {
        this.init(condition, count);
    }

    public void init(String condition, int count) {
        if (condition != null && condition.equals("")) {
            throw new IllegalArgumentException("condition cannot be empty.");
        }
        this.condition = condition;
        this.count = count;
    }

    public int getCount() {
        return this.count;
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public void setCondition(String condition) {
        if (condition != null && condition.equals("")) {
            throw new IllegalArgumentException("Condition cannot be emtpy.");
        }
        this.condition = condition;
    }

    public void addAction(Action action) {
        if (action == null) {
            throw new IllegalArgumentException("Cannot add null action.");
        }
        this.actions.addElement(action);
    }

    public void addIfClause(If ifClause) {
        if (ifClause == null) {
            throw new IllegalArgumentException("Cannot add null if clause.");
        }
        this.actions.addElement(ifClause);
    }

    protected void writeAttributes(PrintStream out) throws IOException {
        if (this.condition != null) {
            out.print(" cond='");
            out.print(XMLUtilities.encodeAttribute((String)this.condition));
            out.print("'");
        }
        if (this.count > 0) {
            out.print(" count='");
            out.print(XMLUtilities.encodeAttribute((String)Integer.toString(this.count)));
            out.print("'");
        }
    }

    protected void writeChildren(PrintStream out, int indent) throws IOException {
        int i = 0;
        while (i < this.actions.size()) {
            ((VXMLWidget)this.actions.elementAt(i)).writeWidget(out, indent + 1);
            ++i;
        }
    }
}

