/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.widgets.vxml;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.vtp.framework.util.HashtableUtilities;
import org.eclipse.vtp.framework.widgets.vxml.EventHandler;
import org.eclipse.vtp.framework.widgets.vxml.Filled;
import org.eclipse.vtp.framework.widgets.vxml.FormElement;
import org.eclipse.vtp.framework.widgets.vxml.Option;
import org.eclipse.vtp.framework.widgets.vxml.Prompt;
import org.eclipse.vtp.framework.widgets.vxml.grammar.Grammar;

public class Field
extends FormElement {
    protected Prompt prompt;
    protected Grammar grammar;
    protected Vector options;
    protected Vector eventHandlers;
    protected Vector filledHandlers;
    protected Hashtable properties;

    public Field(String name) {
        super(name);
        this.init(null);
    }

    public Field(String name, Prompt prompt) {
        super(name);
        this.init(prompt);
    }

    public Field(String name, String expression) {
        super(name, expression);
        this.init(null);
    }

    public Field(String name, String expression, Prompt prompt) {
        super(name, expression);
        this.init(prompt);
    }

    public Field(String name, String expression, String condition) {
        super(name, expression, condition);
        this.init(null);
    }

    public Field(String name, String expression, String condition, Prompt prompt) {
        super(name, expression, condition);
        this.init(prompt);
    }

    private void init(Prompt prompt) {
        this.prompt = prompt;
        this.options = new Vector();
        this.eventHandlers = new Vector();
        this.filledHandlers = new Vector();
        this.properties = new Hashtable();
    }

    public Prompt getPrompt() {
        return this.prompt;
    }

    public void setPrompt(Prompt prompt) {
        this.prompt = prompt;
    }

    public void setGrammar(Grammar grammar) {
        this.grammar = grammar;
    }

    public void addOption(Option option) {
        if (option == null) {
            throw new IllegalArgumentException("Cannot add null option.");
        }
        this.options.addElement(option);
    }

    public void addEventHandler(EventHandler eventHandler) {
        if (eventHandler == null) {
            throw new IllegalArgumentException("Cannot add null event handler.");
        }
        this.eventHandlers.addElement(eventHandler);
    }

    public void addFilledHandler(Filled filled) {
        if (filled == null) {
            throw new IllegalArgumentException("Cannot add null filled handler.");
        }
        this.filledHandlers.addElement(filled);
    }

    public void addProperty(String key, String value) {
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null.");
        }
        if (value == null) {
            throw new IllegalArgumentException("Value cannot be null.");
        }
        this.properties.put(key, value);
    }

    protected void writeEventHandlers(PrintStream out, int indent) throws IOException {
        int i = 0;
        while (i < this.filledHandlers.size()) {
            ((Filled)this.filledHandlers.elementAt(i)).writeWidget(out, indent + 1);
            ++i;
        }
        i = 0;
        while (i < this.eventHandlers.size()) {
            ((EventHandler)this.eventHandlers.elementAt(i)).writeWidget(out, indent + 1);
            ++i;
        }
    }

    protected void writeChildren(PrintStream out, int indent) throws IOException {
        String[] keys = HashtableUtilities.getKeys((Hashtable)this.properties);
        int i = 0;
        while (i < keys.length) {
            out.println("<property name='" + keys[i] + "' value='" + this.properties.get(keys[i]) + "'/>");
            ++i;
        }
        super.writeChildren(out, indent);
        this.prompt.writeWidget(out, indent + 1);
        if (this.grammar != null) {
            this.grammar.writeWidget(out, indent + 1);
        }
        if (this.options.size() > 0) {
            out.println("<enumerate/>");
        }
        i = 0;
        while (i < this.options.size()) {
            ((Option)this.options.elementAt(i)).writeWidget(out, indent + 1);
            ++i;
        }
    }

    protected void writeEndTag(PrintStream out, int indent) throws IOException {
        out.println("</field>");
    }

    protected void writeStartTagEntry(PrintStream out, int indent) throws IOException {
        out.print("<field");
    }

    protected void writeStartTagExit(PrintStream out, int indent) throws IOException {
        out.println(">");
    }
}

