/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.widgets.vxml;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Vector;
import org.eclipse.vtp.framework.widgets.vxml.Dialog;
import org.eclipse.vtp.framework.widgets.vxml.Filled;
import org.eclipse.vtp.framework.widgets.vxml.FormElement;
import org.eclipse.vtp.framework.widgets.vxml.Variable;

public class Form
extends Dialog {
    protected Vector formElements;
    protected Vector variables;
    protected Vector filledHandlers;

    public Form(String id) {
        super(id);
        this.init();
    }

    public Form(String id, int scope) {
        super(id, scope);
        this.init();
    }

    private void init() {
        this.formElements = new Vector();
        this.variables = new Vector();
        this.filledHandlers = new Vector();
    }

    public void addFormElement(FormElement formElement) {
        if (formElement == null) {
            throw new IllegalArgumentException("Cannot add null form element.");
        }
        this.formElements.addElement(formElement);
    }

    public void addVariable(Variable variable) {
        if (variable == null) {
            throw new IllegalArgumentException("Cannot add null variable.");
        }
        this.variables.addElement(variable);
    }

    public void addFilledHandler(Filled filled) {
        if (filled == null) {
            throw new IllegalArgumentException("Cannot add null filled handler.");
        }
        this.filledHandlers.addElement(filled);
    }

    protected void writeChildren(PrintStream out, int indent) throws IOException {
        super.writeChildren(out, indent);
        int i = 0;
        while (i < this.variables.size()) {
            ((Variable)this.variables.elementAt(i)).writeWidget(out, indent + 1);
            ++i;
        }
        i = 0;
        while (i < this.formElements.size()) {
            ((FormElement)this.formElements.elementAt(i)).writeWidget(out, indent + 1);
            ++i;
        }
    }

    protected void writeEventHandlers(PrintStream out, int indent) throws IOException {
        int i = 0;
        while (i < this.filledHandlers.size()) {
            ((Filled)this.filledHandlers.elementAt(i)).writeWidget(out, indent + 1);
            ++i;
        }
        super.writeEventHandlers(out, indent);
    }

    protected void writeEndTag(PrintStream out, int indent) throws IOException {
        out.println("</form>");
    }

    protected void writeStartTagEntry(PrintStream out, int indent) throws IOException {
        out.print("<form");
    }

    protected void writeStartTagExit(PrintStream out, int indent) throws IOException {
        out.println(">");
    }
}

