/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.widgets.vxml;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Vector;
import org.eclipse.vtp.framework.util.XMLUtilities;
import org.eclipse.vtp.framework.widgets.vxml.Action;
import org.eclipse.vtp.framework.widgets.vxml.Else;
import org.eclipse.vtp.framework.widgets.vxml.ElseIf;
import org.eclipse.vtp.framework.widgets.vxml.VXMLWidget;

public class If
extends VXMLWidget {
    protected String condition;
    protected Vector actions;
    protected Vector elseifs;
    protected Else elseClause;

    public If(String condition) {
        if (condition == null) {
            throw new IllegalArgumentException("Condition cannot be null.");
        }
        if (condition.equals("")) {
            throw new IllegalArgumentException("Condition cannot be empty.");
        }
        this.condition = condition;
        this.actions = new Vector();
        this.elseifs = new Vector();
        this.elseClause = null;
    }

    public void addAction(Action action) {
        if (action == null) {
            throw new IllegalArgumentException("Cannot add null action.");
        }
        this.actions.addElement(action);
    }

    public void addElseif(ElseIf elseif) {
        if (elseif == null) {
            throw new IllegalArgumentException("Cannot add null elseif clause.");
        }
        this.elseifs.addElement(elseif);
    }

    public void setElseClause(Else elseClause) {
        this.elseClause = elseClause;
    }

    protected void writeAttributes(PrintStream out) throws IOException {
        out.print(" cond='");
        out.print(XMLUtilities.encodeAttribute((String)this.condition));
        out.print("'");
    }

    protected void writeChildren(PrintStream out, int indent) throws IOException {
        int i = 0;
        while (i < this.actions.size()) {
            ((VXMLWidget)this.actions.elementAt(i)).writeWidget(out, indent + 1);
            ++i;
        }
        i = 0;
        while (i < this.elseifs.size()) {
            ((ElseIf)this.elseifs.elementAt(i)).writeWidget(out, indent);
            ++i;
        }
        if (this.elseClause != null) {
            this.elseClause.writeWidget(out, indent);
        }
    }

    protected void writeEndTag(PrintStream out, int indent) throws IOException {
        out.println("</if>");
    }

    protected void writeStartTagEntry(PrintStream out, int indent) throws IOException {
        out.print("<if");
    }

    protected void writeStartTagExit(PrintStream out, int indent) throws IOException {
        out.println(">");
    }
}

