/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.widgets.vxml;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.vtp.framework.util.HashtableUtilities;
import org.eclipse.vtp.framework.widgets.vxml.Choice;
import org.eclipse.vtp.framework.widgets.vxml.Dialog;
import org.eclipse.vtp.framework.widgets.vxml.Prompt;

public class Menu
extends Dialog {
    protected Prompt prompt;
    protected Vector choices;
    protected Hashtable properties;

    public Menu(String id, Prompt prompt) {
        super(id);
        this.init(prompt);
    }

    public Menu(String id, int scope, Prompt prompt) {
        super(id, scope);
        this.init(prompt);
    }

    private void init(Prompt prompt) {
        if (prompt == null) {
            throw new IllegalArgumentException("Prompt cannot be null.");
        }
        this.prompt = prompt;
        this.choices = new Vector();
        this.properties = new Hashtable();
    }

    public Prompt getPrompt() {
        return this.prompt;
    }

    public void addProperty(String key, String value) {
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null.");
        }
        if (key.equals("")) {
            throw new IllegalArgumentException("Key cannot be empty.");
        }
        if (value == null) {
            throw new IllegalArgumentException("Value cannot be null.");
        }
        this.properties.put(key, value);
    }

    public void addChoice(Choice choice) {
        if (choice == null) {
            throw new IllegalArgumentException("Cannot add a null choice.");
        }
        this.choices.addElement(choice);
    }

    public void setPrompt(Prompt prompt) {
        if (prompt == null) {
            throw new IllegalArgumentException("Prompt cannot be null.");
        }
        this.prompt = prompt;
    }

    protected void writeChildren(PrintStream out, int indent) throws IOException {
        String[] keys = HashtableUtilities.getKeys((Hashtable)this.properties);
        int i = 0;
        while (i < keys.length) {
            out.println("<property name='" + keys[i] + "' value='" + this.properties.get(keys[i]) + "'/>");
            ++i;
        }
        super.writeChildren(out, indent);
        this.prompt.writeWidget(out, indent + 1);
        i = 0;
        while (i < this.choices.size()) {
            ((Choice)this.choices.elementAt(i)).writeWidget(out, indent + 1);
            ++i;
        }
    }

    protected void writeEndTag(PrintStream out, int indent) throws IOException {
        out.println("</menu>");
    }

    protected void writeStartTagEntry(PrintStream out, int indent) throws IOException {
        out.print("<menu");
    }

    protected void writeStartTagExit(PrintStream out, int indent) throws IOException {
        out.println(">");
    }
}

