/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.widgets.vxml;

import java.io.IOException;
import java.io.PrintStream;
import org.eclipse.vtp.framework.util.XMLUtilities;
import org.eclipse.vtp.framework.widgets.vxml.BasicOutput;
import org.eclipse.vtp.framework.widgets.vxml.VXMLWidget;

public class Option
extends VXMLWidget {
    protected String dtmf;
    protected String value;
    protected BasicOutput text;

    public Option() {
        this.init(null, null, null);
    }

    public Option(BasicOutput text) {
        this.init(null, null, text);
    }

    public Option(BasicOutput text, String dtmf) {
        this.init(dtmf, null, text);
    }

    public Option(BasicOutput text, String dtmf, String value) {
        this.init(dtmf, value, text);
    }

    private void init(String dtmf, String value, BasicOutput text) {
        if (dtmf != null && dtmf.equals("")) {
            throw new IllegalArgumentException("DTMF cannot be empty.");
        }
        if (value != null && value.equals("")) {
            throw new IllegalArgumentException("Value cannot be empty.");
        }
        this.text = text;
        this.dtmf = dtmf;
        this.value = value;
    }

    public void setDTMF(String dtmf) {
        if (dtmf != null && dtmf.equals("")) {
            throw new IllegalArgumentException("DTMF cannot be empty.");
        }
        this.dtmf = dtmf;
    }

    public void setValue(String value) {
        if (value != null && value.equals("")) {
            throw new IllegalArgumentException("Value cannot be emtpy.");
        }
        this.value = value;
    }

    public void setText(BasicOutput text) {
        this.text = text;
    }

    public String getDTMF() {
        return this.dtmf;
    }

    public String getValue() {
        return this.value;
    }

    public BasicOutput getText() {
        return this.text;
    }

    protected void writeAttributes(PrintStream out) throws IOException {
        if (this.dtmf != null) {
            out.print(" dtmf='");
            out.print(XMLUtilities.encodeAttribute((String)this.dtmf));
            out.print("'");
        }
        if (this.value != null) {
            out.print(" value='");
            out.print(XMLUtilities.encodeAttribute((String)this.value));
            out.print("'");
        }
    }

    protected void writeChildren(PrintStream out, int indent) throws IOException {
        if (this.text != null) {
            this.text.writeWidget(out, indent + 1);
        }
    }

    protected void writeEndTag(PrintStream out, int indent) throws IOException {
        out.println("</option>");
    }

    protected void writeStartTagEntry(PrintStream out, int indent) throws IOException {
        out.print("<option");
    }

    protected void writeStartTagExit(PrintStream out, int indent) throws IOException {
        out.println(">");
    }
}

