/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.widgets.vxml;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Vector;
import org.eclipse.vtp.framework.util.XMLUtilities;
import org.eclipse.vtp.framework.widgets.vxml.EventHandler;
import org.eclipse.vtp.framework.widgets.vxml.Filled;
import org.eclipse.vtp.framework.widgets.vxml.FormElement;
import org.eclipse.vtp.framework.widgets.vxml.Parameter;

public class Subdialog
extends FormElement {
    private String sourceURI;
    private Vector parameters;
    private Vector eventHandlers;
    private Vector filledHandlers;

    public Subdialog(String name) {
        super(name);
        this.init(null);
    }

    public Subdialog(String name, String expression) {
        super(name, expression);
        this.init(null);
    }

    public Subdialog(String name, String expression, String condition) {
        super(name, expression, condition);
        this.init(null);
    }

    public Subdialog(String name, String expression, String condition, String sourceURI) {
        super(name, expression, condition);
        this.init(sourceURI);
    }

    private void init(String sourceURI) {
        this.sourceURI = sourceURI;
        this.parameters = new Vector();
        this.eventHandlers = new Vector();
        this.filledHandlers = new Vector();
    }

    public String getSourceURI() {
        return this.sourceURI;
    }

    public void setSourceURI(String sourceURI) {
        this.sourceURI = sourceURI;
    }

    public void addParameter(Parameter parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException("Cannot add null parameter.");
        }
        this.parameters.addElement(parameter);
    }

    public void addEventHandler(EventHandler eventHandler) {
        if (eventHandler == null) {
            throw new IllegalArgumentException("Cannot add null event handler.");
        }
        this.eventHandlers.addElement(eventHandler);
    }

    public void addFilledHandler(Filled filled) {
        if (filled == null) {
            throw new IllegalArgumentException("Cannot add null filled handler.");
        }
        this.filledHandlers.addElement(filled);
    }

    protected void writeAttributes(PrintStream out) throws IOException {
        super.writeAttributes(out);
        if (this.sourceURI != null) {
            out.print(" srcexpr='");
            out.print(XMLUtilities.encodeAttribute((String)this.sourceURI));
            out.print("'");
        }
    }

    protected void writeEventHandlers(PrintStream out, int indent) throws IOException {
        int i = 0;
        while (i < this.filledHandlers.size()) {
            ((Filled)this.filledHandlers.elementAt(i)).writeWidget(out, indent + 1);
            ++i;
        }
        i = 0;
        while (i < this.eventHandlers.size()) {
            ((EventHandler)this.eventHandlers.elementAt(i)).writeWidget(out, indent + 1);
            ++i;
        }
    }

    protected void writeChildren(PrintStream out, int indent) throws IOException {
        super.writeChildren(out, indent);
        int i = 0;
        while (i < this.parameters.size()) {
            ((Parameter)this.parameters.elementAt(i)).writeWidget(out, indent + 1);
            ++i;
        }
    }

    protected void writeEndTag(PrintStream out, int indent) throws IOException {
        out.println("</subdialog>");
    }

    protected void writeStartTagEntry(PrintStream out, int indent) throws IOException {
        out.print("<subdialog");
    }

    protected void writeStartTagExit(PrintStream out, int indent) throws IOException {
        out.println(">");
    }
}

