/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.widgets.vxml;

import java.io.IOException;
import java.io.PrintStream;
import org.eclipse.vtp.framework.util.XMLUtilities;
import org.eclipse.vtp.framework.widgets.vxml.VXMLWidget;

public class Variable
extends VXMLWidget {
    protected String name;
    protected String initialValue = null;

    public Variable(String name) {
        this.init(name, null);
    }

    public Variable(String name, String initialValue) {
        this.init(name, initialValue);
    }

    private void init(String name, String initialValue) {
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null.");
        }
        if (name.equals("")) {
            throw new IllegalArgumentException("Name cannot be empty string.");
        }
        this.name = name;
        this.initialValue = initialValue;
    }

    public String getName() {
        return this.name;
    }

    public String getInitialValue() {
        return this.initialValue;
    }

    public void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null.");
        }
        if (name.equals("")) {
            throw new IllegalArgumentException("Name cannot be empty.");
        }
        this.name = name;
    }

    public void setInitialValue(String initialValue) {
        this.initialValue = initialValue;
    }

    protected void writeAttributes(PrintStream out) throws IOException {
        out.print(" name='");
        out.print(XMLUtilities.encodeAttribute((String)this.name));
        out.print("'");
        if (this.initialValue != null) {
            out.print(" expr='");
            out.print(XMLUtilities.encodeAttribute((String)this.initialValue));
            out.print("'");
        }
    }

    protected void writeStartTagEntry(PrintStream out, int indent) throws IOException {
        out.print("<var");
    }

    protected void writeStartTagExit(PrintStream out, int indent) throws IOException {
        out.println("/>");
    }
}

