/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.widgets.vxml.grammar.grxml;

import java.io.IOException;
import java.io.PrintStream;
import org.eclipse.vtp.framework.widgets.vxml.grammar.grxml.Iota;
import org.eclipse.vtp.framework.widgets.vxml.grammar.grxml.OneOf;

public class Item
extends Iota {
    int minimumNumber = 0;
    int maximumNumber = 1;
    OneOf oneOf = null;
    char text;

    public Item() {
    }

    public Item(char text) {
        this.text = text;
    }

    public void setMinimumNumber(int minimumNumber) {
        this.minimumNumber = minimumNumber;
    }

    public void setMaximumNumber(int maximumNumber) {
        this.maximumNumber = maximumNumber;
    }

    public void setOneOf(OneOf oneOf) {
        this.oneOf = oneOf;
    }

    protected void writeAttributes(PrintStream out) throws IOException {
        if (this.maximumNumber > 1) {
            out.print(" repeat='");
            out.print(String.valueOf(Integer.toString(this.minimumNumber)) + "-" + Integer.toString(this.maximumNumber));
            out.print("'");
        }
    }

    protected void writeChildren(PrintStream out, int indent) throws IOException {
        if (this.oneOf != null) {
            this.oneOf.writeWidget(out, indent + 1);
        } else {
            out.print(this.text);
        }
    }

    protected void writeEndTag(PrintStream out, int indent) throws IOException {
        out.println("</item>");
    }

    protected void writeStartTagEntry(PrintStream out, int indent) throws IOException {
        out.print("<item");
    }

    protected void writeStartTagExit(PrintStream out, int indent) throws IOException {
        out.print(">");
        if (this.oneOf != null) {
            out.println();
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Item)) {
            return false;
        }
        Item item = (Item)obj;
        if (this.oneOf != null ? !this.oneOf.equals(item.oneOf) : this.text != item.text) {
            return false;
        }
        return this.minimumNumber == item.minimumNumber && this.maximumNumber == item.maximumNumber;
    }
}

