/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.widgets.vxml.grammar.grxml;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Vector;
import org.eclipse.vtp.framework.widgets.vxml.VXMLWidget;
import org.eclipse.vtp.framework.widgets.vxml.grammar.grxml.Iota;

public class Rule
extends VXMLWidget {
    protected String id;
    protected Vector items;

    public Rule(String id) {
        if (id == null) {
            throw new IllegalArgumentException("Id cannot be null.");
        }
        if (id.equals("")) {
            throw new IllegalArgumentException("Id cannot be empty.");
        }
        this.id = id;
        this.items = new Vector();
    }

    public String getId() {
        return this.id;
    }

    public void addItem(Iota item) {
        if (item == null) {
            throw new IllegalArgumentException("Item cannot be null.");
        }
        this.items.addElement(item);
    }

    protected void writeAttributes(PrintStream out) throws IOException {
        out.print(" id='");
        out.print(this.id);
        out.print("'");
    }

    protected void writeChildren(PrintStream out, int indent) throws IOException {
        int i = 0;
        while (i < this.items.size()) {
            ((Iota)this.items.elementAt(i)).writeWidget(out, indent + 1);
            ++i;
        }
    }

    protected void writeEndTag(PrintStream out, int indent) throws IOException {
        out.println("</rule>");
    }

    protected void writeStartTagEntry(PrintStream out, int indent) throws IOException {
        out.print("<rule");
    }

    protected void writeStartTagExit(PrintStream out, int indent) throws IOException {
        out.println(">");
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Rule)) {
            return false;
        }
        Rule rule = (Rule)obj;
        return this.id.equals(rule.id) && this.items.equals(rule.items);
    }
}

