/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.uddi;

import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.uddi.UDDIValidatorImpl;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.uddi4j.datatype.tmodel.TModel;

public class BP3003
extends AssertionProcess {
    private final UDDIValidatorImpl validator;

    public BP3003(UDDIValidatorImpl impl) {
        super(impl);
        this.validator = impl;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        this.result = "passed";
        TModel tModel = (TModel)entryContext.getEntry().getEntryDetail();
        if (tModel == null) {
            this.result = "failed";
            this.failureDetailMessage = "Could not locate a tModel with a categorization of 'wsdlSpec'.";
        } else if (!this.validator.isWsdlSpec(tModel)) {
            this.result = "failed";
            this.failureDetailMessage = "The tModel key is: [" + tModel.getTModelKey() + "]\n" + "The categoryBag is: [" + this.validator.categoryBagToString(tModel.getCategoryBag()) + "]";
        } else {
            this.validator.setWSDLLocation(this.validator.getWSDLLocation(this.validator.getOverviewURL(tModel)));
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetailMessage);
    }
}

