/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.editor;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.ui.editor.ServerEditorSection;
import org.eclipse.wst.server.ui.internal.Trace;
import org.eclipse.wst.server.ui.internal.editor.IServerEditorPageSectionFactory;

public class ServerEditorPageSectionFactory
implements IServerEditorPageSectionFactory {
    private IConfigurationElement element;
    private Expression fContextualLaunchExpr = null;

    public ServerEditorPageSectionFactory(IConfigurationElement element) {
        this.element = element;
    }

    protected IConfigurationElement getConfigurationElement() {
        return this.element;
    }

    public String getId() {
        return this.element.getAttribute("id");
    }

    public int getOrder() {
        try {
            String o = this.element.getAttribute("order");
            return Integer.parseInt(o);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public String getInsertionId() {
        return this.element.getAttribute("insertionId");
    }

    protected String[] getTypeIds() {
        try {
            ArrayList<String> list = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(this.element.getAttribute("typeIds"), ",");
            while (st.hasMoreTokens()) {
                String str = st.nextToken();
                if (str == null || str.length() <= 0) continue;
                list.add(str.trim());
            }
            String[] s = new String[list.size()];
            list.toArray(s);
            return s;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean supportsType(String id) {
        if (id == null || id.length() == 0) {
            return false;
        }
        String[] s = this.getTypeIds();
        if (s == null) {
            return false;
        }
        int size = s.length;
        int i = 0;
        while (i < size) {
            if (s[i].endsWith("*") ? id.length() >= s[i].length() && id.startsWith(s[i].substring(0, s[i].length() - 1)) : id.equals(s[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean shouldCreateSection(IServerWorkingCopy server) {
        try {
            return this.isEnabled(server);
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Error calling delegate", e);
            return false;
        }
    }

    public ServerEditorSection createSection() {
        try {
            return (ServerEditorSection)this.element.createExecutableExtension("class");
        }
        catch (Throwable t) {
            Trace.trace(Trace.SEVERE, "Could not create server editor section", t);
            return null;
        }
    }

    public Expression getContextualLaunchEnablementExpression() throws CoreException {
        if (this.fContextualLaunchExpr == null) {
            IConfigurationElement enablement;
            IConfigurationElement[] elements = this.element.getChildren("enablement");
            IConfigurationElement iConfigurationElement = enablement = elements.length > 0 ? elements[0] : null;
            if (enablement != null) {
                this.fContextualLaunchExpr = ExpressionConverter.getDefault().perform(enablement);
            }
        }
        return this.fContextualLaunchExpr;
    }

    protected boolean evalEnablementExpression(IEvaluationContext context, Expression exp) throws CoreException {
        return exp != null ? exp.evaluate(context) != EvaluationResult.FALSE : false;
    }

    public boolean isEnabled(Object obj) throws CoreException {
        if (this.getContextualLaunchEnablementExpression() == null) {
            return true;
        }
        EvaluationContext context = new EvaluationContext(null, obj);
        context.addVariable("server", obj);
        return this.evalEnablementExpression((IEvaluationContext)context, this.getContextualLaunchEnablementExpression());
    }

    public String toString() {
        return "ServerEditorSection [" + this.getId() + ", " + this.getInsertionId() + ", " + this.getOrder() + "]";
    }
}

