/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.viewers;

import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.viewers.AbstractTreeComposite;
import org.eclipse.wst.server.ui.internal.viewers.DefaultViewerSorter;
import org.eclipse.wst.server.ui.internal.viewers.RuntimeTypeTreeContentProvider;
import org.eclipse.wst.server.ui.internal.viewers.RuntimeTypeTreeLabelProvider;
import org.eclipse.wst.server.ui.internal.wizard.NewInstallableServerWizard;

public class RuntimeTypeComposite
extends AbstractTreeComposite {
    protected IRuntimeType selection;
    protected RuntimeTypeSelectionListener listener;
    protected boolean creation;
    protected String type;
    protected String version;
    protected String runtimeTypeId;
    protected RuntimeTypeTreeContentProvider contentProvider;
    protected boolean initialSelection = true;

    public RuntimeTypeComposite(Composite parent, int style, boolean creation, RuntimeTypeSelectionListener listener2, String type, String version, String runtimeTypeId) {
        super(parent, style);
        this.listener = listener2;
        this.creation = creation;
        this.type = type;
        this.version = version;
        this.runtimeTypeId = runtimeTypeId;
        this.contentProvider = new RuntimeTypeTreeContentProvider(1, creation, type, version, runtimeTypeId);
        this.treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new RuntimeTypeTreeLabelProvider());
        this.treeViewer.setInput((Object)"root");
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object obj = RuntimeTypeComposite.this.getSelection(event.getSelection());
                if (obj instanceof IRuntimeType) {
                    RuntimeTypeComposite.this.selection = (IRuntimeType)obj;
                    RuntimeTypeComposite.this.setDescription(RuntimeTypeComposite.this.selection.getDescription());
                } else {
                    RuntimeTypeComposite.this.selection = null;
                    RuntimeTypeComposite.this.setDescription("");
                }
                RuntimeTypeComposite.this.listener.runtimeTypeSelected(RuntimeTypeComposite.this.selection);
            }
        });
        this.treeViewer.setSorter((ViewerSorter)new DefaultViewerSorter());
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.initialSelection) {
            this.initialSelection = false;
            if (this.contentProvider.getInitialSelection() != null) {
                this.treeViewer.setSelection((ISelection)new StructuredSelection(this.contentProvider.getInitialSelection()), true);
            }
        }
    }

    protected String getTitleLabel() {
        return Messages.runtimeTypeCompTree;
    }

    protected String getDescriptionLabel() {
        return Messages.runtimeTypeCompDescription;
    }

    protected String[] getComboOptions() {
        return new String[]{Messages.name, Messages.vendor, Messages.version, Messages.moduleSupport};
    }

    protected void viewOptionSelected(byte option) {
        ISelection sel = this.treeViewer.getSelection();
        this.treeViewer.setContentProvider((IContentProvider)new RuntimeTypeTreeContentProvider(option, this.creation, this.type, this.version, this.runtimeTypeId));
        this.treeViewer.setSelection(sel);
    }

    public void refresh() {
        ISelection sel = this.treeViewer.getSelection();
        RuntimeTypeTreeContentProvider cp = (RuntimeTypeTreeContentProvider)this.treeViewer.getContentProvider();
        this.treeViewer.setContentProvider((IContentProvider)new RuntimeTypeTreeContentProvider(cp.style, this.creation, this.type, this.version, this.runtimeTypeId));
        this.treeViewer.setSelection(sel);
    }

    public IRuntimeType getSelectedRuntimeType() {
        return this.selection;
    }

    protected String getDetailsLabel() {
        if (ServerPlugin.getInstallableServers().length > 0) {
            return Messages.installableServerLink;
        }
        return null;
    }

    protected void detailsSelected() {
        NewInstallableServerWizard wizard2 = new NewInstallableServerWizard();
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard2);
        if (dialog.open() != 1) {
            this.refresh();
        }
    }

    public static interface RuntimeTypeSelectionListener {
        public void runtimeTypeSelected(IRuntimeType var1);
    }
}

