/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.ui.wsi.properties;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.wst.ws.internal.plugin.WSPlugin;
import org.eclipse.wst.ws.internal.preferences.PersistentWSIContext;
import org.eclipse.wst.ws.internal.ui.WstWSUIPluginMessages;

public class WSICompliancePropertyPage
extends PropertyPage
implements SelectionListener {
    private String INFOPOP_PWSI_PAGE = "org.eclipse.wst.ws.ui.PWSI0000";
    private Label wsi_ssbp_Label_;
    private Combo wsi_ssbp_Types_;
    private String INFOPOP_PWSI_SSBP_COMBO_TYPE = "org.eclipse.wst.ws.ui.PWSI0004";
    private String INFOPOP_PWSI_AP_COMBO_TYPE = "org.eclipse.wst.ws.ui.PWSI0008";
    private Label wsi_ap_Label_;
    private Combo wsi_ap_Types_;
    private int savedSSBPSetting_ = -1;

    protected Control createContents(Composite superparent) {
        IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
        Composite parent = new Composite(superparent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        parent.setLayout((Layout)layout);
        parent.setLayoutData((Object)new GridData(768));
        parent.setToolTipText(WstWSUIPluginMessages.TOOLTIP_PWSI_PAGE);
        helpSystem.setHelp((Control)parent, this.INFOPOP_PWSI_PAGE);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        Composite wsi_Composite = new Composite(parent, 0);
        wsi_Composite.setLayout((Layout)gl);
        wsi_Composite.setLayoutData((Object)new GridData(768));
        this.wsi_ap_Label_ = new Label(wsi_Composite, 0);
        this.wsi_ap_Label_.setText(WstWSUIPluginMessages.LABEL_WSI_AP);
        this.wsi_ap_Label_.setToolTipText(WstWSUIPluginMessages.TOOLTIP_PWSI_AP_LABEL);
        this.wsi_ap_Types_ = new Combo(wsi_Composite, 12);
        this.wsi_ap_Types_.setToolTipText(WstWSUIPluginMessages.TOOLTIP_PWSI_AP_COMBO);
        this.wsi_ap_Types_.setLayoutData((Object)new GridData(768));
        helpSystem.setHelp((Control)this.wsi_ap_Types_, this.INFOPOP_PWSI_AP_COMBO_TYPE);
        this.wsi_ap_Types_.add(WstWSUIPluginMessages.STOP_NON_WSI);
        this.wsi_ap_Types_.add(WstWSUIPluginMessages.WARN_NON_WSI);
        this.wsi_ap_Types_.add(WstWSUIPluginMessages.IGNORE_NON_WSI);
        this.wsi_ap_Types_.add(WstWSUIPluginMessages.FOLLOW_WSI_PREFERENCE);
        this.wsi_ap_Types_.addSelectionListener((SelectionListener)this);
        this.wsi_ssbp_Label_ = new Label(wsi_Composite, 0);
        this.wsi_ssbp_Label_.setText(WstWSUIPluginMessages.LABEL_WSI_SSBP);
        this.wsi_ssbp_Label_.setToolTipText(WstWSUIPluginMessages.TOOLTIP_PWSI_SSBP_LABEL);
        this.wsi_ssbp_Types_ = new Combo(wsi_Composite, 12);
        this.wsi_ssbp_Types_.setToolTipText(WstWSUIPluginMessages.TOOLTIP_PWSI_SSBP_COMBO);
        this.wsi_ssbp_Types_.setLayoutData((Object)new GridData(768));
        helpSystem.setHelp((Control)this.wsi_ssbp_Types_, this.INFOPOP_PWSI_SSBP_COMBO_TYPE);
        this.wsi_ssbp_Types_.add(WstWSUIPluginMessages.STOP_NON_WSI);
        this.wsi_ssbp_Types_.add(WstWSUIPluginMessages.WARN_NON_WSI);
        this.wsi_ssbp_Types_.add(WstWSUIPluginMessages.IGNORE_NON_WSI);
        this.wsi_ssbp_Types_.add(WstWSUIPluginMessages.FOLLOW_WSI_PREFERENCE);
        this.initializeValues();
        Dialog.applyDialogFont((Control)superparent);
        return parent;
    }

    protected void performDefaults() {
        super.performDefaults();
        this.initializeDefaults();
    }

    public boolean performOk() {
        this.storeValues();
        return true;
    }

    protected void performApply() {
        this.performOk();
    }

    private void initializeDefaults() {
        this.wsi_ssbp_Types_.select(this.wsi_ssbp_Types_.indexOf(WstWSUIPluginMessages.FOLLOW_WSI_PREFERENCE));
        int apSelection = this.wsi_ap_Types_.indexOf(WstWSUIPluginMessages.FOLLOW_WSI_PREFERENCE);
        this.wsi_ap_Types_.select(apSelection);
        this.savedSSBPSetting_ = -1;
        this.processAPSelection(apSelection);
    }

    private void initializeValues() {
        String WSIText = this.getWSISelection((PersistentWSIContext)WSPlugin.getInstance().getWSISSBPContext());
        this.wsi_ssbp_Types_.select(this.wsi_ssbp_Types_.indexOf(WSIText));
        int apSelection = this.wsi_ap_Types_.indexOf(this.getWSISelection((PersistentWSIContext)WSPlugin.getInstance().getWSIAPContext()));
        this.wsi_ap_Types_.select(apSelection);
        this.savedSSBPSetting_ = -1;
        this.processAPSelection(apSelection);
    }

    private String getWSISelection(PersistentWSIContext context) {
        IProject project = (IProject)this.getElement();
        String WSIvalue = context.getProjectWSICompliance(project);
        String WSIText = WstWSUIPluginMessages.FOLLOW_WSI_PREFERENCE;
        if ("0".equals(WSIvalue)) {
            WSIText = WstWSUIPluginMessages.STOP_NON_WSI;
        } else if ("1".equals(WSIvalue)) {
            WSIText = WstWSUIPluginMessages.WARN_NON_WSI;
        } else if ("2".equals(WSIvalue)) {
            WSIText = WstWSUIPluginMessages.IGNORE_NON_WSI;
        }
        return WSIText;
    }

    private void storeValues() {
        this.updateWSIContext(this.wsi_ssbp_Types_.getSelectionIndex(), (PersistentWSIContext)WSPlugin.getInstance().getWSISSBPContext());
        this.updateWSIContext(this.wsi_ap_Types_.getSelectionIndex(), (PersistentWSIContext)WSPlugin.getInstance().getWSIAPContext());
    }

    private void updateWSIContext(int selectionIndex, PersistentWSIContext context) {
        String value = "3";
        IProject project = (IProject)this.getElement();
        switch (selectionIndex) {
            case 0: {
                value = "0";
                break;
            }
            case 1: {
                value = "1";
                break;
            }
            case 2: {
                value = "2";
                break;
            }
            case 3: {
                value = "3";
            }
        }
        context.updateProjectWSICompliances(project, value);
    }

    public void widgetSelected(SelectionEvent e) {
        this.processAPSelection(this.wsi_ap_Types_.getSelectionIndex());
    }

    public void processAPSelection(int selection) {
        if (selection == 2) {
            this.wsi_ssbp_Types_.setEnabled(true);
            if (this.savedSSBPSetting_ != -1) {
                this.wsi_ssbp_Types_.select(this.savedSSBPSetting_);
                this.savedSSBPSetting_ = -1;
            }
        } else if (selection == 0 || selection == 1) {
            if (this.savedSSBPSetting_ == -1) {
                this.savedSSBPSetting_ = this.wsi_ssbp_Types_.getSelectionIndex();
            }
            this.wsi_ssbp_Types_.select(selection);
            this.wsi_ssbp_Types_.setEnabled(false);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }
}

