/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.internal.dialer.nullphone;

import java.io.PrintStream;
import org.eclipse.vtp.internal.dialer.IVoipCall;
import org.eclipse.vtp.internal.dialer.IVoipConnection;
import org.eclipse.vtp.internal.dialer.IVoipDialer;
import org.eclipse.vtp.internal.dialer.IVoipDialerFactory;
import org.eclipse.vtp.internal.dialer.IVoipDialerListener;
import org.eclipse.vtp.internal.dialer.VoipDialerException;
import org.eclipse.vtp.internal.dialer.VoipDialerListener;
import org.eclipse.vtp.launching.internal.tellme.Messages;

public class NullPhone
implements IVoipCall,
IVoipConnection,
IVoipDialer,
IVoipDialerFactory {
    private int currentStatus;
    private VoipDialerListener listener;
    private final int thisId;
    private final int thisRole;
    private static int idBase = 0;
    private static final int ROLE_DIALER = 0;
    private static final int ROLE_CONNECTION = 1;
    private static final int ROLE_CALL = 2;

    public NullPhone() {
        this(0);
    }

    private NullPhone(int role) {
        this.thisRole = role;
        this.thisId = ++idBase;
        switch (role) {
            case 0: {
                this.currentStatus = 2;
                break;
            }
            case 1: {
                this.currentStatus = 1;
                break;
            }
            case 2: {
                this.currentStatus = 1;
                break;
            }
        }
    }

    public IVoipDialer getDialer() {
        return this;
    }

    public int status() {
        return this.currentStatus;
    }

    public void sendDTMF(String dtmf) throws VoipDialerException {
        if (this.thisRole != 2) {
            throw new VoipDialerException((IVoipDialerListener)this.listener, String.valueOf(Messages.NullPhone_0) + this.thisId + Messages.NullPhone_1);
        }
        this.listener.dialerMessage(String.valueOf(Messages.NullPhone_2) + dtmf + Messages.NullPhone_3 + this.thisId + Messages.NullPhone_4);
    }

    public void sendDTMF(String dtmf, int pause) throws VoipDialerException {
        if (this.thisRole != 2) {
            throw new VoipDialerException((IVoipDialerListener)this.listener, String.valueOf(Messages.NullPhone_5) + this.thisId + Messages.NullPhone_6);
        }
        this.listener.dialerMessage(String.valueOf(Messages.NullPhone_7) + dtmf + Messages.NullPhone_8 + this.thisId + Messages.NullPhone_9 + pause + Messages.NullPhone_10);
    }

    public void hangUp() throws VoipDialerException {
        if (this.thisRole != 2) {
            throw new VoipDialerException((IVoipDialerListener)this.listener, String.valueOf(Messages.NullPhone_11) + this.thisId + Messages.NullPhone_12);
        }
        this.listener.dialerMessage(String.valueOf(Messages.NullPhone_13) + this.thisId + Messages.NullPhone_14);
    }

    public IVoipCall dial(String number) throws VoipDialerException {
        if (this.thisRole != 1) {
            throw new VoipDialerException((IVoipDialerListener)this.listener, String.valueOf(Messages.NullPhone_15) + this.thisId + Messages.NullPhone_16);
        }
        NullPhone callObj = new NullPhone(2);
        this.listener.dialerMessage(String.valueOf(Messages.NullPhone_17) + number + Messages.NullPhone_18 + this.thisId + Messages.NullPhone_19 + callObj.thisId);
        return callObj;
    }

    public void disconnect() throws VoipDialerException {
        if (this.thisRole != 1) {
            throw new VoipDialerException((IVoipDialerListener)this.listener, String.valueOf(Messages.NullPhone_20) + this.thisId + Messages.NullPhone_21);
        }
        this.listener.dialerMessage(String.valueOf(Messages.NullPhone_22) + this.thisId + Messages.NullPhone_23);
    }

    public void initialize() throws VoipDialerException {
        this.initialize(new IVoipDialerListener(){

            public void dialerMessage(String msg) {
            }
        });
    }

    public void initialize(IVoipDialerListener theirListener) throws VoipDialerException {
        if (this.thisRole != 0) {
            throw new VoipDialerException((IVoipDialerListener)this.listener, String.valueOf(Messages.NullPhone_24) + this.thisId + Messages.NullPhone_25);
        }
        this.currentStatus = 1;
        this.listener = new LocalListener(theirListener);
        this.listener.dialerMessage(String.valueOf(Messages.NullPhone_26) + this.thisId + Messages.NullPhone_27);
    }

    public IVoipConnection connect() throws VoipDialerException {
        if (this.thisRole != 0) {
            throw new VoipDialerException((IVoipDialerListener)this.listener, String.valueOf(Messages.NullPhone_28) + this.thisId + Messages.NullPhone_29);
        }
        NullPhone connectionObj = new NullPhone(1);
        this.listener.dialerMessage(String.valueOf(Messages.NullPhone_30) + Messages.NullPhone_31 + this.thisId + Messages.NullPhone_32 + connectionObj.thisId);
        return connectionObj;
    }

    public void writeMessageLog(PrintStream dest) {
        String[] messageHistory = this.listener.messageHistory();
        int idx = 0;
        while (idx < messageHistory.length) {
            dest.println(messageHistory[idx]);
            ++idx;
        }
    }

    public IVoipConnection getConnection() {
        return new NullPhone(1);
    }

    private class LocalListener
    extends VoipDialerListener {
        private IVoipDialerListener theirListener = null;

        LocalListener() {
        }

        LocalListener(IVoipDialerListener otherListener) {
            this.theirListener = otherListener;
        }

        public void dialerMessage(String message) {
            super.dialerMessage(message);
            if (this.theirListener != null) {
                this.theirListener.dialerMessage(message);
            }
        }
    }
}

