/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.launching.internal.tellme;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.vtp.launching.internal.tellme.Messages;
import org.eclipse.vtp.launching.internal.tellme.TellmePlugin;

public class DisplayActions {
    private static final SimpleDateFormat time = new SimpleDateFormat("mm:ss.SSS", Locale.getDefault());
    private static final boolean DEBUGGING = TellmePlugin.getDefault().isDebugging();
    private static Display theDisplay = null;

    private DisplayActions() {
    }

    private static Display findDisplay() {
        if (theDisplay == null) {
            theDisplay = Display.getDefault();
        }
        return theDisplay;
    }

    public static void showError(String title, String failReason) {
        final String foo = title;
        final String bar = failReason;
        final Display display = DisplayActions.findDisplay();
        if (DEBUGGING) {
            System.out.println(String.valueOf(time.format(new Date())) + Messages.DisplayActions_1 + failReason);
            System.out.flush();
        }
        display.asyncExec(new Runnable(){

            public void run() {
                MessageDialog.openError((Shell)new Shell(display, 0), (String)foo, (String)bar);
            }
        });
    }

    public static void showError(String failReason) {
        DisplayActions.showError(Messages.DisplayActions_2, failReason);
    }

    public static void showEndOfCall(final String theCallID) {
        final Display display = DisplayActions.findDisplay();
        if (DEBUGGING) {
            System.out.println(String.valueOf(time.format(new Date())) + Messages.DisplayActions_3);
            System.out.flush();
        }
        display.asyncExec(new Runnable(){

            public void run() {
                String msgID = "".equals(theCallID) ? Messages.DisplayActions_0 : theCallID;
                MessageDialog.openInformation((Shell)new Shell(display, 0), (String)Messages.DisplayActions_6, (String)(String.valueOf(Messages.DisplayActions_7) + msgID + Messages.DisplayActions_8));
            }
        });
    }
}

