/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.launching.internal.tellme;

import java.net.URI;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.vtp.launching.IVoiceXMLBrowser;
import org.eclipse.vtp.launching.VoiceXMLBrowserInput;
import org.eclipse.vtp.launching.VoiceXMLBrowserProcess;
import org.eclipse.vtp.launching.VoiceXMLLogMessage;
import org.eclipse.vtp.launching.internal.tellme.CallLog;
import org.eclipse.vtp.launching.internal.tellme.CallState;
import org.eclipse.vtp.launching.internal.tellme.LogItem;
import org.eclipse.vtp.launching.internal.tellme.LogItemReader;
import org.eclipse.vtp.launching.internal.tellme.Messages;
import org.eclipse.vtp.launching.internal.tellme.StudioInteractions;
import org.eclipse.vtp.launching.internal.tellme.TellmeBrowserException;
import org.eclipse.vtp.launching.internal.tellme.TellmePlugin;

public class GetLogItems
implements Runnable {
    private static final SimpleDateFormat logDF = new SimpleDateFormat("MM/dd/yy HH:mm:ss", Locale.getDefault());
    private static final SimpleDateFormat time = new SimpleDateFormat("mm:ss.SSS", Locale.getDefault());
    private static final boolean DEBUGGING = TellmePlugin.getDefault().isDebugging();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object t;
        CallState.initLogFetch();
        IVoiceXMLBrowser activeBrowser = null;
        ILaunch[] launches = DebugPlugin.getDefault().getLaunchManager().getLaunches();
        if (launches == null) {
            CallState.reportLogFetchFail(Messages.GetLogItems_0);
            Object object = CallState.getSynch();
            synchronized (object) {
                CallState.setLogFetchDone();
                if (DEBUGGING) {
                    System.out.println(String.valueOf(time.format(new Date())) + "calling launchDone from logFetch on failure");
                    System.out.flush();
                }
                if (CallState.launchDone()) {
                    CallState.endLaunch();
                }
            }
            return;
        }
        int i = 0;
        while (i < launches.length) {
            t = launches[i].getProcesses();
            if (t != null && ((IProcess[])t).length > 0 && t[0] instanceof VoiceXMLBrowserProcess) {
                activeBrowser = ((VoiceXMLBrowserProcess)t[0]).getVoiceXMLBrowser();
            }
            ++i;
        }
        CallLog theLog = null;
        if (DEBUGGING) {
            System.out.println(String.valueOf(time.format(new Date())) + ": GetLogItems started");
            System.out.flush();
        }
        if ((theLog = CallState.getLog()) == null) {
            CallState.reportLogFetchFail(Messages.GetLogItems_1);
            t = CallState.getSynch();
            synchronized (t) {
                CallState.setLogFetchDone();
                if (DEBUGGING) {
                    System.out.println(String.valueOf(time.format(new Date())) + "calling launchDone from logFetch on failure (no log)");
                    System.out.flush();
                }
                if (CallState.launchDone()) {
                    CallState.endLaunch();
                }
            }
            return;
        }
        try {
            LogItemReader theLogReader = StudioInteractions.getLogItemReader(theLog);
            LogItem theItem = theLogReader.nextLogItem();
            if (theItem == null) {
                DebugEvent[] event = new DebugEvent[]{new DebugEvent((Object)activeBrowser, 32, 3)};
                event[0].setData((Object)new VoiceXMLLogMessage(new Date(), Messages.GetLogItems_2));
                DebugPlugin.getDefault().fireDebugEventSet(event);
                CallState.reportLogFetchFail(Messages.GetLogItems_3);
                Object object = CallState.getSynch();
                synchronized (object) {
                    CallState.setLogFetchDone();
                    if (DEBUGGING) {
                        System.out.println(String.valueOf(time.format(new Date())) + "calling launchDone from logFetch on failure (no log events)");
                        System.out.flush();
                    }
                    if (CallState.launchDone()) {
                        CallState.endLaunch();
                    }
                }
                return;
            }
            Date logDate = null;
            while (theItem != null && !CallState.isStopping()) {
                if (DEBUGGING) {
                    System.out.println(String.valueOf(time.format(new Date())) + ": log item: \t" + theItem.getKind() + "\t" + theItem.getTime() + "\t" + theItem.getBody());
                    System.out.flush();
                }
                try {
                    logDate = logDF.parse(theItem.getTime());
                }
                catch (ParseException e) {
                    DebugPlugin.log((IStatus)new Status(4, "org.eclipse.vtp.launching.tellme", 4, Messages.GetLogItems_4, (Throwable)e));
                }
                String body = theItem.getBody();
                if (body != null && body.trim().length() != 0 && body.indexOf("https://studio.tellme.com/telephone/cgi-bin/runapp.pl") == -1 && body.indexOf("https://studio.tellme.com/telephone/cgi-bin/runscratch.pl") == -1 && body.indexOf("http://redirect.vui.en-us.tellme.com/index.vxml") == -1) {
                    DebugEvent[] event = new DebugEvent[]{new DebugEvent((Object)activeBrowser, 32, 3)};
                    event[0].setData((Object)new VoiceXMLLogMessage(logDate, theItem.getBody()));
                    DebugPlugin.getDefault().fireDebugEventSet(event);
                    if (body.startsWith("FILE") && body.indexOf(" LOADED [") != -1) {
                        StringTokenizer st = new StringTokenizer(body);
                        if (st.hasMoreTokens()) {
                            st.nextToken();
                        }
                        if (st.hasMoreTokens()) {
                            try {
                                String strURI = st.nextToken();
                                DebugEvent[] resourceLoadEvent = new DebugEvent[]{new DebugEvent((Object)activeBrowser, 32, 1)};
                                resourceLoadEvent[0].setData((Object)new URI(strURI));
                                DebugPlugin.getDefault().fireDebugEventSet(resourceLoadEvent);
                            }
                            catch (Exception e) {
                                DebugPlugin.log((IStatus)new Status(4, "org.eclipse.vtp.launching.tellme", 4, Messages.GetLogItems_11, (Throwable)e));
                            }
                        }
                    }
                    if (body.startsWith("RECOGNIZED")) {
                        try {
                            Pattern p = Pattern.compile(".*result = \\[([^\\]]*)\\].* confidence = ([0-9\\.]+)\\%");
                            Matcher m = p.matcher(body);
                            if (m.matches() && m.groupCount() == 2) {
                                String result = m.group(1);
                                double confidence = Double.parseDouble(m.group(2));
                                VoiceXMLBrowserInput browserInput = new VoiceXMLBrowserInput();
                                browserInput.setConfidence(confidence);
                                if (confidence == 100.0) {
                                    browserInput.setInputType(1);
                                } else {
                                    browserInput.setInputType(2);
                                }
                                browserInput.setInput((Object)result);
                                DebugEvent[] resourceLoadEvent = new DebugEvent[]{new DebugEvent((Object)activeBrowser, 32, 2)};
                                resourceLoadEvent[0].setData((Object)browserInput);
                                DebugPlugin.getDefault().fireDebugEventSet(resourceLoadEvent);
                            }
                        }
                        catch (Exception exception) {}
                    }
                }
                if (!"SESSION_DONE".equals(theItem.getBody())) {
                    theItem = theLogReader.nextLogItem();
                    continue;
                }
                break;
            }
        }
        catch (TellmeBrowserException e) {
            DebugPlugin.log((IStatus)new Status(4, "org.eclipse.vtp.launching.tellme", 4, Messages.GetLogItems_13, (Throwable)e));
        }
        if (DEBUGGING) {
            System.out.println(String.valueOf(time.format(new Date())) + ": no more log items");
            System.out.flush();
        }
        if (CallState.isStopping()) {
            CallState.reportLogFetchFail(Messages.GetLogItems_14);
        } else if (theLog == null) {
            CallState.reportLogFetchFail(Messages.GetLogItems_15);
        } else {
            CallState.setCallID(theLog.getCallID());
            CallState.reportLogFetchSucceed("");
        }
        Object object = CallState.getSynch();
        synchronized (object) {
            CallState.setLogFetchDone();
            if (DEBUGGING) {
                System.out.println(String.valueOf(time.format(new Date())) + ": calling launchDone from logFetch at end");
                System.out.flush();
            }
            if (CallState.launchDone()) {
                CallState.endLaunch();
            }
        }
    }
}

