/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.launching.internal.tellme;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.vtp.launching.internal.tellme.CallLog;
import org.eclipse.vtp.launching.internal.tellme.CallState;
import org.eclipse.vtp.launching.internal.tellme.GetLogItems;
import org.eclipse.vtp.launching.internal.tellme.Messages;
import org.eclipse.vtp.launching.internal.tellme.StudioInteractions;
import org.eclipse.vtp.launching.internal.tellme.TellmePlugin;

public class GetLogListChange
implements Runnable {
    static final int WAIT_SECS = 30;
    private static final SimpleDateFormat time = new SimpleDateFormat("mm:ss.SSS", Locale.getDefault());
    private static final boolean DEBUGGING = TellmePlugin.getDefault().isDebugging();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        CallState.initLogList();
        String logList0 = StudioInteractions.getFirstLogFromList(StudioInteractions.getListOfLogs()).getSessionID();
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e1) {
            DebugPlugin.log((IStatus)new Status(4, "org.eclipse.vtp.launching.tellme", 4, Messages.GetLogListChange_0, (Throwable)e1));
        }
        String logList = null;
        CallLog log = null;
        int waitLoops = 15;
        while ((logList = (log = StudioInteractions.getFirstLogFromList(StudioInteractions.getListOfLogs())).getSessionID()) != null && logList.equals(logList0) && waitLoops-- != 0 && !CallState.isStopping()) {
            if (DEBUGGING) {
                System.out.println(String.valueOf(time.format(new Date())) + ": Check for log flow start again.");
                System.out.flush();
            }
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                DebugPlugin.log((IStatus)new Status(4, "org.eclipse.vtp.launching.tellme", 4, Messages.GetLogListChange_1, (Throwable)e));
            }
        }
        if (CallState.isStopping()) {
            CallState.reportLogListFail(Messages.GetLogListChange_2);
            CallState.reportLogFetchFail("");
            Object object = CallState.getSynch();
            synchronized (object) {
                CallState.setLogListDone();
                CallState.setLogFetchDone();
                if (CallState.launchDone()) {
                    CallState.endLaunch();
                }
            }
            return;
        }
        if (waitLoops <= 0) {
            if (DEBUGGING) {
                System.out.println("waited too long for log to start streaming");
                System.out.flush();
            }
            CallState.reportLogListFail(String.valueOf(Messages.GetLogListChange_4) + 30 + Messages.GetLogListChange_5);
            CallState.setLog(null);
        } else {
            CallState.setLog(log);
            CallState.reportLogListSucceed("");
        }
        Object object = CallState.getSynch();
        synchronized (object) {
            CallState.setLogListDone();
        }
        new GetLogItems().run();
    }
}

