/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.launching.internal.tellme.config;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.vtp.debug.ui.BrowserConfigurationUIListener;
import org.eclipse.vtp.debug.ui.IBrowserConfigurationUI;
import org.eclipse.vtp.launching.internal.tellme.DisplayActions;
import org.eclipse.vtp.launching.internal.tellme.Messages;
import org.eclipse.vtp.launching.internal.tellme.TellmePlugin;

public class TellmeBrowserConfig
implements IBrowserConfigurationUI {
    protected Text devID = null;
    protected Label idlabel = null;
    protected Text devPIN = null;
    protected Label pinlabel = null;
    protected Text devEMAIL = null;
    protected Text devPSWD = null;
    protected Button noAutoLogin = null;
    private Group tellmeGroup = null;
    private final String phoneNumber;
    private boolean inInitialize = false;

    public TellmeBrowserConfig() {
        Preferences pluginPrefs = TellmePlugin.getDefault().getPluginPreferences();
        this.phoneNumber = pluginPrefs.getString("org.eclipse.vtp.launching.tellme.studio_phone");
    }

    public void drawConfigurationUI(Composite compUI, BrowserConfigurationUIListener callback) {
        final BrowserConfigurationUIListener localcallback = callback;
        ModifyListener listener = new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                if (!TellmeBrowserConfig.this.inInitialize) {
                    localcallback.contentsChanged();
                }
            }
        };
        SelectionAdapter check = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Button myWidget = (Button)event.widget;
                if (myWidget.getSelection()) {
                    TellmeBrowserConfig.this.devID.setEnabled(true);
                    TellmeBrowserConfig.this.idlabel.setEnabled(true);
                    TellmeBrowserConfig.this.devPIN.setEnabled(true);
                    TellmeBrowserConfig.this.pinlabel.setEnabled(true);
                } else {
                    TellmeBrowserConfig.this.devID.setEnabled(false);
                    TellmeBrowserConfig.this.idlabel.setEnabled(false);
                    TellmeBrowserConfig.this.devPIN.setEnabled(false);
                    TellmeBrowserConfig.this.pinlabel.setEnabled(false);
                }
                localcallback.contentsChanged();
            }
        };
        Text info = new Text(compUI, 8);
        GridData infoData = new GridData(768);
        infoData.verticalIndent = 20;
        info.setText(Messages.TellmeBrowserConfig_0);
        this.tellmeGroup = new Group(compUI, 16);
        GridData groupgd = new GridData(768);
        groupgd.verticalIndent = 15;
        this.tellmeGroup.setLayoutData((Object)groupgd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        this.tellmeGroup.setLayout((Layout)layout);
        this.tellmeGroup.setText(Messages.TellmeBrowserConfig_1);
        Label email = new Label((Composite)this.tellmeGroup, 0);
        email.setText(Messages.TellmeBrowserConfig_2);
        email.setLayoutData((Object)new GridData());
        this.devEMAIL = new Text((Composite)this.tellmeGroup, 2052);
        GridData grid = new GridData(768);
        grid.grabExcessHorizontalSpace = true;
        this.devEMAIL.setLayoutData((Object)grid);
        this.devEMAIL.addModifyListener(listener);
        Label pswd = new Label((Composite)this.tellmeGroup, 0);
        pswd.setText(Messages.TellmeBrowserConfig_3);
        pswd.setLayoutData((Object)new GridData());
        this.devPSWD = new Text((Composite)this.tellmeGroup, 0x400804);
        grid = new GridData(768);
        grid.grabExcessHorizontalSpace = true;
        this.devPSWD.setLayoutData((Object)grid);
        this.devPSWD.addModifyListener(listener);
        Composite loginControl = new Composite((Composite)this.tellmeGroup, 0);
        GridData loginCtrlLayout = new GridData(768);
        loginCtrlLayout.horizontalSpan = 4;
        loginControl.setLayoutData((Object)loginCtrlLayout);
        loginControl.setLayout((Layout)new RowLayout(256));
        this.noAutoLogin = new Button(loginControl, 32);
        this.noAutoLogin.setSelection(false);
        this.noAutoLogin.addSelectionListener((SelectionListener)check);
        Label box = new Label(loginControl, 0);
        box.setText(Messages.TellmeBrowserConfig_4);
        this.idlabel = new Label((Composite)this.tellmeGroup, 0);
        this.idlabel.setText(Messages.TellmeBrowserConfig_5);
        this.idlabel.setLayoutData((Object)new GridData());
        this.idlabel.setEnabled(false);
        this.devID = new Text((Composite)this.tellmeGroup, 2052);
        grid = new GridData(768);
        grid.grabExcessHorizontalSpace = true;
        this.devID.setLayoutData((Object)grid);
        this.devID.addModifyListener(listener);
        this.devID.setEnabled(false);
        this.pinlabel = new Label((Composite)this.tellmeGroup, 0);
        this.pinlabel.setText(Messages.TellmeBrowserConfig_6);
        this.pinlabel.setLayoutData((Object)new GridData());
        this.pinlabel.setEnabled(false);
        this.devPIN = new Text((Composite)this.tellmeGroup, 0x400804);
        grid = new GridData(768);
        grid.grabExcessHorizontalSpace = true;
        this.devPIN.setLayoutData((Object)grid);
        this.devPIN.addModifyListener(listener);
        this.devPIN.setEnabled(false);
        Group tellmeInfoGroup = new Group(compUI, 24);
        GridLayout gl2 = new GridLayout();
        tellmeInfoGroup.setText(Messages.TellmeBrowserConfig_7);
        tellmeInfoGroup.setLayout((Layout)gl2);
        GridData groupgd2 = new GridData(1808);
        groupgd2.grabExcessHorizontalSpace = true;
        groupgd2.grabExcessVerticalSpace = true;
        tellmeInfoGroup.setLayoutData((Object)groupgd2);
        Link l = new Link((Composite)tellmeInfoGroup, 0);
        l.setText(String.valueOf(Messages.TellmeBrowserConfig_8) + Messages.TellmeBrowserConfig_9 + Messages.TellmeBrowserConfig_10 + Messages.TellmeBrowserConfig_11 + Messages.TellmeBrowserConfig_12 + Messages.TellmeBrowserConfig_13 + Messages.TellmeBrowserConfig_14);
        l.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.text != null && event.text.startsWith("http")) {
                    Program.launch((String)event.text);
                }
            }
        });
        GridData txtgd = new GridData(1808);
        l.setLayoutData((Object)txtgd);
        compUI.pack();
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        if (this.devEMAIL != null) {
            this.devEMAIL.setText("");
        }
        if (this.devPSWD != null) {
            this.devPSWD.setText("");
        }
        if (this.devID != null) {
            this.devID.setText("");
        }
        if (this.devPIN != null) {
            this.devPIN.setText("");
        }
        this.noAutoLogin.setSelection(false);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.vtp.launching.tellme.devID", this.devID.getText().trim());
        configuration.setAttribute("org.eclipse.vtp.launching.tellme.devPIN", this.devPIN.getText().trim());
        configuration.setAttribute("org.eclipse.vtp.launching.tellme.devEMAIL", this.devEMAIL.getText().trim());
        configuration.setAttribute("org.eclipse.vtp.launching.tellme.devPSWD", this.devPSWD.getText().trim());
        configuration.setAttribute("org.eclipse.vtp.launching.tellme.devNoAutoLogin", String.valueOf(this.noAutoLogin.getSelection()).trim());
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.inInitialize = true;
        try {
            this.devID.setText(configuration.getAttribute("org.eclipse.vtp.launching.tellme.devID", ""));
            this.devPIN.setText(configuration.getAttribute("org.eclipse.vtp.launching.tellme.devPIN", ""));
            this.devEMAIL.setText(configuration.getAttribute("org.eclipse.vtp.launching.tellme.devEMAIL", ""));
            this.devPSWD.setText(configuration.getAttribute("org.eclipse.vtp.launching.tellme.devPSWD", ""));
            this.noAutoLogin.setSelection("true".equals(configuration.getAttribute("org.eclipse.vtp.launching.tellme.devNoAutoLogin", "false")));
            if (this.noAutoLogin.getSelection()) {
                this.devID.setEnabled(true);
                this.devPIN.setEnabled(true);
                this.idlabel.setEnabled(true);
                this.pinlabel.setEnabled(true);
            }
        }
        catch (CoreException e) {
            DisplayActions.showError(String.valueOf(Messages.TellmeBrowserConfig_15) + e.getMessage());
        }
        this.inInitialize = false;
    }

    public boolean isValid(ILaunchConfiguration configuration) {
        boolean valid = true;
        try {
            String devid = configuration.getAttribute("org.eclipse.vtp.launching.tellme.devID", "").trim();
            String devpin = configuration.getAttribute("org.eclipse.vtp.launching.tellme.devPIN", "").trim();
            String devemail = configuration.getAttribute("org.eclipse.vtp.launching.tellme.devEMAIL", "").trim();
            String devpswd = configuration.getAttribute("org.eclipse.vtp.launching.tellme.devPSWD", "");
            String noautologin = configuration.getAttribute("org.eclipse.vtp.launching.tellme.devNoAutoLogin", "false").trim();
            if (!(noautologin.equals("false") || devid.length() != 0 && devpin.length() != 0)) {
                return false;
            }
            if (devemail.length() == 0 || devpswd.length() == 0) {
                return false;
            }
        }
        catch (CoreException e) {
            valid = false;
            e.printStackTrace();
        }
        return valid;
    }

    public void dispose() {
        if (this.tellmeGroup == null) {
            return;
        }
        this.tellmeGroup.dispose();
    }
}

