/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.adt.design;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.wst.xsd.ui.internal.adt.design.DesignViewContextMenuProvider;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.RootContentEditPart;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.model.IGraphElement;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.model.IModelProxy;
import org.eclipse.wst.xsd.ui.internal.adt.editor.CommonSelectionManager;
import org.eclipse.wst.xsd.ui.internal.adt.facade.IADTObject;
import org.eclipse.wst.xsd.ui.internal.adt.facade.IField;
import org.eclipse.wst.xsd.ui.internal.adt.facade.IModel;
import org.eclipse.wst.xsd.ui.internal.adt.facade.IStructure;
import org.eclipse.wst.xsd.ui.internal.adt.outline.ADTContentOutlinePage;

public class DesignViewGraphicalViewer
extends ScrollingGraphicalViewer
implements ISelectionChangedListener {
    protected ADTSelectionChangedListener internalSelectionProvider = new ADTSelectionChangedListener();
    protected InputChangeManager inputChangeManager = new InputChangeManager();

    public DesignViewGraphicalViewer(IEditorPart editor, CommonSelectionManager manager) {
        this.setContextMenu((MenuManager)new DesignViewContextMenuProvider(editor, (EditPartViewer)this, (ISelectionProvider)this));
        editor.getEditorSite().registerContextMenu("org.eclipse.wst.xsd.ui.popup.graph", this.getContextMenu(), (ISelectionProvider)this.internalSelectionProvider, false);
        this.addSelectionChangedListener(this.internalSelectionProvider);
        this.internalSelectionProvider.addSelectionChangedListener(manager);
        manager.addSelectionChangedListener(this);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        Object selectedObject = ((StructuredSelection)event.getSelection()).getFirstElement();
        if (event.getSource() != this.internalSelectionProvider) {
            EditPart editPart;
            if (selectedObject instanceof IStructure) {
                if ((this.getInput() instanceof IModel && event.getSource() instanceof ADTContentOutlinePage || !(this.getInput() instanceof IModel)) && selectedObject instanceof IGraphElement && ((IGraphElement)selectedObject).isFocusAllowed()) {
                    this.setInput((IStructure)selectedObject);
                }
            } else if (selectedObject instanceof IGraphElement) {
                if (((IGraphElement)selectedObject).isFocusAllowed() && event.getSource() instanceof ADTContentOutlinePage) {
                    this.setInput((IADTObject)selectedObject);
                }
            } else if (selectedObject instanceof IField) {
                IField field = (IField)selectedObject;
                if (field.isGlobal() && this.getInput() instanceof IModel && event.getSource() instanceof ADTContentOutlinePage || field.isGlobal() && !(this.getInput() instanceof IModel)) {
                    this.setInput(field);
                }
            } else if (selectedObject instanceof IModelProxy) {
                IModelProxy adapter = (IModelProxy)selectedObject;
                if (this.getInput() != adapter.getModel()) {
                    this.setInput(adapter.getModel());
                }
            } else if (selectedObject instanceof IModel && this.getInput() != selectedObject) {
                this.setInput((IModel)selectedObject);
            }
            if ((editPart = this.getEditPart((EditPart)this.getRootEditPart(), selectedObject)) != null) {
                this.setSelection((ISelection)new StructuredSelection((Object)editPart));
            }
        }
    }

    protected EditPart getEditPart(EditPart parent, Object object) {
        EditPart editPart;
        EditPart result = null;
        Iterator i = parent.getChildren().iterator();
        while (i.hasNext()) {
            editPart = (EditPart)i.next();
            if (editPart.getModel() != object) continue;
            result = editPart;
            break;
        }
        if (result == null) {
            i = parent.getChildren().iterator();
            while (i.hasNext()) {
                editPart = this.getEditPart((EditPart)i.next(), object);
                if (editPart == null) continue;
                result = editPart;
                break;
            }
        }
        return result;
    }

    public void setInput(IADTObject object) {
        RootContentEditPart rootContentEditPart = (RootContentEditPart)this.getRootEditPart().getContents();
        rootContentEditPart.setModel(object);
        rootContentEditPart.refresh();
        this.inputChangeManager.setSelection((ISelection)new StructuredSelection((Object)object));
    }

    public IADTObject getInput() {
        RootContentEditPart rootContentEditPart = (RootContentEditPart)this.getRootEditPart().getContents();
        return (IADTObject)rootContentEditPart.getModel();
    }

    public EditPart getInputEditPart() {
        return this.getRootEditPart().getContents();
    }

    public void addInputChangdListener(ISelectionChangedListener listener) {
        this.inputChangeManager.addSelectionChangedListener(listener);
    }

    public void removeInputChangdListener(ISelectionChangedListener listener) {
        this.inputChangeManager.removeSelectionChangedListener(listener);
    }

    class ADTSelectionChangedListener
    implements ISelectionProvider,
    ISelectionChangedListener {
        protected List listenerList = new ArrayList();
        protected ISelection selection = new StructuredSelection();

        ADTSelectionChangedListener() {
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            this.listenerList.add(listener);
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            this.listenerList.remove(listener);
        }

        public ISelection getSelection() {
            return this.selection;
        }

        protected void notifyListeners(SelectionChangedEvent event) {
            Iterator i = this.listenerList.iterator();
            while (i.hasNext()) {
                ISelectionChangedListener listener = (ISelectionChangedListener)i.next();
                listener.selectionChanged(event);
            }
        }

        public StructuredSelection convertSelectionFromEditPartToModel(ISelection editPartSelection) {
            ArrayList<Object> selectedModelObjectList = new ArrayList<Object>();
            if (editPartSelection instanceof IStructuredSelection) {
                Iterator i = ((IStructuredSelection)editPartSelection).iterator();
                while (i.hasNext()) {
                    Object obj = i.next();
                    Object model = null;
                    if (obj instanceof EditPart) {
                        EditPart editPart = (EditPart)obj;
                        model = editPart.getModel();
                    }
                    if (model == null) continue;
                    selectedModelObjectList.add(model);
                }
            }
            return new StructuredSelection(selectedModelObjectList);
        }

        public void setSelection(ISelection selection) {
            this.selection = selection;
        }

        public void selectionChanged(SelectionChangedEvent event) {
            StructuredSelection newSelection = this.convertSelectionFromEditPartToModel(event.getSelection());
            this.selection = newSelection;
            SelectionChangedEvent newEvent = new SelectionChangedEvent((ISelectionProvider)this, (ISelection)newSelection);
            this.notifyListeners(newEvent);
        }
    }

    private class InputChangeManager
    implements ISelectionProvider {
        List listeners = new ArrayList();

        private InputChangeManager() {
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }

        public ISelection getSelection() {
            return null;
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            this.listeners.remove(listener);
        }

        public void setSelection(ISelection selection) {
            this.notifyListeners(selection);
        }

        void notifyListeners(ISelection selection) {
            ArrayList list = new ArrayList(this.listeners);
            Iterator i = list.iterator();
            while (i.hasNext()) {
                ISelectionChangedListener listener = (ISelectionChangedListener)i.next();
                listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, selection));
            }
        }
    }
}

