/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.common.commands;

import org.eclipse.wst.xsd.ui.internal.adapters.XSDBaseAdapter;
import org.eclipse.wst.xsd.ui.internal.common.commands.BaseCommand;
import org.eclipse.wst.xsd.ui.internal.common.util.Messages;
import org.eclipse.xsd.XSDComplexTypeContent;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDCompositor;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDDerivationMethod;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.XSDVariety;

public class SetBaseTypeCommand
extends BaseCommand {
    XSDConcreteComponent concreteComponent;
    XSDTypeDefinition baseType;
    XSDBaseAdapter adapter;

    public SetBaseTypeCommand(XSDConcreteComponent concreteComponent, XSDTypeDefinition baseType) {
        super(Messages._UI_ACTION_SET_BASE_TYPE);
        this.concreteComponent = concreteComponent;
        this.baseType = baseType;
    }

    public void execute() {
        if (this.concreteComponent instanceof XSDComplexTypeDefinition) {
            XSDComplexTypeDefinition complexType = (XSDComplexTypeDefinition)this.concreteComponent;
            if (this.baseType instanceof XSDSimpleTypeDefinition) {
                if (!(complexType.getContent() instanceof XSDSimpleTypeDefinition)) {
                    XSDSimpleTypeDefinition simpleContent = XSDFactory.eINSTANCE.createXSDSimpleTypeDefinition();
                    complexType.setContent((XSDComplexTypeContent)simpleContent);
                }
            } else if (!(complexType.getContent() instanceof XSDParticle)) {
                XSDParticle particle = XSDFactory.eINSTANCE.createXSDParticle();
                XSDModelGroup group = XSDFactory.eINSTANCE.createXSDModelGroup();
                group.setCompositor(XSDCompositor.SEQUENCE_LITERAL);
                particle.setContent((XSDParticleContent)group);
                complexType.setContent((XSDComplexTypeContent)particle);
            }
            complexType.setBaseTypeDefinition(this.baseType);
            complexType.setDerivationMethod(XSDDerivationMethod.EXTENSION_LITERAL);
            this.formatChild(complexType.getElement());
        } else if (this.concreteComponent instanceof XSDSimpleTypeDefinition) {
            XSDSimpleTypeDefinition simpleType = (XSDSimpleTypeDefinition)this.concreteComponent;
            if (this.baseType instanceof XSDSimpleTypeDefinition) {
                XSDVariety variety = simpleType.getVariety();
                if (variety.getValue() == 0) {
                    simpleType.setBaseTypeDefinition((XSDSimpleTypeDefinition)this.baseType);
                } else if (variety.getValue() == 2) {
                    simpleType.getMemberTypeDefinitions().add((Object)this.baseType);
                } else if (variety.getValue() == 1) {
                    simpleType.setItemTypeDefinition((XSDSimpleTypeDefinition)this.baseType);
                }
            }
        }
    }
}

