/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.common.commands;

import org.eclipse.gef.commands.Command;
import org.eclipse.ltk.core.refactoring.participants.ProcessorBasedRefactoring;
import org.eclipse.ltk.core.refactoring.participants.RenameProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameRefactoring;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xsd.ui.internal.refactor.PerformUnsavedRefactoringOperation;
import org.eclipse.wst.xsd.ui.internal.refactor.XMLRefactoringComponent;
import org.eclipse.wst.xsd.ui.internal.refactor.rename.RenameComponentProcessor;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDSchema;

public class UpdateNameCommand
extends Command {
    private String newName;
    private XSDNamedComponent component;

    public UpdateNameCommand(String label, XSDNamedComponent component, String newName) {
        super(label);
        if (component instanceof XSDComplexTypeDefinition && component.getName() == null && component.eContainer() instanceof XSDNamedComponent && ((XSDNamedComponent)component.eContainer()).getName() != null) {
            component = (XSDNamedComponent)component.eContainer();
        }
        this.component = component;
        this.newName = newName;
    }

    public void execute() {
        this.renameComponent(this.newName);
    }

    private void renameComponent(String newName) {
        if (this.component.eContainer() instanceof XSDSchema) {
            XMLRefactoringComponent refactoringComponent = new XMLRefactoringComponent(this.component, (IDOMElement)this.component.getElement(), this.component.getName(), this.component.getTargetNamespace());
            RenameComponentProcessor processor = new RenameComponentProcessor(refactoringComponent, newName, true);
            RenameRefactoring refactoring = new RenameRefactoring((RenameProcessor)processor);
            PerformUnsavedRefactoringOperation operation = new PerformUnsavedRefactoringOperation((ProcessorBasedRefactoring)refactoring);
            operation.run(null);
        } else {
            this.component.setName(newName);
        }
    }
}

