/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.common.properties.sections.appinfo;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.wst.common.ui.internal.dialogs.SelectSingleFileDialog;
import org.eclipse.wst.xsd.ui.internal.common.properties.sections.appinfo.SelectFromCatalogDialog;
import org.eclipse.wst.xsd.ui.internal.common.properties.sections.appinfo.SpecificationForExtensionsSchema;
import org.eclipse.wst.xsd.ui.internal.common.util.Messages;
import org.eclipse.wst.xsd.ui.internal.editor.XSDEditorPlugin;

public class AddNewCategoryDialog
extends Dialog {
    private static final String SCHEMA_LABEL = Messages._UI_LABEL_SCHEMA;
    private static final String NAME_LABEL = Messages._UI_LABEL_NAME;
    private String dialogTitle = Messages._UI_LABEL_ADD_CATEGORY;
    protected MenuManager browseMenu;
    protected Label name;
    protected Text nameText;
    protected Label schema;
    protected CLabel schemaDisplayer;
    protected ToolBar browseToolBar;
    protected ToolItem browseItem;
    protected List invalidNames;
    protected String appInfoSchemaLocation;
    protected String categoryName;
    protected CLabel errDisplayer;
    protected boolean isCategoryNameValid;

    public AddNewCategoryDialog(Shell parentShell) {
        super(parentShell);
    }

    public AddNewCategoryDialog(Shell parentShell, String dialogTitle) {
        super(parentShell);
        this.dialogTitle = dialogTitle;
    }

    public void setUnavailableCategoryNames(List unavailNames) {
        this.invalidNames = unavailNames;
    }

    public String getNewCategoryName() {
        return this.categoryName.trim();
    }

    public String getCategoryLocation() {
        return this.appInfoSchemaLocation;
    }

    public SpecificationForExtensionsSchema getExtensionsSchemaSpec() {
        SpecificationForExtensionsSchema schemaSpec = new SpecificationForExtensionsSchema();
        schemaSpec.setDisplayName(this.getNewCategoryName());
        schemaSpec.setLocation(this.getCategoryLocation());
        return schemaSpec;
    }

    protected Control createButtonBar(Composite parent) {
        Control result = super.createButtonBar(parent);
        this.getButton(0).setEnabled(false);
        return result;
    }

    protected Button getButton(int id) {
        return super.getButton(id);
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(this.dialogTitle);
        Composite mainComposite = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout(3, false);
        layout.marginTop = 10;
        mainComposite.setLayout((Layout)layout);
        mainComposite.setLayoutData((Object)new GridData(1808));
        GridData data = new GridData();
        data.widthHint = 400;
        mainComposite.setLayoutData((Object)data);
        this.name = new Label(mainComposite, 0);
        this.name.setText(NAME_LABEL);
        this.nameText = new Text(mainComposite, 2052);
        this.nameText.setLayoutData((Object)new GridData(768));
        Button hidden = new Button(mainComposite, 0);
        hidden.setVisible(false);
        this.schema = new Label(mainComposite, 0);
        this.schema.setText(SCHEMA_LABEL);
        this.schemaDisplayer = new CLabel(mainComposite, 2052);
        this.schemaDisplayer.setLayoutData((Object)new GridData(768));
        this.browseToolBar = new ToolBar(mainComposite, 0x800000);
        this.browseItem = new ToolItem(this.browseToolBar, 0);
        this.browseItem.setImage(XSDEditorPlugin.getXSDImage("icons/appinfo_browse.gif"));
        this.browseMenu = new MenuManager();
        BrowseInWorkspaceAction browseInWorkspace = new BrowseInWorkspaceAction();
        this.browseMenu.add((IAction)browseInWorkspace);
        BrowseCatalogAction browseCatalog = new BrowseCatalogAction();
        this.browseMenu.add((IAction)browseCatalog);
        this.browseItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Menu menu = AddNewCategoryDialog.this.browseMenu.createContextMenu((Control)AddNewCategoryDialog.this.getShell());
                Rectangle bounds = AddNewCategoryDialog.this.browseItem.getBounds();
                Point topLeft = new Point(bounds.x, bounds.y + bounds.height);
                topLeft = AddNewCategoryDialog.this.browseToolBar.toDisplay(topLeft);
                menu.setLocation(topLeft.x, topLeft.y);
                menu.setVisible(true);
            }
        });
        this.errDisplayer = new CLabel(mainComposite, 0x800000);
        GridData gd = new GridData(1808);
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 3;
        this.errDisplayer.setLayoutData((Object)gd);
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddNewCategoryDialog.this.categoryName = AddNewCategoryDialog.this.nameText.getText();
                if (AddNewCategoryDialog.this.invalidNames != null && AddNewCategoryDialog.this.invalidNames.contains(AddNewCategoryDialog.this.categoryName.trim())) {
                    AddNewCategoryDialog.this.isCategoryNameValid = false;
                    AddNewCategoryDialog.this.getButton(0).setEnabled(false);
                    AddNewCategoryDialog.this.errDisplayer.setText(Messages._UI_ERROR_NAME_ALREADY_USED);
                    AddNewCategoryDialog.this.errDisplayer.setImage(XSDEditorPlugin.getXSDImage("icons/error_st_obj.gif"));
                    return;
                }
                if (AddNewCategoryDialog.this.categoryName.equals("")) {
                    AddNewCategoryDialog.this.isCategoryNameValid = false;
                    AddNewCategoryDialog.this.getButton(0).setEnabled(false);
                    AddNewCategoryDialog.this.errDisplayer.setText("");
                    AddNewCategoryDialog.this.errDisplayer.setImage(null);
                    return;
                }
                if (!AddNewCategoryDialog.this.categoryName.equals("")) {
                    AddNewCategoryDialog.this.isCategoryNameValid = true;
                    AddNewCategoryDialog.this.errDisplayer.setText("");
                    AddNewCategoryDialog.this.errDisplayer.setImage(null);
                }
                if (!AddNewCategoryDialog.this.appInfoSchemaLocation.equals("")) {
                    AddNewCategoryDialog.this.getButton(0).setEnabled(true);
                }
            }
        });
        return parent;
    }

    protected void okPressed() {
        super.okPressed();
    }

    protected class BrowseCatalogAction
    extends Action {
        public BrowseCatalogAction() {
            super(Messages._UI_ACTION_BROWSE_CATALOG);
        }

        public void run() {
            SelectFromCatalogDialog dialog = new SelectFromCatalogDialog(AddNewCategoryDialog.this.getShell());
            if (dialog.open() == 0) {
                AddNewCategoryDialog.this.appInfoSchemaLocation = dialog.getCurrentSelectionLocation();
                AddNewCategoryDialog.this.schemaDisplayer.setImage(XSDEditorPlugin.getXSDImage("icons/xmlcatalog_obj.gif"));
                AddNewCategoryDialog.this.schemaDisplayer.setText(dialog.getCurrentSelectionNamespace());
                if (AddNewCategoryDialog.this.isCategoryNameValid && !AddNewCategoryDialog.this.appInfoSchemaLocation.equals("")) {
                    AddNewCategoryDialog.this.getButton(0).setEnabled(true);
                    AddNewCategoryDialog.this.errDisplayer.setText("");
                    AddNewCategoryDialog.this.errDisplayer.setImage(null);
                }
            }
        }
    }

    protected class BrowseInWorkspaceAction
    extends Action {
        private static final String XSD_FILE_EXTENSION = ".xsd";

        public BrowseInWorkspaceAction() {
            super(Messages._UI_ACTION_BROWSE_WORKSPACE);
        }

        public void run() {
            IFile appInfoSchemaFile;
            SelectSingleFileDialog dialog = new SelectSingleFileDialog(AddNewCategoryDialog.this.getShell(), null, true);
            dialog.addFilterExtensions(new String[]{XSD_FILE_EXTENSION});
            dialog.create();
            dialog.setTitle(Messages._UI_LABEL_SELECT_XSD_FILE);
            dialog.setMessage(Messages._UI_DESCRIPTION_CHOOSE_XSD_FILE);
            if (dialog.open() == 0 && (appInfoSchemaFile = dialog.getFile()) != null) {
                String uri = appInfoSchemaFile.getFullPath().toString();
                while (uri.startsWith("/") || uri.startsWith("\\")) {
                    uri = uri.substring(1);
                }
                AddNewCategoryDialog.this.appInfoSchemaLocation = uri.toString();
                AddNewCategoryDialog.this.appInfoSchemaLocation = "file://" + Platform.getLocation().toString() + "/" + AddNewCategoryDialog.this.appInfoSchemaLocation;
                AddNewCategoryDialog.this.schemaDisplayer.setImage(XSDEditorPlugin.getXSDImage("icons/XSDFile.gif"));
                AddNewCategoryDialog.this.schemaDisplayer.setText(uri);
                if (AddNewCategoryDialog.this.isCategoryNameValid) {
                    AddNewCategoryDialog.this.getButton(0).setEnabled(true);
                    AddNewCategoryDialog.this.errDisplayer.setText("");
                    AddNewCategoryDialog.this.errDisplayer.setImage(null);
                }
            }
        }
    }
}

