/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mirror.util;

import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.ConstructorDeclaration;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.EnumConstantDeclaration;
import com.sun.mirror.declaration.EnumDeclaration;
import com.sun.mirror.declaration.ExecutableDeclaration;
import com.sun.mirror.declaration.FieldDeclaration;
import com.sun.mirror.declaration.InterfaceDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.Modifier;
import com.sun.mirror.declaration.ParameterDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.declaration.TypeParameterDeclaration;
import com.sun.mirror.util.DeclarationScanner;
import com.sun.mirror.util.DeclarationVisitor;
import com.sun.mirror.util.SimpleDeclarationVisitor;
import com.sun.mirror.util.SourcePosition;
import java.util.Comparator;
import java.util.TreeSet;

class SourceOrderDeclScanner
extends DeclarationScanner {
    static final Comparator<Declaration> comparator = new SourceOrderComparator();

    SourceOrderDeclScanner(DeclarationVisitor pre, DeclarationVisitor post) {
        super(pre, post);
    }

    public void visitTypeDeclaration(TypeDeclaration d) {
        d.accept(this.pre);
        TreeSet<Declaration> decls = new TreeSet<Declaration>(comparator);
        for (TypeParameterDeclaration typeParameterDeclaration : d.getFormalTypeParameters()) {
            decls.add(typeParameterDeclaration);
        }
        for (FieldDeclaration fieldDeclaration : d.getFields()) {
            decls.add(fieldDeclaration);
        }
        for (MethodDeclaration methodDeclaration : d.getMethods()) {
            decls.add(methodDeclaration);
        }
        for (TypeDeclaration typeDeclaration : d.getNestedTypes()) {
            decls.add(typeDeclaration);
        }
        for (Declaration declaration : decls) {
            declaration.accept(this);
        }
        d.accept(this.post);
    }

    public void visitClassDeclaration(ClassDeclaration d) {
        d.accept(this.pre);
        TreeSet<Declaration> decls = new TreeSet<Declaration>(comparator);
        for (TypeParameterDeclaration tpDecl : d.getFormalTypeParameters()) {
            decls.add(tpDecl);
        }
        for (FieldDeclaration fieldDecl : d.getFields()) {
            decls.add(fieldDecl);
        }
        for (MethodDeclaration methodDecl : d.getMethods()) {
            decls.add(methodDecl);
        }
        for (TypeDeclaration typeDecl : d.getNestedTypes()) {
            decls.add(typeDecl);
        }
        for (ConstructorDeclaration ctorDecl : d.getConstructors()) {
            decls.add(ctorDecl);
        }
        for (Declaration decl : decls) {
            decl.accept(this);
        }
        d.accept(this.post);
    }

    public void visitExecutableDeclaration(ExecutableDeclaration d) {
        d.accept(this.pre);
        TreeSet<Declaration> decls = new TreeSet<Declaration>(comparator);
        for (TypeParameterDeclaration tpDecl : d.getFormalTypeParameters()) {
            decls.add(tpDecl);
        }
        for (ParameterDeclaration pDecl : d.getParameters()) {
            decls.add(pDecl);
        }
        for (Declaration decl : decls) {
            decl.accept(this);
        }
        d.accept(this.post);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SourceOrderComparator
    implements Comparator<Declaration> {
        static final /* synthetic */ boolean $assertionsDisabled;

        static {
            $assertionsDisabled = !SourceOrderComparator.class.desiredAssertionStatus();
        }

        SourceOrderComparator() {
        }

        static boolean equals(Declaration d1, Declaration d2) {
            return d1 == d2 || d1 != null && d1.equals(d2);
        }

        private int compareEqualPosition(Declaration d1, Declaration d2) {
            if (!$assertionsDisabled && d1.getPosition() != d2.getPosition()) {
                throw new AssertionError();
            }
            DeclPartialOrder dpo1 = new DeclPartialOrder();
            DeclPartialOrder dpo2 = new DeclPartialOrder();
            d1.accept(dpo1);
            d2.accept(dpo2);
            int difference = dpo1.getValue() - dpo2.getValue();
            if (difference != 0) {
                return difference;
            }
            int result = d1.getSimpleName().compareTo(d2.getSimpleName());
            if (result != 0) {
                return result;
            }
            return Long.signum((long)System.identityHashCode(d1) - (long)System.identityHashCode(d2));
        }

        @Override
        public int compare(Declaration d1, Declaration d2) {
            if (SourceOrderComparator.equals(d1, d2)) {
                return 0;
            }
            SourcePosition p1 = d1.getPosition();
            SourcePosition p2 = d2.getPosition();
            if (p1 == null && p2 != null) {
                return 1;
            }
            if (p1 != null && p2 == null) {
                return -1;
            }
            if (p1 == null && p2 == null) {
                return this.compareEqualPosition(d1, d2);
            }
            if (!($assertionsDisabled || p1 != null && p2 != null)) {
                throw new AssertionError();
            }
            int fileComp = p1.file().compareTo(p2.file());
            if (fileComp == 0) {
                long diff = (long)p1.line() - (long)p2.line();
                if (diff == 0L) {
                    diff = Long.signum((long)p1.column() - (long)p2.column());
                    if (diff != 0L) {
                        return (int)diff;
                    }
                    return this.compareEqualPosition(d1, d2);
                }
                return diff < 0L ? -1 : 1;
            }
            return fileComp;
        }

        private static class DeclPartialOrder
        extends SimpleDeclarationVisitor {
            private int value = 1000;

            private static int staticAdjust(Declaration d) {
                return d.getModifiers().contains((Object)Modifier.STATIC) ? 0 : 1;
            }

            DeclPartialOrder() {
            }

            public int getValue() {
                return this.value;
            }

            public void visitTypeParameterDeclaration(TypeParameterDeclaration d) {
                this.value = 0;
            }

            public void visitEnumConstantDeclaration(EnumConstantDeclaration d) {
                this.value = 1;
            }

            public void visitClassDeclaration(ClassDeclaration d) {
                this.value = 2 + DeclPartialOrder.staticAdjust(d);
            }

            public void visitInterfaceDeclaration(InterfaceDeclaration d) {
                this.value = 4;
            }

            public void visitEnumDeclaration(EnumDeclaration d) {
                this.value = 6;
            }

            public void visitAnnotationTypeDeclaration(AnnotationTypeDeclaration d) {
                this.value = 8;
            }

            public void visitFieldDeclaration(FieldDeclaration d) {
                this.value = 10 + DeclPartialOrder.staticAdjust(d);
            }

            public void visitConstructorDeclaration(ConstructorDeclaration d) {
                this.value = 12;
            }

            public void visitMethodDeclaration(MethodDeclaration d) {
                this.value = 14 + DeclPartialOrder.staticAdjust(d);
            }
        }
    }
}

