/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.core.internal.env;

import com.sun.mirror.apt.AnnotationProcessorListener;
import com.sun.mirror.apt.Filer;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.apt.core.env.EclipseAnnotationProcessorEnvironment;
import org.eclipse.jdt.apt.core.env.Phase;
import org.eclipse.jdt.apt.core.internal.declaration.EclipseMirrorObject;
import org.eclipse.jdt.apt.core.internal.declaration.TypeDeclarationImpl;
import org.eclipse.jdt.apt.core.internal.env.APTProblem;
import org.eclipse.jdt.apt.core.internal.env.BaseProcessorEnv;
import org.eclipse.jdt.apt.core.internal.env.BuildEnv;
import org.eclipse.jdt.apt.core.internal.env.EnvUtil;
import org.eclipse.jdt.apt.core.internal.env.MessagerImpl;
import org.eclipse.jdt.apt.core.internal.env.ReconcileEnv;
import org.eclipse.jdt.apt.core.internal.util.Factory;
import org.eclipse.jdt.apt.core.internal.util.Visitors;
import org.eclipse.jdt.apt.core.util.AptConfig;
import org.eclipse.jdt.apt.core.util.EclipseMessager;
import org.eclipse.jdt.core.BindingKey;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.compiler.BuildContext;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.ReconcileContext;
import org.eclipse.jdt.core.dom.ASTRequestor;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ITypeBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCompilationEnv
extends BaseProcessorEnv
implements EclipseAnnotationProcessorEnvironment {
    private static final String PATHVAR_TOKEN = "^%[^%/\\\\ ]+%.*";
    private static final String PATHVAR_ROOT = "%ROOT%";
    private static final String PATHVAR_PROJECTROOT = "%PROJECT.DIR%";
    private Set<AnnotationProcessorListener> _listeners = null;
    protected List<APTProblem> _problems = new ArrayList<APTProblem>();
    private Map<String, String> _options;
    private boolean _isClosed = false;
    EnvCallback _callback;
    protected ASTRequestor _requestor;

    public static void newReconcileEnv(ReconcileContext reconcileContext, EnvCallback callback) {
        assert (reconcileContext != null) : "reconcile context is null";
        ReconcileEnv env = ReconcileEnv.newEnv(reconcileContext);
        env._callback = callback;
        env.openPipeline();
    }

    public static void newBuildEnv(BuildContext[] filesWithAnnotations, BuildContext[] additionalFiles, IJavaProject javaProj, EnvCallback callback) {
        assert (filesWithAnnotations != null) : "missing files";
        BuildEnv env = new BuildEnv(filesWithAnnotations, additionalFiles, javaProj);
        env._callback = callback;
        env.createASTs(filesWithAnnotations);
    }

    AbstractCompilationEnv(CompilationUnit compilationUnit, IFile file, IJavaProject javaProj, Phase phase) {
        super(compilationUnit, file, javaProj, phase);
        this.initOptions(javaProj);
    }

    @Override
    protected ITypeBinding getTypeDefinitionBindingFromCorrectName(String fullyQualifiedName) {
        this.checkValid();
        String key = BindingKey.createTypeBindingKey((String)fullyQualifiedName);
        return (ITypeBinding)this._requestor.createBindings(new String[]{key})[0];
    }

    @Override
    public void addListener(AnnotationProcessorListener listener) {
        this.checkValid();
        if (this._listeners == null) {
            this._listeners = new HashSet<AnnotationProcessorListener>();
        }
        this._listeners.add(listener);
    }

    @Override
    public void removeListener(AnnotationProcessorListener listener) {
        this.checkValid();
        if (this._listeners == null) {
            return;
        }
        this._listeners.remove(listener);
    }

    public Set<AnnotationProcessorListener> getProcessorListeners() {
        if (this._listeners == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this._listeners);
    }

    private void initOptions(IJavaProject jproj) {
        Map<String, String> procOptions = AptConfig.getProcessorOptions(jproj);
        this._options = new HashMap<String, String>(procOptions.size() * 2);
        for (Map.Entry<String, String> entry : procOptions.entrySet()) {
            String value = this.resolveVarPath(jproj, entry.getValue());
            String key = entry.getKey();
            this._options.put(key, value);
            if (AptConfig.isAutomaticProcessorOption(key)) continue;
            String sunStyle = value != null ? "-A" + entry.getKey() + "=" + value : "-A" + entry.getKey();
            this._options.put(sunStyle, "");
        }
    }

    private String resolveVarPath(IJavaProject jproj, String value) {
        if (value == null) {
            return null;
        }
        if (!Pattern.matches(PATHVAR_TOKEN, value)) {
            return value;
        }
        Path path = new Path(value);
        String firstToken = path.segment(0);
        if (PATHVAR_ROOT.equals(firstToken)) {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IResource proj = root.findMember(path.segment(1));
            if (proj == null) {
                return value;
            }
            IPath relativePath = path.removeFirstSegments(2);
            IPath absoluteProjPath = proj.getLocation();
            IPath absoluteResPath = absoluteProjPath.append(relativePath);
            return absoluteResPath.toOSString();
        }
        if (jproj != null && PATHVAR_PROJECTROOT.equals(firstToken)) {
            IPath relativePath = path.removeFirstSegments(1);
            IPath absoluteProjPath = jproj.getProject().getLocation();
            IPath absoluteResPath = absoluteProjPath.append(relativePath);
            return absoluteResPath.toOSString();
        }
        String cpvName = firstToken.substring(1, firstToken.length() - 1);
        IPath cpvPath = JavaCore.getClasspathVariable((String)cpvName);
        if (cpvPath != null) {
            IPath resolved = cpvPath.append(path.removeFirstSegments(1));
            return resolved.toOSString();
        }
        return value;
    }

    @Override
    public Map<String, String> getOptions() {
        HashMap<String, String> options = new HashMap<String, String>(this._options);
        options.put("phase", this.getPhase().toString());
        return options;
    }

    public abstract CompilationUnit getASTFrom(IFile var1);

    @Override
    public CompilationUnit getAST() {
        return this._astRoot;
    }

    @Override
    public EclipseMessager getMessager() {
        this.checkValid();
        return new MessagerImpl(this);
    }

    abstract void addMessage(IFile var1, int var2, int var3, MessagerImpl.Severity var4, String var5, int var6, String[] var7);

    public List<? extends CategorizedProblem> getProblems() {
        this.checkValid();
        if (!this._problems.isEmpty()) {
            EnvUtil.updateProblemLength(this._problems, this.getAstCompilationUnit());
        }
        return this._problems;
    }

    APTProblem createProblem(IFile resource, int start, int end, MessagerImpl.Severity severity, String msg, int line, String[] arguments) {
        APTProblem newProblem = new APTProblem(msg, severity, resource, start, end - 1, line, arguments);
        return newProblem;
    }

    @Override
    public abstract Filer getFiler();

    public Map<String, AnnotationTypeDeclaration> getAnnotationTypes() {
        this.checkValid();
        ArrayList<Annotation> instances = new ArrayList<Annotation>();
        HashMap<String, AnnotationTypeDeclaration> decls = new HashMap<String, AnnotationTypeDeclaration>();
        Visitors.AnnotationVisitor visitor = new Visitors.AnnotationVisitor(instances);
        this._astRoot.accept((ASTVisitor)visitor);
        int instanceIndex = 0;
        int size = instances.size();
        while (instanceIndex < size) {
            TypeDeclarationImpl decl;
            Annotation instance = (Annotation)instances.get(instanceIndex);
            ITypeBinding annoType = instance.resolveTypeBinding();
            if (annoType != null && (decl = Factory.createReferenceType(annoType, this)).kind() == EclipseMirrorObject.MirrorKind.TYPE_ANNOTATION) {
                AnnotationTypeDeclaration annoDecl = (AnnotationTypeDeclaration)((Object)decl);
                decls.put(annoDecl.getQualifiedName(), annoDecl);
            }
            ++instanceIndex;
        }
        return decls;
    }

    void checkValid() {
        if (this._isClosed) {
            throw new IllegalStateException("Environment has expired");
        }
    }

    public void close() {
        if (this.isClosed()) {
            return;
        }
        if (this._listeners != null) {
            this._listeners.clear();
        }
        this._problems = null;
        this._typeCache.clear();
        this._packageRootsCache = null;
        this._isClosed = true;
        this._callback = null;
        this._requestor = null;
    }

    boolean isClosed() {
        return this._isClosed;
    }

    public static interface EnvCallback {
        public void run(AbstractCompilationEnv var1);
    }
}

