/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ssh;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.IServerConnection;
import org.eclipse.team.internal.ccvs.core.connection.CVSAuthenticationException;
import org.eclipse.team.internal.ccvs.ssh.CVSSSHMessages;
import org.eclipse.team.internal.ccvs.ssh.Client;

public class SSHServerConnection
implements IServerConnection {
    private static final String INVOKE_SVR_CMD = "cvs server";
    private static final int DEFAULT_PORT = 22;
    private ICVSRepositoryLocation location;
    private String password;
    InputStream inputStream;
    OutputStream outputStream;
    Client client;

    public SSHServerConnection(ICVSRepositoryLocation location, String password) {
        this.location = location;
        this.password = password;
    }

    public void close() throws IOException {
        this.client.disconnect();
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void open(IProgressMonitor monitor) throws IOException, CVSAuthenticationException {
        monitor.subTask(CVSSSHMessages.SSHServerConnection_authenticating);
        monitor.worked(1);
        String hostname = this.location.getHost();
        String username = this.location.getUsername();
        int port = this.location.getPort();
        if (port == 0) {
            port = 22;
        }
        this.client = new Client(hostname, port, username, this.password, INVOKE_SVR_CMD, this.location.getTimeout());
        this.client.connect(monitor);
        this.inputStream = this.client.getInputStream();
        this.outputStream = this.client.getOutputStream();
    }
}

