/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.editor.ccxml.ui.internal.wizards;

import java.text.Collator;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.eclipse.vtp.editor.ccxml.ui.internal.Logger;
import org.eclipse.vtp.editor.ccxml.ui.internal.wizards.NewCCXMLModelWizard;
import org.eclipse.vtp.editor.ccxml.ui.internal.wizards.XMLWizardsMessages;
import org.eclipse.vtp.editor.internal.wizards.NewXMLGenerator;
import org.eclipse.wst.common.uriresolver.internal.util.URIHelper;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalogEntry;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.eclipse.wst.xml.core.internal.contentmodel.util.NamespaceInfo;
import org.eclipse.wst.xml.ui.internal.dialogs.NamespaceInfoErrorHelper;
import org.eclipse.wst.xml.ui.internal.dialogs.SelectFileOrXMLCatalogIdPanel;
import org.eclipse.wst.xml.ui.internal.nsedit.CommonEditNamespacesDialog;

public class NewXMLWizard
extends NewCCXMLModelWizard {
    protected static final int CREATE_FROM_DTD = 0;
    protected static final int CREATE_FROM_XSD = 1;
    protected static final int CREATE_FROM_SCRATCH = 2;
    protected static final int CREATE_FROM_DEFAULT = 3;
    protected static final String[] createFromRadioButtonLabel = new String[]{XMLWizardsMessages._UI_RADIO_XML_FROM_DTD, XMLWizardsMessages._UI_RADIO_XML_FROM_SCHEMA, XMLWizardsMessages._UI_RADIO_XML_FROM_SCRATCH, XMLWizardsMessages._UI_RADIO_XML_FROM_DEFAULT};
    protected static final String defaultFileExtension = ".ccxml";
    protected static final String[] filePageFilterExtensions = new String[]{".ccxml"};
    protected static final String[] browseXSDFilterExtensions = new String[]{".xsd"};
    protected static final String[] browseDTDFilterExtensions = new String[]{".dtd"};
    protected static final String rootElementName = "ccxml";
    protected NewCCXMLModelWizard.NewCCXMLFilePage newFilePage;
    protected NewCCXMLModelWizard.CCXMLStartPage startPage;
    protected SelectGrammarFilePage selectGrammarFilePage;
    protected SelectRootElementPage selectRootElementPage;
    protected String cmDocumentErrorMessage;
    protected NewXMLGenerator generator;
    static /* synthetic */ Class class$0;

    public NewXMLWizard() {
        this.setWindowTitle(XMLWizardsMessages._UI_WIZARD_CREATE_XML_HEADING);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.vtp.editor.ccxml.ui.internal.wizards.CCXMLWizard");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setDefaultPageImageDescriptor(ImageDescriptor.createFromFile((Class)clazz, (String)"icons/CCXMLNewFile.gif"));
        this.generator = new NewXMLGenerator();
    }

    public NewXMLWizard(IFile file, CMDocument cmDocument) {
        this();
        this.generator.setGrammarURI(URIHelper.getPlatformURI((IResource)file));
        this.generator.setCMDocument(cmDocument);
    }

    public static void showDialog(Shell shell, IFile file, IStructuredSelection structuredSelection) {
        String[] errorInfo = new String[2];
        CMDocument cmDocument = NewXMLGenerator.createCMDocument((String)file.getLocation().toOSString(), (String[])errorInfo);
        if (errorInfo[0] == null) {
            NewXMLWizard wizard = new NewXMLWizard(file, cmDocument);
            wizard.init(PlatformUI.getWorkbench(), structuredSelection);
            wizard.setNeedsProgressMonitor(true);
            WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
            dialog.create();
            dialog.getShell().setText(XMLWizardsMessages._UI_DIALOG_NEW_TITLE);
            dialog.setBlockOnOpen(true);
            dialog.open();
        } else {
            MessageDialog.openInformation((Shell)shell, (String)errorInfo[0], (String)errorInfo[1]);
        }
    }

    public void addPages() {
        String grammarURI = this.generator.getGrammarURI();
        if (grammarURI == null) {
            this.startPage = new NewCCXMLModelWizard.CCXMLStartPage(this, "StartPage", createFromRadioButtonLabel){

                public void createControl(Composite parent) {
                    super.createControl(parent);
                }

                public void setVisible(boolean visible) {
                    super.setVisible(visible);
                    this.getRadioButtonAtIndex(NewXMLWizard.this.getCreateMode()).setSelection(true);
                    this.getRadioButtonAtIndex(NewXMLWizard.this.getCreateMode()).setFocus();
                    PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)NewXMLWizard.this.startPage.getRadioButtonAtIndex(0), "org.eclipse.wst.xml.ui.xmlc0101");
                    PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)NewXMLWizard.this.startPage.getRadioButtonAtIndex(1), "org.eclipse.wst.xml.ui.xmlc0102");
                    PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)NewXMLWizard.this.startPage.getRadioButtonAtIndex(2), "org.eclipse.wst.xml.ui.xmlc0103");
                    PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)NewXMLWizard.this.startPage.getRadioButtonAtIndex(3), "org.eclipse.wst.xml.ui.xmlc0103");
                }
            };
            this.startPage.setTitle(XMLWizardsMessages._UI_WIZARD_CREATE_XML_HEADING);
            this.startPage.setDescription(XMLWizardsMessages._UI_WIZARD_CREATE_XML_EXPL);
            this.addPage((IWizardPage)this.startPage);
        }
        this.newFilePage = new NewCCXMLModelWizard.NewCCXMLFilePage(this.fSelection);
        this.newFilePage.setTitle(XMLWizardsMessages._UI_WIZARD_CREATE_XML_FILE_HEADING);
        this.newFilePage.setDescription(XMLWizardsMessages._UI_WIZARD_CREATE_XML_FILE_EXPL);
        this.newFilePage.defaultName = grammarURI != null ? URIHelper.removeFileExtension((String)URIHelper.getLastSegment((String)grammarURI)) : "NewFile";
        this.newFilePage.defaultFileExtension = defaultFileExtension;
        this.newFilePage.filterExtensions = filePageFilterExtensions;
        this.addPage((IWizardPage)this.newFilePage);
        this.selectGrammarFilePage = new SelectGrammarFilePage();
        this.addPage((IWizardPage)this.selectGrammarFilePage);
        this.selectRootElementPage = new SelectRootElementPage();
        this.selectRootElementPage.setTitle(XMLWizardsMessages._UI_WIZARD_SELECT_ROOT_HEADING);
        this.selectRootElementPage.setDescription(XMLWizardsMessages._UI_WIZARD_SELECT_ROOT_EXPL);
        this.addPage((IWizardPage)this.selectRootElementPage);
    }

    public IWizardPage getStartingPage() {
        Object result = null;
        result = this.startPage != null ? this.startPage : this.newFilePage;
        return result;
    }

    public int getCreateMode() {
        int selectedIndex;
        String grammarURI = this.generator.getGrammarURI();
        int result = 2;
        if (grammarURI != null) {
            if (grammarURI.endsWith(".dtd")) {
                result = 0;
            } else if (grammarURI.endsWith(".xsd")) {
                result = 1;
            }
        } else if (this.startPage != null && (selectedIndex = this.startPage.getSelectedRadioButtonIndex()) != -1) {
            result = selectedIndex;
        }
        return result;
    }

    public IWizardPage getNextPage(IWizardPage currentPage) {
        Object nextPage = null;
        if (currentPage == this.startPage) {
            nextPage = this.newFilePage;
        } else if (currentPage == this.newFilePage) {
            nextPage = this.getCreateMode() == 2 ? null : (this.getCreateMode() == 3 ? null : (this.generator.getGrammarURI() == null ? this.selectGrammarFilePage : this.selectRootElementPage));
        } else if (currentPage == this.selectGrammarFilePage) {
            nextPage = this.selectRootElementPage;
        }
        return nextPage;
    }

    public boolean canFinish() {
        boolean result = false;
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        if (this.startPage != null && (this.startPage.getSelectedRadioButtonIndex() == 2 || this.startPage.getSelectedRadioButtonIndex() == 3) && currentPage == this.newFilePage || currentPage == this.selectRootElementPage) {
            result = currentPage.isPageComplete();
        }
        return result;
    }

    public boolean performFinish() {
        boolean result = true;
        super.performFinish();
        String fileName = null;
        try {
            String[] namespaceErrors = this.generator.getNamespaceInfoErrors();
            if (namespaceErrors != null) {
                String title = namespaceErrors[0];
                String message = namespaceErrors[1];
                result = MessageDialog.openQuestion((Shell)this.getShell(), (String)title, (String)message);
            }
            if (result) {
                fileName = this.newFilePage.getFileName();
                if (new Path(fileName).getFileExtension() == null) {
                    this.newFilePage.setFileName(fileName.concat(defaultFileExtension));
                }
                IFile newFile = this.newFilePage.createNewFile();
                String xmlFileName = newFile.getLocation().toOSString();
                if (this.getCreateMode() == 3) {
                    this.generator.setGrammarURI(null);
                    this.generator.setCMDocument(null);
                    this.cmDocumentErrorMessage = null;
                    this.generator.createDefaultXMLDocument(newFile, xmlFileName, rootElementName, "org.eclipse.vtp.editor.ccxml.core.ccxmlsource");
                } else if (this.getContainer().getCurrentPage() == this.selectRootElementPage) {
                    this.generator.createXMLDocument(newFile, xmlFileName);
                } else {
                    this.generator.createEmptyXMLDocument(newFile);
                }
                newFile.refreshLocal(1, null);
                IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                BasicNewResourceWizard.selectAndReveal((IResource)newFile, (IWorkbenchWindow)workbenchWindow);
                this.openEditor(newFile);
            }
        }
        catch (Exception e) {
            Logger.logException("Exception completing New XML wizard " + fileName, e);
        }
        return result;
    }

    public void openEditor(IFile file) {
        String editorId = null;
        try {
            IEditorDescriptor editor = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(file.getLocation().toOSString(), file.getContentDescription().getContentType());
            if (editor != null) {
                editorId = editor.getId();
            }
        }
        catch (CoreException coreException) {
            return;
        }
        IWorkbenchWindow dw = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        try {
            IWorkbenchPage page;
            if (dw != null && (page = dw.getActivePage()) != null) {
                page.openEditor((IEditorInput)new FileEditorInput(file), editorId, true);
            }
        }
        catch (PartInitException partInitException) {
            return;
        }
    }

    protected String getDefaultSystemId() {
        String relativePath = "platform:/resource/" + this.newFilePage.getContainerFullPath().toString() + "/dummy";
        return URIHelper.getRelativeURI((String)this.generator.getGrammarURI(), (String)relativePath);
    }

    public static GridLayout createOptionsPanelLayout() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 0;
        return gridLayout;
    }

    class SelectGrammarFilePage
    extends WizardPage {
        protected SelectFileOrXMLCatalogIdPanel panel;

        SelectGrammarFilePage() {
            super("SelectGrammarFilePage");
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.wst.xml.ui.xmlc0500");
            composite.setLayout((Layout)new GridLayout());
            composite.setLayoutData((Object)new GridData(1808));
            this.setControl((Control)composite);
            this.panel = new SelectFileOrXMLCatalogIdPanel(composite);
            this.panel.setLayoutData((Object)new GridData(1808));
            SelectFileOrXMLCatalogIdPanel.Listener listener = new SelectFileOrXMLCatalogIdPanel.Listener(this){
                final /* synthetic */ SelectGrammarFilePage this$1;
                {
                    this.this$1 = selectGrammarFilePage;
                }

                public void completionStateChanged() {
                    this.this$1.updateErrorMessage();
                }
            };
            this.panel.setListener(listener);
        }

        public void setVisible(boolean visible) {
            super.setVisible(visible);
            if (visible) {
                if (NewXMLWizard.this.getCreateMode() == 0) {
                    this.setTitle(XMLWizardsMessages._UI_WIZARD_SELECT_DTD_FILE_TITLE);
                    this.setDescription(XMLWizardsMessages._UI_WIZARD_SELECT_DTD_FILE_DESC);
                    this.panel.setFilterExtensions(browseDTDFilterExtensions);
                } else {
                    this.setTitle(XMLWizardsMessages._UI_WIZARD_SELECT_XSD_FILE_TITLE);
                    this.setDescription(XMLWizardsMessages._UI_WIZARD_SELECT_XSD_FILE_DESC);
                    this.panel.setFilterExtensions(browseXSDFilterExtensions);
                }
                NewXMLWizard.this.generator.setGrammarURI(null);
                NewXMLWizard.this.generator.setCMDocument(null);
                NewXMLWizard.this.cmDocumentErrorMessage = null;
            }
            this.panel.setVisibleHelper(visible);
        }

        public String getURI() {
            IFile file;
            String uri = this.panel.getXMLCatalogURI();
            if (uri == null && (file = this.panel.getFile()) != null) {
                uri = URIHelper.getPlatformURI((IResource)file);
            }
            return uri;
        }

        public boolean isPageComplete() {
            return this.getURI() != null && this.getErrorMessage() == null;
        }

        public String getXMLCatalogId() {
            return this.panel.getXMLCatalogId();
        }

        public ICatalogEntry getXMLCatalogEntry() {
            return this.panel.getXMLCatalogEntry();
        }

        public String computeErrorMessage() {
            String errorMessage = null;
            String uri = this.getURI();
            if (uri != null && !URIHelper.isReadableURI((String)uri, (boolean)false)) {
                errorMessage = XMLWizardsMessages._UI_LABEL_ERROR_CATALOG_ENTRY_INVALID;
            }
            return errorMessage;
        }

        public void updateErrorMessage() {
            String errorMessage = this.computeErrorMessage();
            this.setErrorMessage(errorMessage);
            this.setPageComplete(this.isPageComplete());
        }
    }

    class SelectRootElementPage
    extends WizardPage
    implements SelectionListener {
        protected Combo combo;
        protected Button[] radioButton;
        protected PageBook pageBook;
        protected XSDOptionsPanel xsdOptionsPanel;
        protected DTDOptionsPanel dtdOptionsPanel;

        SelectRootElementPage() {
            super("SelectRootElementPage");
        }

        public void createControl(Composite parent) {
            Composite containerGroup = new Composite(parent, 0);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)containerGroup, "org.eclipse.wst.xml.ui.xmlc0410");
            containerGroup.setLayout((Layout)new GridLayout());
            containerGroup.setLayoutData((Object)new GridData(768));
            this.setControl((Control)containerGroup);
            Label containerLabel = new Label(containerGroup, 0);
            containerLabel.setText(XMLWizardsMessages._UI_LABEL_ROOT_ELEMENT);
            this.combo = new Combo(containerGroup, 12);
            this.combo.setLayoutData((Object)new GridData(768));
            this.combo.addSelectionListener((SelectionListener)this);
            Group group = new Group(containerGroup, 0);
            group.setText(XMLWizardsMessages._UI_WIZARD_CONTENT_OPTIONS);
            GridLayout layout = new GridLayout();
            layout.numColumns = 1;
            layout.makeColumnsEqualWidth = true;
            layout.marginWidth = 0;
            group.setLayout((Layout)layout);
            group.setLayoutData((Object)new GridData(768));
            this.radioButton = new Button[4];
            this.radioButton[0] = new Button((Composite)group, 32);
            this.radioButton[0].setText(XMLWizardsMessages._UI_WIZARD_CREATE_OPTIONAL_ATTRIBUTES);
            this.radioButton[0].setLayoutData((Object)new GridData(768));
            this.radioButton[0].setSelection(false);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.radioButton[0], "org.eclipse.wst.xml.ui.xmlc0441");
            this.radioButton[1] = new Button((Composite)group, 32);
            this.radioButton[1].setText(XMLWizardsMessages._UI_WIZARD_CREATE_OPTIONAL_ELEMENTS);
            this.radioButton[1].setLayoutData((Object)new GridData(768));
            this.radioButton[1].setSelection(false);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.radioButton[1], "org.eclipse.wst.xml.ui.xmlc0442");
            this.radioButton[2] = new Button((Composite)group, 32);
            this.radioButton[2].setText(XMLWizardsMessages._UI_WIZARD_CREATE_FIRST_CHOICE);
            this.radioButton[2].setLayoutData((Object)new GridData(768));
            this.radioButton[2].setSelection(true);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.radioButton[2], "org.eclipse.wst.xml.ui.xmlc0443");
            this.radioButton[3] = new Button((Composite)group, 32);
            this.radioButton[3].setText(XMLWizardsMessages._UI_WIZARD_FILL_ELEMENTS_AND_ATTRIBUTES);
            this.radioButton[3].setLayoutData((Object)new GridData(768));
            this.radioButton[3].setSelection(true);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.radioButton[3], "org.eclipse.wst.xml.ui.xmlc0444");
            this.pageBook = new PageBook(containerGroup, 0);
            this.pageBook.setLayoutData((Object)new GridData(1808));
            this.xsdOptionsPanel = new XSDOptionsPanel(this, (Composite)this.pageBook);
            this.dtdOptionsPanel = new DTDOptionsPanel(this, (Composite)this.pageBook);
            this.pageBook.showPage((Control)this.xsdOptionsPanel);
        }

        public void widgetSelected(SelectionEvent event) {
            int index = this.combo.getSelectionIndex();
            String rootElementName = index != -1 ? this.combo.getItem(index) : null;
            NewXMLWizard.this.generator.setRootElementName(rootElementName);
        }

        public void widgetDefaultSelected(SelectionEvent event) {
        }

        public void setVisible(boolean visible) {
            super.setVisible(visible);
            if (visible) {
                try {
                    if (NewXMLWizard.this.generator.getGrammarURI() == null) {
                        NewXMLWizard.this.generator.setGrammarURI(NewXMLWizard.this.selectGrammarFilePage.getURI());
                        NewXMLWizard.this.generator.setXMLCatalogEntry(NewXMLWizard.this.selectGrammarFilePage.getXMLCatalogEntry());
                    }
                    Assert.isNotNull((Object)NewXMLWizard.this.generator.getGrammarURI());
                    if (NewXMLWizard.this.generator.getCMDocument() == null) {
                        String[] errorInfo = new String[2];
                        CMDocument[] cmdocs = new CMDocument[1];
                        Runnable r = new Runnable(this, cmdocs, errorInfo){
                            final /* synthetic */ SelectRootElementPage this$1;
                            private final /* synthetic */ CMDocument[] val$cmdocs;
                            private final /* synthetic */ String[] val$errorInfo;
                            {
                                this.this$1 = selectRootElementPage;
                                this.val$cmdocs = cMDocumentArray;
                                this.val$errorInfo = stringArray;
                            }

                            public void run() {
                                this.val$cmdocs[0] = NewXMLGenerator.createCMDocument((String)SelectRootElementPage.access$0((SelectRootElementPage)this.this$1).generator.getGrammarURI(), (String[])this.val$errorInfo);
                            }
                        };
                        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)r);
                        NewXMLWizard.this.generator.setCMDocument(cmdocs[0]);
                        NewXMLWizard.this.cmDocumentErrorMessage = errorInfo[1];
                    }
                    if (NewXMLWizard.this.generator.getCMDocument() != null && NewXMLWizard.this.cmDocumentErrorMessage == null) {
                        CMNamedNodeMap nameNodeMap = NewXMLWizard.this.generator.getCMDocument().getElements();
                        Vector<String> nameNodeVector = new Vector<String>();
                        int i = 0;
                        while (i < nameNodeMap.getLength()) {
                            CMElementDeclaration cmElementDeclaration = (CMElementDeclaration)nameNodeMap.item(i);
                            Object value = cmElementDeclaration.getProperty("Abstract");
                            if (value != Boolean.TRUE) {
                                nameNodeVector.add(cmElementDeclaration.getElementName());
                            }
                            ++i;
                        }
                        Object[] nameNodeArray = nameNodeVector.toArray();
                        if (nameNodeArray.length > 0) {
                            Arrays.sort(nameNodeArray, Collator.getInstance());
                        }
                        String defaultRootName = (String)NewXMLWizard.this.generator.getCMDocument().getProperty("http://org.eclipse.wst/cm/properties/defaultRootName");
                        int defaultRootIndex = -1;
                        this.combo.removeAll();
                        int i2 = 0;
                        while (i2 < nameNodeArray.length) {
                            String elementName = (String)nameNodeArray[i2];
                            this.combo.add(elementName);
                            if (defaultRootName != null && defaultRootName.equals(elementName)) {
                                defaultRootIndex = i2;
                            }
                            ++i2;
                        }
                        if (nameNodeArray.length > 0) {
                            defaultRootIndex = defaultRootIndex != -1 ? defaultRootIndex : 0;
                            this.combo.select(defaultRootIndex);
                            NewXMLWizard.this.generator.setRootElementName(this.combo.getItem(defaultRootIndex));
                        }
                    }
                    if (NewXMLWizard.this.generator.getGrammarURI().endsWith("xsd")) {
                        this.pageBook.showPage((Control)this.xsdOptionsPanel);
                        NewXMLWizard.this.generator.setDefaultSystemId(NewXMLWizard.this.getDefaultSystemId());
                        NewXMLWizard.this.generator.createNamespaceInfoList();
                        int i = 0;
                        while (i < NewXMLWizard.this.generator.namespaceInfoList.size()) {
                            NamespaceInfo nsinfo = (NamespaceInfo)NewXMLWizard.this.generator.namespaceInfoList.get(i);
                            if ((nsinfo.prefix == null || nsinfo.prefix.trim().length() == 0) && nsinfo.uri != null && nsinfo.uri.trim().length() != 0) {
                                nsinfo.prefix = this.getDefaultPrefix(NewXMLWizard.this.generator.namespaceInfoList);
                            }
                            ++i;
                        }
                        this.xsdOptionsPanel.setNamespaceInfoList(NewXMLWizard.this.generator.namespaceInfoList);
                    } else if (NewXMLWizard.this.generator.getGrammarURI().endsWith("dtd")) {
                        this.pageBook.showPage((Control)this.dtdOptionsPanel);
                        this.dtdOptionsPanel.update();
                    }
                }
                catch (Exception exception) {}
                this.updateErrorMessage();
            }
        }

        private String getDefaultPrefix(List nsInfoList) {
            String defaultPrefix = "p";
            if (nsInfoList == null) {
                return defaultPrefix;
            }
            Vector<String> v = new Vector<String>();
            int i = 0;
            while (i < nsInfoList.size()) {
                NamespaceInfo nsinfo = (NamespaceInfo)nsInfoList.get(i);
                if (nsinfo.prefix != null) {
                    v.addElement(nsinfo.prefix);
                }
                ++i;
            }
            if (v.contains(defaultPrefix)) {
                String s = defaultPrefix;
                int j = 0;
                while (v.contains(s)) {
                    s = String.valueOf(defaultPrefix) + Integer.toString(j);
                    ++j;
                }
                return s;
            }
            return defaultPrefix;
        }

        public boolean isPageComplete() {
            boolean complete;
            boolean bl = complete = NewXMLWizard.this.generator.getRootElementName() != null && NewXMLWizard.this.generator.getRootElementName().length() > 0 && this.getErrorMessage() == null;
            if (complete) {
                int buildPolicy = 0;
                if (this.radioButton[0].getSelection()) {
                    buildPolicy |= 1;
                }
                if (this.radioButton[1].getSelection()) {
                    buildPolicy |= 2;
                }
                if (this.radioButton[2].getSelection()) {
                    buildPolicy = buildPolicy | 4 | 0x10;
                }
                if (this.radioButton[3].getSelection()) {
                    buildPolicy |= 8;
                }
                NewXMLWizard.this.generator.setBuildPolicy(buildPolicy);
            }
            return complete;
        }

        public String computeErrorMessage() {
            String errorMessage = null;
            if (NewXMLWizard.this.cmDocumentErrorMessage != null) {
                errorMessage = NewXMLWizard.this.cmDocumentErrorMessage;
            } else if (NewXMLWizard.this.generator.getRootElementName() == null || NewXMLWizard.this.generator.getRootElementName().length() == 0) {
                errorMessage = XMLWizardsMessages._ERROR_ROOT_ELEMENT_MUST_BE_SPECIFIED;
            }
            return errorMessage;
        }

        public void updateErrorMessage() {
            String errorMessage = this.computeErrorMessage();
            if (errorMessage == null) {
                if (this.xsdOptionsPanel.isVisible()) {
                    errorMessage = this.xsdOptionsPanel.computeErrorMessage();
                } else if (this.dtdOptionsPanel.isVisible()) {
                    errorMessage = this.dtdOptionsPanel.computeErrorMessage();
                }
            }
            this.setErrorMessage(errorMessage);
            this.setPageComplete(this.isPageComplete());
        }

        static /* synthetic */ NewXMLWizard access$0(SelectRootElementPage selectRootElementPage) {
            return selectRootElementPage.NewXMLWizard.this;
        }
    }

    class XSDOptionsPanel
    extends Composite {
        protected String errorMessage = null;
        protected SelectRootElementPage parentPage;
        protected CommonEditNamespacesDialog editNamespaces;

        public XSDOptionsPanel(SelectRootElementPage parentPage, Composite parent) {
            super(parent, 0);
            this.parentPage = parentPage;
            this.setLayout((Layout)NewXMLWizard.createOptionsPanelLayout());
            this.setLayoutData(new GridData(1808));
            Composite co = new Composite((Composite)this, 0);
            co.setLayout((Layout)new GridLayout());
            if (NewXMLWizard.this.newFilePage != null && NewXMLWizard.this.newFilePage.getContainerFullPath() != null) {
                String resourceURI = "platform:/resource" + NewXMLWizard.this.newFilePage.getContainerFullPath().toString() + "/dummy";
                String resolvedPath = URIHelper.normalize((String)resourceURI, null, null);
                if (resolvedPath.startsWith("file:/")) {
                    resolvedPath = resolvedPath.substring(6);
                }
                String tableTitle = XMLWizardsMessages._UI_LABEL_NAMESPACE_INFORMATION;
                this.editNamespaces = new CommonEditNamespacesDialog(co, (IPath)new Path(resolvedPath), tableTitle, true, true);
            }
        }

        public void setNamespaceInfoList(List list) {
            this.editNamespaces.setNamespaceInfoList(list);
            this.editNamespaces.updateErrorMessage(list);
        }

        public void updateErrorMessage(List namespaceInfoList) {
            NamespaceInfoErrorHelper helper = new NamespaceInfoErrorHelper();
            this.errorMessage = helper.computeErrorMessage(namespaceInfoList, null);
            this.parentPage.updateErrorMessage();
        }

        public String computeErrorMessage() {
            return this.errorMessage;
        }
    }

    public class DTDOptionsPanel
    extends Composite
    implements ModifyListener {
        protected Group group;
        protected Text systemIdField;
        protected Text publicIdField;
        protected SelectRootElementPage parentPage;

        public DTDOptionsPanel(SelectRootElementPage parentPage, Composite parent) {
            super(parent, 0);
            this.parentPage = parentPage;
            this.setLayoutData(new GridData(768));
            this.setLayout((Layout)NewXMLWizard.createOptionsPanelLayout());
            Group group = new Group((Composite)this, 0);
            group.setText(XMLWizardsMessages._UI_LABEL_DOCTYPE_INFORMATION);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            group.setLayout((Layout)layout);
            group.setLayoutData((Object)new GridData(768));
            Label publicIdLabel = new Label((Composite)group, 0);
            publicIdLabel.setText(XMLWizardsMessages._UI_LABEL_PUBLIC_ID);
            this.publicIdField = new Text((Composite)group, 2052);
            this.publicIdField.setLayoutData((Object)new GridData(768));
            this.publicIdField.addModifyListener((ModifyListener)this);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.publicIdField, "org.eclipse.wst.xml.ui.xmlc0210");
            Label systemIdLabel = new Label((Composite)group, 0);
            systemIdLabel.setText(XMLWizardsMessages._UI_LABEL_SYSTEM_ID);
            this.systemIdField = new Text((Composite)group, 2052);
            this.systemIdField.setLayoutData((Object)new GridData(768));
            this.systemIdField.addModifyListener((ModifyListener)this);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.systemIdField, "org.eclipse.wst.xml.ui.xmlc0220");
        }

        public void update() {
            String thePublicId = null;
            String theSystemId = null;
            ICatalogEntry xmlCatalogEntry = NewXMLWizard.this.generator.getXMLCatalogEntry();
            if (xmlCatalogEntry != null) {
                if (xmlCatalogEntry.getEntryType() == 2) {
                    thePublicId = xmlCatalogEntry.getKey();
                    theSystemId = xmlCatalogEntry.getAttributeValue("webURL");
                    if (theSystemId == null) {
                        theSystemId = NewXMLWizard.this.generator.getGrammarURI().startsWith("http:") ? NewXMLWizard.this.generator.getGrammarURI() : URIHelper.getLastSegment((String)NewXMLWizard.this.generator.getGrammarURI());
                    }
                } else {
                    theSystemId = xmlCatalogEntry.getKey();
                }
            } else {
                theSystemId = NewXMLWizard.this.getDefaultSystemId();
            }
            this.publicIdField.setText(thePublicId != null ? thePublicId : "");
            this.systemIdField.setText(theSystemId != null ? theSystemId : "");
        }

        public void modifyText(ModifyEvent e) {
            NewXMLWizard.this.generator.setSystemId(this.systemIdField.getText());
            NewXMLWizard.this.generator.setPublicId(this.publicIdField.getText());
            this.parentPage.updateErrorMessage();
        }

        public String computeErrorMessage() {
            return null;
        }
    }
}

