/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.languages.es;

import java.math.BigDecimal;
import java.net.URL;
import java.util.Calendar;
import java.util.Currency;
import java.util.Date;
import java.util.Locale;
import org.eclipse.vtp.framework.media.language.DefaultTranslator;
import org.eclipse.vtp.framework.media.language.TranslatorOutput;

public class SpanishTranslator
extends DefaultTranslator {
    private static final String ORDINALS_GROUP = "Ordinales";
    private static final String COMMON_GROUP = "Com\u00c3\u00ban";
    private static final String MONEY_GROUP = "Dinero";
    private static final String NUMBERS_GROUP = "N\u00c3\u00bameros";
    private static final String MONTHS_GROUP = "Meses";
    private static final String DAYS_GROUP = "D\u00c3\u00adas";
    private static final String DE = "De";
    private static final String EL = "El";
    private static final String LA = "La";
    private static final String LAS = "Las";
    private static final String Y = "Y";
    private static final String[] MONTHS = new String[]{"Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre"};
    private static final String[] DAYS = new String[]{"Domingo", "Lunes", "Martes", "Mi\u00c3\u00a9rcoles", "Jueves", "Viernes", "S\u00c3\u00a1bado"};
    private static final Currency USD_CURRENCY = Currency.getInstance("USD");
    private static final BigDecimal ZERO = new BigDecimal("0");
    private static final BigDecimal NEGATIVE_ONE = new BigDecimal("-1");
    private static final String DOLAR = "D\u00c3\u00b3lar";
    private static final String DOLARES = "D\u00c3\u00b3lares";
    private static final String CENTAVO = "Centavo";
    private static final String CENTAVOS = "Centavos";
    private static final String MIL = "Mil";
    private static final String MILLONES = "Millones";
    private static final String NEGATIVA = "Negativa";
    static /* synthetic */ Class class$0;

    public static URL getDescriptor() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.vtp.framework.languages.es.SpanishTranslator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz.getResource("/META-INF/openVXML/language.xml");
    }

    public void translateDate(Date date, Locale locale, TranslatorOutput out) {
        Calendar cal = Calendar.getInstance(locale);
        cal.setTime(date);
        out.prompt(DAYS[cal.get(7) - 1], DAYS_GROUP);
        out.prompt(EL, COMMON_GROUP);
        int dateInt = cal.get(5);
        if (dateInt == 1) {
            this.translateOrdinal(dateInt, locale, out);
        } else {
            this.translateNumber(dateInt, locale, out);
        }
        out.prompt(DE, COMMON_GROUP);
        out.prompt(MONTHS[cal.get(2)], MONTHS_GROUP);
        out.prompt(DE, COMMON_GROUP);
        int year = cal.get(1);
        this.translateNumber(year, locale, out);
    }

    public void translateTime(Date time, boolean showTimeZone, Locale locale, TranslatorOutput out) {
        Calendar cal = Calendar.getInstance(locale);
        cal.setTime(time);
        int hour = cal.get(11);
        out.prompt(hour == 1 ? LA : LAS, COMMON_GROUP);
        this.translateNumber(hour, locale, out);
        int minute = cal.get(12);
        if (minute > 0) {
            out.prompt(Y, COMMON_GROUP);
            this.translateNumber(minute, locale, out);
        }
        if (showTimeZone) {
            out.characters(cal.getTimeZone().getID());
        }
    }

    public void translateMoney(BigDecimal money, Currency currency, Locale locale, TranslatorOutput out) {
        if (USD_CURRENCY.equals(currency)) {
            int cents;
            if (money.compareTo(ZERO) < 0) {
                out.prompt(NEGATIVA, NUMBERS_GROUP);
                money = money.multiply(NEGATIVE_ONE);
            }
            this.translateNumber(money.intValue(), locale, out);
            out.prompt(money.intValue() == 1 ? DOLAR : DOLARES, MONEY_GROUP);
            String str = money.toString();
            if (str.indexOf(46) >= 0 && (cents = Integer.parseInt(str.substring(str.indexOf(46) + 1))) > 0) {
                out.prompt(Y, COMMON_GROUP);
                this.translateNumber(cents, locale, out);
                out.prompt(cents == 1 ? CENTAVO : CENTAVOS, MONEY_GROUP);
            }
        } else {
            super.translateMoney(money, currency, locale, out);
        }
    }

    public void translateNumber(int number, Locale locale, TranslatorOutput out) {
        int thousands;
        int millions;
        int billions;
        if (number == 0) {
            out.prompt("0", NUMBERS_GROUP);
            return;
        }
        if (number < 0) {
            out.prompt(NEGATIVA, NUMBERS_GROUP);
            number *= -1;
        }
        if ((billions = number / 1000000000) > 0) {
            this.translateNumberInHundreds(billions, locale, out);
            out.prompt(MIL, NUMBERS_GROUP);
            out.prompt(MILLONES, NUMBERS_GROUP);
            number -= billions * 1000000000;
        }
        if ((millions = number / 1000000) > 0) {
            this.translateNumberInHundreds(millions, locale, out);
            out.prompt(MILLONES, NUMBERS_GROUP);
            number -= millions * 1000000;
        }
        if ((thousands = number / 1000) > 0) {
            this.translateNumberInHundreds(thousands, locale, out);
            out.prompt(MIL, NUMBERS_GROUP);
            number -= thousands * 1000;
        }
        if (number > 0) {
            this.translateNumberInHundreds(number, locale, out);
        }
    }

    public void translateOrdinal(int ordinal, Locale locale, TranslatorOutput out) {
        if (ordinal < 1 || ordinal > 10) {
            this.translateNumber(ordinal, locale, out);
            return;
        }
        switch (ordinal) {
            case 1: {
                out.prompt("1st", ORDINALS_GROUP);
                break;
            }
            case 2: {
                out.prompt("2nd", ORDINALS_GROUP);
                break;
            }
            case 3: {
                out.prompt("3rd", ORDINALS_GROUP);
                break;
            }
            default: {
                out.prompt(String.valueOf(String.valueOf(ordinal)) + "th", ORDINALS_GROUP);
            }
        }
    }

    public void translateLetter(char letter, Locale locale, TranslatorOutput out) {
        out.text(" ");
        out.prompt(String.valueOf(letter).toLowerCase(locale), "Letras");
        out.text(" ");
    }

    private void translateNumberInHundreds(int number, Locale locale, TranslatorOutput out) {
        int hundreds = number / 100;
        if (hundreds > 0) {
            out.prompt(String.valueOf(hundreds * 100), NUMBERS_GROUP);
            number -= hundreds * 100;
        }
        if (number > 29) {
            out.prompt(String.valueOf(number - number % 10), NUMBERS_GROUP);
            if ((number %= 10) > 0) {
                out.prompt(Y, COMMON_GROUP);
            }
        }
        if (number > 0) {
            out.prompt(String.valueOf(number), NUMBERS_GROUP);
        }
    }
}

