/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.ui.shared.actions.util;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.vtp.desktop.ui.shared.actions.util.IProvisioningActionItemSorter;
import org.eclipse.vtp.desktop.ui.shared.actions.util.IProvisioningModelSelection;
import org.eclipse.vtp.desktop.ui.shared.actions.util.InternalAction;
import org.eclipse.vtp.desktop.ui.shared.actions.util.InternalActionItem;
import org.eclipse.vtp.desktop.ui.shared.actions.util.InternalActionItemContainer;
import org.eclipse.vtp.desktop.ui.shared.actions.util.InternalActionSet;
import org.eclipse.vtp.desktop.ui.shared.actions.util.InternalActionSetSection;
import org.eclipse.vtp.desktop.ui.shared.actions.util.SectionConstraint;

public class ProvisioningModelActionManager
implements InternalActionItemContainer {
    private List orphanList = new ArrayList();
    private List sectionList = new ArrayList();
    private Map sectionMap = new HashMap();
    private InternalActionSetSection head = new InternalActionSetSection("", "HEAD", new SectionConstraint(0, null));
    private InternalActionSetSection content = new InternalActionSetSection("", "CONTENT", new SectionConstraint(0, null));
    private InternalActionSetSection tail = new InternalActionSetSection("", "TAIL", new SectionConstraint(0, null));
    static /* synthetic */ Class class$0;

    public ProvisioningModelActionManager() {
        this.sectionList.add(this.head);
        this.sectionMap.put("HEAD", this.head);
        this.sectionList.add(this.content);
        this.sectionMap.put("CONTENT", this.content);
        this.sectionList.add(this.tail);
        this.sectionMap.put("TAIL", this.tail);
    }

    public boolean addActionItem(InternalActionItem actionItem) {
        return this.content.addActionItem(actionItem);
    }

    public boolean addSection(InternalActionSetSection section) {
        SectionConstraint location = section.getLocation();
        if (this.sectionMap.get(section.getName()) != null) {
            return false;
        }
        if (location.getConstraint() == 0) {
            this.sectionList.add(section);
            this.sectionMap.put(section.getName(), section);
            return true;
        }
        int i = 0;
        while (i < this.sectionList.size()) {
            InternalActionSetSection currentSection = (InternalActionSetSection)this.sectionList.get(i);
            if (currentSection.equals(location.getLocation())) {
                if (location.getConstraint() == 1) {
                    this.sectionList.add(i, section);
                    this.sectionMap.put(section.getName(), section);
                    return true;
                }
                if (location.getConstraint() == 2) {
                    this.sectionList.add(i + 1, section);
                    this.sectionMap.put(section.getName(), section);
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    public InternalActionItemContainer findContainer(Stack ids) {
        if (ids.size() == 0) {
            return this.content;
        }
        String currentId = (String)ids.peek();
        Object obj = this.sectionMap.get(currentId);
        if (obj == null) {
            return this.content.findContainer(ids);
        }
        ids.pop();
        if (ids.size() > 0) {
            return ((InternalActionSetSection)obj).findContainer(ids);
        }
        return (InternalActionItemContainer)obj;
    }

    public void loadExtensionPoint(String extensionPointId) {
        InternalActionItemContainer container;
        Stack<String> ids;
        String[] idsArray;
        boolean doOrphans = false;
        IConfigurationElement[] configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor(extensionPointId);
        int i = 0;
        while (i < configurationElements.length) {
            InternalActionItemContainer container2;
            Stack<String> ids2;
            String[] idsArray2;
            String containerId;
            if (configurationElements[i].getName().equals("section")) {
                String sectionName = configurationElements[i].getAttribute("name");
                containerId = configurationElements[i].getAttribute("container-id");
                if (containerId == null) {
                    containerId = "";
                }
                SectionConstraint sc = configurationElements[i].getAttribute("before") != null ? new SectionConstraint(1, configurationElements[i].getAttribute("before")) : (configurationElements[i].getAttribute("after") != null ? new SectionConstraint(2, configurationElements[i].getAttribute("after")) : new SectionConstraint(0, null));
                InternalActionSetSection section = new InternalActionSetSection(containerId, sectionName, sc);
                if (configurationElements[i].getAttribute("sorter") != null) {
                    try {
                        Class<?> sorterClass = Class.forName(configurationElements[i].getAttribute("sorter"));
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = Class.forName("org.eclipse.vtp.desktop.ui.shared.actions.util.IProvisioningActionItemSorter");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (clazz.isAssignableFrom(sorterClass)) {
                            Constructor<?> sorterConstructor = sorterClass.getConstructor(new Class[0]);
                            section.setSorter((IProvisioningActionItemSorter)sorterConstructor.newInstance(new Object[0]));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (containerId.equals("")) {
                    this.addSection(section);
                    doOrphans = true;
                } else {
                    idsArray2 = containerId.split("\\.");
                    ids2 = new Stack<String>();
                    int a = idsArray2.length - 1;
                    while (a > -1) {
                        ids2.push(idsArray2[a]);
                        --a;
                    }
                    container2 = this.findContainer(ids2);
                    if (container2 == null) {
                        this.orphanList.add(section);
                    } else if (container2 instanceof InternalActionSet) {
                        ((InternalActionSet)container2).addSection(section);
                        doOrphans = true;
                    }
                }
            } else if (configurationElements[i].getName().equals("action-set")) {
                String actionSetName = configurationElements[i].getAttribute("name");
                containerId = configurationElements[i].getAttribute("section-id");
                if (containerId == null) {
                    containerId = "";
                }
                InternalActionSet actionSet = new InternalActionSet(containerId, actionSetName);
                actionSet.setPluginNameSpace(configurationElements[i].getDeclaringExtension().getNamespace());
                if (configurationElements[i].getAttribute("tool-tip") != null) {
                    actionSet.setToolTip(configurationElements[i].getAttribute("tool-tip"));
                }
                if (configurationElements[i].getAttribute("sorter") != null) {
                    try {
                        Class<?> sorterClass = Class.forName(configurationElements[i].getAttribute("sorter"));
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = Class.forName("org.eclipse.vtp.desktop.ui.shared.actions.util.IProvisioningActionItemSorter");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (clazz.isAssignableFrom(sorterClass)) {
                            Constructor<?> sorterConstructor = sorterClass.getConstructor(new Class[0]);
                            actionSet.setSorter((IProvisioningActionItemSorter)sorterConstructor.newInstance(new Object[0]));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (configurationElements[i].getAttribute("target") != null) {
                    actionSet.setTargetClass(configurationElements[i].getAttribute("target"));
                } else if (configurationElements[i].getAttribute("filter") != null) {
                    actionSet.setFilterClass(configurationElements[i].getAttribute("filter"));
                }
                idsArray = containerId.split("\\.");
                ids = new Stack();
                int a = idsArray.length - 1;
                while (a > -1) {
                    ids.push(idsArray[a]);
                    --a;
                }
                container = this.findContainer(ids);
                if (container == null) {
                    this.orphanList.add(actionSet);
                } else {
                    container.addActionItem(actionSet);
                    doOrphans = true;
                }
            } else if (configurationElements[i].getName().equals("action")) {
                String actionName = configurationElements[i].getAttribute("name");
                containerId = configurationElements[i].getAttribute("container-id");
                if (containerId == null) {
                    containerId = "";
                }
                String actionClassString = configurationElements[i].getAttribute("class");
                InternalAction action = new InternalAction(containerId, actionName, actionClassString);
                action.setPluginNameSpace(configurationElements[i].getDeclaringExtension().getNamespace());
                if (configurationElements[i].getAttribute("tool-tip") != null) {
                    action.setToolTip(configurationElements[i].getAttribute("tool-tip"));
                }
                if (configurationElements[i].getAttribute("target") != null) {
                    action.setTargetClass(configurationElements[i].getAttribute("target"));
                } else if (configurationElements[i].getAttribute("filter") != null) {
                    action.setFilterClass(configurationElements[i].getAttribute("filter"));
                }
                idsArray2 = containerId.split("\\.");
                ids2 = new Stack();
                int a = idsArray2.length - 1;
                while (a > -1) {
                    ids2.push(idsArray2[a]);
                    --a;
                }
                container2 = this.findContainer(ids2);
                if (container2 == null) {
                    this.orphanList.add(action);
                } else {
                    container2.addActionItem(action);
                }
            }
            ++i;
        }
        if (doOrphans) {
            boolean orphanAdded = true;
            while (orphanAdded) {
                orphanAdded = false;
                int i2 = 0;
                while (i2 < this.orphanList.size()) {
                    Object obj = this.orphanList.get(i2);
                    if (obj instanceof InternalActionSetSection) {
                        InternalActionSetSection iass = (InternalActionSetSection)obj;
                        idsArray = iass.getContainerId().split("\\.");
                        ids = new Stack<String>();
                        int a = idsArray.length - 1;
                        while (a > -1) {
                            ids.push(idsArray[a]);
                            --a;
                        }
                        container = this.findContainer(ids);
                        if (container != null && container instanceof InternalActionSet) {
                            ((InternalActionSet)container).addSection(iass);
                            orphanAdded = true;
                        }
                    } else if (obj instanceof InternalActionItem) {
                        InternalActionItem iai = (InternalActionItem)obj;
                        idsArray = iai.getContainerId().split("\\.");
                        ids = new Stack();
                        int a = idsArray.length - 1;
                        while (a > -1) {
                            ids.push(idsArray[a]);
                            --a;
                        }
                        container = this.findContainer(ids);
                        if (container != null) {
                            container.addActionItem(iai);
                            orphanAdded = true;
                        }
                    }
                    ++i2;
                }
            }
        }
    }

    public void selectionChanged(IProvisioningModelSelection selection) {
        int i = 0;
        while (i < this.sectionList.size()) {
            ((InternalActionSetSection)this.sectionList.get(i)).processSelectionChange(selection);
            ++i;
        }
    }

    public void fillContextMenu(IMenuManager menuManager) {
        int i = 0;
        while (i < this.sectionList.size()) {
            ((InternalActionSetSection)this.sectionList.get(i)).fillContextMenu(menuManager);
            ++i;
        }
    }
}

