/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.editor.internal.wizards;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.vtp.editor.internal.nls.VoicetoolsResourceHandler;

public class NewModelWizard
extends Wizard
implements INewWizard {
    protected IStructuredSelection fSelection;
    protected IWorkbench fWorkbench;
    protected String fCurrentDirectory;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.fWorkbench = workbench;
        this.fSelection = selection;
    }

    public boolean performFinish() {
        boolean result = true;
        WizardPage currentPage = (WizardPage)this.getContainer().getCurrentPage();
        if (currentPage != null) {
            result = currentPage.isPageComplete();
        }
        return result;
    }

    public FileDialog showFileDialog(Shell shell, String defaultDirectory, String defaultFile, String[] filterExtensions) {
        FileDialog fileDialog = new FileDialog(shell, 4096);
        if (defaultDirectory != null) {
            defaultDirectory.length();
        }
        if (defaultDirectory != null && defaultDirectory.length() != 0) {
            fileDialog.setFilterPath(defaultDirectory);
        }
        fileDialog.setFileName(defaultFile);
        fileDialog.setFilterExtensions(filterExtensions);
        fileDialog.open();
        return fileDialog;
    }

    public void setCurrentDirectory(String currentDirectory1) {
        this.fCurrentDirectory = currentDirectory1;
    }

    public void createWorkbenchResource(IContainer container, String fileName) {
        IPath path = container.getFullPath();
        path = path.append(fileName);
        IFile file = container.getWorkspace().getRoot().getFile(path);
        if (!file.exists()) {
            try {
                file.create(null, true, null);
            }
            catch (CoreException coreException) {}
        }
    }

    public class StartPage
    extends WizardPage
    implements Listener {
        protected int selectedButton;
        protected String[] radioButtonLabel;
        protected Button[] radioButton;

        public StartPage(String pageName, String[] radioButtonLabel) {
            super(pageName);
            this.radioButtonLabel = radioButtonLabel;
            this.radioButton = new Button[radioButtonLabel.length];
        }

        public Button getRadioButtonAtIndex(int i) {
            Button result = null;
            if (i >= 0 && i < this.radioButton.length) {
                result = this.radioButton[i];
            }
            return result;
        }

        public int getSelectedRadioButtonIndex() {
            int result = -1;
            int i = 0;
            while (i < this.radioButton.length) {
                if (this.radioButton[i].getSelection()) {
                    result = i;
                }
                ++i;
            }
            return result;
        }

        public void createControl(Composite parent) {
            Composite base = new Composite(parent, 0);
            base.setLayout((Layout)new GridLayout());
            Composite radioButtonsGroup = new Composite(base, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 1;
            layout.makeColumnsEqualWidth = true;
            layout.marginWidth = 0;
            radioButtonsGroup.setLayout((Layout)layout);
            GridData gd = new GridData(1808);
            gd.heightHint = 300;
            gd.widthHint = 650;
            radioButtonsGroup.setLayoutData((Object)gd);
            int i = 0;
            while (i < this.radioButtonLabel.length) {
                this.radioButton[i] = new Button(radioButtonsGroup, 16);
                this.radioButton[i].setText(this.radioButtonLabel[i]);
                this.radioButton[i].setLayoutData((Object)new GridData(768));
                this.radioButton[i].setSelection(false);
                if (i + 1 == this.radioButtonLabel.length) {
                    this.radioButton[i].setSelection(true);
                }
                ++i;
            }
            Label label = new Label(radioButtonsGroup, 16448);
            label.setText("      ** " + VoicetoolsResourceHandler.getString("_UI_DEFAULT_DTD_LABEL") + "  " + this.getDefaultDTD());
            GridData data = new GridData(768);
            data.grabExcessHorizontalSpace = true;
            label.setLayoutData((Object)data);
            this.setControl((Control)base);
            this.setPageComplete(this.isPageComplete());
        }

        public void handleEvent(Event event) {
            if (event.type == 24) {
                this.setPageComplete(this.isPageComplete());
            }
        }

        public String getDefaultDTD() {
            return "";
        }
    }

    public class NewFilePage
    extends WizardNewFileCreationPage {
        public String defaultName = "NewFile";
        public String defaultFileExtension = ".lxml";
        public String[] filterExtensions = new String[]{"*.txt"};
        private List fValidExtensions = null;
        public String contentType = "";

        public NewFilePage(IStructuredSelection selection) {
            super("", selection);
        }

        protected String computeDefaultFileName() {
            int count = 0;
            String fileName = String.valueOf(this.defaultName) + this.defaultFileExtension;
            IPath containerFullPath = this.getContainerFullPath();
            if (containerFullPath != null) {
                while (true) {
                    IPath path = containerFullPath.append(fileName);
                    if (!ResourcesPlugin.getWorkspace().getRoot().exists(path)) break;
                    fileName = String.valueOf(this.defaultName) + ++count + this.defaultFileExtension;
                }
            }
            return fileName;
        }

        protected String existsFileAnyCase(String fileName) {
            IResource parent;
            if (this.getContainerFullPath() != null && !this.getContainerFullPath().isEmpty() && fileName.compareTo("") != 0 && (parent = ResourcesPlugin.getWorkspace().getRoot().findMember(this.getContainerFullPath())) instanceof IContainer) {
                IContainer container = (IContainer)parent;
                try {
                    IResource[] members = container.members();
                    String enteredFileUpper = fileName.toUpperCase();
                    int i = 0;
                    while (i < members.length) {
                        String resourceUpperName = members[i].getName().toUpperCase();
                        if (resourceUpperName.equals(enteredFileUpper)) {
                            return members[i].getName();
                        }
                        ++i;
                    }
                }
                catch (CoreException coreException) {}
            }
            return null;
        }

        protected boolean validatePage() {
            return super.validatePage();
        }

        public void createControl(Composite parent) {
            super.createControl(parent);
            this.addAdditionalInfo(parent);
            this.setFileName(this.computeDefaultFileName());
            this.setPageComplete(this.validatePage());
        }

        public List getValidExtensions() {
            if (this.fValidExtensions == null) {
                IContentType type = Platform.getContentTypeManager().getContentType(this.contentType);
                this.fValidExtensions = new ArrayList<String>(Arrays.asList(type.getFileSpecs(8)));
            }
            return this.fValidExtensions;
        }

        public void addAdditionalInfo(Composite composite) {
        }
    }
}

