/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.ui.internal.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListDialog;
import org.eclipse.wst.common.ui.internal.UIPlugin;

public class SaveDirtyFilesDialog
extends ListDialog {
    public static boolean saveDirtyFiles() {
        boolean result = true;
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        IEditorPart[] dirtyEditors = SaveDirtyFilesDialog.getDirtyEditors();
        if (dirtyEditors.length > 0) {
            result = false;
            SaveDirtyFilesDialog saveDirtyFilesDialog = new SaveDirtyFilesDialog(shell);
            saveDirtyFilesDialog.setInput(Arrays.asList(dirtyEditors));
            if (saveDirtyFilesDialog.open() == 0) {
                result = true;
                int numDirtyEditors = dirtyEditors.length;
                int i = 0;
                while (i < numDirtyEditors) {
                    dirtyEditors[i].doSave(null);
                    ++i;
                }
            }
        }
        return result;
    }

    private static IEditorPart[] getDirtyEditors() {
        ArrayList<IEditorPart> result = new ArrayList<IEditorPart>(0);
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            IWorkbenchPage[] pages = windows[i].getPages();
            int x = 0;
            while (x < pages.length) {
                IEditorPart[] editors = pages[x].getDirtyEditors();
                int z = 0;
                while (z < editors.length) {
                    IEditorPart ep = editors[z];
                    result.add(ep);
                    ++z;
                }
                ++x;
            }
            ++i;
        }
        return result.toArray(new IEditorPart[result.size()]);
    }

    public SaveDirtyFilesDialog(Shell parent) {
        super(parent);
        this.setTitle(UIPlugin.getResourceString("SaveFilesDialog_save_all_resources"));
        this.setAddCancelButton(true);
        this.setLabelProvider(this.createDialogLabelProvider());
        this.setMessage(UIPlugin.getResourceString("SaveFilesDialog_must_save"));
        this.setContentProvider(new ListContentProvider());
    }

    protected Control createDialogArea(Composite container) {
        Composite result = (Composite)super.createDialogArea(container);
        return result;
    }

    private ILabelProvider createDialogLabelProvider() {
        return new LabelProvider(){

            public Image getImage(Object element) {
                return ((IEditorPart)element).getTitleImage();
            }

            public String getText(Object element) {
                return ((IEditorPart)element).getTitle();
            }
        };
    }

    private static class ListContentProvider
    implements IStructuredContentProvider {
        List fContents;

        public Object[] getElements(Object input) {
            if (this.fContents != null && this.fContents == input) {
                return this.fContents.toArray();
            }
            return new Object[0];
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.fContents = newInput instanceof List ? (List)newInput : null;
        }

        public void dispose() {
        }

        public boolean isDeleted(Object o) {
            return this.fContents != null && !this.fContents.contains(o);
        }
    }
}

