/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.runtime.logview;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.runtime.PDERuntimeMessages;
import org.eclipse.pde.internal.runtime.PDERuntimePlugin;
import org.eclipse.pde.internal.runtime.PDERuntimePluginImages;
import org.eclipse.pde.internal.runtime.logview.EventDetailsDialogAction;
import org.eclipse.pde.internal.runtime.logview.FilterDialog;
import org.eclipse.pde.internal.runtime.logview.LogEntry;
import org.eclipse.pde.internal.runtime.logview.LogReader;
import org.eclipse.pde.internal.runtime.logview.LogViewContentProvider;
import org.eclipse.pde.internal.runtime.logview.LogViewLabelProvider;
import org.eclipse.pde.internal.runtime.logview.OpenLogDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.ViewPart;

public class LogView
extends ViewPart
implements ILogListener {
    public static final String P_LOG_WARNING = "warning";
    public static final String P_LOG_ERROR = "error";
    public static final String P_LOG_INFO = "info";
    public static final String P_LOG_LIMIT = "limit";
    public static final String P_USE_LIMIT = "useLimit";
    public static final String P_SHOW_ALL_SESSIONS = "allSessions";
    private static final String P_COLUMN_1 = "column2";
    private static final String P_COLUMN_2 = "column3";
    private static final String P_COLUMN_3 = "column4";
    public static final String P_ACTIVATE = "activate";
    public static final String P_ORDER_TYPE = "orderType";
    public static final String P_ORDER_VALUE = "orderValue";
    private int MESSAGE_ORDER;
    private int PLUGIN_ORDER;
    private int DATE_ORDER;
    public static final byte MESSAGE = 0;
    public static final byte PLUGIN = 1;
    public static final byte DATE = 2;
    public static int ASCENDING = 1;
    public static int DESCENDING = -1;
    private ArrayList fLogs = new ArrayList();
    private Clipboard fClipboard;
    private IMemento fMemento;
    private File fInputFile = Platform.getLogFileLocation().toFile();
    private String fDirectory;
    private Comparator fComparator;
    private Collator fCollator;
    private boolean fCanOpenTextShell;
    private Text fTextLabel;
    private Shell fTextShell;
    private boolean fFirstEvent = true;
    private TreeColumn fColumn1;
    private TreeColumn fColumn2;
    private TreeColumn fColumn3;
    private Tree fTree;
    private TreeViewer fTreeViewer;
    private Action fPropertiesAction;
    private Action fDeleteLogAction;
    private Action fReadLogAction;
    private Action fCopyAction;
    private Action fActivateViewAction;
    private Action fOpenLogAction;
    private Action fExportAction;

    public void createPartControl(Composite parent) {
        this.readLogFile();
        this.createViewer(parent);
        this.createActions();
        this.fClipboard = new Clipboard(this.fTree.getDisplay());
        this.fTree.setToolTipText("");
        this.getSite().setSelectionProvider((ISelectionProvider)this.fTreeViewer);
        this.initializeViewerSorter();
        this.makeHoverShell();
        Platform.addLogListener((ILogListener)this);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.fTree, "org.eclipse.pde.doc.user.log_view");
    }

    private void createActions() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fCopyAction = this.createCopyAction();
        bars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.fCopyAction);
        IToolBarManager toolBarManager = bars.getToolBarManager();
        this.fExportAction = this.createExportAction();
        toolBarManager.add((IAction)this.fExportAction);
        final Action importLogAction = this.createImportLogAction();
        toolBarManager.add((IAction)importLogAction);
        toolBarManager.add((IContributionItem)new Separator());
        final Action clearAction = this.createClearAction();
        toolBarManager.add((IAction)clearAction);
        this.fDeleteLogAction = this.createDeleteLogAction();
        toolBarManager.add((IAction)this.fDeleteLogAction);
        this.fOpenLogAction = this.createOpenLogAction();
        toolBarManager.add((IAction)this.fOpenLogAction);
        this.fReadLogAction = this.createReadLogAction();
        toolBarManager.add((IAction)this.fReadLogAction);
        toolBarManager.add((IContributionItem)new Separator());
        IMenuManager mgr = bars.getMenuManager();
        mgr.add((IAction)this.createFilterAction());
        mgr.add((IContributionItem)new Separator());
        this.fActivateViewAction = this.createActivateViewAction();
        mgr.add((IAction)this.fActivateViewAction);
        this.createPropertiesAction();
        MenuManager popupMenuManager = new MenuManager("#PopupMenu");
        IMenuListener listener = new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IAction)LogView.this.fCopyAction);
                manager.add((IContributionItem)new Separator());
                manager.add((IAction)clearAction);
                manager.add((IAction)LogView.this.fDeleteLogAction);
                manager.add((IAction)LogView.this.fOpenLogAction);
                manager.add((IAction)LogView.this.fReadLogAction);
                manager.add((IContributionItem)new Separator());
                manager.add((IAction)LogView.this.fExportAction);
                manager.add((IAction)importLogAction);
                manager.add((IContributionItem)new Separator());
                ((EventDetailsDialogAction)LogView.this.fPropertiesAction).setComparator(LogView.this.fComparator);
                manager.add((IAction)LogView.this.fPropertiesAction);
                manager.add((IContributionItem)new Separator("additions"));
            }
        };
        popupMenuManager.addMenuListener(listener);
        popupMenuManager.setRemoveAllWhenShown(true);
        this.getSite().registerContextMenu(popupMenuManager, this.getSite().getSelectionProvider());
        Menu menu = popupMenuManager.createContextMenu((Control)this.fTree);
        this.fTree.setMenu(menu);
    }

    private Action createActivateViewAction() {
        Action action = new Action(PDERuntimeMessages.LogView_activate){

            public void run() {
                LogView.this.fMemento.putString(LogView.P_ACTIVATE, this.isChecked() ? "true" : "false");
            }
        };
        action.setChecked(this.fMemento.getString(P_ACTIVATE).equals("true"));
        return action;
    }

    private Action createClearAction() {
        Action action = new Action(PDERuntimeMessages.LogView_clear){

            public void run() {
                LogView.this.handleClear();
            }
        };
        action.setImageDescriptor(PDERuntimePluginImages.DESC_CLEAR);
        action.setDisabledImageDescriptor(PDERuntimePluginImages.DESC_CLEAR_DISABLED);
        action.setToolTipText(PDERuntimeMessages.LogView_clear_tooltip);
        action.setText(PDERuntimeMessages.LogView_clear);
        return action;
    }

    private Action createCopyAction() {
        Action action = new Action(PDERuntimeMessages.LogView_copy){

            public void run() {
                LogView.this.copyToClipboard(LogView.this.fTreeViewer.getSelection());
            }
        };
        action.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_COPY"));
        return action;
    }

    private Action createDeleteLogAction() {
        Action action = new Action(PDERuntimeMessages.LogView_delete){

            public void run() {
                LogView.this.doDeleteLog();
            }
        };
        action.setToolTipText(PDERuntimeMessages.LogView_delete_tooltip);
        action.setImageDescriptor(PDERuntimePluginImages.DESC_REMOVE_LOG);
        action.setDisabledImageDescriptor(PDERuntimePluginImages.DESC_REMOVE_LOG_DISABLED);
        action.setEnabled(this.fInputFile.exists() && this.fInputFile.equals(Platform.getLogFileLocation().toFile()));
        return action;
    }

    private Action createExportAction() {
        Action action = new Action(PDERuntimeMessages.LogView_export){

            public void run() {
                LogView.this.handleExport();
            }
        };
        action.setToolTipText(PDERuntimeMessages.LogView_export_tooltip);
        action.setImageDescriptor(PDERuntimePluginImages.DESC_EXPORT);
        action.setDisabledImageDescriptor(PDERuntimePluginImages.DESC_EXPORT_DISABLED);
        action.setEnabled(this.fInputFile.exists());
        return action;
    }

    private Action createFilterAction() {
        Action action = new Action(PDERuntimeMessages.LogView_filter){

            public void run() {
                LogView.this.handleFilter();
            }
        };
        action.setToolTipText(PDERuntimeMessages.LogView_filter);
        action.setImageDescriptor(PDERuntimePluginImages.DESC_FILTER);
        action.setDisabledImageDescriptor(PDERuntimePluginImages.DESC_FILTER_DISABLED);
        return action;
    }

    private Action createImportLogAction() {
        Action action = new Action(PDERuntimeMessages.LogView_import){

            public void run() {
                LogView.this.handleImport();
            }
        };
        action.setToolTipText(PDERuntimeMessages.LogView_import_tooltip);
        action.setImageDescriptor(PDERuntimePluginImages.DESC_IMPORT);
        action.setDisabledImageDescriptor(PDERuntimePluginImages.DESC_IMPORT_DISABLED);
        return action;
    }

    private Action createOpenLogAction() {
        Action action = new Action(PDERuntimeMessages.LogView_view_currentLog){

            public void run() {
                if (LogView.this.fInputFile.exists()) {
                    Program[] p = new Program[1];
                    OpenLogDialog[] openDialog = new OpenLogDialog[1];
                    Shell shell = LogView.this.getViewSite().getShell();
                    Runnable runnable = new Runnable(this, p, openDialog, shell){
                        final /* synthetic */ 9 this$1;
                        private final /* synthetic */ Program[] val$p;
                        private final /* synthetic */ OpenLogDialog[] val$openDialog;
                        private final /* synthetic */ Shell val$shell;
                        {
                            this.this$1 = var1_1;
                            this.val$p = programArray;
                            this.val$openDialog = openLogDialogArray;
                            this.val$shell = shell;
                        }

                        public void run() {
                            boolean failed = false;
                            if (LogView.access$14(9.access$0(this.this$1)).length() <= 0x100000L) {
                                boolean bl = failed = !Program.launch((String)LogView.access$14(9.access$0(this.this$1)).getAbsolutePath());
                                if (failed) {
                                    this.val$p[0] = Program.findProgram((String)".txt");
                                    if (this.val$p[0] != null) {
                                        this.val$p[0].execute(LogView.access$14(9.access$0(this.this$1)).getAbsolutePath());
                                        return;
                                    }
                                }
                            }
                            if (failed) {
                                this.val$openDialog[0] = new OpenLogDialog(this.val$shell, LogView.access$14(9.access$0(this.this$1)));
                                this.val$openDialog[0].create();
                            }
                        }
                    };
                    BusyIndicator.showWhile((Display)shell.getDisplay(), (Runnable)runnable);
                    if (openDialog[0] != null) {
                        openDialog[0].open();
                    }
                }
            }

            static /* synthetic */ LogView access$0(9 var0) {
                return var0.LogView.this;
            }
        };
        action.setImageDescriptor(PDERuntimePluginImages.DESC_OPEN_LOG);
        action.setDisabledImageDescriptor(PDERuntimePluginImages.DESC_OPEN_LOG_DISABLED);
        action.setEnabled(this.fInputFile.exists());
        action.setToolTipText(PDERuntimeMessages.LogView_view_currentLog_tooltip);
        return action;
    }

    private void createPropertiesAction() {
        this.fPropertiesAction = new EventDetailsDialogAction(this.fTree.getShell(), (ISelectionProvider)this.fTreeViewer);
        this.fPropertiesAction.setImageDescriptor(PDERuntimePluginImages.DESC_PROPERTIES);
        this.fPropertiesAction.setDisabledImageDescriptor(PDERuntimePluginImages.DESC_PROPERTIES_DISABLED);
        this.fPropertiesAction.setToolTipText(PDERuntimeMessages.LogView_properties_tooltip);
        this.fPropertiesAction.setEnabled(false);
    }

    private Action createReadLogAction() {
        Action action = new Action(PDERuntimeMessages.LogView_readLog_restore){

            public void run() {
                LogView.this.fInputFile = Platform.getLogFileLocation().toFile();
                LogView.this.reloadLog();
            }
        };
        action.setToolTipText(PDERuntimeMessages.LogView_readLog_restore_tooltip);
        action.setImageDescriptor(PDERuntimePluginImages.DESC_READ_LOG);
        action.setDisabledImageDescriptor(PDERuntimePluginImages.DESC_READ_LOG_DISABLED);
        return action;
    }

    private void createViewer(Composite parent) {
        this.fTreeViewer = new TreeViewer(parent, 65536);
        this.fTree = this.fTreeViewer.getTree();
        this.fTree.setLinesVisible(true);
        this.createColumns(this.fTree);
        this.fTreeViewer.setContentProvider((IContentProvider)new LogViewContentProvider(this));
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)new LogViewLabelProvider());
        this.fTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                LogView.this.handleSelectionChanged(e.getSelection());
                if (LogView.this.fPropertiesAction.isEnabled()) {
                    ((EventDetailsDialogAction)LogView.this.fPropertiesAction).resetSelection();
                }
            }
        });
        this.fTreeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ((EventDetailsDialogAction)LogView.this.fPropertiesAction).setComparator(LogView.this.fComparator);
                LogView.this.fPropertiesAction.run();
            }
        });
        this.fTreeViewer.setInput((Object)this);
        this.addMouseListeners();
    }

    private void createColumns(Tree tree) {
        this.fColumn1 = new TreeColumn(tree, 16384);
        this.fColumn1.setText(PDERuntimeMessages.LogView_column_message);
        this.fColumn1.setWidth(this.fMemento.getInteger(P_COLUMN_1).intValue());
        this.fColumn1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LogView logView = LogView.this;
                logView.MESSAGE_ORDER = logView.MESSAGE_ORDER * -1;
                ViewerSorter sorter = LogView.this.getViewerSorter((byte)0);
                LogView.this.fTreeViewer.setSorter(sorter);
                LogView.this.fCollator = sorter.getCollator();
                boolean isComparatorSet = ((EventDetailsDialogAction)LogView.this.fPropertiesAction).resetSelection((byte)0, LogView.this.MESSAGE_ORDER);
                LogView.this.setComparator((byte)0);
                if (!isComparatorSet) {
                    ((EventDetailsDialogAction)LogView.this.fPropertiesAction).setComparator(LogView.this.fComparator);
                }
                LogView.this.fMemento.putInteger(LogView.P_ORDER_VALUE, LogView.this.MESSAGE_ORDER);
                LogView.this.fMemento.putInteger(LogView.P_ORDER_TYPE, 0);
                LogView.this.setColumnSorting(LogView.this.fColumn1, LogView.this.MESSAGE_ORDER);
            }
        });
        this.fColumn2 = new TreeColumn(tree, 16384);
        this.fColumn2.setText(PDERuntimeMessages.LogView_column_plugin);
        this.fColumn2.setWidth(this.fMemento.getInteger(P_COLUMN_2).intValue());
        this.fColumn2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LogView logView = LogView.this;
                logView.PLUGIN_ORDER = logView.PLUGIN_ORDER * -1;
                ViewerSorter sorter = LogView.this.getViewerSorter((byte)1);
                LogView.this.fTreeViewer.setSorter(sorter);
                LogView.this.fCollator = sorter.getCollator();
                boolean isComparatorSet = ((EventDetailsDialogAction)LogView.this.fPropertiesAction).resetSelection((byte)1, LogView.this.PLUGIN_ORDER);
                LogView.this.setComparator((byte)1);
                if (!isComparatorSet) {
                    ((EventDetailsDialogAction)LogView.this.fPropertiesAction).setComparator(LogView.this.fComparator);
                }
                LogView.this.fMemento.putInteger(LogView.P_ORDER_VALUE, LogView.this.PLUGIN_ORDER);
                LogView.this.fMemento.putInteger(LogView.P_ORDER_TYPE, 1);
                LogView.this.setColumnSorting(LogView.this.fColumn2, LogView.this.PLUGIN_ORDER);
            }
        });
        this.fColumn3 = new TreeColumn(tree, 16384);
        this.fColumn3.setText(PDERuntimeMessages.LogView_column_date);
        this.fColumn3.setWidth(this.fMemento.getInteger(P_COLUMN_3).intValue());
        this.fColumn3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LogView logView = LogView.this;
                logView.DATE_ORDER = logView.DATE_ORDER * -1;
                ViewerSorter sorter = LogView.this.getViewerSorter((byte)2);
                LogView.this.fTreeViewer.setSorter(sorter);
                LogView.this.fCollator = sorter.getCollator();
                LogView.this.setComparator((byte)2);
                ((EventDetailsDialogAction)LogView.this.fPropertiesAction).setComparator(LogView.this.fComparator);
                LogView.this.fMemento.putInteger(LogView.P_ORDER_VALUE, LogView.this.DATE_ORDER);
                LogView.this.fMemento.putInteger(LogView.P_ORDER_TYPE, 2);
                LogView.this.setColumnSorting(LogView.this.fColumn3, LogView.this.DATE_ORDER);
            }
        });
        tree.setHeaderVisible(true);
    }

    private void initializeViewerSorter() {
        byte orderType = this.fMemento.getInteger(P_ORDER_TYPE).byteValue();
        ViewerSorter sorter = this.getViewerSorter(orderType);
        this.fTreeViewer.setSorter(sorter);
        if (orderType == 0) {
            this.setColumnSorting(this.fColumn1, this.MESSAGE_ORDER);
        } else if (orderType == 1) {
            this.setColumnSorting(this.fColumn2, this.PLUGIN_ORDER);
        } else if (orderType == 2) {
            this.setColumnSorting(this.fColumn3, this.DATE_ORDER);
        }
    }

    private void setColumnSorting(TreeColumn column, int order) {
        this.fTree.setSortColumn(column);
        this.fTree.setSortDirection(order == ASCENDING ? 128 : 1024);
    }

    public void dispose() {
        this.writeSettings();
        Platform.removeLogListener((ILogListener)this);
        this.fClipboard.dispose();
        if (this.fTextShell != null) {
            this.fTextShell.dispose();
        }
        LogReader.reset();
        super.dispose();
    }

    private void handleImport() {
        FileDialog dialog = new FileDialog(this.getViewSite().getShell());
        dialog.setFilterExtensions(new String[]{"*.log"});
        if (this.fDirectory != null) {
            dialog.setFilterPath(this.fDirectory);
        }
        this.handleImportPath(dialog.open());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleImportPath(String path) {
        if (path == null) return;
        if (!new Path(path).toFile().exists()) return;
        this.fInputFile = new Path(path).toFile();
        this.fDirectory = this.fInputFile.getParent();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask(PDERuntimeMessages.LogView_operation_importing, -1);
                LogView.this.readLogFile();
            }
        };
        ProgressMonitorDialog pmd = new ProgressMonitorDialog(this.getViewSite().getShell());
        try {
            try {
                pmd.run(true, true, op);
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InterruptedException interruptedException) {}
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.fReadLogAction.setText(PDERuntimeMessages.LogView_readLog_reload);
            this.fReadLogAction.setToolTipText(PDERuntimeMessages.LogView_readLog_reload);
            this.asyncRefresh(false);
            this.resetDialogButtons();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.fReadLogAction.setText(PDERuntimeMessages.LogView_readLog_reload);
        this.fReadLogAction.setToolTipText(PDERuntimeMessages.LogView_readLog_reload);
        this.asyncRefresh(false);
        this.resetDialogButtons();
    }

    private void handleExport() {
        String path;
        FileDialog dialog = new FileDialog(this.getViewSite().getShell(), 8192);
        dialog.setFilterExtensions(new String[]{"*.log"});
        if (this.fDirectory != null) {
            dialog.setFilterPath(this.fDirectory);
        }
        if ((path = dialog.open()) != null) {
            if (path.indexOf(46) == -1 && !path.endsWith(".log")) {
                path = String.valueOf(path) + ".log";
            }
            File outputFile = new Path(path).toFile();
            this.fDirectory = outputFile.getParent();
            if (outputFile.exists()) {
                String message = NLS.bind((String)PDERuntimeMessages.LogView_confirmOverwrite_message, (Object)outputFile.toString());
                if (!MessageDialog.openQuestion((Shell)this.getViewSite().getShell(), (String)PDERuntimeMessages.LogView_exportLog, (String)message)) {
                    return;
                }
            }
            this.copy(this.fInputFile, outputFile);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void copy(File inputFile, File outputFile) {
        BufferedReader reader = null;
        BufferedWriter writer = null;
        try {
            try {
                reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(inputFile), "UTF-8"));
                writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), "UTF-8"));
                while (reader.ready()) {
                    writer.write(reader.readLine());
                    writer.write(System.getProperty("line.separator"));
                }
            }
            catch (IOException iOException) {}
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            try {
                if (reader != null) {
                    reader.close();
                }
                if (writer == null) throw throwable;
                writer.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        try {}
        catch (IOException iOException) {
            return;
        }
        if (reader != null) {
            reader.close();
        }
        if (writer == null) return;
        writer.close();
    }

    private void handleFilter() {
        FilterDialog dialog = new FilterDialog(PDERuntimePlugin.getActiveWorkbenchShell(), this.fMemento);
        dialog.create();
        dialog.getShell().setText(PDERuntimeMessages.LogView_FilterDialog_title);
        if (dialog.open() == 0) {
            this.reloadLog();
        }
    }

    private void doDeleteLog() {
        String title = PDERuntimeMessages.LogView_confirmDelete_title;
        String message = PDERuntimeMessages.LogView_confirmDelete_message;
        if (!MessageDialog.openConfirm((Shell)this.fTree.getShell(), (String)title, (String)message)) {
            return;
        }
        if (this.fInputFile.delete() || this.fLogs.size() > 0) {
            this.fLogs.clear();
            this.asyncRefresh(false);
            this.resetDialogButtons();
        }
    }

    public void fillContextMenu(IMenuManager manager) {
    }

    public LogEntry[] getLogs() {
        return this.fLogs.toArray(new LogEntry[this.fLogs.size()]);
    }

    protected void handleClear() {
        BusyIndicator.showWhile((Display)this.fTree.getDisplay(), (Runnable)new Runnable(){

            public void run() {
                LogView.this.fLogs.clear();
                LogView.this.asyncRefresh(false);
                LogView.this.resetDialogButtons();
            }
        });
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void reloadLog() {
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask(PDERuntimeMessages.LogView_operation_reloading, -1);
                LogView.this.readLogFile();
            }
        };
        ProgressMonitorDialog pmd = new ProgressMonitorDialog(this.getViewSite().getShell());
        try {
            try {
                pmd.run(true, true, op);
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InterruptedException interruptedException) {}
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.fReadLogAction.setText(PDERuntimeMessages.LogView_readLog_restore);
            this.fReadLogAction.setToolTipText(PDERuntimeMessages.LogView_readLog_restore);
            this.asyncRefresh(false);
            this.resetDialogButtons();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.fReadLogAction.setText(PDERuntimeMessages.LogView_readLog_restore);
        this.fReadLogAction.setToolTipText(PDERuntimeMessages.LogView_readLog_restore);
        this.asyncRefresh(false);
        this.resetDialogButtons();
    }

    private void readLogFile() {
        this.fLogs.clear();
        if (!this.fInputFile.exists()) {
            return;
        }
        LogReader.parseLogFile(this.fInputFile, this.fLogs, this.fMemento);
    }

    public void logging(IStatus status, String plugin) {
        if (!this.fInputFile.equals(Platform.getLogFileLocation().toFile())) {
            return;
        }
        if (this.fFirstEvent) {
            this.readLogFile();
            this.asyncRefresh();
            this.fFirstEvent = false;
        } else {
            this.pushStatus(status);
        }
    }

    private void pushStatus(IStatus status) {
        LogEntry entry = new LogEntry(status);
        LogReader.addEntry(entry, this.fLogs, this.fMemento, true);
        this.asyncRefresh();
    }

    private void asyncRefresh() {
        this.asyncRefresh(true);
    }

    private void asyncRefresh(final boolean activate) {
        if (this.fTree.isDisposed()) {
            return;
        }
        Display display = this.fTree.getDisplay();
        final LogView view = this;
        if (display != null) {
            display.asyncExec(new Runnable(){

                public void run() {
                    if (!LogView.this.fTree.isDisposed()) {
                        IWorkbenchPage page;
                        LogView.this.fTreeViewer.refresh();
                        LogView.this.fDeleteLogAction.setEnabled(LogView.this.fInputFile.exists() && LogView.this.fInputFile.equals(Platform.getLogFileLocation().toFile()));
                        LogView.this.fOpenLogAction.setEnabled(LogView.this.fInputFile.exists());
                        LogView.this.fExportAction.setEnabled(LogView.this.fInputFile.exists());
                        if (activate && LogView.this.fActivateViewAction.isChecked() && (page = PDERuntimePlugin.getActivePage()) != null) {
                            page.bringToTop((IWorkbenchPart)view);
                        }
                    }
                }
            });
        }
    }

    public void setFocus() {
        if (this.fTree != null && !this.fTree.isDisposed()) {
            this.fTree.setFocus();
        }
    }

    private void handleSelectionChanged(ISelection selection) {
        this.updateStatus(selection);
        this.fCopyAction.setEnabled(!selection.isEmpty());
        this.fPropertiesAction.setEnabled(!selection.isEmpty());
    }

    private void updateStatus(ISelection selection) {
        IStatusLineManager status = this.getViewSite().getActionBars().getStatusLineManager();
        if (selection.isEmpty()) {
            status.setMessage(null);
        } else {
            LogEntry entry = (LogEntry)((Object)((IStructuredSelection)selection).getFirstElement());
            status.setMessage(((LogViewLabelProvider)this.fTreeViewer.getLabelProvider()).getColumnText((Object)entry, 0));
        }
    }

    private void copyToClipboard(ISelection selection) {
        StringWriter writer = new StringWriter();
        PrintWriter pwriter = new PrintWriter(writer);
        if (selection.isEmpty()) {
            return;
        }
        LogEntry entry = (LogEntry)((Object)((IStructuredSelection)selection).getFirstElement());
        entry.write(pwriter);
        pwriter.flush();
        String textVersion = writer.toString();
        try {
            pwriter.close();
            writer.close();
        }
        catch (IOException iOException) {}
        if (textVersion.trim().length() > 0) {
            this.fClipboard.setContents(new Object[]{textVersion}, new Transfer[]{TextTransfer.getInstance()});
        }
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.fMemento = memento == null ? XMLMemento.createWriteRoot((String)"LOGVIEW") : memento;
        this.readSettings();
        byte type = this.fMemento.getInteger(P_ORDER_TYPE).byteValue();
        switch (type) {
            case 2: {
                this.DATE_ORDER = this.fMemento.getInteger(P_ORDER_VALUE);
                this.MESSAGE_ORDER = DESCENDING;
                this.PLUGIN_ORDER = DESCENDING;
                break;
            }
            case 0: {
                this.MESSAGE_ORDER = this.fMemento.getInteger(P_ORDER_VALUE);
                this.DATE_ORDER = DESCENDING;
                this.PLUGIN_ORDER = DESCENDING;
                break;
            }
            case 1: {
                this.PLUGIN_ORDER = this.fMemento.getInteger(P_ORDER_VALUE);
                this.MESSAGE_ORDER = DESCENDING;
                this.DATE_ORDER = DESCENDING;
                break;
            }
            default: {
                this.DATE_ORDER = DESCENDING;
                this.MESSAGE_ORDER = DESCENDING;
                this.PLUGIN_ORDER = DESCENDING;
            }
        }
        if (this.fCollator == null) {
            this.fCollator = Collator.getInstance();
        }
        this.setComparator(this.fMemento.getInteger(P_ORDER_TYPE).byteValue());
    }

    private void initializeMemento() {
        Integer width;
        if (this.fMemento.getString(P_USE_LIMIT) == null) {
            this.fMemento.putString(P_USE_LIMIT, "true");
        }
        if (this.fMemento.getInteger(P_LOG_LIMIT) == null) {
            this.fMemento.putInteger(P_LOG_LIMIT, 50);
        }
        if (this.fMemento.getString(P_LOG_INFO) == null) {
            this.fMemento.putString(P_LOG_INFO, "true");
        }
        if (this.fMemento.getString(P_LOG_WARNING) == null) {
            this.fMemento.putString(P_LOG_WARNING, "true");
        }
        if (this.fMemento.getString(P_LOG_ERROR) == null) {
            this.fMemento.putString(P_LOG_ERROR, "true");
        }
        if (this.fMemento.getString(P_SHOW_ALL_SESSIONS) == null) {
            this.fMemento.putString(P_SHOW_ALL_SESSIONS, "true");
        }
        if ((width = this.fMemento.getInteger(P_COLUMN_1)) == null || width == 0) {
            this.fMemento.putInteger(P_COLUMN_1, 300);
        }
        if ((width = this.fMemento.getInteger(P_COLUMN_2)) == null || width == 0) {
            this.fMemento.putInteger(P_COLUMN_2, 150);
        }
        if ((width = this.fMemento.getInteger(P_COLUMN_3)) == null || width == 0) {
            this.fMemento.putInteger(P_COLUMN_3, 150);
        }
        if (this.fMemento.getString(P_ACTIVATE) == null) {
            this.fMemento.putString(P_ACTIVATE, "true");
        }
        this.fMemento.putInteger(P_ORDER_VALUE, DESCENDING);
        this.fMemento.putInteger(P_ORDER_TYPE, 2);
    }

    public void saveState(IMemento memento) {
        if (this.fMemento == null || memento == null) {
            return;
        }
        this.fMemento.putInteger(P_COLUMN_1, this.fColumn1.getWidth());
        this.fMemento.putInteger(P_COLUMN_2, this.fColumn2.getWidth());
        this.fMemento.putInteger(P_COLUMN_3, this.fColumn3.getWidth());
        this.fMemento.putString(P_ACTIVATE, this.fActivateViewAction.isChecked() ? "true" : "false");
        memento.putMemento(this.fMemento);
        this.writeSettings();
    }

    private void addMouseListeners() {
        Listener tableListener = new Listener(){

            public void handleEvent(Event e) {
                switch (e.type) {
                    case 5: {
                        LogView.this.onMouseMove(e);
                        break;
                    }
                    case 32: {
                        LogView.this.onMouseHover(e);
                        break;
                    }
                    case 3: {
                        LogView.this.onMouseDown(e);
                    }
                }
            }
        };
        int[] tableEvents = new int[]{3, 5, 32};
        int i = 0;
        while (i < tableEvents.length) {
            this.fTree.addListener(tableEvents[i], tableListener);
            ++i;
        }
    }

    private void makeHoverShell() {
        int border;
        this.fTextShell = new Shell(this.fTree.getShell(), 540676);
        Display display = this.fTextShell.getDisplay();
        this.fTextShell.setBackground(display.getSystemColor(29));
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = border = (this.fTree.getShell().getStyle() & 8) == 0 ? 0 : 1;
        layout.marginWidth = border;
        this.fTextShell.setLayout((Layout)layout);
        this.fTextShell.setLayoutData((Object)new GridData(768));
        Composite shellComposite = new Composite((Composite)this.fTextShell, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        shellComposite.setLayout((Layout)layout);
        shellComposite.setLayoutData((Object)new GridData(1810));
        this.fTextLabel = new Text(shellComposite, 74);
        GridData gd = new GridData(1808);
        gd.widthHint = 100;
        gd.grabExcessHorizontalSpace = true;
        this.fTextLabel.setLayoutData((Object)gd);
        Color c = this.fTree.getDisplay().getSystemColor(29);
        this.fTextLabel.setBackground(c);
        c = this.fTree.getDisplay().getSystemColor(28);
        this.fTextLabel.setForeground(c);
        this.fTextLabel.setEditable(false);
        this.fTextShell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                LogView.this.onTextShellDispose(e);
            }
        });
    }

    void onTextShellDispose(DisposeEvent e) {
        this.fCanOpenTextShell = true;
        this.setFocus();
    }

    void onMouseDown(Event e) {
        if (this.fTextShell != null && !this.fTextShell.isDisposed() && !this.fTextShell.isFocusControl()) {
            this.fTextShell.setVisible(false);
            this.fCanOpenTextShell = true;
        }
    }

    void onMouseHover(Event e) {
        if (!this.fCanOpenTextShell) {
            return;
        }
        this.fCanOpenTextShell = false;
        Point point = new Point(e.x, e.y);
        TreeItem item = this.fTree.getItem(point);
        if (item == null) {
            return;
        }
        String message = ((LogEntry)((Object)item.getData())).getStack();
        if (message == null) {
            return;
        }
        this.fTextLabel.setText(message);
        Rectangle bounds = this.fTree.getDisplay().getBounds();
        Point cursorPoint = this.fTree.getDisplay().getCursorLocation();
        int x = point.x;
        int y = point.y + 25;
        int width = this.fTree.getColumn(0).getWidth();
        int height = 125;
        if (cursorPoint.x + width > bounds.width) {
            x -= width;
        }
        if (cursorPoint.y + height + 25 > bounds.height) {
            y -= height + 27;
        }
        this.fTextShell.setLocation(this.fTree.toDisplay(x, y));
        this.fTextShell.setSize(width, height);
        this.fTextShell.setVisible(true);
    }

    void onMouseMove(Event e) {
        Point point;
        TreeItem item;
        if (this.fTextShell != null && !this.fTextShell.isDisposed() && this.fTextShell.isVisible()) {
            this.fTextShell.setVisible(false);
        }
        if ((item = this.fTree.getItem(point = new Point(e.x, e.y))) == null) {
            return;
        }
        Image image = item.getImage();
        LogEntry entry = (LogEntry)((Object)item.getData());
        int parentCount = this.getNumberOfParents(entry);
        int startRange = 20 + Math.max(image.getBounds().width + 2, 9) * parentCount;
        int endRange = startRange + 16;
        this.fCanOpenTextShell = e.x >= startRange && e.x <= endRange;
    }

    private int getNumberOfParents(LogEntry entry) {
        LogEntry parent = (LogEntry)((Object)entry.getParent((Object)entry));
        if (parent == null) {
            return 0;
        }
        return 1 + this.getNumberOfParents(parent);
    }

    public Comparator getComparator() {
        return this.fComparator;
    }

    private void setComparator(byte sortType) {
        this.fComparator = sortType == 2 ? new Comparator(){

            public int compare(Object e1, Object e2) {
                Date date1 = ((LogEntry)((Object)e1)).getDate();
                Date date2 = ((LogEntry)((Object)e2)).getDate();
                if (LogView.this.DATE_ORDER == ASCENDING) {
                    return date1.getTime() < date2.getTime() ? DESCENDING : ASCENDING;
                }
                return date1.getTime() > date2.getTime() ? DESCENDING : ASCENDING;
            }
        } : (sortType == 1 ? new Comparator(){

            public int compare(Object e1, Object e2) {
                LogEntry entry1 = (LogEntry)((Object)e1);
                LogEntry entry2 = (LogEntry)((Object)e2);
                return LogView.this.fCollator.compare(entry1.getPluginId(), entry2.getPluginId()) * LogView.this.PLUGIN_ORDER;
            }
        } : new Comparator(){

            public int compare(Object e1, Object e2) {
                LogEntry entry1 = (LogEntry)((Object)e1);
                LogEntry entry2 = (LogEntry)((Object)e2);
                return LogView.this.fCollator.compare(entry1.getMessage(), entry2.getMessage()) * LogView.this.MESSAGE_ORDER;
            }
        });
    }

    private ViewerSorter getViewerSorter(byte sortType) {
        if (sortType == 1) {
            return new ViewerSorter(){

                public int compare(Viewer viewer, Object e1, Object e2) {
                    LogEntry entry1 = (LogEntry)((Object)e1);
                    LogEntry entry2 = (LogEntry)((Object)e2);
                    return super.compare(viewer, (Object)entry1.getPluginId(), (Object)entry2.getPluginId()) * LogView.this.PLUGIN_ORDER;
                }
            };
        }
        if (sortType == 0) {
            return new ViewerSorter(){

                public int compare(Viewer viewer, Object e1, Object e2) {
                    LogEntry entry1 = (LogEntry)((Object)e1);
                    LogEntry entry2 = (LogEntry)((Object)e2);
                    return super.compare(viewer, (Object)entry1.getMessage(), (Object)entry2.getMessage()) * LogView.this.MESSAGE_ORDER;
                }
            };
        }
        return new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                Date date1 = ((LogEntry)((Object)e1)).getDate();
                Date date2 = ((LogEntry)((Object)e2)).getDate();
                if (LogView.this.DATE_ORDER == ASCENDING) {
                    return date1.getTime() < date2.getTime() ? DESCENDING : ASCENDING;
                }
                return date1.getTime() > date2.getTime() ? DESCENDING : ASCENDING;
            }
        };
    }

    private void resetDialogButtons() {
        ((EventDetailsDialogAction)this.fPropertiesAction).resetDialogButtons();
    }

    private IDialogSettings getLogSettings() {
        IDialogSettings settings = PDERuntimePlugin.getDefault().getDialogSettings();
        return settings.getSection(((Object)((Object)this)).getClass().getName());
    }

    private Preferences getLogPreferences() {
        return PDERuntimePlugin.getDefault().getPluginPreferences();
    }

    private void readSettings() {
        IDialogSettings s = this.getLogSettings();
        Preferences p = this.getLogPreferences();
        if (s == null || p == null) {
            this.initializeMemento();
            return;
        }
        try {
            this.fMemento.putString(P_USE_LIMIT, s.getBoolean(P_USE_LIMIT) ? "true" : "false");
            this.fMemento.putInteger(P_LOG_LIMIT, s.getInt(P_LOG_LIMIT));
            this.fMemento.putString(P_LOG_INFO, s.getBoolean(P_LOG_INFO) ? "true" : "false");
            this.fMemento.putString(P_LOG_WARNING, s.getBoolean(P_LOG_WARNING) ? "true" : "false");
            this.fMemento.putString(P_LOG_ERROR, s.getBoolean(P_LOG_ERROR) ? "true" : "false");
            this.fMemento.putString(P_SHOW_ALL_SESSIONS, s.getBoolean(P_SHOW_ALL_SESSIONS) ? "true" : "false");
            this.fMemento.putInteger(P_COLUMN_1, p.getInt(P_COLUMN_1) > 0 ? p.getInt(P_COLUMN_1) : 300);
            this.fMemento.putInteger(P_COLUMN_2, p.getInt(P_COLUMN_2) > 0 ? p.getInt(P_COLUMN_2) : 150);
            this.fMemento.putInteger(P_COLUMN_3, p.getInt(P_COLUMN_3) > 0 ? p.getInt(P_COLUMN_3) : 150);
            this.fMemento.putString(P_ACTIVATE, p.getBoolean(P_ACTIVATE) ? "true" : "false");
            int order = p.getInt(P_ORDER_VALUE);
            this.fMemento.putInteger(P_ORDER_VALUE, order == 0 ? DESCENDING : order);
            this.fMemento.putInteger(P_ORDER_TYPE, p.getInt(P_ORDER_TYPE));
        }
        catch (NumberFormatException numberFormatException) {
            this.fMemento.putInteger(P_LOG_LIMIT, 50);
            this.fMemento.putInteger(P_COLUMN_1, 300);
            this.fMemento.putInteger(P_COLUMN_2, 150);
            this.fMemento.putInteger(P_COLUMN_3, 150);
            this.fMemento.putInteger(P_ORDER_TYPE, 2);
            this.fMemento.putInteger(P_ORDER_VALUE, DESCENDING);
        }
    }

    private void writeSettings() {
        this.writeViewSettings();
        this.writeFilterSettings();
    }

    private void writeFilterSettings() {
        IDialogSettings settings = this.getLogSettings();
        if (settings == null) {
            settings = PDERuntimePlugin.getDefault().getDialogSettings().addNewSection(((Object)((Object)this)).getClass().getName());
        }
        settings.put(P_USE_LIMIT, this.fMemento.getString(P_USE_LIMIT).equals("true"));
        settings.put(P_LOG_LIMIT, this.fMemento.getInteger(P_LOG_LIMIT).intValue());
        settings.put(P_LOG_INFO, this.fMemento.getString(P_LOG_INFO).equals("true"));
        settings.put(P_LOG_WARNING, this.fMemento.getString(P_LOG_WARNING).equals("true"));
        settings.put(P_LOG_ERROR, this.fMemento.getString(P_LOG_ERROR).equals("true"));
        settings.put(P_SHOW_ALL_SESSIONS, this.fMemento.getString(P_SHOW_ALL_SESSIONS).equals("true"));
    }

    private void writeViewSettings() {
        Preferences preferences = this.getLogPreferences();
        preferences.setValue(P_COLUMN_1, this.fMemento.getInteger(P_COLUMN_1).intValue());
        preferences.setValue(P_COLUMN_2, this.fMemento.getInteger(P_COLUMN_2).intValue());
        preferences.setValue(P_COLUMN_3, this.fMemento.getInteger(P_COLUMN_3).intValue());
        preferences.setValue(P_ACTIVATE, this.fMemento.getString(P_ACTIVATE).equals("true"));
        int order = this.fMemento.getInteger(P_ORDER_VALUE);
        preferences.setValue(P_ORDER_VALUE, order == 0 ? DESCENDING : order);
        preferences.setValue(P_ORDER_TYPE, this.fMemento.getInteger(P_ORDER_TYPE).intValue());
    }

    public void sortByDateDescending() {
        this.setColumnSorting(this.fColumn3, DESCENDING);
    }
}

